/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import java.util.EnumMap;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.FieldLocationIdentity;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.extended.AbstractBoxingNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.extended.UnboxNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetCounter;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.word.LocationIdentity;

public class BoxingSnippets
implements Snippets {
    @Snippet
    public static Object booleanValueOf(boolean value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static Object byteValueOf(byte value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static Object charValueOf(char value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(Character.valueOf(value));
    }

    @Snippet
    public static Object doubleValueOf(double value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static Object floatValueOf(float value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(Float.valueOf(value));
    }

    @Snippet
    public static Object intValueOf(int value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static Object longValueOf(long value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static Object shortValueOf(short value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static boolean booleanValue(Boolean value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    @Snippet
    public static byte byteValue(Byte value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    @Snippet
    public static char charValue(Character value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value.charValue();
    }

    @Snippet
    public static double doubleValue(Double value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    @Snippet
    public static float floatValue(Float value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value.floatValue();
    }

    @Snippet
    public static int intValue(Integer value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    @Snippet
    public static long longValue(Long value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    @Snippet
    public static short shortValue(Short value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    public static final class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final EnumMap<JavaKind, SnippetTemplate.SnippetInfo> boxSnippets = new EnumMap(JavaKind.class);
        private final EnumMap<JavaKind, SnippetTemplate.SnippetInfo> unboxSnippets = new EnumMap(JavaKind.class);
        private final SnippetCounter valueOfCounter;
        private final SnippetCounter valueCounter;

        public Templates(OptionValues options, SnippetCounter.Group.Factory factory, Providers providers) {
            super(options, providers);
            for (JavaKind kind : new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Double, JavaKind.Float, JavaKind.Int, JavaKind.Long, JavaKind.Short}) {
                FieldLocationIdentity accessedLocation = null;
                LocationIdentity cacheLocation = null;
                boolean mustHaveCacheField = false;
                switch (kind) {
                    case Byte: 
                    case Short: 
                    case Char: 
                    case Int: 
                    case Long: {
                        accessedLocation = new FieldLocationIdentity(AbstractBoxingNode.getValueField(providers.getMetaAccess().lookupJavaType(kind.toBoxedJavaClass())));
                        cacheLocation = Templates.getCacheLocation(providers, kind);
                        mustHaveCacheField = true;
                        break;
                    }
                    case Boolean: 
                    case Float: 
                    case Double: {
                        accessedLocation = new FieldLocationIdentity(AbstractBoxingNode.getValueField(providers.getMetaAccess().lookupJavaType(kind.toBoxedJavaClass())));
                        break;
                    }
                    default: {
                        throw GraalError.shouldNotReachHereUnexpectedValue(kind);
                    }
                }
                assert (accessedLocation != null);
                if (kind == JavaKind.Boolean) {
                    assert (cacheLocation == null);
                    FieldLocationIdentity trueField = null;
                    FieldLocationIdentity falseField = null;
                    for (ResolvedJavaField field : providers.getMetaAccess().lookupJavaType(kind.toBoxedJavaClass()).getStaticFields()) {
                        if (field.getName().equals("TRUE")) {
                            trueField = new FieldLocationIdentity(field);
                            continue;
                        }
                        if (!field.getName().equals("FALSE")) continue;
                        falseField = new FieldLocationIdentity(field);
                    }
                    this.boxSnippets.put(kind, this.snippet(providers, BoxingSnippets.class, kind.getJavaName() + "ValueOf", trueField, falseField));
                } else {
                    GraalError.guarantee(!mustHaveCacheField || cacheLocation != null, "Must have a cache location for kind %s", (Object)kind);
                    if (cacheLocation != null) {
                        this.boxSnippets.put(kind, this.snippet(providers, BoxingSnippets.class, kind.getJavaName() + "ValueOf", LocationIdentity.INIT_LOCATION, accessedLocation, cacheLocation, NamedLocationIdentity.getArrayLocation(JavaKind.Object)));
                    } else {
                        this.boxSnippets.put(kind, this.snippet(providers, BoxingSnippets.class, kind.getJavaName() + "ValueOf", LocationIdentity.INIT_LOCATION, accessedLocation, NamedLocationIdentity.getArrayLocation(JavaKind.Object)));
                    }
                }
                this.unboxSnippets.put(kind, this.snippet(providers, BoxingSnippets.class, kind.getJavaName() + "Value", accessedLocation));
            }
            SnippetCounter.Group group = factory.createSnippetCounterGroup("Boxing");
            this.valueOfCounter = new SnippetCounter(group, "valueOf", "box intrinsification");
            this.valueCounter = new SnippetCounter(group, "<kind>Value", "unbox intrinsification");
        }

        static Class<?> getCacheClass(JavaKind kind) {
            Class<?>[] innerClasses = null;
            for (Class<?> innerClass : innerClasses = kind.toBoxedJavaClass().getDeclaredClasses()) {
                if (!innerClass.getSimpleName().equals(kind.toBoxedJavaClass().getSimpleName() + "Cache")) continue;
                return innerClass;
            }
            return null;
        }

        private static LocationIdentity getCacheLocation(CoreProviders providers, JavaKind kind) {
            Class<?> cacheClass = Templates.getCacheClass(kind);
            if (cacheClass == null) {
                throw GraalError.shouldNotReachHere(String.format("Cache class for %s not found", kind));
            }
            try {
                return new FieldLocationIdentity(providers.getMetaAccess().lookupJavaField(cacheClass.getDeclaredField("cache")));
            }
            catch (Throwable e) {
                throw GraalError.shouldNotReachHere(e);
            }
        }

        public void lower(BoxNode box, LoweringTool tool) {
            SnippetTemplate.Arguments args = null;
            args = new SnippetTemplate.Arguments(this.boxSnippets.get(box.getBoxingKind()), box.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("value", box.getValue());
            args.addConst("valueOfCounter", this.valueOfCounter);
            SnippetTemplate template = this.template(tool, box, args);
            box.getDebug().log("Lowering integerValueOf in %s: node=%s, template=%s, arguments=%s", box.graph(), (Object)box, (Object)template, (Object)args);
            template.instantiate(tool.getMetaAccess(), box, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(UnboxNode unbox, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.unboxSnippets.get(unbox.getBoxingKind()), unbox.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("value", unbox.getValue());
            args.addConst("valueCounter", this.valueCounter);
            SnippetTemplate template = this.template(tool, unbox, args);
            unbox.getDebug().log("Lowering integerValueOf in %s: node=%s, template=%s, arguments=%s", unbox.graph(), (Object)unbox, (Object)template, (Object)args);
            template.instantiate(tool.getMetaAccess(), unbox, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

