/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.ClassIsArrayNode;
import jdk.graal.compiler.nodes.extended.ObjectIsArrayNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.InstanceOfSnippetsTemplates;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public abstract class IsArraySnippets
implements Snippets {
    @Snippet
    Object objectIsArraySnippet(@Snippet.NonNullParameter Object object, Object trueValue, Object falseValue) {
        return BranchProbabilityNode.unknownProbability(this.classIsArray(object.getClass())) ? trueValue : falseValue;
    }

    @Snippet
    Object classIsArraySnippet(@Snippet.NonNullParameter Class<?> clazz, Object trueValue, Object falseValue) {
        return BranchProbabilityNode.unknownProbability(this.classIsArray(clazz)) ? trueValue : falseValue;
    }

    protected abstract boolean classIsArray(Class<?> var1);

    public static class Templates
    extends InstanceOfSnippetsTemplates {
        private final SnippetTemplate.SnippetInfo objectIsArraySnippet;
        private final SnippetTemplate.SnippetInfo classIsArraySnippet;

        public Templates(IsArraySnippets receiver, OptionValues options, Providers providers) {
            super(options, providers);
            this.objectIsArraySnippet = this.snippet(providers, IsArraySnippets.class, "objectIsArraySnippet", null, receiver, new LocationIdentity[0]);
            this.classIsArraySnippet = this.snippet(providers, IsArraySnippets.class, "classIsArraySnippet", null, receiver, new LocationIdentity[0]);
        }

        @Override
        protected SnippetTemplate.Arguments makeArguments(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool) {
            SnippetTemplate.Arguments args;
            FloatingNode node = replacer.instanceOf;
            if (node instanceof ObjectIsArrayNode) {
                args = new SnippetTemplate.Arguments(this.objectIsArraySnippet, node.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("object", ((ObjectIsArrayNode)node).getValue());
            } else if (replacer.instanceOf instanceof ClassIsArrayNode) {
                args = new SnippetTemplate.Arguments(this.classIsArraySnippet, node.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("clazz", ((ClassIsArrayNode)node).getValue());
            } else {
                throw GraalError.shouldNotReachHere(String.valueOf(node) + " " + String.valueOf(replacer));
            }
            args.add("trueValue", replacer.trueValue);
            args.add("falseValue", replacer.falseValue);
            return args;
        }
    }
}

