/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ComputeObjectAddressNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.replacements.nodes.ArrayIndexOfNode;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.graal.compiler.replacements.nodes.MacroWithExceptionNode;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_128)
public final class ArrayIndexOfMacroNode
extends MacroWithExceptionNode
implements Simplifiable {
    public static final NodeClass<ArrayIndexOfMacroNode> TYPE = NodeClass.create(ArrayIndexOfMacroNode.class);
    private final Stride stride;
    private final LIRGeneratorTool.ArrayIndexOfVariant variant;
    private final LocationIdentity locationIdentity;
    private boolean intrinsifiable = false;

    public ArrayIndexOfMacroNode(MacroNode.MacroParams p, Stride stride, LIRGeneratorTool.ArrayIndexOfVariant variant, LocationIdentity locationIdentity) {
        this(TYPE, p, stride, variant, locationIdentity);
    }

    public ArrayIndexOfMacroNode(NodeClass<? extends MacroWithExceptionNode> c, MacroNode.MacroParams p, Stride stride, LIRGeneratorTool.ArrayIndexOfVariant variant, LocationIdentity locationIdentity) {
        super(c, p);
        this.stride = stride;
        this.variant = variant;
        this.locationIdentity = locationIdentity;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        Architecture arch;
        if (!this.intrinsifiable && ArrayIndexOfNode.isSupported(arch = tool.getLowerer().getTarget().arch, this.stride, this.variant)) {
            this.intrinsifiable = true;
            this.replaceWithNonThrowing();
        }
    }

    @Override
    public void lower(LoweringTool tool) {
        if (this.intrinsifiable) {
            ValueNode[] searchValues = (ValueNode[])this.getArguments().subList(7).toArray(ValueNode[]::new);
            if (this.variant == LIRGeneratorTool.ArrayIndexOfVariant.Table) {
                ValueNode array = searchValues[0];
                ConstantNode offset = ConstantNode.forLong(tool.getMetaAccess().getArrayBaseOffset(JavaKind.Byte));
                assert (offset.getStackKind() == tool.getReplacements().getWordKind()) : Assertions.errorMessageContext("offset", offset);
                searchValues[0] = this.graph().add(new ComputeObjectAddressNode(array, this.graph().addOrUnique(offset)));
            }
            ArrayIndexOfNode replacement = this.graph().addOrUnique(new ArrayIndexOfNode(this.stride, this.variant, null, this.locationIdentity, this.getArgument(1), this.getArgument(2), this.getArgument(3), this.getArgument(6), searchValues));
            this.killExceptionEdge();
            this.graph().replaceSplitWithFixed(this, replacement, this.next());
            if (this.variant == LIRGeneratorTool.ArrayIndexOfVariant.Table) {
                this.graph().addBeforeFixed(replacement, (ComputeObjectAddressNode)searchValues[0]);
            }
        } else {
            super.lower(tool);
        }
    }
}

