/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes;

import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.TernaryNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class FusedMultiplyAddNode
extends TernaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<FusedMultiplyAddNode> TYPE = NodeClass.create(FusedMultiplyAddNode.class);

    public FusedMultiplyAddNode(ValueNode x, ValueNode y, ValueNode z) {
        super(TYPE, FusedMultiplyAddNode.computeStamp(x.stamp(NodeView.DEFAULT), y.stamp(NodeView.DEFAULT), z.stamp(NodeView.DEFAULT)), x, y, z);
        assert (x.getStackKind().isNumericFloat());
        assert (y.getStackKind().isNumericFloat());
        assert (z.getStackKind().isNumericFloat());
    }

    @Override
    public Stamp foldStamp(Stamp stampX, Stamp stampY, Stamp stampZ) {
        return FusedMultiplyAddNode.computeStamp(stampX, stampY, stampZ);
    }

    private static Stamp computeStamp(Stamp stampX, Stamp stampY, Stamp stampZ) {
        if (stampX.isEmpty()) {
            return stampX;
        }
        if (stampY.isEmpty()) {
            return stampY;
        }
        if (stampZ.isEmpty()) {
            return stampZ;
        }
        JavaConstant constantX = ((FloatStamp)stampX).asConstant();
        JavaConstant constantY = ((FloatStamp)stampY).asConstant();
        JavaConstant constantZ = ((FloatStamp)stampZ).asConstant();
        if (constantX != null && constantY != null && constantZ != null) {
            if (stampX.getStackKind() == JavaKind.Float) {
                float result = GraalServices.fma(constantX.asFloat(), constantY.asFloat(), constantZ.asFloat());
                if (Float.isNaN(result)) {
                    return StampFactory.forFloat(JavaKind.Float, Double.NaN, Double.NaN, false);
                }
                return StampFactory.forFloat(JavaKind.Float, result, result, true);
            }
            double result = GraalServices.fma(constantX.asDouble(), constantY.asDouble(), constantZ.asDouble());
            assert (stampX.getStackKind() == JavaKind.Double) : Assertions.errorMessage(stampX, stampY, stampZ);
            if (Double.isNaN(result)) {
                return StampFactory.forFloat(JavaKind.Double, Double.NaN, Double.NaN, false);
            }
            return StampFactory.forFloat(JavaKind.Double, result, result, true);
        }
        return stampX.unrestricted();
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY, ValueNode forZ) {
        if (forX.isConstant() && forY.isConstant() && forZ.isConstant()) {
            JavaConstant constantX = forX.asJavaConstant();
            JavaConstant constantY = forY.asJavaConstant();
            JavaConstant constantZ = forZ.asJavaConstant();
            if (forX.getStackKind() == JavaKind.Float) {
                return ConstantNode.forFloat(GraalServices.fma(constantX.asFloat(), constantY.asFloat(), constantZ.asFloat()));
            }
            assert (forX.getStackKind() == JavaKind.Double) : Assertions.errorMessage(forX, forY, forZ);
            return ConstantNode.forDouble(GraalServices.fma(constantX.asDouble(), constantY.asDouble(), constantZ.asDouble()));
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, gen.emitFusedMultiplyAdd(builder.operand(this.getX()), builder.operand(this.getY()), builder.operand(this.getZ())));
    }
}

