/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes.arithmetic;

import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.extended.GuardedNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticNode;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class IntegerAddExactNode
extends AddNode
implements GuardedNode,
IntegerExactArithmeticNode,
IterableNodeType {
    public static final NodeClass<IntegerAddExactNode> TYPE = NodeClass.create(IntegerAddExactNode.class);
    @Node.Input(value=InputType.Guard)
    protected GuardingNode guard;

    public IntegerAddExactNode(ValueNode x, ValueNode y, GuardingNode guard) {
        super(TYPE, x, y);
        this.setStamp(x.stamp(NodeView.DEFAULT).unrestricted());
        assert (x.stamp(NodeView.DEFAULT).isCompatible(y.stamp(NodeView.DEFAULT))) : Assertions.errorMessageContext("x", y, "y", y);
        assert (x.stamp(NodeView.DEFAULT) instanceof IntegerStamp) : Assertions.errorMessageContext("x", x, "y", y);
        this.guard = guard;
    }

    @Override
    public boolean inferStamp() {
        return false;
    }

    @Override
    public Stamp foldStamp(Stamp stampX, Stamp stampY) {
        IntegerStamp a = (IntegerStamp)stampX;
        IntegerStamp b = (IntegerStamp)stampY;
        int bits = a.getBits();
        assert (bits == b.getBits()) : Assertions.errorMessageContext("x", stampX, "y", stampY);
        if (IntegerStamp.addCanOverflow(a, b)) {
            return a.unrestricted();
        }
        long defaultMask = CodeUtil.mask((int)bits);
        long newLowerBound = CodeUtil.signExtend((long)(a.lowerBound() + b.lowerBound() & defaultMask), (int)bits);
        long newUpperBound = CodeUtil.signExtend((long)(a.upperBound() + b.upperBound() & defaultMask), (int)bits);
        return IntegerStamp.create(bits, newLowerBound, newUpperBound);
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        long c;
        if (forX.isConstant() && !forY.isConstant()) {
            return (ValueNode)new IntegerAddExactNode(forY, forX, this.guard).canonical(tool);
        }
        if (forX.isConstant() && forY.isConstant()) {
            return this.canonicalXYconstant(forX, forY);
        }
        if (forY.isConstant() && (c = forY.asJavaConstant().asLong()) == 0L) {
            return forX;
        }
        if (!IntegerStamp.addCanOverflow((IntegerStamp)forX.stamp(NodeView.DEFAULT), (IntegerStamp)forY.stamp(NodeView.DEFAULT))) {
            return (ValueNode)new AddNode(forX, forY).canonical(tool);
        }
        if (this.getGuard() == null) {
            return (ValueNode)new AddNode(forX, forY).canonical(tool);
        }
        return this;
    }

    private ValueNode canonicalXYconstant(ValueNode forX, ValueNode forY) {
        JavaConstant xConst = forX.asJavaConstant();
        JavaConstant yConst = forY.asJavaConstant();
        assert (xConst.getJavaKind() == yConst.getJavaKind()) : Assertions.errorMessageContext("forX", forX, "forY", forY);
        try {
            if (xConst.getJavaKind() == JavaKind.Int) {
                return ConstantNode.forInt(Math.addExact(xConst.asInt(), yConst.asInt()));
            }
            assert (xConst.getJavaKind() == JavaKind.Long) : Assertions.errorMessage(forX, forY, xConst, yConst);
            return ConstantNode.forLong(Math.addExact(xConst.asLong(), yConst.asLong()));
        }
        catch (ArithmeticException arithmeticException) {
            return this;
        }
    }

    @Override
    public GuardingNode getGuard() {
        return this.guard;
    }

    @Override
    public void setGuard(GuardingNode guard) {
        this.updateUsagesInterface(this.guard, guard);
        this.guard = guard;
    }

    @Override
    protected boolean isExact() {
        return true;
    }
}

