/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.nodes.arithmetic;

import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.Value;

@NodeInfo(shortName="|*H|", cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class UnsignedMulHighNode
extends BinaryArithmeticNode<ArithmeticOpTable.BinaryOp.UMulHigh>
implements Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<UnsignedMulHighNode> TYPE = NodeClass.create(UnsignedMulHighNode.class);

    public UnsignedMulHighNode(ValueNode x, ValueNode y) {
        super(TYPE, UnsignedMulHighNode.getArithmeticOpTable(x).getUMulHigh(), x, y);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.UMulHigh> getOp(ArithmeticOpTable table) {
        return table.getUMulHigh();
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        Value a = nodeValueMap.operand(this.getX());
        Value b = nodeValueMap.operand(this.getY());
        nodeValueMap.setResult(this, gen.emitUMulHigh(a, b));
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        if (forX.isConstant() && !forY.isConstant()) {
            ValueNode improvement = this.canonical(tool, forY, forX);
            if (improvement != this) {
                return improvement;
            }
            return new UnsignedMulHighNode(forY, forX);
        }
        return UnsignedMulHighNode.canonical(this, forY);
    }

    private static ValueNode canonical(UnsignedMulHighNode self, ValueNode forY) {
        long i;
        Constant c;
        if (forY.isConstant() && (c = forY.asConstant()) instanceof PrimitiveConstant && ((PrimitiveConstant)c).getJavaKind().isNumericInteger() && ((i = ((PrimitiveConstant)c).asLong()) == 0L || i == 1L)) {
            return ConstantNode.forIntegerStamp(self.stamp(NodeView.DEFAULT), 0L);
        }
        return self;
    }
}

