/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.serviceprovider;

import java.util.ArrayList;
import jdk.graal.compiler.serviceprovider.SpeculationReasonGroup;
import jdk.vm.ci.code.BytecodePosition;

class SpeculationEncodingAdapter
implements SpeculationReasonGroup.SpeculationContextObject.Visitor {
    private ArrayList<Object> objects = null;

    SpeculationEncodingAdapter() {
    }

    Object[] flatten(Object[] context) {
        boolean flatten = false;
        for (Object c : context) {
            if (!(c instanceof SpeculationReasonGroup.SpeculationContextObject) && (c == null || c.getClass() != BytecodePosition.class)) continue;
            flatten = true;
            break;
        }
        if (!flatten) {
            return context;
        }
        this.objects = new ArrayList();
        for (Object c : context) {
            if (c instanceof SpeculationReasonGroup.SpeculationContextObject) {
                SpeculationReasonGroup.SpeculationContextObject sco = (SpeculationReasonGroup.SpeculationContextObject)c;
                this.objects.add(c.getClass().getName());
                sco.accept(this);
                continue;
            }
            if (c != null && c.getClass() == BytecodePosition.class) {
                this.objects.add(c.getClass().getName());
                for (BytecodePosition p = (BytecodePosition)c; p != null; p = p.getCaller()) {
                    this.visitInt(p.getBCI());
                    this.objects.add(p.getMethod());
                }
                continue;
            }
            this.objects.add(c);
        }
        return this.objects.toArray();
    }

    @Override
    public void visitBoolean(boolean v) {
        this.objects.add((byte)(v ? 1 : 0));
    }

    @Override
    public void visitByte(byte v) {
        this.objects.add(v);
    }

    @Override
    public void visitChar(char v) {
        this.objects.add(Character.valueOf(v));
    }

    @Override
    public void visitShort(short v) {
        this.objects.add(v);
    }

    @Override
    public void visitInt(int v) {
        this.objects.add(v);
    }

    @Override
    public void visitLong(long v) {
        this.objects.add(v);
    }

    @Override
    public void visitFloat(float v) {
        this.objects.add(Float.floatToRawIntBits(v));
    }

    @Override
    public void visitDouble(double v) {
        this.objects.add(Double.doubleToRawLongBits(v));
    }

    @Override
    public void visitObject(Object v) {
        if (v == null) {
            this.objects.add(0);
        } else {
            this.objects.add(v);
        }
    }
}

