/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle;

import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.truffle.PartialEvaluator;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;

public final class PEAgnosticInlineInvokePlugin
implements InlineInvokePlugin {
    private final EconomicSet<Invoke> directInvokes = EconomicSet.create();
    private final List<Invoke> indirectInvokes = new ArrayList<Invoke>();
    private final PartialEvaluator partialEvaluator;

    public PEAgnosticInlineInvokePlugin(PartialEvaluator partialEvaluator) {
        this.partialEvaluator = partialEvaluator;
    }

    @Override
    public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        if (method.equals((Object)this.partialEvaluator.types.OptimizedCallTarget_callDirect)) {
            return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
        }
        return this.partialEvaluator.asInlineInfo(method);
    }

    @Override
    public void notifyNotInlined(GraphBuilderContext b, ResolvedJavaMethod original, Invoke invoke) {
        if (original.equals((Object)this.partialEvaluator.types.OptimizedCallTarget_callDirect)) {
            this.directInvokes.add((Object)invoke);
        } else if (original.equals((Object)this.partialEvaluator.types.OptimizedCallTarget_callBoundary)) {
            this.indirectInvokes.add(invoke);
        }
    }

    public EconomicSet<Invoke> getDirectInvokes() {
        return this.directInvokes;
    }

    public List<Invoke> getIndirectInvokes() {
        return this.indirectInvokes;
    }
}

