/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle;

import jdk.graal.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.ConditionalEliminationPhase;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.truffle.TruffleTierContext;
import jdk.graal.compiler.truffle.phases.FrameAccessVerificationPhase;
import jdk.graal.compiler.truffle.phases.PhiTransformPhase;
import jdk.graal.compiler.virtual.phases.ea.PartialEscapePhase;

public class PostPartialEvaluationSuite
extends PhaseSuite<TruffleTierContext> {
    public PostPartialEvaluationSuite(OptionValues optionValues, boolean iterativePartialEscape) {
        CanonicalizerPhase canonicalizerPhase = CanonicalizerPhase.create();
        this.appendPhase(new ConvertDeoptimizeToGuardPhase(canonicalizerPhase));
        this.appendPhase(new InlineReplacementsPhase());
        this.appendPhase(canonicalizerPhase);
        this.appendPhase(new ConditionalEliminationPhase(canonicalizerPhase, false));
        this.appendPhase(new FrameAccessVerificationPhase());
        this.appendPhase(new PartialEscapePhase(iterativePartialEscape, canonicalizerPhase, optionValues));
        this.appendPhase(new PhiTransformPhase(canonicalizerPhase));
    }

    public static class InlineReplacementsPhase
    extends BasePhase<TruffleTierContext> {
        @Override
        protected void run(StructuredGraph graph, TruffleTierContext context) {
            for (MethodCallTargetNode methodCallTargetNode : graph.getNodes(MethodCallTargetNode.TYPE)) {
                StructuredGraph inlineGraph;
                if (!methodCallTargetNode.invokeKind().isDirect() || (inlineGraph = context.getProviders().getReplacements().getInlineSubstitution(methodCallTargetNode.targetMethod(), methodCallTargetNode.invoke().bci(), methodCallTargetNode.invoke().getInlineControl(), graph.trackNodeSourcePosition(), methodCallTargetNode.asNode().getNodeSourcePosition(), graph.allowAssumptions(), context.debug.getOptions())) == null) continue;
                InliningUtil.inline(methodCallTargetNode.invoke(), inlineGraph, true, methodCallTargetNode.targetMethod());
            }
        }
    }
}

