/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle;

import com.oracle.truffle.compiler.TruffleCompilerOptionDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.java.BytecodeParserOptions;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionGroup;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.options.OptionsParser;
import jdk.graal.compiler.truffle.ExpansionStatistics;
import jdk.graal.compiler.truffle.TruffleCompilerImpl;
import org.graalvm.collections.EconomicMap;

@OptionGroup(prefix="compiler.", registerAsService=false)
public class TruffleCompilerOptions {
    public static final OptionKey<Boolean> DiagnoseFailure = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> EncodedGraphCache = new OptionKey<Boolean>(true);
    public static final OptionKey<Boolean> ExcludeAssertions = new OptionKey<Boolean>(true);
    public static final OptionKey<String> FirstTierInliningPolicy = new OptionKey<String>("");
    public static final OptionKey<Boolean> FirstTierUseEconomy = new OptionKey<Boolean>(true);
    public static final OptionKey<Boolean> InlineAcrossTruffleBoundary = new OptionKey<Boolean>(false);
    public static final OptionKey<String> InlineOnly = new OptionKey<Object>(null);
    public static final OptionKey<Boolean> Inlining = new OptionKey<Boolean>(true);
    public static final OptionKey<Integer> InliningExpansionBudget = new OptionKey<Integer>(12000);
    public static final OptionKey<Integer> InliningInliningBudget = new OptionKey<Integer>(12000);
    public static final OptionKey<String> InliningPolicy = new OptionKey<String>("");
    public static final OptionKey<Integer> InliningRecursionDepth = new OptionKey<Integer>(2);
    public static final OptionKey<Boolean> InliningUseSize = new OptionKey<Boolean>(false);
    public static final OptionKey<Integer> InstrumentationTableSize = new OptionKey<Integer>(10000);
    public static final OptionKey<Boolean> InstrumentBoundaries = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> InstrumentBoundariesPerInlineSite = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> InstrumentBranches = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> InstrumentBranchesPerInlineSite = new OptionKey<Boolean>(false);
    public static final OptionKey<String> InstrumentFilter = new OptionKey<String>("*.*.*");
    public static final OptionKey<Boolean> IterativePartialEscape = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> LogInlinedTargets = new OptionKey<Boolean>(false);
    public static final OptionKey<Integer> MaximumGraalGraphSize = new OptionKey<Integer>(150000);
    private static final String EXPANSION_SYNTAX = "(syntax: true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...)";
    private static final String EXPANSION_VALUES = "Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.";
    public static final OptionKey<CompilationTiers> MethodExpansionStatistics = new OptionKey<CompilationTiers>(CompilationTiers.defaultValue());
    public static final OptionKey<CompilationTiers> NodeExpansionStatistics = new OptionKey<CompilationTiers>(CompilationTiers.defaultValue());
    public static final OptionKey<Boolean> NodeSourcePositions = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> ParsePEGraphsWithAssumptions = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> TraceInlining = new OptionKey<Boolean>(false);
    public static final OptionKey<Boolean> TraceInliningDetails = new OptionKey<Boolean>(false);
    public static final OptionKey<CompilationTiers> TraceMethodExpansion = new OptionKey<CompilationTiers>(CompilationTiers.defaultValue());
    public static final OptionKey<CompilationTiers> TraceNodeExpansion = new OptionKey<CompilationTiers>(CompilationTiers.defaultValue());
    private static final String PERFORMANCE_WARNING_LIST = "Performance warnings are: call, instanceof, store, frame_merge, trivial.";
    private static final String PERFORMANCE_WARNING_SYNTAX = " (syntax: none|all|<perfWarning>,<perfWarning>,...)";
    public static final OptionKey<PerformanceWarnings> TracePerformanceWarnings = new OptionKey<PerformanceWarnings>(PerformanceWarnings.defaultValue());
    public static final OptionKey<Integer> TraceStackTraceLimit = new OptionKey<Integer>(20);
    public static final OptionKey<PerformanceWarnings> TreatPerformanceWarningsAsErrors = new OptionKey<PerformanceWarnings>(PerformanceWarnings.defaultValue());

    private static OptionValues enableNodeSourcePositions(OptionValues values) {
        if (GraalOptions.TrackNodeSourcePosition.getValue(values).booleanValue()) {
            return values;
        }
        return new OptionValues(values, GraalOptions.TrackNodeSourcePosition, Boolean.TRUE, new Object[0]);
    }

    public static boolean optionExists(String key) {
        return TruffleCompilerImpl.OPTION_DESCRIPTORS.get(key) != null;
    }

    private static String indent(int nameLength) {
        int len = Math.max(1, 16 - nameLength);
        return new String(new char[len]).replace('\u0000', ' ');
    }

    public static TruffleCompilerOptionDescriptor[] listOptions() {
        ArrayList<TruffleCompilerOptionDescriptor> convertedDescriptors = new ArrayList<TruffleCompilerOptionDescriptor>();
        for (OptionDescriptor descriptor : TruffleCompilerImpl.OPTION_DESCRIPTORS) {
            convertedDescriptors.add(TruffleCompilerOptions.createCompilerOptionDescriptor(descriptor));
        }
        return convertedDescriptors.toArray(new TruffleCompilerOptionDescriptor[convertedDescriptors.size()]);
    }

    private static TruffleCompilerOptionDescriptor createCompilerOptionDescriptor(OptionDescriptor d) {
        return new TruffleCompilerOptionDescriptor(d.getName(), TruffleCompilerOptions.matchGraalOptionType(d), d.isDeprecated(), d.getHelp(), d.getDeprecationMessage());
    }

    private static TruffleCompilerOptionDescriptor.Type matchGraalOptionType(OptionDescriptor d) {
        switch (d.getOptionType()) {
            case User: {
                return TruffleCompilerOptionDescriptor.Type.USER;
            }
            case Expert: {
                return TruffleCompilerOptionDescriptor.Type.EXPERT;
            }
            case Debug: {
                return TruffleCompilerOptionDescriptor.Type.DEBUG;
            }
        }
        return TruffleCompilerOptionDescriptor.Type.DEBUG;
    }

    static Object parseCustom(OptionDescriptor descriptor, String uncheckedValue) {
        Class<?> type = descriptor.getOptionValueType();
        if (type == PerformanceWarnings.class) {
            return PerformanceWarnings.parse(uncheckedValue);
        }
        if (type == CompilationTiers.class) {
            return CompilationTiers.parse(uncheckedValue);
        }
        return null;
    }

    static OptionValues updateValues(OptionValues graalOptions) {
        OptionValues options = graalOptions;
        if (ExpansionStatistics.isEnabled(options)) {
            options = TruffleCompilerOptions.enableNodeSourcePositions(options);
        }
        options = new OptionValues(options, BytecodeParserOptions.DoNotMoveAllocationsWithOOMEHandlers, false, new Object[0]);
        return options;
    }

    public static String validateOption(String key, String uncheckedValue) {
        OptionDescriptor descriptor = TruffleCompilerImpl.OPTION_DESCRIPTORS.get(key);
        if (descriptor == null) {
            return "Option with key '" + key + "' not found.";
        }
        try {
            Object value = TruffleCompilerOptions.parseCustom(descriptor, uncheckedValue);
            if (value == null) {
                value = OptionsParser.parseOptionValue(descriptor, uncheckedValue);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
    }

    public record PerformanceWarnings(Set<PerformanceWarningKind> kinds) {
        public static PerformanceWarnings defaultValue() {
            return new PerformanceWarnings(Set.of());
        }

        public static PerformanceWarnings parse(String value) {
            return new PerformanceWarnings(PerformanceWarnings.parseImpl(value));
        }

        private static Set<PerformanceWarningKind> parseImpl(String value) {
            if ("none".equals(value)) {
                return EnumSet.noneOf(PerformanceWarningKind.class);
            }
            if ("all".equals(value)) {
                EnumSet<PerformanceWarningKind> result = EnumSet.allOf(PerformanceWarningKind.class);
                result.removeIf(PerformanceWarningKind::isOptional);
                return result;
            }
            EnumSet<PerformanceWarningKind> result = EnumSet.noneOf(PerformanceWarningKind.class);
            for (String name : value.split(",")) {
                if ("bailout".equals(name)) continue;
                try {
                    result.add(PerformanceWarningKind.forName(name));
                }
                catch (IllegalArgumentException e) {
                    Object message = String.format("The \"%s\" is not a valid performance warning kind. Valid values are%n", name);
                    for (PerformanceWarningKind kind : PerformanceWarningKind.values()) {
                        message = (String)message + String.format("%s%s%s%n", kind.name, TruffleCompilerOptions.indent(kind.name.length()), kind.help);
                    }
                    message = (String)message + String.format("all%sEnables all performance warnings%n", TruffleCompilerOptions.indent(3));
                    message = (String)message + String.format("none%sDisables performance warnings%n", TruffleCompilerOptions.indent(4));
                    throw new IllegalArgumentException((String)message);
                }
            }
            return result;
        }
    }

    public record CompilationTiers(Set<CompilationTier> tiers) {
        public static CompilationTiers defaultValue() {
            return new CompilationTiers(Set.of());
        }

        public static CompilationTiers parse(String s) {
            return new CompilationTiers(CompilationTiers.parseImpl(s));
        }

        private static Set<CompilationTier> parseImpl(String s) {
            if (s.equals("true")) {
                return Collections.singleton(CompilationTier.truffleTier);
            }
            if (s.equals("false")) {
                return Collections.emptySet();
            }
            String[] strings = s.split(",");
            EnumSet<CompilationTier> tiers = EnumSet.noneOf(CompilationTier.class);
            for (int i = 0; i < strings.length; ++i) {
                tiers.add(CompilationTier.parse(strings[i]));
            }
            return Collections.unmodifiableSet(tiers);
        }
    }

    public static enum PerformanceWarningKind {
        FRAME_INCOMPATIBLE_MERGE("frame_merge", "Enables warnings about deopts inserted for incompatible frame slot merges"),
        MISSING_LOOP_FREQUENCY_INFO("loop", "Enables missing loop frequency warnings", true),
        TRIVIAL_FAIL("trivial", "Enables trivial fail warnings"),
        VIRTUAL_INSTANCEOF("instanceof", "Enables virtual instanceof warnings"),
        VIRTUAL_RUNTIME_CALL("call", "Enables virtual call warnings"),
        VIRTUAL_STORE("store", "Enables virtual store warnings");

        private static final EconomicMap<String, PerformanceWarningKind> kindByName;
        final String help;
        final boolean isOptional;
        final String name;

        public static PerformanceWarningKind forName(String name) {
            PerformanceWarningKind kind = (PerformanceWarningKind)((Object)kindByName.get((Object)name));
            if (kind == null) {
                throw new IllegalArgumentException("Unknown PerformanceWarningKind name " + name);
            }
            return kind;
        }

        private PerformanceWarningKind(String name, String help) {
            this(name, help, false);
        }

        private PerformanceWarningKind(String name, String help, boolean isOptional) {
            this.name = name;
            this.help = help;
            this.isOptional = isOptional;
        }

        boolean isOptional() {
            return this.isOptional;
        }

        static {
            kindByName = EconomicMap.create();
            for (PerformanceWarningKind kind : PerformanceWarningKind.values()) {
                kindByName.put((Object)kind.name, (Object)kind);
            }
        }
    }

    public static enum CompilationTier {
        lowTier,
        peTier,
        truffleTier;


        static CompilationTier parse(String name) {
            try {
                return CompilationTier.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Unknown tier option value '%s'. %s", name, TruffleCompilerOptions.EXPANSION_VALUES));
            }
        }
    }
}

