/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugDumpHandler;
import jdk.graal.compiler.debug.DebugHandler;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.graphio.GraphOutput;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.serviceprovider.ServiceProvider;
import jdk.graal.compiler.truffle.TruffleAST;

@ServiceProvider(value=DebugHandlersFactory.class)
public class TruffleDebugHandlersFactory
implements DebugHandlersFactory {
    @Override
    public List<DebugHandler> createHandlers(OptionValues options) {
        return List.of(new TruffleASTDumpHandler(this));
    }

    private final class TruffleASTDumpHandler
    implements DebugDumpHandler {
        TruffleASTDumpHandler(TruffleDebugHandlersFactory truffleDebugHandlersFactory) {
        }

        @Override
        public void dump(Object object, DebugContext debug, boolean forced, String format, Object ... arguments) {
            if (object instanceof TruffleAST) {
                TruffleAST ast = (TruffleAST)object;
                if (DebugOptions.PrintGraph.getValue(debug.getOptions()) != DebugOptions.PrintGraphTarget.Disable) {
                    try {
                        GraphOutput<TruffleAST, ?> output = debug.buildOutput(GraphOutput.newBuilder(TruffleAST.AST_DUMP_STRUCTURE).blocks(TruffleAST.AST_DUMP_STRUCTURE));
                        HashMap properties = new HashMap();
                        output.beginGroup(ast, "AST", "AST", null, 0, null);
                        output.print((TruffleAST)object, properties, 0, format, arguments);
                        output.endGroup();
                        output.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to dump block mapping", e);
                    }
                }
            }
        }
    }
}

