/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.hotspot;

import com.oracle.truffle.compiler.TruffleCompiler;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import jdk.graal.compiler.hotspot.CompilerConfigurationFactory;
import jdk.graal.compiler.hotspot.HotSpotGraalOptionValues;
import jdk.graal.compiler.hotspot.JVMCIVersionCheck;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.truffle.AbstractTruffleCompilationSupport;
import jdk.graal.compiler.truffle.hotspot.HotSpotTruffleCompilerImpl;
import jdk.graal.compiler.truffle.hotspot.HotSpotTruffleHostEnvironmentLookup;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.services.Services;

public final class HotSpotTruffleCompilationSupport
extends AbstractTruffleCompilationSupport {
    private volatile String compilerConfigurationName;

    public String getCompilerConfigurationName(TruffleCompilerRuntime truffleRuntime) {
        String compilerConfig = this.compilerConfigurationName;
        if (compilerConfig != null) {
            return compilerConfig;
        }
        return HotSpotTruffleCompilationSupport.getLazyCompilerConfigurationName();
    }

    public static String getLazyCompilerConfigurationName() {
        OptionValues options = HotSpotGraalOptionValues.defaultOptions();
        String factoryName = HotSpotTruffleCompilerImpl.Options.TruffleCompilerConfiguration.getValue(options);
        HotSpotJVMCIRuntime runtime = HotSpotJVMCIRuntime.runtime();
        CompilerConfigurationFactory compilerConfigurationFactory = CompilerConfigurationFactory.selectFactory(factoryName, options, runtime);
        return compilerConfigurationFactory.getName();
    }

    public TruffleCompiler createCompiler(TruffleCompilerRuntime runtime) {
        HotSpotTruffleCompilerImpl compiler = HotSpotTruffleCompilerImpl.create(runtime);
        this.compilerConfigurationName = compiler.getHotspotGraalRuntime().getCompilerConfigurationName();
        return compiler;
    }

    public void registerRuntime(TruffleCompilerRuntime runtime) {
        HotSpotTruffleHostEnvironmentLookup.registerRuntime(runtime);
    }

    public String getCompilerVersion() {
        return HotSpotTruffleCompilationSupport.readCompilerVersion();
    }

    public static String readCompilerVersion() {
        String string;
        InputStream in = HotSpotTruffleCompilationSupport.class.getResourceAsStream("/META-INF/graalvm/jdk.graal.compiler/version");
        if (in == null) {
            throw new InternalError("Compiler must have a version file.");
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        try {
            string = r.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new InternalError(ioe);
            }
        }
        r.close();
        return string;
    }

    public static String verifyJVMCIVersion() {
        return JVMCIVersionCheck.check(Services.getSavedProperties());
    }
}

