/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.hotspot;

import jdk.graal.compiler.core.phases.CommunityCompilerConfiguration;
import jdk.graal.compiler.core.phases.HighTier;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.truffle.host.HostInliningPhase;
import jdk.graal.compiler.truffle.host.InjectImmutableFrameFieldsPhase;
import jdk.graal.compiler.truffle.substitutions.TruffleInvocationPlugins;
import jdk.vm.ci.code.Architecture;

public final class TruffleCommunityCompilerConfiguration
extends CommunityCompilerConfiguration {
    @Override
    public HighTier createHighTier(OptionValues options) {
        HighTier highTier = super.createHighTier(options);
        TruffleCommunityCompilerConfiguration.installCommunityHighTier(options, highTier);
        return highTier;
    }

    public static void installCommunityHighTier(OptionValues options, HighTier defaultHighTier) {
        HostInliningPhase.install(defaultHighTier, options);
        InjectImmutableFrameFieldsPhase.install(defaultHighTier, options);
    }

    @Override
    public void registerGraphBuilderPlugins(Architecture arch, GraphBuilderConfiguration.Plugins plugins, OptionValues options, Replacements replacements) {
        super.registerGraphBuilderPlugins(arch, plugins, options, replacements);
        TruffleCommunityCompilerConfiguration.registerCommunityGraphBuilderPlugins(arch, plugins, options, replacements);
    }

    public static void registerCommunityGraphBuilderPlugins(final Architecture arch, final GraphBuilderConfiguration.Plugins plugins, OptionValues options, final Replacements replacements) {
        HostInliningPhase.installInlineInvokePlugin(plugins, options);
        plugins.getInvocationPlugins().defer(new Runnable(){

            @Override
            public void run() {
                TruffleInvocationPlugins.register(arch, plugins.getInvocationPlugins(), replacements);
            }
        });
    }
}

