/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.hotspot.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntime;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotBackend;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotZBarrierSetLIRGenerator;
import jdk.graal.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotRegistersProvider;
import jdk.graal.compiler.lir.amd64.AMD64Move;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.asm.EntryPointDecorator;
import jdk.graal.compiler.serviceprovider.ServiceProvider;
import jdk.graal.compiler.truffle.TruffleCompilerConfiguration;
import jdk.graal.compiler.truffle.hotspot.TruffleCallBoundaryInstrumentationFactory;
import jdk.graal.compiler.truffle.hotspot.TruffleEntryPointDecorator;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.meta.JavaKind;

@ServiceProvider(value=TruffleCallBoundaryInstrumentationFactory.class)
public class AMD64TruffleCallBoundaryInstrumentationFactory
extends TruffleCallBoundaryInstrumentationFactory {
    @Override
    public EntryPointDecorator create(TruffleCompilerConfiguration compilerConfig, GraalHotSpotVMConfig config, HotSpotRegistersProvider registers) {
        return new TruffleEntryPointDecorator(this, compilerConfig, config, registers){

            @Override
            public void emitEntryPoint(CompilationResultBuilder crb) {
                AMD64MacroAssembler masm = (AMD64MacroAssembler)crb.asm;
                Register thisRegister = crb.getCodeCache().getRegisterConfig().getCallingConventionRegisters((CallingConvention.Type)HotSpotCallingConventionType.JavaCall, JavaKind.Object).get(0);
                Register spillRegister = AMD64.r10;
                Label doProlog = new Label();
                int pos = masm.position();
                AMD64Address address = new AMD64Address(thisRegister, this.installedCodeOffset);
                if (this.config.useCompressedOops) {
                    masm.movl(spillRegister, address, true);
                    assert (masm.position() - pos >= 5) : masm.position() + "-" + pos;
                    CompressEncoding encoding = this.config.getOopEncoding();
                    Register heapBaseRegister = AMD64Move.UncompressPointerOp.hasBase(encoding) ? this.registers.getHeapBaseRegister() : Register.None;
                    AMD64Move.UncompressPointerOp.emitUncompressCode(masm, spillRegister, encoding.getShift(), heapBaseRegister, true);
                } else {
                    masm.movq(spillRegister, address, true);
                    assert (masm.position() - pos >= 5) : masm.position() + "-" + pos;
                    if (this.config.gc == HotSpotGraalRuntime.HotSpotGC.Z) {
                        ForeignCallLinkage callTarget = crb.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_FIELD_BARRIER);
                        AMD64HotSpotZBarrierSetLIRGenerator.emitBarrier(crb, masm, null, spillRegister, this.config, callTarget, address, null, (AMD64HotSpotBackend.HotSpotFrameContext)crb.frameContext);
                    }
                }
                masm.movq(spillRegister, new AMD64Address(spillRegister, this.entryPointOffset));
                masm.testqAndJcc(spillRegister, spillRegister, AMD64Assembler.ConditionFlag.Equal, doProlog, true);
                masm.jmp(spillRegister);
                masm.bind(doProlog);
            }
        };
    }

    @Override
    public String getArchitecture() {
        return "AMD64";
    }
}

