/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.nodes;

import java.util.Objects;
import jdk.graal.compiler.nodes.util.JavaConstantFormattable;
import jdk.graal.compiler.nodes.util.JavaConstantFormatter;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

public final class ObjectLocationIdentity
extends LocationIdentity
implements JavaConstantFormattable {
    private final JavaConstant object;

    public static LocationIdentity create(JavaConstant object) {
        assert (object.getJavaKind() == JavaKind.Object) : object;
        assert (object.isNonNull());
        return new ObjectLocationIdentity(object);
    }

    private ObjectLocationIdentity(JavaConstant object) {
        this.object = object;
    }

    public JavaConstant getObject() {
        return this.object;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectLocationIdentity) {
            ObjectLocationIdentity that = (ObjectLocationIdentity)obj;
            return Objects.equals(that.object, this.object);
        }
        return false;
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean isImmutable() {
        return false;
    }

    public String toString() {
        return "Identity(" + String.valueOf(this.object) + ")";
    }

    @Override
    public String format(JavaConstantFormatter formatter) {
        return "Identity(" + formatter.format(this.object) + ")";
    }
}

