/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.truffle.PartialEvaluator;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class SpeculativeExceptionAnchorNode
extends FixedWithNextNode
implements Canonicalizable {
    public static final NodeClass<SpeculativeExceptionAnchorNode> TYPE = NodeClass.create(SpeculativeExceptionAnchorNode.class);
    private final DeoptimizationReason reason;
    private final DeoptimizationAction action;
    private final ResolvedJavaMethod targetMethod;

    public SpeculativeExceptionAnchorNode(DeoptimizationReason reason, DeoptimizationAction action, ResolvedJavaMethod targetMethod) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.reason = reason;
        this.action = action;
        this.targetMethod = targetMethod;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        SpeculationLog speculationLog = this.graph().getSpeculationLog();
        if (speculationLog != null) {
            SpeculationLog.SpeculationReason speculationReason = PartialEvaluator.createTruffleBoundaryExceptionSpeculation(this.targetMethod);
            if (speculationLog.maySpeculate(speculationReason)) {
                SpeculationLog.Speculation exceptionSpeculation = speculationLog.speculate(speculationReason);
                return new DeoptimizeNode(this.action, this.reason, exceptionSpeculation);
            }
            return null;
        }
        return this;
    }
}

