/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.nodes.frame;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameAccessFlags;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameAccessType;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameAccessorNode;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class VirtualFrameIsNode
extends VirtualFrameAccessorNode
implements Virtualizable {
    public static final NodeClass<VirtualFrameIsNode> TYPE = NodeClass.create(VirtualFrameIsNode.class);
    public static final int STATIC_TAG = 8;

    public VirtualFrameIsNode(InvocationPlugin.Receiver frame, int frameSlotIndex, int accessTag, VirtualFrameAccessType type) {
        super(TYPE, StampFactory.forKind(JavaKind.Boolean), frame, frameSlotIndex, accessTag, type, VirtualFrameAccessFlags.BENIGN);
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        VirtualObjectNode tagVirtual;
        ValueNode tagAlias = tool.getAlias(this.frame.getTagArray(this.type));
        if (tagAlias instanceof VirtualObjectNode && this.frameSlotIndex < (tagVirtual = (VirtualObjectNode)tagAlias).entryCount()) {
            if (this.accessTag == 8) {
                tool.replaceWith(this.getConstant(this.frame.isStatic(this.frameSlotIndex) ? 1 : 0));
                return;
            }
            ValueNode actualTag = tool.getEntry(tagVirtual, this.frameSlotIndex);
            if (actualTag.isConstant()) {
                tool.replaceWith(this.getConstant(actualTag.asJavaConstant().asInt() == this.accessTag ? 1 : 0));
            } else {
                IntegerEqualsNode comparison = new IntegerEqualsNode(actualTag, this.getConstant(this.accessTag));
                tool.addNode(comparison);
                ConditionalNode result = new ConditionalNode(comparison, this.getConstant(1), this.getConstant(0));
                tool.addNode(result);
                tool.replaceWith(result);
            }
            return;
        }
        this.insertDeoptimization(tool);
    }
}

