/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.nodes.frame;

import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ReinterpretNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.truffle.nodes.frame.NewFrameNode;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameAccessFlags;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameAccessType;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameAccessVerificationNode;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameAccessorNode;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class VirtualFrameSetNode
extends VirtualFrameAccessorNode
implements Virtualizable {
    public static final NodeClass<VirtualFrameSetNode> TYPE = NodeClass.create(VirtualFrameSetNode.class);
    @Node.Input
    private ValueNode value;

    public VirtualFrameSetNode(InvocationPlugin.Receiver frame, int frameSlotIndex, int accessTag, ValueNode value, VirtualFrameAccessType type, VirtualFrameAccessFlags accessFlags) {
        super(TYPE, StampFactory.forVoid(), frame, frameSlotIndex, accessTag, type, accessFlags);
        this.value = value;
        assert (accessFlags.updatesFrame());
    }

    public VirtualFrameSetNode(NewFrameNode frame, int frameSlotIndex, int accessTag, ValueNode value, VirtualFrameAccessType type, VirtualFrameAccessFlags accessFlags) {
        super(TYPE, StampFactory.forVoid(), frame, frameSlotIndex, accessTag, type, accessFlags);
        this.value = value;
        assert (accessFlags.updatesFrame());
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        JavaKind valueKind = this.value.getStackKind();
        if (this.type == VirtualFrameAccessType.Auxiliary) {
            VirtualObjectNode dataVirtual;
            ValueNode dataAlias = tool.getAlias(this.frame.getObjectArray(this.type));
            assert (valueKind == JavaKind.Object) : Assertions.errorMessage(valueKind);
            if (dataAlias instanceof VirtualObjectNode && this.frameSlotIndex < (dataVirtual = (VirtualObjectNode)dataAlias).entryCount() && tool.setVirtualEntry(dataVirtual, this.frameSlotIndex, this.value, valueKind, -1L)) {
                tool.delete();
                return;
            }
        } else {
            ValueNode tagAlias = tool.getAlias(this.frame.getTagArray(this.type));
            ValueNode dataAlias = tool.getAlias(valueKind == JavaKind.Object ? this.frame.getObjectArray(this.type) : this.frame.getPrimitiveArray(this.type));
            if (tagAlias instanceof VirtualObjectNode && dataAlias instanceof VirtualObjectNode) {
                VirtualObjectNode tagVirtual = (VirtualObjectNode)tagAlias;
                VirtualObjectNode dataVirtual = (VirtualObjectNode)dataAlias;
                if (this.frameSlotIndex < tagVirtual.entryCount() && this.frameSlotIndex < dataVirtual.entryCount()) {
                    ValueNode actualValue;
                    this.ensureStaticSlotAccessConsistency();
                    if (this.accessFlags.setsTag()) {
                        if (this.accessFlags.isStatic()) {
                            tool.setVirtualEntry(tagVirtual, this.frameSlotIndex, this.getConstantWithStaticModifier(this.accessTag));
                        } else {
                            tool.setVirtualEntry(tagVirtual, this.frameSlotIndex, this.getConstant(this.accessTag));
                        }
                    }
                    if (tool.setVirtualEntry(dataVirtual, this.frameSlotIndex, actualValue = this.maybeExtendForOSRStaticAccess(tool), valueKind == JavaKind.Object ? JavaKind.Object : JavaKind.Long, -1L)) {
                        ValueNode primitiveAlias;
                        if (valueKind == JavaKind.Object && (primitiveAlias = tool.getAlias(this.frame.getPrimitiveArray(this.type))) instanceof VirtualObjectNode) {
                            tool.setVirtualEntry((VirtualObjectNode)primitiveAlias, this.frameSlotIndex, ConstantNode.defaultForKind(JavaKind.Long, this.graph()), JavaKind.Long, -1L);
                        }
                        tool.delete();
                        return;
                    }
                }
            }
        }
        this.insertDeoptimization(tool);
    }

    private ValueNode maybeExtendForOSRStaticAccess(VirtualizerTool tool) {
        if (!this.isOSRRawStaticAccess()) {
            return this.value;
        }
        Stamp valueStamp = this.value.stamp(NodeView.DEFAULT);
        if (!(valueStamp instanceof PrimitiveStamp)) {
            return this.value;
        }
        return VirtualFrameSetNode.extendForOSRStaticAccess(tool, tool.getAlias(this.value));
    }

    private static ValueNode extendForOSRStaticAccess(VirtualizerTool tool, ValueNode entry) {
        JavaKind entryKind = entry.stamp(NodeView.DEFAULT).getStackKind();
        if (entryKind == JavaKind.Long) {
            return entry;
        }
        assert (entryKind.isPrimitive());
        ValueNode tmpValue = entry;
        if (entryKind.isNumericFloat()) {
            entryKind = entryKind == JavaKind.Float ? JavaKind.Int : JavaKind.Long;
            tmpValue = new ReinterpretNode(entryKind, tmpValue);
            tool.addNode(tmpValue);
        }
        if (entryKind != JavaKind.Long) {
            tmpValue = new ZeroExtendNode(tmpValue, JavaKind.Long.getBitCount());
            tool.addNode(tmpValue);
        }
        assert (tmpValue.stamp(NodeView.DEFAULT).getStackKind() == JavaKind.Long) : Assertions.errorMessage(tmpValue, entry, tool);
        return tmpValue;
    }

    private boolean isOSRRawStaticAccess() {
        return this.accessFlags.isStatic() && this.frame.isBytecodeOSRTransferTarget();
    }

    @Override
    public <State> void updateVerificationState(VirtualFrameAccessVerificationNode.VirtualFrameVerificationStateUpdater<State> updater, State state) {
        if (this.isOSRRawStaticAccess()) {
            updater.set(state, this.getFrameSlotIndex(), (byte)1);
        } else {
            updater.set(state, this.getFrameSlotIndex(), (byte)this.getAccessTag());
        }
    }
}

