/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases;

import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.truffle.TruffleTierContext;

public final class InliningAcrossTruffleBoundaryPhase
extends BasePhase<TruffleTierContext> {
    @Override
    protected void run(StructuredGraph graph, TruffleTierContext context) {
        graph.checkCancellation();
        for (MethodCallTargetNode node : graph.getNodes(MethodCallTargetNode.TYPE)) {
            TruffleCompilerRuntime.InlineKind inlineKind = context.partialEvaluator.getMethodInfo(node.targetMethod()).inlineForTruffleBoundary();
            if (inlineKind.allowsInlining()) continue;
            node.invoke().setUseForInlining(false);
        }
    }
}

