/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.MethodFilter;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.truffle.KnownTruffleTypes;
import jdk.graal.compiler.truffle.TruffleCompilerOptions;
import jdk.graal.compiler.truffle.TruffleTierContext;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public abstract class InstrumentPhase
extends BasePhase<TruffleTierContext> {
    private final Instrumentation instrumentation;

    public InstrumentPhase(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    protected String instrumentationFilter(OptionValues options) {
        return TruffleCompilerOptions.InstrumentFilter.getValue(options);
    }

    protected static void insertCounter(StructuredGraph graph, TruffleTierContext context, JavaConstant tableConstant, FixedWithNextNode targetNode, int slotIndex) {
        assert (tableConstant != null);
        TypeReference typeRef = TypeReference.createExactTrusted(context.getMetaAccess().lookupJavaType(tableConstant));
        ConstantNode table = graph.unique(new ConstantNode((Constant)tableConstant, (Stamp)StampFactory.object(typeRef, true)));
        ConstantNode rawIndex = graph.unique(ConstantNode.forInt(slotIndex));
        LoadIndexedNode load = graph.add(new LoadIndexedNode(null, table, rawIndex, null, JavaKind.Long));
        ConstantNode one = graph.unique(ConstantNode.forLong(1L));
        ValueNode add = graph.unique(new AddNode(load, one));
        StoreIndexedNode store = graph.add(new StoreIndexedNode(table, rawIndex, null, null, JavaKind.Long, add));
        graph.addAfterFixed(targetNode, load);
        graph.addAfterFixed(load, store);
    }

    @Override
    public float codeSizeIncrease() {
        return 2.5f;
    }

    @Override
    protected void run(StructuredGraph graph, TruffleTierContext context) {
        JavaConstant tableConstant = context.getSnippetReflection().forObject(this.instrumentation.getAccessTable());
        try {
            this.instrumentGraph(graph, context, tableConstant);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected MethodFilter methodFilter(TruffleTierContext context) {
        String filterValue = this.instrumentationFilter(context.compilerOptions);
        if (filterValue != null) {
            return MethodFilter.parse(filterValue);
        }
        return MethodFilter.matchNothing();
    }

    protected abstract void instrumentGraph(StructuredGraph var1, TruffleTierContext var2, JavaConstant var3);

    protected abstract int instrumentationPointSlotCount();

    protected abstract boolean instrumentPerInlineSite();

    protected abstract Point createPoint(int var1, int var2, Node var3);

    public Point getOrCreatePoint(Node n, MethodFilter methodFilter) {
        Point point = this.instrumentation.getOrCreatePoint(methodFilter, n, this);
        assert (point == null || point.slotCount() == this.instrumentationPointSlotCount()) : "Slot count mismatch between instrumentation point and expected value.";
        return point;
    }

    public static class Instrumentation {
        private Comparator<Point> pointsComparator = new Comparator<Point>(this){

            @Override
            public int compare(Point x, Point y) {
                long diff = y.getHotness() - x.getHotness();
                if (diff < 0L) {
                    return -1;
                }
                if (diff == 0L) {
                    return 0;
                }
                return 1;
            }
        };
        private Comparator<Map.Entry<String, Point>> entriesComparator = new Comparator<Map.Entry<String, Point>>(this){

            @Override
            public int compare(Map.Entry<String, Point> x, Map.Entry<String, Point> y) {
                long diff = y.getValue().getHotness() - x.getValue().getHotness();
                if (diff < 0L) {
                    return -1;
                }
                if (diff == 0L) {
                    return 0;
                }
                return 1;
            }
        };
        private final long[] accessTable;
        public Map<String, Point> pointMap = new LinkedHashMap<String, Point>();
        public int tableIdCount;
        public int tableStartIndex;
        private final String[] omittedStackPatterns;

        public Instrumentation(KnownTruffleTypes types, long[] accessTable) {
            this.accessTable = accessTable;
            this.omittedStackPatterns = new String[]{Instrumentation.asStackPattern(types.OptimizedCallTarget_executeRootNode), Instrumentation.asStackPattern(types.OptimizedCallTarget_profiledPERoot), Instrumentation.asStackPattern(types.OptimizedCallTarget_callDirect), Instrumentation.asStackPattern(types.OptimizedCallTarget_call)};
        }

        private static String asStackPattern(ResolvedJavaMethod method) {
            return method.getDeclaringClass().toJavaName(true) + "." + method.getName();
        }

        private static String filterAndEncode(MethodFilter methodFilter, Node node, InstrumentPhase phase) {
            NodeSourcePosition pos = node.getNodeSourcePosition();
            if (pos != null) {
                if (!methodFilter.matches((JavaMethod)pos.getMethod())) {
                    return null;
                }
                if (phase.instrumentPerInlineSite()) {
                    StringBuilder sb = new StringBuilder();
                    while (pos != null) {
                        MetaUtil.appendLocation((StringBuilder)sb.append("at "), (ResolvedJavaMethod)pos.getMethod(), (int)pos.getBCI());
                        if ((pos = pos.getCaller()) == null) continue;
                        sb.append(CodeUtil.NEW_LINE);
                    }
                    return sb.toString();
                }
                return MetaUtil.appendLocation((StringBuilder)new StringBuilder(), (ResolvedJavaMethod)pos.getMethod(), (int)pos.getBCI()).toString();
            }
            return null;
        }

        private String prettify(String key, Point p) {
            if (p.isPrettified()) {
                StringBuilder sb = new StringBuilder();
                NodeSourcePosition pos = p.getPosition();
                NodeSourcePosition lastPos = null;
                int repetitions = 1;
                block0: while (pos != null) {
                    for (String pattern : this.omittedStackPatterns) {
                        if (!pos.getMethod().format("%H.%n(%p)").contains(pattern)) continue;
                        pos = pos.getCaller();
                        continue block0;
                    }
                    if (lastPos == null) {
                        lastPos = pos;
                        MetaUtil.appendLocation((StringBuilder)sb, (ResolvedJavaMethod)pos.getMethod(), (int)pos.getBCI());
                    } else if (!lastPos.getMethod().equals((Object)pos.getMethod())) {
                        if (repetitions > 1) {
                            sb.append(" x" + repetitions);
                            repetitions = 1;
                        }
                        sb.append(CodeUtil.NEW_LINE);
                        lastPos = pos;
                        MetaUtil.appendLocation((StringBuilder)sb, (ResolvedJavaMethod)pos.getMethod(), (int)pos.getBCI());
                    } else if (lastPos.getBCI() != pos.getBCI()) {
                        if (repetitions > 1) {
                            sb.append(" x" + repetitions);
                            repetitions = 1;
                        }
                        lastPos = pos;
                        sb.append(" [bci: " + pos.getBCI() + "]");
                    } else {
                        ++repetitions;
                    }
                    pos = pos.getCaller();
                }
                if (repetitions > 1) {
                    sb.append(" x" + repetitions);
                    repetitions = 1;
                }
                return sb.toString();
            }
            return key;
        }

        public synchronized ArrayList<String> accessTableToList() {
            ArrayList<AbstractMap.SimpleImmutableEntry<String, Point>> sortedEntries = new ArrayList<AbstractMap.SimpleImmutableEntry<String, Point>>();
            for (Map.Entry<String, Point> entry : this.pointMap.entrySet()) {
                if (!entry.getValue().shouldInclude()) continue;
                AbstractMap.SimpleImmutableEntry<String, Point> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<String, Point>(entry.getKey(), entry.getValue());
                sortedEntries.add(simpleImmutableEntry);
            }
            Collections.sort(sortedEntries, this.entriesComparator);
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry entry : sortedEntries) {
                list.add(this.prettify((String)entry.getKey(), (Point)entry.getValue()) + CodeUtil.NEW_LINE + String.valueOf(entry.getValue()));
            }
            return list;
        }

        public synchronized ArrayList<String> accessTableToHistogram() {
            long totalExecutions = 0L;
            for (Point point : this.pointMap.values()) {
                totalExecutions += point.getHotness();
            }
            ArrayList<Point> sortedPoints = new ArrayList<Point>();
            for (Point p : this.pointMap.values()) {
                if (!p.shouldInclude()) continue;
                sortedPoints.add(p);
            }
            Collections.sort(sortedPoints, this.pointsComparator);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Point point : sortedPoints) {
                int length = (int)(1.0 * (double)point.getHotness() / (double)totalExecutions * 80.0);
                String bar = String.join((CharSequence)"", Collections.nCopies(length, "*"));
                arrayList.add(String.format("%3d: %s", point.getId(), bar));
            }
            return arrayList;
        }

        public synchronized void dumpAccessTable() {
            TTY.println("Execution profile (sorted by hotness)");
            TTY.println("=====================================");
            for (String line : this.accessTableToHistogram()) {
                TTY.println(line);
            }
            TTY.println();
            for (String line : this.accessTableToList()) {
                TTY.println(line);
                TTY.println();
            }
        }

        public synchronized Point getOrCreatePoint(MethodFilter methodFilter, Node n, InstrumentPhase phase) {
            String key = Instrumentation.filterAndEncode(methodFilter, n, phase);
            if (key == null) {
                return null;
            }
            Point existing = this.pointMap.get(key);
            int slotCount = phase.instrumentationPointSlotCount();
            if (existing != null) {
                return existing;
            }
            if (this.tableStartIndex + slotCount < phase.getInstrumentation().getAccessTable().length) {
                int id = this.tableIdCount++;
                int startIndex = this.tableStartIndex;
                this.tableStartIndex += slotCount;
                Point p = phase.createPoint(id, startIndex, n);
                this.pointMap.put(key, p);
                return p;
            }
            if (this.tableStartIndex < phase.getInstrumentation().getAccessTable().length) {
                TTY.println("Maximum number of instrumentation counters exceeded.");
                this.tableStartIndex += slotCount;
            }
            return null;
        }

        public long[] getAccessTable() {
            return this.accessTable;
        }
    }

    public static abstract class Point {
        protected int id;
        protected int rawIndex;
        protected NodeSourcePosition position;

        public Point(int id, int rawIndex, NodeSourcePosition position) {
            this.id = id;
            this.rawIndex = rawIndex;
            this.position = position;
        }

        public int slotIndex(int offset) {
            assert (offset < this.slotCount()) : "Offset exceeds instrumentation point's slot count: " + offset;
            return this.rawIndex + offset;
        }

        public int getId() {
            return this.id;
        }

        public NodeSourcePosition getPosition() {
            return this.position;
        }

        public abstract int slotCount();

        public abstract long getHotness();

        public abstract boolean isPrettified();

        public boolean shouldInclude() {
            return true;
        }
    }

    public static final class InstrumentationConfiguration {
        public final boolean instrumentBranches;
        public final boolean instrumentBranchesPerInlineSite;
        public final boolean instrumentBoundaries;
        public final boolean instrumentBoundariesPerInlineSite;
        public final int instrumentationTableSize;

        public InstrumentationConfiguration(OptionValues options) {
            this.instrumentBranches = TruffleCompilerOptions.InstrumentBranches.getValue(options);
            this.instrumentBranchesPerInlineSite = TruffleCompilerOptions.InstrumentBranchesPerInlineSite.getValue(options);
            this.instrumentBoundaries = TruffleCompilerOptions.InstrumentBoundaries.getValue(options);
            this.instrumentBoundariesPerInlineSite = TruffleCompilerOptions.InstrumentBoundariesPerInlineSite.getValue(options);
            this.instrumentationTableSize = TruffleCompilerOptions.InstrumentationTableSize.getValue(options);
        }
    }
}

