/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases.inlining;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.util.GraphOrder;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.graal.compiler.truffle.PartialEvaluator;
import jdk.graal.compiler.truffle.PostPartialEvaluationSuite;
import jdk.graal.compiler.truffle.TruffleCompilerOptions;
import jdk.graal.compiler.truffle.TruffleInliningScope;
import jdk.graal.compiler.truffle.TruffleTierContext;
import jdk.graal.compiler.truffle.phases.inlining.CallTree;
import jdk.graal.compiler.truffle.phases.inlining.InliningPolicy;
import jdk.graal.compiler.truffle.phases.inlining.InliningPolicyProvider;

public final class AgnosticInliningPhase
extends BasePhase<TruffleTierContext> {
    private static final ArrayList<InliningPolicyProvider> POLICY_PROVIDERS;
    private final PartialEvaluator partialEvaluator;
    private final PostPartialEvaluationSuite postPartialEvaluationSuite;

    public AgnosticInliningPhase(PartialEvaluator partialEvaluator, PostPartialEvaluationSuite postPartialEvaluationSuite) {
        this.partialEvaluator = partialEvaluator;
        this.postPartialEvaluationSuite = postPartialEvaluationSuite;
    }

    private static InliningPolicyProvider chosenProvider(String name) {
        for (InliningPolicyProvider provider : POLICY_PROVIDERS) {
            if (!provider.getName().equals(name)) continue;
            return provider;
        }
        throw new IllegalStateException("No inlining policy provider with provided name: " + name);
    }

    private static InliningPolicyProvider getInliningPolicyProvider(TruffleTierContext context) {
        boolean firstTier = context.isFirstTier();
        String policy = (firstTier ? TruffleCompilerOptions.FirstTierInliningPolicy : TruffleCompilerOptions.InliningPolicy).getValue(context.compilerOptions);
        if (Objects.equals(policy, "")) {
            return POLICY_PROVIDERS.get(firstTier ? POLICY_PROVIDERS.size() - 1 : 0);
        }
        return AgnosticInliningPhase.chosenProvider(policy);
    }

    @Override
    protected void run(StructuredGraph graph, TruffleTierContext context) {
        InliningPolicy policy = AgnosticInliningPhase.getInliningPolicyProvider(context).get(context.compilerOptions, context);
        CallTree tree = new CallTree(this.partialEvaluator, this.postPartialEvaluationSuite, context, policy);
        TruffleInliningScope scope = TruffleInliningScope.getCurrent(context.debug);
        if (scope != null) {
            scope.setCallTree(tree);
        }
        tree.dumpBasic("Before Inline");
        if (TruffleCompilerOptions.Inlining.getValue(context.compilerOptions).booleanValue()) {
            policy.run(tree);
            tree.dumpBasic("After Inline");
            tree.collectTargetsToDequeue(context.task);
            tree.updateTracingInfo(context.task);
        }
        tree.finalizeGraph();
        tree.trace();
        if (!tree.getRoot().getChildren().isEmpty()) {
            this.postPartialEvaluationSuite.apply(graph, context);
        }
        graph.maybeCompress();
        assert (GraphOrder.assertSchedulableGraph(graph));
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    static {
        Iterable<InliningPolicyProvider> services = GraalServices.load(InliningPolicyProvider.class);
        ArrayList<InliningPolicyProvider> providers = new ArrayList<InliningPolicyProvider>();
        for (InliningPolicyProvider provider : services) {
            providers.add(provider);
        }
        Collections.sort(providers);
        POLICY_PROVIDERS = providers;
    }
}

