/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases.inlining;

import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import jdk.graal.compiler.core.common.PermanentBailoutException;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeSuccessorList;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.phases.contract.NodeCostUtil;
import jdk.graal.compiler.truffle.PerformanceInformationHandler;
import jdk.graal.compiler.truffle.TruffleCompilerOptions;
import jdk.graal.compiler.truffle.TruffleTierContext;
import jdk.graal.compiler.truffle.phases.inlining.CallTree;
import jdk.graal.compiler.truffle.phases.inlining.GraphManager;
import jdk.graal.compiler.truffle.phases.inlining.InliningPolicy;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.UnmodifiableEconomicMap;

@NodeInfo(nameTemplate="{p#directCallTarget}", cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public final class CallNode
extends Node
implements Comparable<CallNode> {
    private static final NodeClass<CallNode> TYPE = NodeClass.create(CallNode.class);
    private JavaConstant callNode;
    private final TruffleCompilable directCallTarget;
    private final int truffleCallees;
    private final double rootRelativeFrequency;
    private final int depth;
    private final int id;
    private boolean trivial;
    @Node.Successor
    private NodeSuccessorList<CallNode> children;
    private State state = State.Cutoff;
    private Object policyData;
    private int recursionDepth = -1;
    private StructuredGraph irAfterPE;
    private StructuredGraph ir;
    private Invoke invoke;
    private int graphSize;
    private boolean forced;
    private boolean root;

    protected CallNode(JavaConstant callNode, TruffleCompilable directCallTarget, double rootRelativeFrequency, int depth, int id, boolean forced) {
        super(TYPE);
        this.rootRelativeFrequency = rootRelativeFrequency;
        this.callNode = callNode;
        this.directCallTarget = directCallTarget;
        this.truffleCallees = directCallTarget != null ? directCallTarget.countDirectCallNodes() : 0;
        this.trivial = directCallTarget != null && directCallTarget.isTrivial();
        this.children = new NodeSuccessorList((Node)this, 0);
        this.depth = depth;
        this.id = id;
        this.forced = forced;
    }

    public JavaConstant getCallNode() {
        return this.callNode;
    }

    static CallNode makeRoot(TruffleTierContext context, CallTree callTree) {
        Objects.requireNonNull(callTree);
        Objects.requireNonNull(context);
        CallNode root = new CallNode(null, context.compilable, 1.0, 0, callTree.nextId(), false);
        root.root = true;
        callTree.add(root);
        root.ir = context.graph;
        root.policyData = callTree.getPolicy().newCallNodeData(root);
        GraphManager.Entry entry = callTree.getGraphManager().peRoot();
        root.irAfterPE = entry.graphAfterPEForDebugDump;
        root.graphSize = entry.graphSize;
        EconomicSet<Invoke> directInvokes = entry.directInvokes;
        root.verifyTrivial(entry);
        CallNode.addChildren(context, root, directInvokes);
        root.state = State.Inlined;
        callTree.getPolicy().afterExpand(root);
        callTree.frontierSize = root.children.size();
        return root;
    }

    private static void addChildren(TruffleTierContext context, CallNode node, EconomicSet<Invoke> directInvokes) {
        for (Invoke invoke : directInvokes) {
            if (!invoke.isAlive()) continue;
            ValueNode nodeArgument = (ValueNode)invoke.callTarget().arguments().get(1);
            Integer callNodeCount = CallNode.getCallCount(context, nodeArgument);
            TruffleCompilable constantTarget = CallNode.resolveTargetReceiver(context, invoke);
            boolean forced = CallNode.isInliningForced(context, nodeArgument);
            double relativeFrequency = callNodeCount == null ? 1.0 : CallNode.calculateFrequency(node.directCallTarget, callNodeCount);
            double childFrequency = relativeFrequency * node.rootRelativeFrequency;
            CallNode callNode = new CallNode(nodeArgument.asJavaConstant(), constantTarget, childFrequency, node.depth + 1, node.getCallTree().nextId(), forced);
            node.getCallTree().add(callNode);
            node.children.add((Object)callNode);
            callNode.policyData = node.getPolicy().newCallNodeData(callNode);
            callNode.setInvokeOrRemove(invoke);
        }
        node.getPolicy().afterAddChildren(node);
    }

    static TruffleCompilable resolveTargetReceiver(TruffleTierContext context, Invoke invoke) {
        ValueNode receiver = invoke.getReceiver();
        if (receiver.isJavaConstant()) {
            return context.runtime().asCompilableTruffleAST(receiver.asJavaConstant());
        }
        throw GraalError.shouldNotReachHere("DirectCall without constant receiver should not be reachable.");
    }

    static Integer getCallCount(TruffleTierContext context, ValueNode callNode) {
        if (!callNode.isJavaConstant()) {
            return null;
        }
        JavaConstant callCount = context.getConstantReflection().readFieldValue(context.types().OptimizedDirectCallNode_callCount, callNode.asJavaConstant());
        if (callCount == null) {
            return null;
        }
        return callCount.asInt();
    }

    static boolean isInliningForced(TruffleTierContext context, ValueNode callNode) {
        if (!callNode.isJavaConstant()) {
            return false;
        }
        JavaConstant callCount = context.getConstantReflection().readFieldValue(context.types().OptimizedDirectCallNode_inliningForced, callNode.asJavaConstant());
        if (callCount == null) {
            return false;
        }
        return callCount.asBoolean();
    }

    private static double calculateFrequency(TruffleCompilable target, int callNodeCount) {
        return (double)Math.max(1, callNodeCount) / (double)Math.max(1, target.getCallCount());
    }

    public TruffleCompilable getDirectCallTarget() {
        return this.directCallTarget;
    }

    private void putProperties(Map<Object, Object> properties) {
        if (this.state == State.Indirect) {
            return;
        }
        properties.put("Frequency", this.rootRelativeFrequency);
        properties.put("Recursion Depth", this.getRecursionDepth());
        properties.put("IR Nodes", this.ir == null ? 0 : this.ir.getNodeCount());
        properties.put("Graph Size", this.graphSize);
        properties.put("Truffle Callees", this.truffleCallees);
        properties.put("Explore/inline ratio", this.exploreInlineRatio());
        properties.put("Depth", this.depth);
        properties.put("Forced", this.isForced());
        this.getPolicy().putProperties(this, properties);
    }

    private double exploreInlineRatio() {
        CallTree callTree = this.getCallTree();
        return this.isRoot() ? (double)callTree.expanded / (double)callTree.inlined : Double.NaN;
    }

    public int getRecursionDepth() {
        if (this.recursionDepth == -1) {
            this.recursionDepth = this.computeRecursionDepth();
        }
        return this.recursionDepth;
    }

    private int computeRecursionDepth() {
        return this.computeRecursionDepth(this.getParent(), this.directCallTarget);
    }

    private int computeRecursionDepth(CallNode node, TruffleCompilable target) {
        if (node == null) {
            return 0;
        }
        int parentDepth = this.computeRecursionDepth(node.getParent(), target);
        if (node.directCallTarget.isSameOrSplit(target)) {
            return parentDepth + 1;
        }
        return parentDepth;
    }

    public int getDepth() {
        return this.depth;
    }

    public InliningPolicy getPolicy() {
        return this.getCallTree().getPolicy();
    }

    private void setInvokeOrRemove(Invoke newInvoke) {
        if (newInvoke == null || !newInvoke.isAlive()) {
            this.remove();
        } else {
            this.invoke = newInvoke;
        }
    }

    public void remove() {
        this.state = State.Removed;
        this.getPolicy().removedNode(this);
    }

    private void addIndirectChildren(GraphManager.Entry entry) {
        for (Invoke indirectInvoke : entry.indirectInvokes) {
            if (indirectInvoke == null || !indirectInvoke.isAlive()) continue;
            CallNode child = new CallNode(null, null, 0.0, this.depth + 1, this.getCallTree().nextId(), false);
            child.state = State.Indirect;
            child.invoke = indirectInvoke;
            this.getCallTree().add(child);
            this.children.add((Object)child);
        }
    }

    public void expand() {
        GraphManager.Entry entry;
        assert (this.state == State.Cutoff) : "Cannot expand a non-cutoff node. Node is " + String.valueOf((Object)this.state);
        assert (this.getParent() != null);
        this.state = State.Expanded;
        ++this.getCallTree().expanded;
        assert (this.state == State.Expanded) : Assertions.errorMessage(new Object[]{this.state});
        assert (this.ir == null);
        GraphManager manager = this.getCallTree().getGraphManager();
        try {
            entry = manager.pe(this.directCallTarget);
        }
        catch (PermanentBailoutException e) {
            this.state = State.BailedOut;
            return;
        }
        this.verifyTrivial(entry);
        this.ir = this.copyGraphAndAddChildren(manager.rootContext(), entry);
        this.graphSize = entry.graphSize;
        this.irAfterPE = entry.graphAfterPEForDebugDump;
        this.addIndirectChildren(entry);
        this.getPolicy().afterExpand(this);
    }

    private void verifyTrivial(GraphManager.Entry entry) {
        if (this.trivial && !entry.trivial) {
            this.trivial = false;
            PerformanceInformationHandler.logPerformanceWarning(TruffleCompilerOptions.PerformanceWarningKind.TRIVIAL_FAIL, this.directCallTarget, Collections.emptyList(), "Root node of target marked trivial but not trivial after PE", Collections.emptyMap());
        }
    }

    private StructuredGraph copyGraphAndAddChildren(final TruffleTierContext context, final GraphManager.Entry entry) {
        StructuredGraph graph = entry.graph;
        return (StructuredGraph)graph.copy(new Consumer<UnmodifiableEconomicMap<Node, Node>>(){
            final /* synthetic */ CallNode this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(UnmodifiableEconomicMap<Node, Node> duplicates) {
                EconomicSet replacements = EconomicSet.create();
                for (Invoke original : entry.directInvokes) {
                    Invoke replacement;
                    if (!original.isAlive() || (replacement = (Invoke)duplicates.get((Object)((Node)((Object)original)))) == null || !replacement.isAlive()) continue;
                    replacements.add((Object)replacement);
                }
                CallNode.addChildren(context, this.this$0, (EconomicSet<Invoke>)replacements);
            }
        }, graph.getDebug());
    }

    public void inline() {
        this.inline(InliningUtil.NoReturnAction);
    }

    public void inline(InliningUtil.InlineeReturnAction returnAction) {
        assert (this.state == State.Expanded) : "Cannot inline node that is not expanded: " + String.valueOf((Object)this.state);
        assert (this.ir != null) : this.ir;
        assert (this.getParent() != null);
        if (!this.invoke.isAlive()) {
            this.remove();
            return;
        }
        UnmodifiableEconomicMap<Node, Node> replacements = this.getCallTree().getGraphManager().doInline(this.invoke, this.ir, this.directCallTarget, returnAction);
        this.updateChildInvokes(replacements);
        this.state = State.Inlined;
        ++this.getCallTree().inlined;
        this.getCallTree().frontierSize += this.children.size() - 1;
    }

    private void updateChildInvokes(UnmodifiableEconomicMap<Node, Node> replacements) {
        for (CallNode child : this.children) {
            if (child.state == State.Removed) continue;
            Node childInvoke = (Node)((Object)child.invoke);
            if (childInvoke == null || !childInvoke.isAlive() || !replacements.containsKey((Object)childInvoke)) {
                child.remove();
                continue;
            }
            Invoke replacementInvoke = (Invoke)replacements.get((Object)childInvoke);
            child.setInvokeOrRemove(replacementInvoke);
        }
    }

    public boolean isForced() {
        return this.forced;
    }

    public CallNode getParent() {
        return (CallNode)this.predecessor();
    }

    public Invoke getInvoke() {
        return this.invoke;
    }

    public State getState() {
        return this.state;
    }

    public boolean isRoot() {
        return this.root;
    }

    public String getName() {
        if (this.directCallTarget == null) {
            return "<indirect>";
        }
        return this.directCallTarget.toString();
    }

    public List<CallNode> getChildren() {
        return this.children;
    }

    public StructuredGraph getIR() {
        return this.ir;
    }

    public CallTree getCallTree() {
        return (CallTree)this.graph();
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        Map<Object, Object> debugProperties = super.getDebugProperties(map);
        this.putProperties(debugProperties);
        if (this.ir != null) {
            debugProperties.put("ir node count", this.ir.getNodeCount());
        }
        return debugProperties;
    }

    HashMap<String, Object> getStringProperties() {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        this.putProperties(properties);
        HashMap<String, Object> stringProperties = new HashMap<String, Object>();
        for (Object key : properties.keySet()) {
            stringProperties.put(key.toString(), properties.get(key));
        }
        return stringProperties;
    }

    public double getRootRelativeFrequency() {
        return this.rootRelativeFrequency;
    }

    public boolean isTrivial() {
        return this.trivial;
    }

    public int getSize() {
        if (this.getCallTree().useSize) {
            return this.graphSize;
        }
        return this.ir.getNodeCount();
    }

    public int recalculateSize() {
        if (this.getCallTree().useSize) {
            this.graphSize = NodeCostUtil.computeGraphSize(this.ir);
            return this.graphSize;
        }
        return this.ir.getNodeCount();
    }

    public Object getPolicyData() {
        return this.policyData;
    }

    public int getTruffleCallees() {
        return this.truffleCallees;
    }

    @Override
    public String toString(Verbosity v) {
        return "CallNode{state=" + String.valueOf((Object)this.state) + ", children=" + String.valueOf(this.children) + ", truffleAST=" + String.valueOf(this.directCallTarget) + "}";
    }

    @Override
    public int compareTo(CallNode o) {
        return Integer.compare(this.id, o.id);
    }

    public void finalizeGraph() {
        if (this.state == State.Inlined) {
            for (CallNode child : this.children) {
                child.finalizeGraph();
            }
        }
        if (this.state == State.Cutoff || this.state == State.Expanded || this.state == State.BailedOut) {
            if (this.invoke.isAlive()) {
                this.getCallTree().getGraphManager().finalizeGraph(this.invoke, this.directCallTarget);
            } else {
                this.state = State.Removed;
            }
        }
    }

    void collectTargetsToDequeue(TruffleCompilationTask provider) {
        if (this.state == State.Inlined) {
            if (this.directCallTarget != this.getCallTree().getRoot().directCallTarget && this.directCallTarget.getKnownCallSiteCount() == 1) {
                provider.addTargetToDequeue(this.directCallTarget);
            }
            for (CallNode child : this.children) {
                child.collectTargetsToDequeue(provider);
            }
        }
    }

    public void collectInlinedTargets(TruffleCompilationTask inliningPlan) {
        if (this.state == State.Inlined) {
            inliningPlan.addInlinedTarget(this.directCallTarget);
            for (CallNode child : this.children) {
                child.collectInlinedTargets(inliningPlan);
            }
        }
    }

    public static enum State {
        Cutoff,
        Expanded,
        Inlined,
        Removed,
        BailedOut,
        Indirect;

    }
}

