/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases.inlining;

import com.oracle.truffle.compiler.TruffleCompilationTask;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.truffle.PartialEvaluator;
import jdk.graal.compiler.truffle.PostPartialEvaluationSuite;
import jdk.graal.compiler.truffle.TruffleCompilerOptions;
import jdk.graal.compiler.truffle.TruffleTierContext;
import jdk.graal.compiler.truffle.phases.inlining.CallNode;
import jdk.graal.compiler.truffle.phases.inlining.GraphManager;
import jdk.graal.compiler.truffle.phases.inlining.InliningPolicy;

public final class CallTree
extends Graph {
    private final InliningPolicy policy;
    private final GraphManager graphManager;
    private final CallNode root;
    private final TruffleTierContext context;
    final boolean useSize;
    int expanded = 1;
    int inlined = 1;
    int frontierSize;
    private int nextId = 0;

    CallTree(PartialEvaluator partialEvaluator, PostPartialEvaluationSuite postPartialEvaluationSuite, TruffleTierContext context, InliningPolicy policy) {
        super(context.graph.getOptions(), context.debug);
        this.policy = policy;
        this.context = context;
        this.graphManager = new GraphManager(partialEvaluator, postPartialEvaluationSuite, context);
        this.useSize = TruffleCompilerOptions.InliningUseSize.getValue(context.compilerOptions);
        this.root = CallNode.makeRoot(context, this);
    }

    int nextId() {
        return this.nextId++;
    }

    InliningPolicy getPolicy() {
        return this.policy;
    }

    public CallNode getRoot() {
        return this.root;
    }

    public int getInlinedCount() {
        return this.inlined;
    }

    public int getExpandedCount() {
        return this.expanded;
    }

    GraphManager getGraphManager() {
        return this.graphManager;
    }

    void trace() {
        Boolean details = TruffleCompilerOptions.TraceInliningDetails.getValue(this.context.compilerOptions);
        if (TruffleCompilerOptions.TraceInlining.getValue(this.context.compilerOptions).booleanValue() || details.booleanValue()) {
            TruffleCompilerRuntime runtime = this.context.runtime();
            runtime.logEvent(this.root.getDirectCallTarget(), 0, "Inline start", this.root.getName(), this.root.getStringProperties(), null);
            this.traceRecursive(runtime, this.root, details, 0);
            runtime.logEvent(this.root.getDirectCallTarget(), 0, "Inline done", this.root.getName(), this.root.getStringProperties(), null);
        }
    }

    private void traceRecursive(TruffleCompilerRuntime runtime, CallNode node, boolean details, int depth) {
        if (depth != 0) {
            runtime.logEvent(this.root.getDirectCallTarget(), depth, node.getState().toString(), node.getName(), node.getStringProperties(), null);
        }
        if (node.getState() == CallNode.State.Inlined || details) {
            for (CallNode child : node.getChildren()) {
                this.traceRecursive(runtime, child, details, depth + 1);
            }
        }
    }

    @Override
    public String toString() {
        return "Call Tree";
    }

    void dumpBasic(String format) {
        this.getDebug().dump(1, (Object)this, format, "");
    }

    public void dumpInfo(String format, Object arg) {
        this.getDebug().dump(2, (Object)this, format, arg);
    }

    public void finalizeGraph() {
        this.root.finalizeGraph();
    }

    void collectTargetsToDequeue(TruffleCompilationTask task) {
        this.root.collectTargetsToDequeue(task);
    }

    public void updateTracingInfo(TruffleCompilationTask task) {
        int inlinedWithoutRoot = this.inlined - 1;
        task.setCallCounts(inlinedWithoutRoot + this.frontierSize, inlinedWithoutRoot);
        if (this.loggingInlinedTargets()) {
            this.root.collectInlinedTargets(task);
        }
    }

    private boolean loggingInlinedTargets() {
        return this.context.debug.isDumpEnabled(1) || TruffleCompilerOptions.LogInlinedTargets.getValue(this.context.compilerOptions) != false;
    }
}

