/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases.inlining;

import com.oracle.truffle.compiler.TruffleCompilable;
import java.util.List;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.phases.contract.NodeCostUtil;
import jdk.graal.compiler.truffle.PEAgnosticInlineInvokePlugin;
import jdk.graal.compiler.truffle.PartialEvaluator;
import jdk.graal.compiler.truffle.PostPartialEvaluationSuite;
import jdk.graal.compiler.truffle.TruffleCompilerOptions;
import jdk.graal.compiler.truffle.TruffleDebugJavaMethod;
import jdk.graal.compiler.truffle.TruffleTierContext;
import jdk.graal.compiler.truffle.nodes.TruffleAssumption;
import jdk.graal.compiler.truffle.phases.inlining.AgnosticInliningPhase;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.UnmodifiableEconomicMap;

final class GraphManager {
    public static final int TRIVIAL_NODE_COUNT_LIMIT = 500;
    private final PartialEvaluator partialEvaluator;
    private final EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCacheForInlining;
    private final EconomicMap<TruffleCompilable, Entry> irCache = EconomicMap.create();
    private final TruffleTierContext rootContext;
    private final PostPartialEvaluationSuite postPartialEvaluationSuite;
    private final boolean useSize;

    GraphManager(PartialEvaluator partialEvaluator, PostPartialEvaluationSuite postPartialEvaluationSuite, TruffleTierContext rootContext) {
        this.partialEvaluator = partialEvaluator;
        this.postPartialEvaluationSuite = postPartialEvaluationSuite;
        this.rootContext = rootContext;
        this.graphCacheForInlining = partialEvaluator.getOrCreateEncodedGraphCache();
        this.useSize = TruffleCompilerOptions.InliningUseSize.getValue(rootContext.compilerOptions);
    }

    Entry pe(TruffleCompilable truffleAST) {
        Entry entry = (Entry)this.irCache.get((Object)truffleAST);
        if (entry == null) {
            try (DebugContext.Scope guestScope = this.rootContext.debug.scope((Object)"Truffle", new TruffleDebugJavaMethod(this.rootContext.task, truffleAST));){
                PEAgnosticInlineInvokePlugin plugin = this.newPlugin();
                TruffleTierContext context = this.newContext(truffleAST, false);
                try (DebugContext.Scope hostScope = context.debug.scope((Object)"CreateGraph", context.graph);
                     Indent indent = context.debug.logAndIndent("evaluate %s", context.graph);){
                    this.partialEvaluator.doGraphPE(context, plugin, this.graphCacheForInlining);
                    context.graph.getAssumptions().record((Assumptions.Assumption)new TruffleAssumption(context.getNodeRewritingAssumption(this.partialEvaluator.getProviders())));
                    StructuredGraph graphAfterPE = GraphManager.copyGraphForDebugDump(context);
                    this.postPartialEvaluationSuite.apply(context.graph, context);
                    entry = new Entry(context.graph, plugin, graphAfterPE, this.useSize ? NodeCostUtil.computeGraphSize(context.graph) : -1);
                    context.debug.dump(2, context.graph, "After PE Tier");
                }
                catch (Throwable e) {
                    throw context.debug.handle(e);
                }
            }
            catch (Throwable e) {
                throw this.rootContext.debug.handle(e);
            }
            this.irCache.put((Object)truffleAST, (Object)entry);
        }
        return entry;
    }

    private TruffleTierContext newContext(TruffleCompilable truffleAST, boolean finalize) {
        return new TruffleTierContext(this.partialEvaluator, this.rootContext.compilerOptions, this.rootContext.debug, truffleAST, finalize ? this.partialEvaluator.getCallDirect() : this.partialEvaluator.inlineRootForCallTarget(truffleAST), this.rootContext.compilationId, this.rootContext.log, this.rootContext.task, this.rootContext.handler);
    }

    private PEAgnosticInlineInvokePlugin newPlugin() {
        return new PEAgnosticInlineInvokePlugin(this.partialEvaluator);
    }

    TruffleTierContext rootContext() {
        return this.rootContext;
    }

    Entry peRoot() {
        PEAgnosticInlineInvokePlugin plugin = this.newPlugin();
        this.partialEvaluator.doGraphPE(this.rootContext, plugin, this.graphCacheForInlining);
        StructuredGraph graphAfterPE = GraphManager.copyGraphForDebugDump(this.rootContext);
        this.postPartialEvaluationSuite.apply(this.rootContext.graph, this.rootContext);
        this.rootContext.debug.dump(1, this.rootContext.graph, "After PE Tier");
        return new Entry(this.rootContext.graph, plugin, graphAfterPE, this.useSize ? NodeCostUtil.computeGraphSize(this.rootContext.graph) : -1);
    }

    UnmodifiableEconomicMap<Node, Node> doInline(Invoke invoke, StructuredGraph ir, TruffleCompilable truffleAST, InliningUtil.InlineeReturnAction returnAction) {
        return InliningUtil.inline(invoke, ir, true, this.partialEvaluator.inlineRootForCallTarget(truffleAST), "cost-benefit analysis", AgnosticInliningPhase.class.getName(), returnAction);
    }

    void finalizeGraph(Invoke invoke, TruffleCompilable truffleAST) {
        TruffleTierContext context = this.newContext(truffleAST, true);
        this.partialEvaluator.doGraphPE(context, new InlineInvokePlugin(){

            @Override
            public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
                return GraphManager.this.partialEvaluator.asInlineInfo(method);
            }
        }, this.graphCacheForInlining);
        InliningUtil.inline(invoke, context.graph, true, this.partialEvaluator.getCallInlined(), "finalization", AgnosticInliningPhase.class.getName());
    }

    private static StructuredGraph copyGraphForDebugDump(TruffleTierContext context) {
        if (context.debug.isDumpEnabled(2)) {
            return (StructuredGraph)context.graph.copy(context.debug);
        }
        return null;
    }

    static final class Entry {
        final StructuredGraph graph;
        final EconomicSet<Invoke> directInvokes;
        final List<Invoke> indirectInvokes;
        final boolean trivial;
        final StructuredGraph graphAfterPEForDebugDump;
        final int graphSize;

        Entry(StructuredGraph graph, PEAgnosticInlineInvokePlugin plugin, StructuredGraph graphAfterPEForDebugDump, int graphSize) {
            this.graph = graph;
            this.directInvokes = plugin.getDirectInvokes();
            this.indirectInvokes = plugin.getIndirectInvokes();
            this.trivial = this.directInvokes.isEmpty() && this.indirectInvokes.isEmpty() && graph.getNodes(LoopBeginNode.TYPE).count() == 0 && graph.getNodeCount() < 500;
            this.graphAfterPEForDebugDump = graphAfterPEForDebugDump;
            this.graphSize = graphSize;
        }
    }
}

