/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.phases.inlining;

import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.truffle.TruffleCompilerOptions;
import jdk.graal.compiler.truffle.phases.inlining.CallNode;
import jdk.graal.compiler.truffle.phases.inlining.CallTree;
import jdk.graal.compiler.truffle.phases.inlining.InliningPolicy;

final class TrivialOnlyInliningPolicy
implements InliningPolicy {
    private final OptionValues options;

    TrivialOnlyInliningPolicy(OptionValues options) {
        this.options = options;
    }

    @Override
    public void run(CallTree tree) {
        String inlineOnly = TruffleCompilerOptions.InlineOnly.getValue(this.options);
        for (CallNode child : tree.getRoot().getChildren()) {
            if (!InliningPolicy.acceptForInline(child, inlineOnly) || !child.isTrivial()) continue;
            child.expand();
            if (child.getState() != CallNode.State.Expanded) continue;
            child.inline();
        }
    }
}

