/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.truffle.substitutions;

import com.oracle.truffle.compiler.TruffleCompilationTask;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConditionAnchorNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.DynamicPiNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiArrayNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerMulHighNode;
import jdk.graal.compiler.nodes.calc.RoundNode;
import jdk.graal.compiler.nodes.debug.BlackholeNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.GuardedUnsafeLoadNode;
import jdk.graal.compiler.nodes.extended.RawLoadNode;
import jdk.graal.compiler.nodes.extended.RawStoreNode;
import jdk.graal.compiler.nodes.extended.UnsafeAccessNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.java.InstanceOfDynamicNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.spi.LoweringProvider;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.EnsureVirtualizedNode;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.PEGraphDecoder;
import jdk.graal.compiler.replacements.StandardGraphBuilderPlugins;
import jdk.graal.compiler.replacements.nodes.arithmetic.UnsignedMulHighNode;
import jdk.graal.compiler.serviceprovider.SpeculationReasonGroup;
import jdk.graal.compiler.truffle.KnownTruffleTypes;
import jdk.graal.compiler.truffle.PerformanceInformationHandler;
import jdk.graal.compiler.truffle.TruffleCompilation;
import jdk.graal.compiler.truffle.TruffleCompilerOptions;
import jdk.graal.compiler.truffle.TruffleDebugJavaMethod;
import jdk.graal.compiler.truffle.nodes.AnyExtendNode;
import jdk.graal.compiler.truffle.nodes.AnyNarrowNode;
import jdk.graal.compiler.truffle.nodes.IsCompilationConstantNode;
import jdk.graal.compiler.truffle.nodes.ObjectLocationIdentity;
import jdk.graal.compiler.truffle.nodes.TruffleAssumption;
import jdk.graal.compiler.truffle.nodes.asserts.NeverPartOfCompilationNode;
import jdk.graal.compiler.truffle.nodes.frame.AllowMaterializeNode;
import jdk.graal.compiler.truffle.nodes.frame.ForceMaterializeNode;
import jdk.graal.compiler.truffle.nodes.frame.NewFrameNode;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameAccessFlags;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameAccessType;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameClearNode;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameCopyNode;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameGetNode;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameGetTagNode;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameIsNode;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameSetNode;
import jdk.graal.compiler.truffle.nodes.frame.VirtualFrameSwapNode;
import jdk.graal.compiler.truffle.phases.TruffleSafepointInsertionPhase;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.word.LocationIdentity;

public class TruffleGraphBuilderPlugins {
    private static final SpeculationReasonGroup BUFFER_SEGMENT_NULL_SPECULATION = new SpeculationReasonGroup("BufferSegmentNull", new Class[0]);

    public static void registerInvocationPlugins(InvocationPlugins plugins, KnownTruffleTypes types, Providers providers, boolean canDelayIntrinsification) {
        MetaAccessProvider metaAccess = providers.getMetaAccess();
        TruffleGraphBuilderPlugins.registerObjectsPlugins(plugins, types);
        TruffleGraphBuilderPlugins.registerOptimizedAssumptionPlugins(plugins, types);
        TruffleGraphBuilderPlugins.registerExactMathPlugins(plugins, types, providers.getReplacements(), providers.getLowerer());
        TruffleGraphBuilderPlugins.registerHostCompilerDirectivesPlugins(plugins, types);
        TruffleGraphBuilderPlugins.registerCompilerDirectivesPlugins(plugins, types, canDelayIntrinsification);
        TruffleGraphBuilderPlugins.registerCompilerAssertsPlugins(plugins, types, canDelayIntrinsification);
        TruffleGraphBuilderPlugins.registerOptimizedCallTargetPlugins(plugins, types, canDelayIntrinsification);
        TruffleGraphBuilderPlugins.registerFrameWithoutBoxingPlugins(plugins, types, canDelayIntrinsification);
        TruffleGraphBuilderPlugins.registerTruffleSafepointPlugins(plugins, types, canDelayIntrinsification);
        TruffleGraphBuilderPlugins.registerNodePlugins(plugins, types, metaAccess, canDelayIntrinsification, providers.getConstantReflection());
        TruffleGraphBuilderPlugins.registerDynamicObjectPlugins(plugins, types, canDelayIntrinsification);
        TruffleGraphBuilderPlugins.registerBufferPlugins(plugins, types, canDelayIntrinsification);
        TruffleGraphBuilderPlugins.registerMemorySegmentPlugins(plugins, types, canDelayIntrinsification);
    }

    private static void registerTruffleSafepointPlugins(InvocationPlugins plugins, KnownTruffleTypes types, final boolean canDelayIntrinsification) {
        ResolvedJavaType truffleSafepoint = types.TruffleSafepoint;
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(truffleSafepoint));
        r.register(new InvocationPlugin.RequiredInvocationPlugin("poll", new Type[]{new InvocationPlugins.ResolvedJavaSymbol(types.Node)}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                if (!TruffleSafepointInsertionPhase.allowsSafepoints(b.getGraph())) {
                    if (!canDelayIntrinsification) {
                        throw TruffleGraphBuilderPlugins.failPEConstant(b, arg);
                    }
                    return false;
                }
                if (arg.isConstant()) {
                    return true;
                }
                if (canDelayIntrinsification) {
                    return false;
                }
                throw TruffleGraphBuilderPlugins.failPEConstant(b, arg);
            }
        });
    }

    private static void registerObjectsPlugins(InvocationPlugins plugins, KnownTruffleTypes types) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(types.Objects));
        r.register(new RequireNonNullPlugin(new Type[]{Object.class}));
        r.register(new RequireNonNullPlugin(new Type[]{Object.class, String.class}));
        r.register(new RequireNonNullPlugin(new Type[]{Object.class, Supplier.class}));
    }

    public static void registerOptimizedAssumptionPlugins(InvocationPlugins plugins, final KnownTruffleTypes types) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(types.OptimizedAssumption));
        r.register(new InvocationPlugin.RequiredInvocationPlugin("isValid", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                JavaConstant isValid;
                JavaConstant assumption = receiver.get(false).asJavaConstant();
                if (b.getAssumptions() != null && assumption != null && assumption.isNonNull() && (isValid = b.getConstantReflection().readFieldValue(types.AbstractAssumption_isValid, assumption)) != null) {
                    if (isValid.asBoolean()) {
                        b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(true));
                        b.getAssumptions().record((Assumptions.Assumption)new TruffleAssumption(assumption));
                    } else {
                        b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(false));
                    }
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("check", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                JavaConstant isValid;
                JavaConstant assumption = receiver.get(false).asJavaConstant();
                if (b.getAssumptions() != null && assumption != null && assumption.isNonNull() && (isValid = b.getConstantReflection().readFieldValue(types.AbstractAssumption_isValid, assumption)) != null) {
                    if (isValid.asBoolean()) {
                        b.getAssumptions().record((Assumptions.Assumption)new TruffleAssumption(assumption));
                    } else {
                        b.add(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.None));
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public static void registerExactMathPlugins(InvocationPlugins plugins, KnownTruffleTypes types, Replacements replacements, LoweringProvider lowerer) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(types.ExactMath), replacements);
        for (final JavaKind kind : new JavaKind[]{JavaKind.Int, JavaKind.Long}) {
            Class type = kind.toJavaClass();
            r.register(new InvocationPlugin("multiplyHigh", new Type[]{type, type}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                    b.addPush(kind, new IntegerMulHighNode(x, y));
                    return true;
                }
            });
            r.register(new InvocationPlugin("multiplyHighUnsigned", new Type[]{type, type}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                    b.addPush(kind, new UnsignedMulHighNode(x, y));
                    return true;
                }
            });
        }
        for (final JavaKind kind : new JavaKind[]{JavaKind.Float, JavaKind.Double}) {
            r.registerConditional(lowerer.supportsRounding(), new InvocationPlugin("truncate", new Type[]{kind.toJavaClass()}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x) {
                    b.addPush(kind, new RoundNode(x, ArithmeticLIRGeneratorTool.RoundingMode.TRUNCATE));
                    return true;
                }
            });
        }
    }

    public static void registerHostCompilerDirectivesPlugins(InvocationPlugins plugins, KnownTruffleTypes types) {
        ResolvedJavaType compilerDirectivesType = types.HostCompilerDirectives;
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(compilerDirectivesType));
        r.register(new InvocationPlugin.RequiredInvocationPlugin("inInterpreterFastPath", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(false));
                return true;
            }
        });
    }

    public static void registerCompilerDirectivesPlugins(InvocationPlugins plugins, KnownTruffleTypes types, final boolean canDelayIntrinsification) {
        ResolvedJavaType compilerDirectivesType = types.CompilerDirectives;
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(compilerDirectivesType));
        r.register(new InvocationPlugin.RequiredInvocationPlugin("inInterpreter", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(false));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("hasNextTier", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                if (canDelayIntrinsification) {
                    return false;
                }
                TruffleCompilationTask task = TruffleCompilation.lookupTask(b.getGraph());
                if (task != null) {
                    b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(task.hasNextTier()));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("inCompiledCode", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(true));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("inCompilationRoot", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                GraphBuilderContext.ExternalInliningContext inliningContext = b.getExternalInliningContext();
                if (inliningContext != null) {
                    b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(inliningContext.getInlinedDepth() == 0));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("transferToInterpreter", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new DeoptimizeNode(DeoptimizationAction.None, DeoptimizationReason.TransferToInterpreter));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("transferToInterpreterAndInvalidate", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.TransferToInterpreter));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("interpreterOnly", new Type[]{Runnable.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("interpreterOnly", new Type[]{Callable.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("injectBranchProbability", new Type[]{Double.TYPE, Boolean.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode probability, ValueNode condition) {
                b.addPush(JavaKind.Boolean, new BranchProbabilityNode(probability, condition));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("bailout", new Type[]{String.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode message) {
                if (canDelayIntrinsification) {
                    StampPair returnStamp = b.getInvokeReturnStamp(b.getAssumptions());
                    CallTargetNode callTarget = b.add(new MethodCallTargetNode(CallTargetNode.InvokeKind.Static, targetMethod, new ValueNode[]{message}, returnStamp, null));
                    b.add(new InvokeNode(callTarget, b.bci()));
                    b.add(new NeverPartOfCompilationNode("intrinsification of call to bailout() will abort entire compilation"));
                    return true;
                }
                if (message.isConstant()) {
                    throw b.bailout(message.asConstant().toValueString());
                }
                throw b.bailout("bailout (message is not compile-time constant, so no additional information is available)");
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("isCompilationConstant", new Type[]{Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                if ((value instanceof BoxNode ? ((BoxNode)value).getValue() : value).isConstant()) {
                    b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(true));
                } else {
                    b.addPush(JavaKind.Boolean, new IsCompilationConstantNode(value));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("isPartialEvaluationConstant", new Type[]{Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                if ((value instanceof BoxNode ? ((BoxNode)value).getValue() : value).isConstant()) {
                    b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(true));
                } else {
                    if (canDelayIntrinsification) {
                        return false;
                    }
                    b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(false));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("materialize", new Type[]{Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                AllowMaterializeNode materializedValue = b.append(new AllowMaterializeNode(value));
                b.add(new ForceMaterializeNode(materializedValue));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("ensureVirtualized", new Type[]{Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.add(new EnsureVirtualizedNode(object, false));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("ensureVirtualizedHere", new Type[]{Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.add(new EnsureVirtualizedNode(object, true));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("ensureAllocatedHere", new Type[]{Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                StandardGraphBuilderPlugins.registerEnsureAllocatedHereIntrinsic(b, object);
                return true;
            }
        });
        for (JavaKind kind : JavaKind.values()) {
            if ((!kind.isPrimitive() || kind == JavaKind.Void) && kind != JavaKind.Object) continue;
            Class<?> javaClass = TruffleGraphBuilderPlugins.getJavaClass(kind);
            r.register(new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("blackhole", new Type[]{javaClass}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                    b.add(new BlackholeNode(value));
                    return true;
                }
            });
        }
        r.register(new InvocationPlugin.RequiredInvocationPlugin("castExact", new Type[]{Object.class, Class.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode javaClass) {
                ValueNode nullCheckedClass = b.addNonNullCast(javaClass);
                LogicNode condition = b.append(InstanceOfDynamicNode.create(b.getAssumptions(), b.getConstantReflection(), nullCheckedClass, object, true, true));
                if (condition.isTautology()) {
                    b.addPush(JavaKind.Object, object);
                } else {
                    FixedGuardNode fixedGuard = b.add(new FixedGuardNode(condition, DeoptimizationReason.ClassCastException, DeoptimizationAction.InvalidateReprofile, false));
                    b.addPush(JavaKind.Object, DynamicPiNode.create(b.getAssumptions(), b.getConstantReflection(), object, fixedGuard, nullCheckedClass, true, true));
                }
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("isExact", new Type[]{Object.class, Class.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode javaClass) {
                ValueNode nullCheckedClass = b.addNonNullCast(javaClass);
                LogicNode condition = b.append(InstanceOfDynamicNode.create(b.getAssumptions(), b.getConstantReflection(), nullCheckedClass, object, false, true));
                b.addPush(JavaKind.Boolean, b.append(new ConditionalNode(condition)));
                return true;
            }
        });
    }

    private static Class<?> getJavaClass(JavaKind kind) {
        return kind == JavaKind.Object ? Object.class : kind.toJavaClass();
    }

    public static void registerCompilerAssertsPlugins(InvocationPlugins plugins, KnownTruffleTypes types, boolean canDelayIntrinsification) {
        ResolvedJavaType compilerAssertsType = types.CompilerAsserts;
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(compilerAssertsType));
        r.register(new PEConstantPlugin(canDelayIntrinsification, new Type[]{Object.class}));
        r.register(new PEConstantPlugin(canDelayIntrinsification, Integer.TYPE));
        r.register(new PEConstantPlugin(canDelayIntrinsification, Long.TYPE));
        r.register(new PEConstantPlugin(canDelayIntrinsification, Float.TYPE));
        r.register(new PEConstantPlugin(canDelayIntrinsification, Double.TYPE));
        r.register(new PEConstantPlugin(canDelayIntrinsification, Boolean.TYPE));
        r.register(new InvocationPlugin.RequiredInvocationPlugin("neverPartOfCompilation", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new NeverPartOfCompilationNode("CompilerAsserts.neverPartOfCompilation()"));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("neverPartOfCompilation", new Type[]{String.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode message) {
                if (message.isConstant()) {
                    String messageString = message.asConstant().toValueString();
                    b.add(new NeverPartOfCompilationNode(messageString));
                    return true;
                }
                throw b.bailout("message for never part of compilation is non-constant");
            }
        });
    }

    public static void registerOptimizedCallTargetPlugins(InvocationPlugins plugins, final KnownTruffleTypes types, final boolean canDelayIntrinsification) {
        ResolvedJavaType optimizedCallTargetType = types.OptimizedCallTarget;
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(optimizedCallTargetType));
        r.register(new InvocationPlugin.RequiredInvocationPlugin("createFrame", new Type[]{new InvocationPlugins.ResolvedJavaSymbol(types.FrameDescriptor), Object[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode descriptor, ValueNode args) {
                if (canDelayIntrinsification) {
                    return false;
                }
                if (!descriptor.isJavaConstant()) {
                    throw b.bailout("Parameter 'descriptor' is not a compile-time constant");
                }
                ValueNode nonNullArguments = b.add(PiNode.create(args, StampFactory.objectNonNull(StampTool.typeReferenceOrNull(args))));
                b.addPush(JavaKind.Object, new NewFrameNode(b, descriptor, nonNullArguments, types));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("castArrayFixedLength", new Type[]{Object[].class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode args, ValueNode length) {
                if (canDelayIntrinsification) {
                    return false;
                }
                if (args.isConstant()) {
                    b.addPush(JavaKind.Object, args);
                    return true;
                }
                b.addPush(JavaKind.Object, new PiArrayNode(args, length, args.stamp(NodeView.DEFAULT)));
                return true;
            }
        });
        TruffleGraphBuilderPlugins.registerUnsafeCast(r, types, canDelayIntrinsification);
    }

    public static void registerFrameWithoutBoxingPlugins(InvocationPlugins plugins, KnownTruffleTypes types, boolean canDelayIntrinsification) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(types.FrameWithoutBoxing));
        TruffleGraphBuilderPlugins.registerFrameMethods(r, types);
        TruffleGraphBuilderPlugins.registerUnsafeCast(r, types, canDelayIntrinsification);
        TruffleGraphBuilderPlugins.registerUnsafeLoadStorePlugins(r, canDelayIntrinsification, null, JavaKind.Long, JavaKind.Object);
        TruffleGraphBuilderPlugins.registerFrameAccessors(r, types, JavaKind.Object);
        TruffleGraphBuilderPlugins.registerFrameAccessors(r, types, JavaKind.Long);
        TruffleGraphBuilderPlugins.registerFrameAccessors(r, types, JavaKind.Int);
        TruffleGraphBuilderPlugins.registerFrameAccessors(r, types, JavaKind.Double);
        TruffleGraphBuilderPlugins.registerFrameAccessors(r, types, JavaKind.Float);
        TruffleGraphBuilderPlugins.registerFrameAccessors(r, types, JavaKind.Boolean);
        TruffleGraphBuilderPlugins.registerFrameAccessors(r, types, JavaKind.Byte);
        TruffleGraphBuilderPlugins.registerOSRFrameTransferMethods(r);
        TruffleGraphBuilderPlugins.registerFrameTagAccessor(r);
        TruffleGraphBuilderPlugins.registerFrameAuxiliaryAccessors(types, r);
    }

    private static void registerFrameAccessors(InvocationPlugins.Registration r, KnownTruffleTypes types, final JavaKind accessKind) {
        final int accessTag = types.FrameSlotKind_javaKindToTagIndex.get(accessKind);
        String nameSuffix = accessKind.name();
        final boolean isPrimitiveAccess = accessKind.isPrimitive();
        r.register(new InvocationPlugin.RequiredInvocationPlugin("get" + nameSuffix, new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(frameNode, frameSlotNode);
                if (frameSlotIndex >= 0) {
                    b.addPush(accessKind, new VirtualFrameGetNode(frameNode, frameSlotIndex, accessKind, accessTag, VirtualFrameAccessType.Indexed, VirtualFrameAccessFlags.NON_STATIC));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("get" + nameSuffix + "Static", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(frameNode, frameSlotNode);
                if (frameSlotIndex >= 0) {
                    b.addPush(accessKind, new VirtualFrameGetNode(frameNode, frameSlotIndex, accessKind, accessTag, VirtualFrameAccessType.Indexed, isPrimitiveAccess ? VirtualFrameAccessFlags.STATIC_PRIMITIVE : VirtualFrameAccessFlags.STATIC_OBJECT));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("set" + nameSuffix, new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, TruffleGraphBuilderPlugins.getJavaClass(accessKind)}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode, ValueNode value) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(frameNode, frameSlotNode);
                if (frameSlotIndex >= 0) {
                    b.add(new VirtualFrameSetNode(frameNode, frameSlotIndex, accessTag, value, VirtualFrameAccessType.Indexed, VirtualFrameAccessFlags.NON_STATIC_UPDATE));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("set" + nameSuffix + "Static", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, TruffleGraphBuilderPlugins.getJavaClass(accessKind)}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode, ValueNode value) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(frameNode, frameSlotNode);
                if (frameSlotIndex >= 0) {
                    b.add(new VirtualFrameSetNode(frameNode, frameSlotIndex, accessTag, value, VirtualFrameAccessType.Indexed, isPrimitiveAccess ? VirtualFrameAccessFlags.STATIC_PRIMITIVE_UPDATE : VirtualFrameAccessFlags.STATIC_OBJECT_UPDATE));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("is" + nameSuffix, new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(frameNode, frameSlotNode);
                if (frameSlotIndex >= 0) {
                    b.addPush(JavaKind.Boolean, new VirtualFrameIsNode(frameNode, frameSlotIndex, accessTag, VirtualFrameAccessType.Indexed));
                    return true;
                }
                return false;
            }
        });
    }

    private static void registerFrameTagAccessor(InvocationPlugins.Registration r) {
        r.register(new InvocationPlugin.RequiredInvocationPlugin("getTag", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(frameNode, frameSlotNode);
                if (frameSlotIndex >= 0) {
                    b.addPush(JavaKind.Boolean, new VirtualFrameGetTagNode(frameNode, frameSlotIndex));
                    return true;
                }
                return false;
            }
        });
    }

    private static void registerFrameAuxiliaryAccessors(KnownTruffleTypes types, InvocationPlugins.Registration r) {
        final int objectTagIndex = types.FrameSlotKind_javaKindToTagIndex.get(JavaKind.Object);
        r.register(new InvocationPlugin.RequiredInvocationPlugin("getAuxiliarySlot", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(frameNode, frameSlotNode);
                if (frameSlotIndex >= 0) {
                    b.addPush(JavaKind.Object, new VirtualFrameGetNode(frameNode, frameSlotIndex, JavaKind.Object, objectTagIndex, VirtualFrameAccessType.Auxiliary, VirtualFrameAccessFlags.NON_STATIC));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("setAuxiliarySlot", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, Object.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode, ValueNode value) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(frameNode, frameSlotNode);
                if (frameSlotIndex >= 0) {
                    b.add(new VirtualFrameSetNode(frameNode, frameSlotIndex, objectTagIndex, value, VirtualFrameAccessType.Auxiliary, VirtualFrameAccessFlags.NON_STATIC_UPDATE));
                    return true;
                }
                return false;
            }
        });
    }

    static int maybeGetConstantNumberedFrameSlotIndex(InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode) {
        int index;
        NewFrameNode newFrameNode;
        ValueNode valueNode;
        if (frameSlotNode.isJavaConstant() && (valueNode = frameNode.get(false)) instanceof NewFrameNode && (newFrameNode = (NewFrameNode)valueNode).getIntrinsifyAccessors() && newFrameNode.isValidIndexedSlotIndex(index = frameSlotNode.asJavaConstant().asInt())) {
            return index;
        }
        return -1;
    }

    private static void registerOSRFrameTransferMethods(InvocationPlugins.Registration r) {
        r.register(new InvocationPlugin.RequiredInvocationPlugin("startOSRTransfer", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode) {
                ValueNode valueNode = frameNode.get(false);
                if (valueNode instanceof NewFrameNode) {
                    NewFrameNode newFrameNode = (NewFrameNode)valueNode;
                    newFrameNode.setBytecodeOSRTransferTarget();
                    return true;
                }
                return false;
            }
        });
    }

    private static void registerFrameMethods(InvocationPlugins.Registration r, KnownTruffleTypes types) {
        r.register(new InvocationPlugin.RequiredInvocationPlugin("getArguments", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frame) {
                ValueNode valueNode = frame.get(false);
                if (valueNode instanceof NewFrameNode) {
                    NewFrameNode newFrameNode = (NewFrameNode)valueNode;
                    b.push(JavaKind.Object, newFrameNode.getArguments());
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("getFrameDescriptor", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frame) {
                ValueNode valueNode = frame.get(false);
                if (valueNode instanceof NewFrameNode) {
                    NewFrameNode newFrameNode = (NewFrameNode)valueNode;
                    b.push(JavaKind.Object, newFrameNode.getDescriptor());
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("materialize", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                NewFrameNode newFrameNode;
                ValueNode frame = receiver.get(true);
                if (frame instanceof NewFrameNode && (newFrameNode = (NewFrameNode)frame).getIntrinsifyAccessors()) {
                    SpeculationLog.Speculation speculation = b.getGraph().getSpeculationLog().speculate(newFrameNode.getIntrinsifyAccessorsSpeculation());
                    b.add(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.RuntimeConstraint, speculation));
                    return true;
                }
                b.addPush(JavaKind.Object, new AllowMaterializeNode(frame));
                return true;
            }
        });
        final int illegalTag = types.FrameSlotKind_javaKindToTagIndex.get(JavaKind.Illegal);
        r.register(new InvocationPlugin.RequiredInvocationPlugin("clear", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot);
                if (frameSlotIndex >= 0) {
                    b.add(new VirtualFrameClearNode(receiver, frameSlotIndex, illegalTag, VirtualFrameAccessType.Indexed, VirtualFrameAccessFlags.NON_STATIC_UPDATE));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("clearPrimitiveStatic", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot);
                if (frameSlotIndex >= 0) {
                    b.add(new VirtualFrameClearNode(receiver, frameSlotIndex, illegalTag, VirtualFrameAccessType.Indexed, VirtualFrameAccessFlags.STATIC_PRIMITIVE_UPDATE));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("clearObjectStatic", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot);
                if (frameSlotIndex >= 0) {
                    b.add(new VirtualFrameClearNode(receiver, frameSlotIndex, illegalTag, VirtualFrameAccessType.Indexed, VirtualFrameAccessFlags.STATIC_OBJECT_UPDATE));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("clearStatic", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot);
                if (frameSlotIndex >= 0) {
                    b.add(new VirtualFrameClearNode(receiver, frameSlotIndex, illegalTag, VirtualFrameAccessType.Indexed, VirtualFrameAccessFlags.STATIC_BOTH_UPDATE));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("swap", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot1, ValueNode frameSlot2) {
                int frameSlot1Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot1);
                int frameSlot2Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot2);
                if (frameSlot1Index >= 0 && frameSlot2Index >= 0) {
                    b.add(new VirtualFrameSwapNode(receiver, frameSlot1Index, frameSlot2Index, VirtualFrameAccessType.Indexed, VirtualFrameAccessFlags.NON_STATIC_UPDATE));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("swapPrimitiveStatic", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot1, ValueNode frameSlot2) {
                int frameSlot1Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot1);
                int frameSlot2Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot2);
                if (frameSlot1Index >= 0 && frameSlot2Index >= 0) {
                    b.add(new VirtualFrameSwapNode(receiver, frameSlot1Index, frameSlot2Index, VirtualFrameAccessType.Indexed, VirtualFrameAccessFlags.STATIC_PRIMITIVE_UPDATE));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("swapObjectStatic", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot1, ValueNode frameSlot2) {
                int frameSlot1Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot1);
                int frameSlot2Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot2);
                if (frameSlot1Index >= 0 && frameSlot2Index >= 0) {
                    b.add(new VirtualFrameSwapNode(receiver, frameSlot1Index, frameSlot2Index, VirtualFrameAccessType.Indexed, VirtualFrameAccessFlags.STATIC_OBJECT_UPDATE));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("swapStatic", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot1, ValueNode frameSlot2) {
                int frameSlot1Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot1);
                int frameSlot2Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot2);
                if (frameSlot1Index >= 0 && frameSlot2Index >= 0) {
                    b.add(new VirtualFrameSwapNode(receiver, frameSlot1Index, frameSlot2Index, VirtualFrameAccessType.Indexed, VirtualFrameAccessFlags.STATIC_BOTH_UPDATE));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("copy", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot1, ValueNode frameSlot2) {
                int frameSlot1Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot1);
                int frameSlot2Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot2);
                if (frameSlot1Index >= 0 && frameSlot2Index >= 0) {
                    b.add(new VirtualFrameCopyNode(receiver, frameSlot1Index, frameSlot2Index, VirtualFrameAccessType.Indexed, VirtualFrameAccessFlags.NON_STATIC_UPDATE));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("copyPrimitiveStatic", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot1, ValueNode frameSlot2) {
                int frameSlot1Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot1);
                int frameSlot2Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot2);
                if (frameSlot1Index >= 0 && frameSlot2Index >= 0) {
                    b.add(new VirtualFrameCopyNode(receiver, frameSlot1Index, frameSlot2Index, VirtualFrameAccessType.Indexed, VirtualFrameAccessFlags.STATIC_PRIMITIVE_UPDATE));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("copyObjectStatic", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot1, ValueNode frameSlot2) {
                int frameSlot1Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot1);
                int frameSlot2Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot2);
                if (frameSlot1Index >= 0 && frameSlot2Index >= 0) {
                    b.add(new VirtualFrameCopyNode(receiver, frameSlot1Index, frameSlot2Index, VirtualFrameAccessType.Indexed, VirtualFrameAccessFlags.STATIC_OBJECT_UPDATE));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("copyStatic", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE, Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot1, ValueNode frameSlot2) {
                int frameSlot1Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot1);
                int frameSlot2Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot2);
                if (frameSlot1Index >= 0 && frameSlot2Index >= 0) {
                    b.add(new VirtualFrameCopyNode(receiver, frameSlot1Index, frameSlot2Index, VirtualFrameAccessType.Indexed, VirtualFrameAccessFlags.STATIC_BOTH_UPDATE));
                    return true;
                }
                return false;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("extend", new Type[]{Integer.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.addPush(JavaKind.Long, new AnyExtendNode(value));
                return true;
            }
        });
        r.register(new InvocationPlugin.RequiredInvocationPlugin("narrow", new Type[]{Long.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.addPush(JavaKind.Int, new AnyNarrowNode(value));
                return true;
            }
        });
    }

    public static void registerNodePlugins(InvocationPlugins plugins, final KnownTruffleTypes types, final MetaAccessProvider metaAccess, final boolean canDelayIntrinsification, final ConstantReflectionProvider constantReflection) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(types.Node));
        r.register(new InvocationPlugin.RequiredInvocationPlugin("getRootNodeImpl", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                JavaConstant prevNode;
                if (canDelayIntrinsification) {
                    return false;
                }
                ValueNode thisValue = receiver.get(false);
                if (!thisValue.isJavaConstant() || thisValue.isNullConstant()) {
                    throw b.bailout("getRootNode() receiver is not a compile-time constant or is null.");
                }
                int parentLimit = PEGraphDecoder.Options.MaximumLoopExplosionCount.getValue(b.getOptions());
                JavaConstant parentNode = thisValue.asJavaConstant();
                int parentsVisited = 0;
                do {
                    if (parentsVisited++ <= parentLimit) continue;
                    throw b.bailout("getRootNode() did not terminate in " + parentLimit + " iterations.");
                } while ((parentNode = constantReflection.readFieldValue(types.Node_parent, prevNode = parentNode)).isNonNull());
                JavaConstant rootNode = prevNode;
                ConstantNode result = ConstantNode.forConstant(rootNode, metaAccess, b.getGraph());
                if (rootNode.isNonNull() && !types.RootNode.isAssignableFrom(result.stamp(NodeView.DEFAULT).javaType(metaAccess))) {
                    result = ConstantNode.defaultForKind(JavaKind.Object, b.getGraph());
                }
                b.addPush(JavaKind.Object, result);
                return true;
            }
        });
    }

    private static void registerBufferPlugins(InvocationPlugins plugins, KnownTruffleTypes types, final boolean canDelayIntrinsification) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(types.Buffer));
        final class CreateExceptionPlugin
        extends InvocationPlugin.RequiredInvocationPlugin {
            CreateExceptionPlugin(String name, Type ... argumentTypes) {
                super(name, argumentTypes);
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode newLimit) {
                if (canDelayIntrinsification || b.needsExplicitException()) {
                    return false;
                }
                b.add(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.RuntimeConstraint));
                return true;
            }
        }
        r.register(new CreateExceptionPlugin("createLimitException", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}));
        r.register(new CreateExceptionPlugin("createPositionException", new Type[]{InvocationPlugin.Receiver.class, Integer.TYPE}));
    }

    private static void registerMemorySegmentPlugins(InvocationPlugins plugins, final KnownTruffleTypes types, final boolean canDelayIntrinsification) {
        ResolvedJavaType memorySegmentImplType = types.AbstractMemorySegmentImpl;
        if (memorySegmentImplType != null) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(memorySegmentImplType));
            r.register(new InvocationPlugin.OptionalInvocationPlugin("sessionImpl", new Type[]{InvocationPlugin.Receiver.class}){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    ValueNode segment;
                    Stamp stamp;
                    SpeculationLog speculationLog = b.getGraph().getSpeculationLog();
                    if (!canDelayIntrinsification && speculationLog != null && (stamp = (segment = receiver.get(false)).stamp(NodeView.DEFAULT)) instanceof ObjectStamp && !((ObjectStamp)stamp).nonNull() && !((ObjectStamp)stamp).alwaysNull()) {
                        ValueNode load = GraphUtil.unproxify(segment);
                        SpeculationLog.SpeculationReason bufferSegmentNullSpeculationReason = BUFFER_SEGMENT_NULL_SPECULATION.createSpeculationReason(new Object[0]);
                        if (load instanceof LoadFieldNode && types.Buffer_segment.equals((Object)((LoadFieldNode)load).field()) && speculationLog.maySpeculate(bufferSegmentNullSpeculationReason)) {
                            SpeculationLog.Speculation speculation = speculationLog.speculate(bufferSegmentNullSpeculationReason);
                            b.add(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.UnreachedCode, speculation));
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
    }

    private static void registerDynamicObjectPlugins(InvocationPlugins plugins, KnownTruffleTypes types, boolean canDelayIntrinsification) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(types.UnsafeAccess));
        TruffleGraphBuilderPlugins.registerUnsafeLoadStorePlugins(r, canDelayIntrinsification, null, JavaKind.Long);
    }

    public static void registerUnsafeCast(InvocationPlugins.Registration r, final KnownTruffleTypes types, final boolean canDelayIntrinsification) {
        r.register(new InvocationPlugin.RequiredInvocationPlugin("unsafeCast", new Type[]{Object.class, Class.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode clazz, ValueNode condition, ValueNode nonNull, ValueNode isExactType) {
                if (clazz.isConstant() && nonNull.isConstant() && isExactType.isConstant()) {
                    if (!Options.TruffleTrustedTypeCast.getValue(b.getOptions()).booleanValue()) {
                        b.push(JavaKind.Object, object);
                        return true;
                    }
                    ConstantReflectionProvider constantReflection = b.getConstantReflection();
                    ResolvedJavaType javaType = constantReflection.asJavaType(clazz.asConstant());
                    if (javaType == null) {
                        b.push(JavaKind.Object, object);
                    } else {
                        TypeReference type;
                        if (isExactType.asJavaConstant().asInt() != 0) {
                            assert (javaType.isConcrete() || javaType.isArray()) : "exact type is not a concrete class: " + String.valueOf(javaType);
                            type = TypeReference.createExactTrusted(javaType);
                        } else {
                            type = TypeReference.createTrusted(b.getAssumptions(), javaType);
                        }
                        boolean trustedNonNull = nonNull.asJavaConstant().asInt() != 0 && Options.TruffleTrustedNonNullCast.getValue(b.getOptions()) != false;
                        ObjectStamp piStamp = StampFactory.object(type, trustedNonNull);
                        ConditionAnchorNode valueAnchorNode = null;
                        if (!condition.isConstant() || condition.asJavaConstant().asInt() != 1) {
                            LogicConstantNode logicConstantNode;
                            boolean skipAnchor = false;
                            LogicNode compareNode = CompareNode.createCompareNode(object.graph(), CanonicalCondition.EQ, condition, ConstantNode.forBoolean(true, object.graph()), constantReflection, NodeView.DEFAULT);
                            if (compareNode instanceof LogicConstantNode && (logicConstantNode = (LogicConstantNode)compareNode).getValue()) {
                                skipAnchor = true;
                            }
                            if (!skipAnchor) {
                                valueAnchorNode = b.add(new ConditionAnchorNode(compareNode));
                            }
                        }
                        b.addPush(JavaKind.Object, TruffleGraphBuilderPlugins.trustedBox(type, types, PiNode.create(object, piStamp, valueAnchorNode)));
                    }
                    return true;
                }
                if (canDelayIntrinsification) {
                    return false;
                }
                TruffleGraphBuilderPlugins.logPerformanceWarningUnsafeCastArgNotConst(targetMethod, clazz, nonNull, isExactType);
                b.push(JavaKind.Object, object);
                return true;
            }
        });
    }

    private static ValueNode trustedBox(TypeReference type, KnownTruffleTypes types, ValueNode v) {
        if (types.primitiveBoxTypes.contains(type.getType())) {
            return new BoxNode.TrustedBoxedValue(v);
        }
        return v;
    }

    public static void registerUnsafeLoadStorePlugins(InvocationPlugins.Registration r, boolean canDelayIntrinsification, JavaConstant anyConstant, JavaKind ... kinds) {
        for (JavaKind kind : kinds) {
            Object kindName = kind.getJavaName();
            kindName = Character.toUpperCase(((String)kindName).charAt(0)) + ((String)kindName).substring(1);
            String getName = "unsafeGet" + (String)kindName;
            String putName = "unsafePut" + (String)kindName;
            r.register(new CustomizedUnsafeLoadPlugin(kind, canDelayIntrinsification, getName, new Type[]{Object.class, Long.TYPE, Boolean.TYPE, Object.class}));
            r.register(new CustomizedUnsafeStorePlugin(kind, anyConstant, canDelayIntrinsification, putName, new Type[]{Object.class, Long.TYPE, TruffleGraphBuilderPlugins.getJavaClass(kind), Object.class}));
        }
    }

    static void logPerformanceWarningLocationNotConstant(ValueNode location, ResolvedJavaMethod targetMethod, UnsafeAccessNode access) {
        if (PerformanceInformationHandler.isWarningEnabled(TruffleCompilerOptions.PerformanceWarningKind.VIRTUAL_STORE)) {
            StructuredGraph graph = location.graph();
            DebugContext debug = access.getDebug();
            try (DebugContext.Scope s = debug.scope((Object)"TrufflePerformanceWarnings", graph);){
                TruffleDebugJavaMethod truffleMethod = debug.contextLookup(TruffleDebugJavaMethod.class);
                if (truffleMethod != null) {
                    LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
                    properties.put("location", location);
                    properties.put("method", targetMethod.format("%h.%n"));
                    PerformanceInformationHandler.logPerformanceWarning(TruffleCompilerOptions.PerformanceWarningKind.VIRTUAL_STORE, truffleMethod.getCompilable(), Collections.singletonList(access), "location argument not PE-constant", properties);
                    debug.dump(3, (Object)graph, "perf warn: Location argument is not a partial evaluation constant: %s", location);
                }
            }
            catch (Throwable t) {
                debug.handle(t);
            }
        }
    }

    static void logPerformanceWarningUnsafeCastArgNotConst(ResolvedJavaMethod targetMethod, ValueNode type, ValueNode nonNull, ValueNode isExactType) {
        if (PerformanceInformationHandler.isWarningEnabled(TruffleCompilerOptions.PerformanceWarningKind.VIRTUAL_STORE)) {
            StructuredGraph graph = type.graph();
            DebugContext debug = type.getDebug();
            try (DebugContext.Scope s = debug.scope((Object)"TrufflePerformanceWarnings", graph);){
                TruffleDebugJavaMethod truffleMethod = debug.contextLookup(TruffleDebugJavaMethod.class);
                if (truffleMethod != null) {
                    LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
                    ArrayList<ValueNode> nonConstArgs = new ArrayList<ValueNode>();
                    properties.put("type", type);
                    if (!type.isConstant()) {
                        nonConstArgs.add(type);
                    }
                    properties.put("nonNull", nonNull);
                    if (!nonNull.isConstant()) {
                        nonConstArgs.add(nonNull);
                    }
                    properties.put("exactType", isExactType);
                    if (!isExactType.isConstant()) {
                        nonConstArgs.add(isExactType);
                    }
                    properties.put("method", targetMethod.format("%h.%n"));
                    PerformanceInformationHandler.logPerformanceWarning(TruffleCompilerOptions.PerformanceWarningKind.VIRTUAL_STORE, truffleMethod.getCompilable(), nonConstArgs, "unsafeCast arguments could not reduce to a constant", properties);
                    debug.dump(3, graph, "perf warn: unsafeCast arguments could not reduce to a constant: %s, %s, %s", type, nonNull, isExactType);
                }
            }
            catch (Throwable t) {
                debug.handle(t);
            }
        }
    }

    static BailoutException failPEConstant(GraphBuilderContext b, ValueNode value) {
        StringBuilder sb = new StringBuilder();
        sb.append(value);
        if (value instanceof ValuePhiNode) {
            ValuePhiNode valuePhi = (ValuePhiNode)value;
            sb.append(" (");
            for (Node n : valuePhi.inputs()) {
                sb.append(n);
                sb.append("; ");
            }
            sb.append(")");
        }
        value.getDebug().dump(3, (Object)value.graph(), "Graph before bailout at node %s", sb);
        throw b.bailout("Partial evaluation did not reduce value to a constant, is a regular compiler node: " + String.valueOf(sb));
    }

    private static class RequireNonNullPlugin
    extends InvocationPlugin.RequiredInvocationPlugin {
        RequireNonNullPlugin(Type ... argumentTypes) {
            super("requireNonNull", argumentTypes);
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
            ValueNode nullChecked = b.nullCheckedValue(arg);
            b.addPush(JavaKind.Object, nullChecked);
            return true;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode obj, ValueNode msg) {
            return this.apply(b, targetMethod, receiver, obj);
        }
    }

    private static final class PEConstantPlugin
    extends InvocationPlugin.RequiredInvocationPlugin {
        private final boolean canDelayIntrinsification;

        private PEConstantPlugin(boolean canDelayIntrinsification, Type ... argumentTypes) {
            super("partialEvaluationConstant", argumentTypes);
            this.canDelayIntrinsification = canDelayIntrinsification;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
            ValueNode curValue = value;
            if (curValue instanceof BoxNode) {
                BoxNode boxNode = (BoxNode)curValue;
                curValue = boxNode.getValue();
            }
            if (curValue.isConstant()) {
                return true;
            }
            if (this.canDelayIntrinsification) {
                return false;
            }
            throw TruffleGraphBuilderPlugins.failPEConstant(b, value);
        }
    }

    static class CustomizedUnsafeLoadPlugin
    extends InvocationPlugin.RequiredInvocationPlugin {
        private final JavaKind returnKind;
        private final boolean canDelayIntrinsification;

        CustomizedUnsafeLoadPlugin(JavaKind returnKind, boolean canDelayIntrinsification, String name, Type ... argumentTypes) {
            super(name, argumentTypes);
            this.returnKind = returnKind;
            this.canDelayIntrinsification = canDelayIntrinsification;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode offset, ValueNode condition, ValueNode location) {
            if (location.isConstant()) {
                boolean forceLocation;
                LocationIdentity locationIdentity;
                if (location.isNullConstant()) {
                    locationIdentity = LocationIdentity.any();
                    forceLocation = false;
                } else {
                    locationIdentity = ObjectLocationIdentity.create(location.asJavaConstant());
                    forceLocation = true;
                }
                ValueNode guard = null;
                if (!condition.isConstant() || condition.asJavaConstant().asInt() == 0) {
                    LogicNode compare = b.add(CompareNode.createCompareNode(b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), null, CanonicalCondition.EQ, condition, ConstantNode.forBoolean(true, object.graph()), NodeView.DEFAULT));
                    guard = b.add(new ConditionAnchorNode(compare));
                }
                b.addPush(this.returnKind, b.add(new GuardedUnsafeLoadNode(b.addNonNullCast(object), offset, this.returnKind, locationIdentity, guard, forceLocation)));
                return true;
            }
            if (this.canDelayIntrinsification) {
                return false;
            }
            RawLoadNode load = b.addPush(this.returnKind, new RawLoadNode(object, offset, this.returnKind, LocationIdentity.any(), true, MemoryOrderMode.PLAIN));
            TruffleGraphBuilderPlugins.logPerformanceWarningLocationNotConstant(location, targetMethod, load);
            return true;
        }
    }

    static class CustomizedUnsafeStorePlugin
    extends InvocationPlugin.RequiredInvocationPlugin {
        private final JavaKind kind;
        private final JavaConstant anyConstant;
        private final boolean canDelayIntrinsification;

        CustomizedUnsafeStorePlugin(JavaKind kind, JavaConstant anyConstant, boolean canDelayIntrinsification, String name, Type ... argumentTypes) {
            super(name, argumentTypes);
            this.kind = kind;
            this.anyConstant = anyConstant;
            this.canDelayIntrinsification = canDelayIntrinsification;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode offset, ValueNode value, ValueNode location) {
            ValueNode locationArgument = location;
            if (locationArgument.isConstant()) {
                boolean forceLocation;
                LocationIdentity locationIdentity;
                if (locationArgument.isNullConstant()) {
                    locationIdentity = LocationIdentity.any();
                    forceLocation = false;
                } else if (locationArgument.asJavaConstant().equals((Object)this.anyConstant)) {
                    locationIdentity = LocationIdentity.any();
                    forceLocation = true;
                } else {
                    locationIdentity = ObjectLocationIdentity.create(locationArgument.asJavaConstant());
                    forceLocation = true;
                }
                b.add(new RawStoreNode(object, offset, value, this.kind, locationIdentity, true, null, forceLocation));
                return true;
            }
            if (this.canDelayIntrinsification) {
                return false;
            }
            RawStoreNode store = b.add(new RawStoreNode(object, offset, value, this.kind, LocationIdentity.any(), true, null, true));
            TruffleGraphBuilderPlugins.logPerformanceWarningLocationNotConstant(location, targetMethod, store);
            return true;
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> TruffleTrustedNonNullCast = new OptionKey<Boolean>(true);
        public static final OptionKey<Boolean> TruffleTrustedTypeCast = new OptionKey<Boolean>(true);
    }
}

