/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.GraalError;

public final class Digest {
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final int BASE62_DIGITS_PER_LONG = 11;
    public static final int DIGEST_SIZE = 22;
    private static final long HASH_SEED = 0L;
    private static final VarHandle LONG_VIEW = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.nativeOrder());

    private Digest() {
    }

    public static String digest(String value) {
        return Digest.digest(value.getBytes(StandardCharsets.UTF_8));
    }

    public static String digest(byte[] bytes) {
        return Digest.digest(bytes, 0, bytes.length);
    }

    public static String digest(byte[] bytes, int offset, int length) {
        String result = new String(Digest.digestAsByteArray(bytes, offset, length), StandardCharsets.UTF_8);
        assert (result.length() == 22) : "--" + result + "--";
        return result.toString();
    }

    public static byte[] digestAsByteArray(byte[] bytes, int offset, int length) {
        LongLong hash = Digest.MurmurHash3_x64_128(bytes, offset, length, 0L);
        byte[] array = new byte[22];
        Digest.encodeBase62(hash.l1, array, 0);
        Digest.encodeBase62(hash.l2, array, 11);
        return array;
    }

    private static void encodeBase62(long value, byte[] result, int resultIndex) {
        long cur = value;
        int base = DIGITS.length;
        for (int i = 0; i < 11; ++i) {
            result[resultIndex + i] = DIGITS[NumUtil.safeToInt(Long.remainderUnsigned(cur, base))];
            cur = Long.divideUnsigned(cur, base);
        }
        GraalError.guarantee(cur == 0L, "Too few loop iterations processing digits");
    }

    public static String digestAsHex(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        LongLong hash = Digest.MurmurHash3_x64_128(bytes, 0, bytes.length, 0L);
        return Long.toHexString(hash.l1) + Long.toHexString(hash.l2);
    }

    public static UUID digestAsUUID(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        LongLong hash = Digest.MurmurHash3_x64_128(bytes, 0, bytes.length, 0L);
        return new UUID(hash.l1, hash.l2);
    }

    private static LongLong MurmurHash3_x64_128(byte[] bytes, int offset, int len, long seed) {
        long k2;
        long k1;
        int nblocks = len / 16;
        long h1 = seed;
        long h2 = seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        for (int i = 0; i < nblocks; ++i) {
            k1 = LONG_VIEW.get(bytes, offset + (i * 2 + 0) * 8);
            k2 = LONG_VIEW.get(bytes, offset + (i * 2 + 1) * 8);
            k1 *= c1;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= c2);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= c2;
            k2 = Long.rotateLeft(k2, 33);
            h2 ^= (k2 *= c1);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        int tail = offset + nblocks * 16;
        k1 = 0L;
        k2 = 0L;
        switch (len & 0xF) {
            case 15: {
                k2 ^= ((long)bytes[tail + 14] & 0xFFL) << 48;
            }
            case 14: {
                k2 ^= ((long)bytes[tail + 13] & 0xFFL) << 40;
            }
            case 13: {
                k2 ^= ((long)bytes[tail + 12] & 0xFFL) << 32;
            }
            case 12: {
                k2 ^= ((long)bytes[tail + 11] & 0xFFL) << 24;
            }
            case 11: {
                k2 ^= ((long)bytes[tail + 10] & 0xFFL) << 16;
            }
            case 10: {
                k2 ^= ((long)bytes[tail + 9] & 0xFFL) << 8;
            }
            case 9: {
                k2 ^= ((long)bytes[tail + 8] & 0xFFL) << 0;
                k2 *= c2;
                k2 = Long.rotateLeft(k2, 33);
                h2 ^= (k2 *= c1);
            }
            case 8: {
                k1 ^= ((long)bytes[tail + 7] & 0xFFL) << 56;
            }
            case 7: {
                k1 ^= ((long)bytes[tail + 6] & 0xFFL) << 48;
            }
            case 6: {
                k1 ^= ((long)bytes[tail + 5] & 0xFFL) << 40;
            }
            case 5: {
                k1 ^= ((long)bytes[tail + 4] & 0xFFL) << 32;
            }
            case 4: {
                k1 ^= ((long)bytes[tail + 3] & 0xFFL) << 24;
            }
            case 3: {
                k1 ^= ((long)bytes[tail + 2] & 0xFFL) << 16;
            }
            case 2: {
                k1 ^= ((long)bytes[tail + 1] & 0xFFL) << 8;
            }
            case 1: {
                k1 ^= ((long)bytes[tail + 0] & 0xFFL) << 0;
                k1 *= c1;
                k1 = Long.rotateLeft(k1, 31);
                h1 ^= (k1 *= c2);
            }
            case 0: {
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("All 16-byte blocks are processed in loop above");
            }
        }
        h1 ^= (long)len;
        h1 += (h2 ^= (long)len);
        h2 += h1;
        h1 = Digest.fmix64(h1);
        h2 = Digest.fmix64(h2);
        h1 += h2;
        return new LongLong(h1, h2 += h1);
    }

    private static long fmix64(long input) {
        long k = input;
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    private record LongLong(long l1, long l2) {
    }
}

