/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.util;

import java.util.List;

public final class SignatureUtil {
    private SignatureUtil() {
    }

    public static String parseSignature(String signature, List<String> parameters) {
        return SignatureUtil.parseSignatureInternal(signature, parameters, true, false);
    }

    private static String parseSignatureInternal(String signature, List<String> parameters, boolean throwOnInvalidFormat, boolean acceptMissingReturnType) {
        if (signature.isEmpty()) {
            return SignatureUtil.throwOrReturn(throwOnInvalidFormat, null, "Signature cannot be empty");
        }
        if (signature.charAt(0) == '(') {
            int nextCur;
            int cur = 1;
            while (cur < signature.length() && signature.charAt(cur) != ')') {
                nextCur = SignatureUtil.parseParameterSignature(signature, cur, throwOnInvalidFormat);
                if (nextCur == -1) {
                    assert (!throwOnInvalidFormat) : "parseParameterSignature can only return -1 if throwOnInvalidFormat is not set";
                    return null;
                }
                if (parameters != null) {
                    parameters.add(signature.substring(cur, nextCur));
                }
                cur = nextCur;
            }
            if (acceptMissingReturnType && ++cur == signature.length()) {
                return "";
            }
            nextCur = SignatureUtil.parseParameterSignature(signature, cur, throwOnInvalidFormat);
            if (nextCur == -1) {
                assert (!throwOnInvalidFormat) : "parseParameterSignature can only return -1 if throwOnInvalidFormat is not set";
                return null;
            }
            String returnType = signature.substring(cur, nextCur);
            if (nextCur != signature.length()) {
                return SignatureUtil.throwOrReturn(throwOnInvalidFormat, null, "Extra characters at end of signature: " + signature);
            }
            return returnType;
        }
        return SignatureUtil.throwOrReturn(throwOnInvalidFormat, null, "Signature must start with a '(': " + signature);
    }

    private static int parseParameterSignature(String signature, int start, boolean throwOnInvalidFormat) {
        try {
            char first;
            int cur = start;
            do {
                first = signature.charAt(cur);
                ++cur;
            } while (first == '[');
            switch (first) {
                case 'L': {
                    while (signature.charAt(cur) != ';') {
                        if (signature.charAt(cur) == '.') {
                            return SignatureUtil.throwOrReturn(throwOnInvalidFormat, -1, "Class name in signature contains '.' at index " + cur + ": " + signature);
                        }
                        ++cur;
                    }
                    ++cur;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    break;
                }
                default: {
                    return SignatureUtil.throwOrReturn(throwOnInvalidFormat, -1, "Invalid character '" + signature.charAt(cur - 1) + "' at index " + (cur - 1) + " in signature: " + signature);
                }
            }
            return cur;
        }
        catch (StringIndexOutOfBoundsException e) {
            return SignatureUtil.throwOrReturn(throwOnInvalidFormat, -1, "Truncated signature: " + signature);
        }
    }

    public static boolean isSignatureValid(String signature, boolean acceptMissingReturnType) {
        return SignatureUtil.parseSignatureInternal(signature, null, false, acceptMissingReturnType) != null;
    }

    private static <T> T throwOrReturn(boolean shouldThrow, T returnValue, String errorMessage) {
        if (shouldThrow) {
            throw new IllegalArgumentException(errorMessage);
        }
        return returnValue;
    }
}

