/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.virtual.phases.ea;

import jdk.graal.compiler.nodes.cfg.HIRBlock;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.MapCursor;

public abstract class EffectsBlockState<T extends EffectsBlockState<T>> {
    private boolean dead;
    protected EconomicSet<HIRBlock> exceptionEdgesToKill;

    public EffectsBlockState() {
    }

    public EffectsBlockState(EffectsBlockState<T> other) {
        this.dead = other.dead;
        EconomicSet<HIRBlock> otherExceptionEdgesToKill = other.exceptionEdgesToKill;
        if (otherExceptionEdgesToKill != null) {
            this.exceptionEdgesToKill = EconomicSet.create(otherExceptionEdgesToKill);
        }
    }

    public String toString() {
        return "";
    }

    protected abstract boolean equivalentTo(T var1);

    public boolean isDead() {
        return this.dead;
    }

    public void markAsDead() {
        this.dead = true;
    }

    protected static <K, V> boolean isSubMapOf(EconomicMap<K, V> superMap, EconomicMap<K, V> subMap) {
        if (superMap == subMap) {
            return true;
        }
        MapCursor cursor = subMap.getEntries();
        while (cursor.advance()) {
            Object key = cursor.getKey();
            Object value = cursor.getValue();
            assert (value != null);
            Object otherValue = superMap.get(key);
            if (otherValue == value || value.equals(otherValue)) continue;
            return false;
        }
        return true;
    }
}

