/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.virtual.phases.ea;

import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.core.common.cfg.Loop;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.graph.ReentrantBlockIterator;
import jdk.graal.compiler.virtual.phases.ea.EffectsBlockState;
import jdk.graal.compiler.virtual.phases.ea.EffectsPhase;
import jdk.graal.compiler.virtual.phases.ea.GraphEffectList;
import jdk.graal.compiler.virtual.phases.ea.VirtualUtil;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.word.LocationIdentity;

public abstract class EffectsClosure<BlockT extends EffectsBlockState<BlockT>>
extends EffectsPhase.Closure<BlockT> {
    protected final ControlFlowGraph cfg;
    protected final StructuredGraph.ScheduleResult schedule;
    protected NodeMap<ValueNode> aliases;
    private NodeBitMap hasScalarReplacedInputs;
    protected BlockMap<GraphEffectList> blockEffects;
    protected EconomicMap<Loop<HIRBlock>, GraphEffectList> loopMergeEffects = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    private EconomicMap<LoopBeginNode, BlockT> loopEntryStates = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    protected EconomicMap<Loop<HIRBlock>, LoopKillCache> loopLocationKillCache = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    protected boolean changed;
    protected final DebugContext debug;
    protected EffectsClosureMode currentMode;

    public EffectsClosure(StructuredGraph.ScheduleResult schedule, ControlFlowGraph cfg) {
        this.schedule = schedule;
        this.cfg = cfg;
        this.aliases = cfg.graph.createNodeMap();
        this.hasScalarReplacedInputs = cfg.graph.createNodeBitMap();
        this.blockEffects = new BlockMap(cfg);
        this.debug = cfg.graph.getDebug();
        for (HIRBlock block : cfg.getBlocks()) {
            this.blockEffects.put(block, new GraphEffectList(this.debug));
        }
        this.currentMode = EffectsClosureMode.REGULAR_VIRTUALIZATION;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public boolean needsApplyEffects() {
        return true;
    }

    @Override
    public void applyEffects() {
        StructuredGraph graph = this.cfg.graph;
        ArrayList<Node> obsoleteNodes = new ArrayList<Node>(0);
        final ArrayList effectList = new ArrayList();
        ReentrantBlockIterator.BlockIteratorClosure<Void> closure = new ReentrantBlockIterator.BlockIteratorClosure<Void>(this){
            final /* synthetic */ EffectsClosure this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected Void getInitialState() {
                return null;
            }

            private void apply(GraphEffectList effects) {
                if (effects != null && !effects.isEmpty()) {
                    effectList.add(effects);
                }
            }

            @Override
            protected Void processBlock(HIRBlock block, Void currentState) {
                this.apply(this.this$0.blockEffects.get(block));
                return currentState;
            }

            @Override
            protected Void merge(HIRBlock merge, List<Void> states) {
                return null;
            }

            @Override
            protected Void cloneState(Void oldState) {
                return oldState;
            }

            @Override
            protected List<Void> processLoop(Loop<HIRBlock> loop, Void initialState) {
                ReentrantBlockIterator.LoopInfo<Void> info = ReentrantBlockIterator.processLoop(this, loop, initialState);
                this.apply((GraphEffectList)this.this$0.loopMergeEffects.get(loop));
                return info.exitStates;
            }
        };
        ReentrantBlockIterator.apply(closure, this.cfg.getStartBlock());
        for (GraphEffectList effects : effectList) {
            effects.apply(graph, obsoleteNodes, false);
        }
        for (GraphEffectList effects : effectList) {
            effects.apply(graph, obsoleteNodes, true);
        }
        this.debug.dump(4, graph, "After applying effects");
        assert (VirtualUtil.assertNonReachable(graph, obsoleteNodes));
        for (Node node : obsoleteNodes) {
            if (!node.isAlive() || !node.hasNoUsages()) continue;
            if (node instanceof FixedWithNextNode) assert (((FixedWithNextNode)node).next() == null);
            node.replaceAtUsages(null);
            GraphUtil.killWithUnusedFloatingInputs(node);
        }
    }

    @Override
    protected BlockT processBlock(HIRBlock block, BlockT state) {
        if (!((EffectsBlockState)state).isDead()) {
            IfNode ifNode;
            LogicNode condition;
            ValueNode alias;
            GraphEffectList effects = this.blockEffects.get(block);
            if (block.getBeginNode().predecessor() instanceof IfNode && (alias = this.getScalarAlias(condition = (ifNode = (IfNode)block.getBeginNode().predecessor()).condition())) instanceof LogicConstantNode) {
                boolean isTrueSuccessor;
                LogicConstantNode constant = (LogicConstantNode)alias;
                boolean bl = isTrueSuccessor = block.getBeginNode() == ifNode.trueSuccessor();
                if (constant.getValue() != isTrueSuccessor) {
                    ((EffectsBlockState)state).markAsDead();
                    effects.killIfBranch(ifNode, constant.getValue());
                    return state;
                }
            }
            OptionValues options = block.getBeginNode().getOptions();
            if (GraalOptions.TraceEscapeAnalysis.getValue(block.getBeginNode().getOptions()).booleanValue()) {
                int predCount = block.getPredecessorCount();
                HIRBlock[] pred = new HIRBlock[predCount];
                for (int i = 0; i < predCount; ++i) {
                    pred[i] = (HIRBlock)block.getPredecessorAt(i);
                }
                int succCount = block.getSuccessorCount();
                HIRBlock[] succ = new HIRBlock[succCount];
                for (int i = 0; i < succCount; ++i) {
                    succ[i] = (HIRBlock)block.getSuccessorAt(i);
                }
                VirtualUtil.trace(options, this.debug, "\nBlock: %s, preds: %s, succ: %s (", block, pred, succ);
            }
            FixedWithNextNode lastFixedNode = null;
            Iterable nodes = this.schedule != null ? (Iterable)this.schedule.getBlockToNodesMap().get(block) : block.getNodes();
            for (Node node : nodes) {
                this.aliases.set(node, null);
                if (node instanceof LoopExitNode) {
                    LoopExitNode loopExit = (LoopExitNode)node;
                    for (ProxyNode proxy : loopExit.proxies()) {
                        this.aliases.set(proxy, null);
                        this.changed |= this.processNode(proxy, state, effects, lastFixedNode) && EffectsClosure.isSignificantNode(node);
                    }
                    this.processLoopExit(loopExit, (EffectsBlockState)this.loopEntryStates.get((Object)loopExit.loopBegin()), state, this.blockEffects.get(block));
                }
                HIRBlock exceptionEdgeToKill = node instanceof WithExceptionNode ? this.cfg.blockFor(((WithExceptionNode)node).exceptionEdge()) : null;
                boolean lastNodeChanged = this.processNode(node, state, effects, lastFixedNode) && EffectsClosure.isSignificantNode(node);
                this.changed |= lastNodeChanged;
                if (lastNodeChanged && exceptionEdgeToKill != null) {
                    if (((EffectsBlockState)state).exceptionEdgesToKill == null) {
                        ((EffectsBlockState)state).exceptionEdgesToKill = EconomicSet.create();
                    }
                    ((EffectsBlockState)state).exceptionEdgesToKill.add((Object)exceptionEdgeToKill);
                }
                if (node instanceof FixedWithNextNode) {
                    lastFixedNode = (FixedWithNextNode)node;
                }
                if (!((EffectsBlockState)state).isDead()) continue;
                break;
            }
            VirtualUtil.trace(options, this.debug, ")\n    end state: %s\n", state);
        }
        return state;
    }

    @Override
    protected BlockT afterSplit(HIRBlock successor, BlockT oldState) {
        BlockT state = oldState;
        if (((EffectsBlockState)oldState).exceptionEdgesToKill != null && ((EffectsBlockState)oldState).exceptionEdgesToKill.contains((Object)successor)) {
            ((EffectsBlockState)state).markAsDead();
        }
        return state;
    }

    private static boolean isSignificantNode(Node node) {
        return !(node instanceof CommitAllocationNode) && !(node instanceof AllocatedObjectNode) && !(node instanceof BoxNode);
    }

    protected abstract boolean processNode(Node var1, BlockT var2, GraphEffectList var3, FixedWithNextNode var4);

    @Override
    protected BlockT merge(HIRBlock merge, List<BlockT> states) {
        assert (this.blockEffects.get(merge).isEmpty());
        MergeProcessor processor = this.createMergeProcessor(merge);
        this.doMergeWithoutDead(processor, states);
        this.blockEffects.get(merge).addAll(processor.mergeEffects);
        this.blockEffects.get(merge).addAll(processor.afterMergeEffects);
        return processor.newState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected final List<BlockT> processLoop(Loop<HIRBlock> loop, BlockT initialState) {
        if (((EffectsBlockState)initialState).isDead()) {
            ArrayList<BlockT> states = new ArrayList<BlockT>();
            int i = 0;
            while (i < loop.getLoopExits().size()) {
                states.add(initialState);
                ++i;
            }
            return states;
        }
        EffectsBlockState initialStateRemovedKilledLocations = this.stripKilledLoopLocations(loop, (EffectsBlockState)this.cloneState(initialState));
        NodeMap<ValueNode> aliasesCopy = null;
        NodeBitMap hasScalarReplacedInputsCopy = null;
        BlockMap<GraphEffectList> blockEffectsCopy = null;
        EconomicMap loopMergeEffectsCopy = null;
        EconomicMap loopEntryStatesCopy = null;
        EconomicMap loopLocationKillCacheCopy = null;
        EffectsBlockState initialStateRemovedKilledLocationsBackup = null;
        if (loop.getDepth() == 1) {
            boolean initBackUp = false;
            for (Loop l : this.cfg.getLoops()) {
                if (l.getDepth() <= GraalOptions.EscapeAnalysisLoopCutoff.getValue(this.cfg.graph.getOptions())) continue;
                initBackUp = true;
                break;
            }
            if (initBackUp) {
                initialStateRemovedKilledLocationsBackup = this.cloneState(initialStateRemovedKilledLocations);
                aliasesCopy = new NodeMap<ValueNode>(this.aliases);
                hasScalarReplacedInputsCopy = this.hasScalarReplacedInputs.copy();
                blockEffectsCopy = new BlockMap<GraphEffectList>(this.cfg);
                for (HIRBlock block : this.cfg.getBlocks()) {
                    GraphEffectList copy = new GraphEffectList(this.debug);
                    copy.addAll(this.blockEffects.get(block));
                    blockEffectsCopy.put(block, copy);
                }
                loopMergeEffectsCopy = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
                loopMergeEffectsCopy.putAll(this.loopMergeEffects);
                loopEntryStatesCopy = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
                loopEntryStatesCopy.putAll(this.loopEntryStates);
                loopLocationKillCacheCopy = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
                loopLocationKillCacheCopy.putAll(this.loopLocationKillCache);
            }
        }
        while (true) {
            CompilationAlarm.checkProgress(this.cfg.graph);
            try {
                EffectsBlockState loopEntryState = initialStateRemovedKilledLocations;
                EffectsBlockState<Object> lastMergedState = this.cloneState(initialStateRemovedKilledLocations);
                this.processInitialLoopState(loop, lastMergedState);
                MergeProcessor mergeProcessor = this.createMergeProcessor(loop.getHeader());
                boolean[] knownAliveLoopEnds = new boolean[loop.numBackedges()];
                for (int iteration = 0; iteration < 10; ++iteration) {
                    try (Indent i = this.debug.logAndIndent("================== Process Loop Effects Closure: block:%s begin node:%s iteration:%s", (Object)loop.getHeader(), (Object)loop.getHeader().getBeginNode(), (Object)iteration);){
                        ReentrantBlockIterator.LoopInfo<EffectsBlockState> info = ReentrantBlockIterator.processLoop(this, loop, this.cloneState(lastMergedState));
                        ArrayList<EffectsBlockState<Object>> states = new ArrayList<EffectsBlockState<Object>>();
                        states.add(initialStateRemovedKilledLocations);
                        states.addAll(info.endStates);
                        this.doMergeWithoutDead(mergeProcessor, states);
                        this.debug.log("MergeProcessor New State: %s", mergeProcessor.newState);
                        this.debug.log("===== vs.");
                        this.debug.log("Last Merged State: %s", lastMergedState);
                        if (((EffectsBlockState)mergeProcessor.newState).equivalentTo((EffectsBlockState)lastMergedState)) {
                            this.blockEffects.get(loop.getHeader()).insertAll(mergeProcessor.mergeEffects, 0);
                            this.loopMergeEffects.put(loop, (Object)mergeProcessor.afterMergeEffects);
                            assert (info.exitStates.size() == loop.getLoopExits().size()) : Assertions.errorMessage(info, info.exitStates, loop, loop.getLoopExits());
                            this.loopEntryStates.put((Object)((LoopBeginNode)loop.getHeader().getBeginNode()), (Object)loopEntryState);
                            assert (this.assertExitStatesNonEmpty(loop, info));
                            this.processKilledLoopLocations(loop, initialStateRemovedKilledLocations, mergeProcessor.newState);
                            if (this.currentMode != EffectsClosureMode.REGULAR_VIRTUALIZATION && loop.getDepth() == 1) {
                                this.currentMode = EffectsClosureMode.REGULAR_VIRTUALIZATION;
                            }
                            List list = info.exitStates;
                            return list;
                        }
                        GraalError.guarantee(info.endStates.size() == knownAliveLoopEnds.length, "should have the same number of end states as loop ends: %s / %s", (Object)info.endStates.size(), (Object)knownAliveLoopEnds.length);
                        int endIndex = 0;
                        for (EffectsBlockState endState : info.endStates) {
                            GraalError.guarantee(!knownAliveLoopEnds[endIndex] || !endState.isDead(), "%s: monotonicity violated, state at loop end %s should remain alive but is dead: %s", loop, (Object)endIndex, (Object)endState);
                            int n = endIndex;
                            knownAliveLoopEnds[n] = knownAliveLoopEnds[n] | !endState.isDead();
                            ++endIndex;
                        }
                        lastMergedState = mergeProcessor.newState;
                        for (HIRBlock block : loop.getBlocks()) {
                            GraphEffectList loopEffects;
                            this.blockEffects.get(block).clear();
                            if (!block.isLoopHeader() || (loopEffects = (GraphEffectList)this.loopMergeEffects.get(block.getLoop())) == null) continue;
                            loopEffects.clear();
                        }
                        continue;
                    }
                }
                throw new GraalError("too many iterations at %s", loop);
            }
            catch (EffecsClosureOverflowException e) {
                if (loop.getDepth() != 1) {
                    throw e;
                }
                assert (this.aliases != aliasesCopy) : aliasesCopy;
                this.aliases = aliasesCopy;
                this.hasScalarReplacedInputs = hasScalarReplacedInputsCopy;
                assert (this.blockEffects != blockEffectsCopy) : "Mus";
                this.blockEffects = blockEffectsCopy;
                this.loopMergeEffects = loopMergeEffectsCopy;
                this.loopEntryStates = loopEntryStatesCopy;
                this.loopLocationKillCache = loopLocationKillCacheCopy;
                initialStateRemovedKilledLocations = initialStateRemovedKilledLocationsBackup;
                this.processStateBeforeLoopOnOverflow(initialStateRemovedKilledLocations, ((LoopBeginNode)loop.getHeader().getBeginNode()).forwardEnd(), this.blockEffects.get((BasicBlock<?>)loop.getHeader().getPredecessorAt(0)));
                this.currentMode = EffectsClosureMode.MATERIALIZE_ALL;
                continue;
            }
            break;
        }
    }

    protected void processStateBeforeLoopOnOverflow(BlockT initialState, FixedNode materializeBefore, GraphEffectList effects) {
    }

    protected BlockT stripKilledLoopLocations(Loop<HIRBlock> loop, BlockT initialState) {
        return initialState;
    }

    protected void processKilledLoopLocations(Loop<HIRBlock> loop, BlockT initialState, BlockT mergedStates) {
    }

    protected void processInitialLoopState(Loop<HIRBlock> loop, BlockT initialState) {
    }

    private void doMergeWithoutDead(MergeProcessor mergeProcessor, List<BlockT> states) {
        int alive = 0;
        for (EffectsBlockState state : states) {
            if (state.isDead()) continue;
            ++alive;
        }
        if (alive == 0) {
            mergeProcessor.setNewState((EffectsBlockState)states.get(0));
        } else if (alive == states.size()) {
            int[] stateIndexes = new int[states.size()];
            for (int i = 0; i < stateIndexes.length; ++i) {
                stateIndexes[i] = i;
            }
            mergeProcessor.setStateIndexes(stateIndexes);
            mergeProcessor.setNewState((EffectsBlockState)this.getInitialState());
            mergeProcessor.merge(states);
        } else {
            ArrayList<EffectsBlockState> aliveStates = new ArrayList<EffectsBlockState>(alive);
            int[] stateIndexes = new int[alive];
            for (int i = 0; i < states.size(); ++i) {
                if (((EffectsBlockState)states.get(i)).isDead()) continue;
                stateIndexes[aliveStates.size()] = i;
                aliveStates.add((EffectsBlockState)states.get(i));
            }
            mergeProcessor.setStateIndexes(stateIndexes);
            mergeProcessor.setNewState((EffectsBlockState)this.getInitialState());
            mergeProcessor.merge(aliveStates);
        }
    }

    private boolean assertExitStatesNonEmpty(Loop<HIRBlock> loop, ReentrantBlockIterator.LoopInfo<BlockT> info) {
        for (int i = 0; i < loop.getLoopExits().size(); ++i) {
            assert (info.exitStates.get(i) != null) : "no loop exit state at " + String.valueOf(loop.getLoopExits().get(i)) + " / " + String.valueOf(loop.getHeader());
        }
        return true;
    }

    protected abstract void processLoopExit(LoopExitNode var1, BlockT var2, BlockT var3, GraphEffectList var4);

    protected abstract MergeProcessor createMergeProcessor(HIRBlock var1);

    public void addScalarAlias(ValueNode node, ValueNode alias) {
        assert (!(alias instanceof VirtualObjectNode)) : "Must not be a virtual object node " + String.valueOf(alias);
        this.aliases.set(node, alias);
        for (Node usage : node.usages()) {
            if (this.hasScalarReplacedInputs.isNew(usage)) continue;
            this.hasScalarReplacedInputs.mark(usage);
        }
    }

    protected final boolean hasScalarReplacedInputs(Node node) {
        return this.hasScalarReplacedInputs.isMarked(node);
    }

    public ValueNode getScalarAlias(ValueNode node) {
        assert (!(node instanceof VirtualObjectNode)) : node;
        if (node == null || !node.isAlive() || this.aliases.isNew(node)) {
            return node;
        }
        ValueNode result = this.aliases.get(node);
        return result == null || result instanceof VirtualObjectNode ? node : result;
    }

    static enum EffectsClosureMode {
        REGULAR_VIRTUALIZATION,
        STOP_NEW_VIRTUALIZATIONS_LOOP_NEST,
        MATERIALIZE_ALL;

    }

    protected abstract class MergeProcessor {
        protected final HIRBlock mergeBlock;
        protected final AbstractMergeNode merge;
        protected final GraphEffectList mergeEffects;
        protected final GraphEffectList afterMergeEffects;
        private int[] stateIndexes;
        protected BlockT newState;

        public MergeProcessor(EffectsClosure this$0, HIRBlock mergeBlock) {
            this.mergeBlock = mergeBlock;
            this.merge = (AbstractMergeNode)mergeBlock.getBeginNode();
            this.mergeEffects = new GraphEffectList(this$0.debug);
            this.afterMergeEffects = new GraphEffectList(this$0.debug);
        }

        protected abstract void merge(List<BlockT> var1);

        private void setNewState(BlockT state) {
            this.newState = state;
            this.mergeEffects.clear();
            this.afterMergeEffects.clear();
        }

        private void setStateIndexes(int[] stateIndexes) {
            this.stateIndexes = stateIndexes;
        }

        protected final HIRBlock getPredecessor(int index) {
            return (HIRBlock)this.mergeBlock.getPredecessorAt(this.stateIndexes[index]);
        }

        protected final NodeIterable<PhiNode> getPhis() {
            return this.merge.phis();
        }

        protected final ValueNode getPhiValueAt(PhiNode phi, int index) {
            return phi.valueAt(this.stateIndexes[index]);
        }

        protected final ValuePhiNode createValuePhi(Stamp stamp) {
            ValuePhiNode valuePhi = new ValuePhiNode(stamp, this.merge, new ValueNode[this.mergeBlock.getPredecessorCount()]);
            valuePhi.setNodeSourcePosition(this.merge.getNodeSourcePosition());
            return valuePhi;
        }

        protected final void setPhiInput(PhiNode phi, int index, ValueNode value) {
            this.afterMergeEffects.initializePhiInput(phi, this.stateIndexes[index], value);
        }

        protected final StructuredGraph graph() {
            return this.merge.graph();
        }

        public String toString() {
            return "MergeProcessor@" + String.valueOf(this.merge);
        }
    }

    static class EffecsClosureOverflowException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        EffecsClosureOverflowException() {
        }
    }

    protected static final class LoopKillCache {
        private int visits;
        private LocationIdentity firstLocation;
        private EconomicSet<LocationIdentity> killedLocations;
        private boolean killsAll;

        protected LoopKillCache(int visits) {
            this.visits = visits;
        }

        protected void visited() {
            ++this.visits;
        }

        protected int visits() {
            return this.visits;
        }

        protected void setKillsAll() {
            this.killsAll = true;
            this.firstLocation = null;
            this.killedLocations = null;
        }

        protected boolean containsLocation(LocationIdentity locationIdentity) {
            if (this.killsAll) {
                return true;
            }
            if (this.firstLocation == null) {
                return false;
            }
            if (!this.firstLocation.equals(locationIdentity)) {
                return this.killedLocations != null ? this.killedLocations.contains((Object)locationIdentity) : false;
            }
            return true;
        }

        protected void rememberLoopKilledLocation(LocationIdentity locationIdentity) {
            if (this.killsAll) {
                return;
            }
            if (this.firstLocation == null || this.firstLocation.equals(locationIdentity)) {
                this.firstLocation = locationIdentity;
            } else {
                if (this.killedLocations == null) {
                    this.killedLocations = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
                }
                this.killedLocations.add((Object)locationIdentity);
            }
        }

        protected boolean loopKillsLocations() {
            if (this.killsAll) {
                return true;
            }
            return this.firstLocation != null;
        }
    }
}

