/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.virtual.phases.ea;

import java.util.Optional;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.virtual.phases.ea.EffectsPhase;
import jdk.graal.compiler.virtual.phases.ea.ReadEliminationClosure;
import jdk.graal.compiler.virtual.phases.ea.VirtualUtil;

public class ReadEliminationPhase
extends EffectsPhase<CoreProviders> {
    protected final boolean considerGuards;

    public ReadEliminationPhase(CanonicalizerPhase canonicalizer) {
        super(1, canonicalizer, true);
        this.considerGuards = true;
    }

    public ReadEliminationPhase(CanonicalizerPhase canonicalizer, boolean considerGuards) {
        super(1, canonicalizer, true);
        this.considerGuards = considerGuards;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.when(graphState.isAfterStage(GraphState.StageFlag.FLOATING_READS) && graphState.isBeforeStage(GraphState.StageFlag.FIXED_READS), "This phase must not be applied while reads are floating"));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        if (VirtualUtil.matches(graph, GraalOptions.EscapeAnalyzeOnly.getValue(graph.getOptions()))) {
            this.runAnalysis(graph, context);
        }
    }

    @Override
    protected EffectsPhase.Closure<?> createEffectsClosure(CoreProviders context, StructuredGraph.ScheduleResult schedule, ControlFlowGraph cfg, OptionValues options) {
        assert (schedule == null);
        return new ReadEliminationClosure(cfg, this.considerGuards);
    }

    @Override
    public float codeSizeIncrease() {
        return 2.0f;
    }
}

