// CheckStyle: start generated
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.regex.AbstractConstantKeysObject;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.RegexEngine;
import com.oracle.truffle.regex.AbstractConstantKeysObject.IsMemberReadable;
import com.oracle.truffle.regex.AbstractConstantKeysObject.ReadMember;
import com.oracle.truffle.regex.runtime.nodes.StringEqualsNode;
import com.oracle.truffle.regex.runtime.nodes.StringEqualsNodeGen;
import com.oracle.truffle.regex.runtime.nodes.ToStringNode;
import com.oracle.truffle.regex.runtime.nodes.ToStringNodeGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(RegexEngine.class)
final class RegexEngineGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(RegexEngine.class, new InteropLibraryExports());
    }

    private RegexEngineGen() {
    }

    @GeneratedBy(RegexEngine.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, RegexEngine.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof RegexEngine;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof RegexEngine;
            return new Cached(receiver);
        }

        @GeneratedBy(RegexEngine.class)
        private static final class Cached extends InteropLibrary {

            private final Class<? extends RegexEngine> receiverClass_;
            @CompilationFinal private volatile int state_;
            @CompilationFinal private volatile int exclude_;
            @Child private ToStringNode patternToStringNode;
            @Child private ToStringNode flagsToStringNode;
            @Child private ToStringNode encodingToStringNode;
            @Child private StringEqualsNode isValidatePropNode;
            @CompilationFinal private IsMemberReadableCacheIdentityData isMemberReadable_cacheIdentity_cache;
            @CompilationFinal private IsMemberReadableCacheEqualsData isMemberReadable_cacheEquals_cache;
            @CompilationFinal private ReadMemberReadIdentityData readMember_readIdentity_cache;
            @CompilationFinal private ReadMemberReadEqualsData readMember_readEquals_cache;

            Cached(Object originalReceiver) {
                RegexEngine receiver = ((RegexEngine) originalReceiver) ;
                this.receiverClass_ = receiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).getLanguage();
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).toDisplayString(allowSideEffects);
            }

            @ExplodeLoop
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                RegexEngine arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b111) != 0 /* is-active cacheIdentity(AbstractConstantKeysObject, String, String, boolean) || cacheEquals(AbstractConstantKeysObject, String, String, boolean) || isReadable(AbstractConstantKeysObject, String) */) {
                    if ((state & 0b1) != 0 /* is-active cacheIdentity(AbstractConstantKeysObject, String, String, boolean) */) {
                        IsMemberReadableCacheIdentityData s1_ = this.isMemberReadable_cacheIdentity_cache;
                        while (s1_ != null) {
                            if ((arg1Value == s1_.cachedSymbol_)) {
                                return IsMemberReadable.cacheIdentity(arg0Value, arg1Value, s1_.cachedSymbol_, s1_.result_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active cacheEquals(AbstractConstantKeysObject, String, String, boolean) */) {
                        IsMemberReadableCacheEqualsData s2_ = this.isMemberReadable_cacheEquals_cache;
                        while (s2_ != null) {
                            if ((arg1Value.equals(s2_.cachedSymbol_))) {
                                return IsMemberReadable.cacheEquals(arg0Value, arg1Value, s2_.cachedSymbol_, s2_.result_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 0b100) != 0 /* is-active isReadable(AbstractConstantKeysObject, String) */) {
                        return IsMemberReadable.isReadable(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberReadableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableAndSpecialize(AbstractConstantKeysObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b1)) == 0 /* is-not-excluded cacheIdentity(AbstractConstantKeysObject, String, String, boolean) */) {
                        int count1_ = 0;
                        IsMemberReadableCacheIdentityData s1_ = this.isMemberReadable_cacheIdentity_cache;
                        if ((state & 0b1) != 0 /* is-active cacheIdentity(AbstractConstantKeysObject, String, String, boolean) */) {
                            while (s1_ != null) {
                                if ((arg1Value == s1_.cachedSymbol_)) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (arg1Value == s1_.cachedSymbol_);
                            if (count1_ < (8)) {
                                s1_ = new IsMemberReadableCacheIdentityData(isMemberReadable_cacheIdentity_cache);
                                s1_.cachedSymbol_ = (arg1Value);
                                s1_.result_ = (IsMemberReadable.isReadable(arg0Value, s1_.cachedSymbol_));
                                this.isMemberReadable_cacheIdentity_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active cacheIdentity(AbstractConstantKeysObject, String, String, boolean) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return IsMemberReadable.cacheIdentity(arg0Value, arg1Value, s1_.cachedSymbol_, s1_.result_);
                        }
                    }
                    if (((exclude & 0b10)) == 0 /* is-not-excluded cacheEquals(AbstractConstantKeysObject, String, String, boolean) */) {
                        int count2_ = 0;
                        IsMemberReadableCacheEqualsData s2_ = this.isMemberReadable_cacheEquals_cache;
                        if ((state & 0b10) != 0 /* is-active cacheEquals(AbstractConstantKeysObject, String, String, boolean) */) {
                            while (s2_ != null) {
                                if ((arg1Value.equals(s2_.cachedSymbol_))) {
                                    break;
                                }
                                s2_ = s2_.next_;
                                count2_++;
                            }
                        }
                        if (s2_ == null) {
                            // assert (arg1Value.equals(s2_.cachedSymbol_));
                            if (count2_ < (8)) {
                                s2_ = new IsMemberReadableCacheEqualsData(isMemberReadable_cacheEquals_cache);
                                s2_.cachedSymbol_ = (arg1Value);
                                s2_.result_ = (IsMemberReadable.isReadable(arg0Value, s2_.cachedSymbol_));
                                this.isMemberReadable_cacheEquals_cache = s2_;
                                this.exclude_ = exclude = exclude | 0b1 /* add-excluded cacheIdentity(AbstractConstantKeysObject, String, String, boolean) */;
                                this.isMemberReadable_cacheIdentity_cache = null;
                                state = state & 0xfffffffe /* remove-active cacheIdentity(AbstractConstantKeysObject, String, String, boolean) */;
                                this.state_ = state = state | 0b10 /* add-active cacheEquals(AbstractConstantKeysObject, String, String, boolean) */;
                            }
                        }
                        if (s2_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return IsMemberReadable.cacheEquals(arg0Value, arg1Value, s2_.cachedSymbol_, s2_.result_);
                        }
                    }
                    this.exclude_ = exclude = exclude | 0b11 /* add-excluded cacheIdentity(AbstractConstantKeysObject, String, String, boolean), cacheEquals(AbstractConstantKeysObject, String, String, boolean) */;
                    this.isMemberReadable_cacheIdentity_cache = null;
                    this.isMemberReadable_cacheEquals_cache = null;
                    state = state & 0xfffffffc /* remove-active cacheIdentity(AbstractConstantKeysObject, String, String, boolean), cacheEquals(AbstractConstantKeysObject, String, String, boolean) */;
                    this.state_ = state = state | 0b100 /* add-active isReadable(AbstractConstantKeysObject, String) */;
                    lock.unlock();
                    hasLock = false;
                    return IsMemberReadable.isReadable(arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b111) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if (((state & 0b111) & ((state & 0b111) - 1)) == 0 /* is-single-active  */) {
                    IsMemberReadableCacheIdentityData s1_ = this.isMemberReadable_cacheIdentity_cache;
                    IsMemberReadableCacheEqualsData s2_ = this.isMemberReadable_cacheEquals_cache;
                    if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @ExplodeLoop
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                RegexEngine arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b111000) != 0 /* is-active readIdentity(AbstractConstantKeysObject, String, String) || readEquals(AbstractConstantKeysObject, String, String) || read(AbstractConstantKeysObject, String) */) {
                    if ((state & 0b1000) != 0 /* is-active readIdentity(AbstractConstantKeysObject, String, String) */) {
                        ReadMemberReadIdentityData s1_ = this.readMember_readIdentity_cache;
                        while (s1_ != null) {
                            if ((arg1Value == s1_.cachedSymbol_)) {
                                return ReadMember.readIdentity(arg0Value, arg1Value, s1_.cachedSymbol_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10000) != 0 /* is-active readEquals(AbstractConstantKeysObject, String, String) */) {
                        ReadMemberReadEqualsData s2_ = this.readMember_readEquals_cache;
                        while (s2_ != null) {
                            if ((arg1Value.equals(s2_.cachedSymbol_))) {
                                return ReadMember.readEquals(arg0Value, arg1Value, s2_.cachedSymbol_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 0b100000) != 0 /* is-active read(AbstractConstantKeysObject, String) */) {
                        return ReadMember.read(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberAndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberAndSpecialize(AbstractConstantKeysObject arg0Value, String arg1Value) throws UnknownIdentifierException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b100)) == 0 /* is-not-excluded readIdentity(AbstractConstantKeysObject, String, String) */) {
                        int count1_ = 0;
                        ReadMemberReadIdentityData s1_ = this.readMember_readIdentity_cache;
                        if ((state & 0b1000) != 0 /* is-active readIdentity(AbstractConstantKeysObject, String, String) */) {
                            while (s1_ != null) {
                                if ((arg1Value == s1_.cachedSymbol_)) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (arg1Value == s1_.cachedSymbol_);
                            if (count1_ < (8)) {
                                s1_ = new ReadMemberReadIdentityData(readMember_readIdentity_cache);
                                s1_.cachedSymbol_ = (arg1Value);
                                this.readMember_readIdentity_cache = s1_;
                                this.state_ = state = state | 0b1000 /* add-active readIdentity(AbstractConstantKeysObject, String, String) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return ReadMember.readIdentity(arg0Value, arg1Value, s1_.cachedSymbol_);
                        }
                    }
                    if (((exclude & 0b1000)) == 0 /* is-not-excluded readEquals(AbstractConstantKeysObject, String, String) */) {
                        int count2_ = 0;
                        ReadMemberReadEqualsData s2_ = this.readMember_readEquals_cache;
                        if ((state & 0b10000) != 0 /* is-active readEquals(AbstractConstantKeysObject, String, String) */) {
                            while (s2_ != null) {
                                if ((arg1Value.equals(s2_.cachedSymbol_))) {
                                    break;
                                }
                                s2_ = s2_.next_;
                                count2_++;
                            }
                        }
                        if (s2_ == null) {
                            // assert (arg1Value.equals(s2_.cachedSymbol_));
                            if (count2_ < (8)) {
                                s2_ = new ReadMemberReadEqualsData(readMember_readEquals_cache);
                                s2_.cachedSymbol_ = (arg1Value);
                                this.readMember_readEquals_cache = s2_;
                                this.exclude_ = exclude = exclude | 0b100 /* add-excluded readIdentity(AbstractConstantKeysObject, String, String) */;
                                this.readMember_readIdentity_cache = null;
                                state = state & 0xfffffff7 /* remove-active readIdentity(AbstractConstantKeysObject, String, String) */;
                                this.state_ = state = state | 0b10000 /* add-active readEquals(AbstractConstantKeysObject, String, String) */;
                            }
                        }
                        if (s2_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return ReadMember.readEquals(arg0Value, arg1Value, s2_.cachedSymbol_);
                        }
                    }
                    this.exclude_ = exclude = exclude | 0b1100 /* add-excluded readIdentity(AbstractConstantKeysObject, String, String), readEquals(AbstractConstantKeysObject, String, String) */;
                    this.readMember_readIdentity_cache = null;
                    this.readMember_readEquals_cache = null;
                    state = state & 0xffffffe7 /* remove-active readIdentity(AbstractConstantKeysObject, String, String), readEquals(AbstractConstantKeysObject, String, String) */;
                    this.state_ = state = state | 0b100000 /* add-active read(AbstractConstantKeysObject, String) */;
                    lock.unlock();
                    hasLock = false;
                    return ReadMember.read(arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).getMembers(includeInternal);
            }

            @Override
            public boolean isExecutable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).isExecutable();
            }

            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                RegexEngine arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b1000000) != 0 /* is-active execute(RegexEngine, Object[], ToStringNode, ToStringNode, ToStringNode) */) {
                    return arg0Value.execute(arg1Value, this.patternToStringNode, this.flagsToStringNode, this.encodingToStringNode);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object executeNode_AndSpecialize(RegexEngine arg0Value, Object[] arg1Value) throws ArityException, UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.patternToStringNode == null) {
                        this.patternToStringNode = super.insert((ToStringNode.create()));
                    }
                    if (this.flagsToStringNode == null) {
                        this.flagsToStringNode = super.insert((ToStringNode.create()));
                    }
                    if (this.encodingToStringNode == null) {
                        this.encodingToStringNode = super.insert((ToStringNode.create()));
                    }
                    this.state_ = state = state | 0b1000000 /* add-active execute(RegexEngine, Object[], ToStringNode, ToStringNode, ToStringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.execute(arg1Value, this.patternToStringNode, this.flagsToStringNode, this.encodingToStringNode);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                RegexEngine arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b10000000) != 0 /* is-active isMemberInvocable(RegexEngine, String, StringEqualsNode) */) {
                    return arg0Value.isMemberInvocable(arg1Value, this.isValidatePropNode);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInvocableNode_AndSpecialize(RegexEngine arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.isValidatePropNode == null) {
                        this.isValidatePropNode = super.insert((StringEqualsNodeGen.create()));
                    }
                    this.state_ = state = state | 0b10000000 /* add-active isMemberInvocable(RegexEngine, String, StringEqualsNode) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.isMemberInvocable(arg1Value, this.isValidatePropNode);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                RegexEngine arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b100000000) != 0 /* is-active invokeMember(RegexEngine, String, Object[], StringEqualsNode, ToStringNode, ToStringNode, ToStringNode) */) {
                    return arg0Value.invokeMember(arg1Value, arg2Value, this.isValidatePropNode, this.patternToStringNode, this.flagsToStringNode, this.encodingToStringNode);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(RegexEngine arg0Value, String arg1Value, Object[] arg2Value) throws UnknownIdentifierException, ArityException, UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.isValidatePropNode == null) {
                        this.isValidatePropNode = super.insert((StringEqualsNodeGen.create()));
                    }
                    if (this.patternToStringNode == null) {
                        this.patternToStringNode = super.insert((ToStringNode.create()));
                    }
                    if (this.flagsToStringNode == null) {
                        this.flagsToStringNode = super.insert((ToStringNode.create()));
                    }
                    if (this.encodingToStringNode == null) {
                        this.encodingToStringNode = super.insert((ToStringNode.create()));
                    }
                    this.state_ = state = state | 0b100000000 /* add-active invokeMember(RegexEngine, String, Object[], StringEqualsNode, ToStringNode, ToStringNode, ToStringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.invokeMember(arg1Value, arg2Value, this.isValidatePropNode, this.patternToStringNode, this.flagsToStringNode, this.encodingToStringNode);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @GeneratedBy(AbstractConstantKeysObject.class)
            private static final class IsMemberReadableCacheIdentityData {

                @CompilationFinal IsMemberReadableCacheIdentityData next_;
                @CompilationFinal String cachedSymbol_;
                @CompilationFinal boolean result_;

                IsMemberReadableCacheIdentityData(IsMemberReadableCacheIdentityData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(AbstractConstantKeysObject.class)
            private static final class IsMemberReadableCacheEqualsData {

                @CompilationFinal IsMemberReadableCacheEqualsData next_;
                @CompilationFinal String cachedSymbol_;
                @CompilationFinal boolean result_;

                IsMemberReadableCacheEqualsData(IsMemberReadableCacheEqualsData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(AbstractConstantKeysObject.class)
            private static final class ReadMemberReadIdentityData {

                @CompilationFinal ReadMemberReadIdentityData next_;
                @CompilationFinal String cachedSymbol_;

                ReadMemberReadIdentityData(ReadMemberReadIdentityData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(AbstractConstantKeysObject.class)
            private static final class ReadMemberReadEqualsData {

                @CompilationFinal ReadMemberReadEqualsData next_;
                @CompilationFinal String cachedSymbol_;

                ReadMemberReadEqualsData(ReadMemberReadEqualsData next_) {
                    this.next_ = next_;
                }

            }
        }
        @GeneratedBy(RegexEngine.class)
        private static final class Uncached extends InteropLibrary {

            private final Class<? extends RegexEngine> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((RegexEngine) receiver).getClass();
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractRegexObject) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractRegexObject) receiver) .getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractRegexObject) receiver) .toDisplayString(allowSideEffects);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                AbstractConstantKeysObject arg0Value = ((AbstractConstantKeysObject) arg0Value_);
                return IsMemberReadable.isReadable(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                AbstractConstantKeysObject arg0Value = ((AbstractConstantKeysObject) arg0Value_);
                return ReadMember.read(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractConstantKeysObject) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractConstantKeysObject) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((RegexEngine) receiver) .isExecutable();
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws ArityException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                RegexEngine arg0Value = ((RegexEngine) arg0Value_);
                return arg0Value.execute(arg1Value, (ToStringNodeGen.getUncached()), (ToStringNodeGen.getUncached()), (ToStringNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                RegexEngine arg0Value = ((RegexEngine) arg0Value_);
                return arg0Value.isMemberInvocable(arg1Value, (StringEqualsNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnknownIdentifierException, ArityException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                RegexEngine arg0Value = ((RegexEngine) arg0Value_);
                return arg0Value.invokeMember(arg1Value, arg2Value, (StringEqualsNodeGen.getUncached()), (ToStringNodeGen.getUncached()), (ToStringNodeGen.getUncached()), (ToStringNodeGen.getUncached()));
            }

        }
    }
}
