// CheckStyle: start generated
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.regex.CompiledRegexObject;
import com.oracle.truffle.regex.RegexObject;
import com.oracle.truffle.regex.RegexObject.ExecCompiledRegexNode;
import com.oracle.truffle.regex.RegexObject.GetCompiledRegexNode;
import com.oracle.truffle.regex.RegexObject.InvokeCacheNode;
import com.oracle.truffle.regex.RegexObject.IsInvocableCacheNode;
import com.oracle.truffle.regex.runtime.nodes.ExpectByteArrayHostObjectNode;
import com.oracle.truffle.regex.runtime.nodes.ExpectByteArrayHostObjectNodeGen;
import com.oracle.truffle.regex.runtime.nodes.ExpectStringOrTruffleObjectNode;
import com.oracle.truffle.regex.runtime.nodes.ExpectStringOrTruffleObjectNodeGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(RegexObject.class)
public final class RegexObjectFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(IsInvocableCacheNode.class)
    static final class IsInvocableCacheNodeGen extends IsInvocableCacheNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_;
        @CompilationFinal private volatile int exclude_;
        @CompilationFinal private CacheIdentityData cacheIdentity_cache;
        @CompilationFinal private CacheEqualsData cacheEquals_cache;

        private IsInvocableCacheNodeGen() {
        }

        @ExplodeLoop
        @Override
        boolean execute(String arg0Value) {
            int state = state_;
            if (state != 0 /* is-active cacheIdentity(String, String, boolean) || cacheEquals(String, String, boolean) || isInvocable(String) */) {
                if ((state & 0b1) != 0 /* is-active cacheIdentity(String, String, boolean) */) {
                    CacheIdentityData s1_ = this.cacheIdentity_cache;
                    while (s1_ != null) {
                        if ((arg0Value == s1_.cachedSymbol_)) {
                            return IsInvocableCacheNode.cacheIdentity(arg0Value, s1_.cachedSymbol_, s1_.result_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active cacheEquals(String, String, boolean) */) {
                    CacheEqualsData s2_ = this.cacheEquals_cache;
                    while (s2_ != null) {
                        if ((arg0Value.equals(s2_.cachedSymbol_))) {
                            return IsInvocableCacheNode.cacheEquals(arg0Value, s2_.cachedSymbol_, s2_.result_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active isInvocable(String) */) {
                    return IsInvocableCacheNode.isInvocable(arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private boolean executeAndSpecialize(String arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if (((exclude & 0b1)) == 0 /* is-not-excluded cacheIdentity(String, String, boolean) */) {
                    int count1_ = 0;
                    CacheIdentityData s1_ = this.cacheIdentity_cache;
                    if ((state & 0b1) != 0 /* is-active cacheIdentity(String, String, boolean) */) {
                        while (s1_ != null) {
                            if ((arg0Value == s1_.cachedSymbol_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg0Value == s1_.cachedSymbol_);
                        if (count1_ < (2)) {
                            s1_ = new CacheIdentityData(cacheIdentity_cache);
                            s1_.cachedSymbol_ = (arg0Value);
                            s1_.result_ = (IsInvocableCacheNode.isInvocable(s1_.cachedSymbol_));
                            this.cacheIdentity_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active cacheIdentity(String, String, boolean) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return IsInvocableCacheNode.cacheIdentity(arg0Value, s1_.cachedSymbol_, s1_.result_);
                    }
                }
                if (((exclude & 0b10)) == 0 /* is-not-excluded cacheEquals(String, String, boolean) */) {
                    int count2_ = 0;
                    CacheEqualsData s2_ = this.cacheEquals_cache;
                    if ((state & 0b10) != 0 /* is-active cacheEquals(String, String, boolean) */) {
                        while (s2_ != null) {
                            if ((arg0Value.equals(s2_.cachedSymbol_))) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        // assert (arg0Value.equals(s2_.cachedSymbol_));
                        if (count2_ < (2)) {
                            s2_ = new CacheEqualsData(cacheEquals_cache);
                            s2_.cachedSymbol_ = (arg0Value);
                            s2_.result_ = (IsInvocableCacheNode.isInvocable(s2_.cachedSymbol_));
                            this.cacheEquals_cache = s2_;
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded cacheIdentity(String, String, boolean) */;
                            this.cacheIdentity_cache = null;
                            state = state & 0xfffffffe /* remove-active cacheIdentity(String, String, boolean) */;
                            this.state_ = state = state | 0b10 /* add-active cacheEquals(String, String, boolean) */;
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return IsInvocableCacheNode.cacheEquals(arg0Value, s2_.cachedSymbol_, s2_.result_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b11 /* add-excluded cacheIdentity(String, String, boolean), cacheEquals(String, String, boolean) */;
                this.cacheIdentity_cache = null;
                this.cacheEquals_cache = null;
                state = state & 0xfffffffc /* remove-active cacheIdentity(String, String, boolean), cacheEquals(String, String, boolean) */;
                this.state_ = state = state | 0b100 /* add-active isInvocable(String) */;
                lock.unlock();
                hasLock = false;
                return IsInvocableCacheNode.isInvocable(arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CacheIdentityData s1_ = this.cacheIdentity_cache;
                CacheEqualsData s2_ = this.cacheEquals_cache;
                if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static IsInvocableCacheNode create() {
            return new IsInvocableCacheNodeGen();
        }

        public static IsInvocableCacheNode getUncached() {
            return IsInvocableCacheNodeGen.UNCACHED;
        }

        @GeneratedBy(IsInvocableCacheNode.class)
        private static final class CacheIdentityData {

            @CompilationFinal CacheIdentityData next_;
            @CompilationFinal String cachedSymbol_;
            @CompilationFinal boolean result_;

            CacheIdentityData(CacheIdentityData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(IsInvocableCacheNode.class)
        private static final class CacheEqualsData {

            @CompilationFinal CacheEqualsData next_;
            @CompilationFinal String cachedSymbol_;
            @CompilationFinal boolean result_;

            CacheEqualsData(CacheEqualsData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(IsInvocableCacheNode.class)
        private static final class Uncached extends IsInvocableCacheNode {

            @TruffleBoundary
            @Override
            boolean execute(String arg0Value) {
                return IsInvocableCacheNode.isInvocable(arg0Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(InvokeCacheNode.class)
    static final class InvokeCacheNodeGen extends InvokeCacheNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_;
        @CompilationFinal private volatile int exclude_;
        @Child private GetStartIdentityData getStartIdentity_cache;
        @Child private GetStartEqualsData getStartEquals_cache;
        @Child private GetEndIdentityData getEndIdentity_cache;
        @Child private GetEndEqualsData getEndEquals_cache;
        @Child private InvokeGenericData invokeGeneric_cache;

        private InvokeCacheNodeGen() {
        }

        @ExplodeLoop
        @Override
        Object execute(String arg0Value, Object arg1Value, Object arg2Value, int arg3Value) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException {
            int state = state_;
            if (state != 0 /* is-active getStartIdentity(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode) || getStartEquals(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode) || getEndIdentity(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) || getEndEquals(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) || invokeGeneric(String, Object, Object, int, ExpectStringOrTruffleObjectNode, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) */) {
                if ((state & 0b1) != 0 /* is-active getStartIdentity(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode) */) {
                    GetStartIdentityData s1_ = this.getStartIdentity_cache;
                    while (s1_ != null) {
                        if ((arg0Value == s1_.cachedSymbol_)) {
                            assert (s1_.cachedSymbol_.equals(RegexObject.PROP_EXEC));
                            return getStartIdentity(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedSymbol_, s1_.expectStringOrTruffleObjectNode_, s1_.execNode_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active getStartEquals(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode) */) {
                    GetStartEqualsData s2_ = this.getStartEquals_cache;
                    while (s2_ != null) {
                        if ((arg0Value.equals(s2_.cachedSymbol_))) {
                            assert (s2_.cachedSymbol_.equals(RegexObject.PROP_EXEC));
                            return getStartEquals(arg0Value, arg1Value, arg2Value, arg3Value, s2_.cachedSymbol_, s2_.expectStringOrTruffleObjectNode_, s2_.execNode_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active getEndIdentity(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) */) {
                    GetEndIdentityData s3_ = this.getEndIdentity_cache;
                    while (s3_ != null) {
                        if ((arg0Value == s3_.cachedSymbol_)) {
                            assert (s3_.cachedSymbol_.equals(RegexObject.PROP_EXEC_BYTES));
                            return getEndIdentity(arg0Value, arg1Value, arg2Value, arg3Value, s3_.cachedSymbol_, s3_.expectByteArrayHostObjectNode_, s3_.execNode_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 0b1000) != 0 /* is-active getEndEquals(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) */) {
                    GetEndEqualsData s4_ = this.getEndEquals_cache;
                    while (s4_ != null) {
                        if ((arg0Value.equals(s4_.cachedSymbol_))) {
                            assert (s4_.cachedSymbol_.equals(RegexObject.PROP_EXEC_BYTES));
                            return getEndEquals(arg0Value, arg1Value, arg2Value, arg3Value, s4_.cachedSymbol_, s4_.expectByteArrayHostObjectNode_, s4_.execNode_);
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state & 0b10000) != 0 /* is-active invokeGeneric(String, Object, Object, int, ExpectStringOrTruffleObjectNode, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) */) {
                    InvokeGenericData s5_ = this.invokeGeneric_cache;
                    if (s5_ != null) {
                        return InvokeCacheNode.invokeGeneric(arg0Value, arg1Value, arg2Value, arg3Value, s5_.expectStringOrTruffleObjectNode_, s5_.expectByteArrayHostObjectNode_, s5_.execNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private Object executeAndSpecialize(String arg0Value, Object arg1Value, Object arg2Value, int arg3Value) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            int oldState = state;
            int oldExclude = exclude;
            int oldCacheCount = state == 0 ? 0 : countCaches();
            try {
                if (((exclude & 0b1)) == 0 /* is-not-excluded getStartIdentity(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode) */) {
                    int count1_ = 0;
                    GetStartIdentityData s1_ = this.getStartIdentity_cache;
                    if ((state & 0b1) != 0 /* is-active getStartIdentity(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode) */) {
                        while (s1_ != null) {
                            if ((arg0Value == s1_.cachedSymbol_)) {
                                assert (s1_.cachedSymbol_.equals(RegexObject.PROP_EXEC));
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        {
                            String cachedSymbol__ = (arg0Value);
                            // assert (arg0Value == s1_.cachedSymbol_);
                            if ((cachedSymbol__.equals(RegexObject.PROP_EXEC)) && count1_ < (2)) {
                                s1_ = super.insert(new GetStartIdentityData(getStartIdentity_cache));
                                s1_.cachedSymbol_ = cachedSymbol__;
                                s1_.expectStringOrTruffleObjectNode_ = s1_.insertAccessor((ExpectStringOrTruffleObjectNode.create()));
                                s1_.execNode_ = s1_.insertAccessor((ExecCompiledRegexNodeGen.create()));
                                this.getStartIdentity_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active getStartIdentity(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode) */;
                            }
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return getStartIdentity(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedSymbol_, s1_.expectStringOrTruffleObjectNode_, s1_.execNode_);
                    }
                }
                if (((exclude & 0b10)) == 0 /* is-not-excluded getStartEquals(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode) */) {
                    int count2_ = 0;
                    GetStartEqualsData s2_ = this.getStartEquals_cache;
                    if ((state & 0b10) != 0 /* is-active getStartEquals(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode) */) {
                        while (s2_ != null) {
                            if ((arg0Value.equals(s2_.cachedSymbol_))) {
                                assert (s2_.cachedSymbol_.equals(RegexObject.PROP_EXEC));
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        {
                            String cachedSymbol__1 = (arg0Value);
                            // assert (arg0Value.equals(s2_.cachedSymbol_));
                            if ((cachedSymbol__1.equals(RegexObject.PROP_EXEC)) && count2_ < (2)) {
                                s2_ = super.insert(new GetStartEqualsData(getStartEquals_cache));
                                s2_.cachedSymbol_ = cachedSymbol__1;
                                s2_.expectStringOrTruffleObjectNode_ = s2_.insertAccessor((ExpectStringOrTruffleObjectNode.create()));
                                s2_.execNode_ = s2_.insertAccessor((ExecCompiledRegexNodeGen.create()));
                                this.getStartEquals_cache = s2_;
                                this.exclude_ = exclude = exclude | 0b1 /* add-excluded getStartIdentity(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode) */;
                                this.getStartIdentity_cache = null;
                                state = state & 0xfffffffe /* remove-active getStartIdentity(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode) */;
                                this.state_ = state = state | 0b10 /* add-active getStartEquals(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode) */;
                            }
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return getStartEquals(arg0Value, arg1Value, arg2Value, arg3Value, s2_.cachedSymbol_, s2_.expectStringOrTruffleObjectNode_, s2_.execNode_);
                    }
                }
                if (((exclude & 0b100)) == 0 /* is-not-excluded getEndIdentity(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) */) {
                    int count3_ = 0;
                    GetEndIdentityData s3_ = this.getEndIdentity_cache;
                    if ((state & 0b100) != 0 /* is-active getEndIdentity(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) */) {
                        while (s3_ != null) {
                            if ((arg0Value == s3_.cachedSymbol_)) {
                                assert (s3_.cachedSymbol_.equals(RegexObject.PROP_EXEC_BYTES));
                                break;
                            }
                            s3_ = s3_.next_;
                            count3_++;
                        }
                    }
                    if (s3_ == null) {
                        {
                            String cachedSymbol__2 = (arg0Value);
                            // assert (arg0Value == s3_.cachedSymbol_);
                            if ((cachedSymbol__2.equals(RegexObject.PROP_EXEC_BYTES)) && count3_ < (2)) {
                                s3_ = super.insert(new GetEndIdentityData(getEndIdentity_cache));
                                s3_.cachedSymbol_ = cachedSymbol__2;
                                s3_.expectByteArrayHostObjectNode_ = s3_.insertAccessor((ExpectByteArrayHostObjectNodeGen.create()));
                                s3_.execNode_ = s3_.insertAccessor((ExecCompiledRegexNodeGen.create()));
                                this.getEndIdentity_cache = s3_;
                                this.state_ = state = state | 0b100 /* add-active getEndIdentity(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) */;
                            }
                        }
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return getEndIdentity(arg0Value, arg1Value, arg2Value, arg3Value, s3_.cachedSymbol_, s3_.expectByteArrayHostObjectNode_, s3_.execNode_);
                    }
                }
                if (((exclude & 0b1000)) == 0 /* is-not-excluded getEndEquals(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) */) {
                    int count4_ = 0;
                    GetEndEqualsData s4_ = this.getEndEquals_cache;
                    if ((state & 0b1000) != 0 /* is-active getEndEquals(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) */) {
                        while (s4_ != null) {
                            if ((arg0Value.equals(s4_.cachedSymbol_))) {
                                assert (s4_.cachedSymbol_.equals(RegexObject.PROP_EXEC_BYTES));
                                break;
                            }
                            s4_ = s4_.next_;
                            count4_++;
                        }
                    }
                    if (s4_ == null) {
                        {
                            String cachedSymbol__3 = (arg0Value);
                            // assert (arg0Value.equals(s4_.cachedSymbol_));
                            if ((cachedSymbol__3.equals(RegexObject.PROP_EXEC_BYTES)) && count4_ < (2)) {
                                s4_ = super.insert(new GetEndEqualsData(getEndEquals_cache));
                                s4_.cachedSymbol_ = cachedSymbol__3;
                                s4_.expectByteArrayHostObjectNode_ = s4_.insertAccessor((ExpectByteArrayHostObjectNodeGen.create()));
                                s4_.execNode_ = s4_.insertAccessor((ExecCompiledRegexNodeGen.create()));
                                this.getEndEquals_cache = s4_;
                                this.exclude_ = exclude = exclude | 0b100 /* add-excluded getEndIdentity(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) */;
                                this.getEndIdentity_cache = null;
                                state = state & 0xfffffffb /* remove-active getEndIdentity(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) */;
                                this.state_ = state = state | 0b1000 /* add-active getEndEquals(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) */;
                            }
                        }
                    }
                    if (s4_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return getEndEquals(arg0Value, arg1Value, arg2Value, arg3Value, s4_.cachedSymbol_, s4_.expectByteArrayHostObjectNode_, s4_.execNode_);
                    }
                }
                InvokeGenericData s5_ = super.insert(new InvokeGenericData());
                s5_.expectStringOrTruffleObjectNode_ = s5_.insertAccessor((ExpectStringOrTruffleObjectNode.create()));
                s5_.expectByteArrayHostObjectNode_ = s5_.insertAccessor((ExpectByteArrayHostObjectNodeGen.create()));
                s5_.execNode_ = s5_.insertAccessor((ExecCompiledRegexNodeGen.create()));
                this.invokeGeneric_cache = s5_;
                this.exclude_ = exclude = exclude | 0b1111 /* add-excluded getStartIdentity(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode), getStartEquals(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode), getEndIdentity(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode), getEndEquals(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) */;
                this.getStartIdentity_cache = null;
                this.getStartEquals_cache = null;
                this.getEndIdentity_cache = null;
                this.getEndEquals_cache = null;
                state = state & 0xfffffff0 /* remove-active getStartIdentity(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode), getStartEquals(String, Object, Object, int, String, ExpectStringOrTruffleObjectNode, ExecCompiledRegexNode), getEndIdentity(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode), getEndEquals(String, Object, Object, int, String, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) */;
                this.state_ = state = state | 0b10000 /* add-active invokeGeneric(String, Object, Object, int, ExpectStringOrTruffleObjectNode, ExpectByteArrayHostObjectNode, ExecCompiledRegexNode) */;
                lock.unlock();
                hasLock = false;
                return InvokeCacheNode.invokeGeneric(arg0Value, arg1Value, arg2Value, arg3Value, s5_.expectStringOrTruffleObjectNode_, s5_.expectByteArrayHostObjectNode_, s5_.execNode_);
            } finally {
                if (oldState != 0 || oldExclude != 0) {
                    checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
                }
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        private void checkForPolymorphicSpecialize(int oldState, int oldExclude, int oldCacheCount) {
            int newState = this.state_;
            int newExclude = this.exclude_;
            if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < countCaches()) {
                this.reportPolymorphicSpecialize();
            }
        }

        private int countCaches() {
            int cacheCount = 0;
            GetStartIdentityData s1_ = this.getStartIdentity_cache;
            while (s1_ != null) {
                cacheCount++;
                s1_= s1_.next_;
            }
            GetStartEqualsData s2_ = this.getStartEquals_cache;
            while (s2_ != null) {
                cacheCount++;
                s2_= s2_.next_;
            }
            GetEndIdentityData s3_ = this.getEndIdentity_cache;
            while (s3_ != null) {
                cacheCount++;
                s3_= s3_.next_;
            }
            GetEndEqualsData s4_ = this.getEndEquals_cache;
            while (s4_ != null) {
                cacheCount++;
                s4_= s4_.next_;
            }
            return cacheCount;
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                GetStartIdentityData s1_ = this.getStartIdentity_cache;
                GetStartEqualsData s2_ = this.getStartEquals_cache;
                GetEndIdentityData s3_ = this.getEndIdentity_cache;
                GetEndEqualsData s4_ = this.getEndEquals_cache;
                if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null) && (s3_ == null || s3_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static InvokeCacheNode create() {
            return new InvokeCacheNodeGen();
        }

        public static InvokeCacheNode getUncached() {
            return InvokeCacheNodeGen.UNCACHED;
        }

        @GeneratedBy(InvokeCacheNode.class)
        private static final class GetStartIdentityData extends Node {

            @Child GetStartIdentityData next_;
            @CompilationFinal String cachedSymbol_;
            @Child ExpectStringOrTruffleObjectNode expectStringOrTruffleObjectNode_;
            @Child ExecCompiledRegexNode execNode_;

            GetStartIdentityData(GetStartIdentityData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(InvokeCacheNode.class)
        private static final class GetStartEqualsData extends Node {

            @Child GetStartEqualsData next_;
            @CompilationFinal String cachedSymbol_;
            @Child ExpectStringOrTruffleObjectNode expectStringOrTruffleObjectNode_;
            @Child ExecCompiledRegexNode execNode_;

            GetStartEqualsData(GetStartEqualsData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(InvokeCacheNode.class)
        private static final class GetEndIdentityData extends Node {

            @Child GetEndIdentityData next_;
            @CompilationFinal String cachedSymbol_;
            @Child ExpectByteArrayHostObjectNode expectByteArrayHostObjectNode_;
            @Child ExecCompiledRegexNode execNode_;

            GetEndIdentityData(GetEndIdentityData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(InvokeCacheNode.class)
        private static final class GetEndEqualsData extends Node {

            @Child GetEndEqualsData next_;
            @CompilationFinal String cachedSymbol_;
            @Child ExpectByteArrayHostObjectNode expectByteArrayHostObjectNode_;
            @Child ExecCompiledRegexNode execNode_;

            GetEndEqualsData(GetEndEqualsData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(InvokeCacheNode.class)
        private static final class InvokeGenericData extends Node {

            @Child ExpectStringOrTruffleObjectNode expectStringOrTruffleObjectNode_;
            @Child ExpectByteArrayHostObjectNode expectByteArrayHostObjectNode_;
            @Child ExecCompiledRegexNode execNode_;

            InvokeGenericData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(InvokeCacheNode.class)
        private static final class Uncached extends InvokeCacheNode {

            @TruffleBoundary
            @Override
            Object execute(String arg0Value, Object arg1Value, Object arg2Value, int arg3Value) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, UnknownIdentifierException {
                return InvokeCacheNode.invokeGeneric(arg0Value, arg1Value, arg2Value, arg3Value, (ExpectStringOrTruffleObjectNodeGen.getUncached()), (ExpectByteArrayHostObjectNodeGen.getUncached()), (ExecCompiledRegexNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(GetCompiledRegexNode.class)
    static final class GetCompiledRegexNodeGen extends GetCompiledRegexNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_;
        @CompilationFinal private volatile int exclude_;
        @CompilationFinal private ExecuteFixedData executeFixed_cache;

        private GetCompiledRegexNodeGen() {
        }

        @ExplodeLoop
        @Override
        Object execute(RegexObject arg0Value) {
            int state = state_;
            if (state != 0 /* is-active executeFixed(RegexObject, RegexObject, Object) || executeVarying(RegexObject) */) {
                if ((state & 0b1) != 0 /* is-active executeFixed(RegexObject, RegexObject, Object) */) {
                    ExecuteFixedData s1_ = this.executeFixed_cache;
                    while (s1_ != null) {
                        if ((arg0Value == s1_.cachedReceiver_)) {
                            return GetCompiledRegexNode.executeFixed(arg0Value, s1_.cachedReceiver_, s1_.cachedCompiledRegex_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active executeVarying(RegexObject) */) {
                    return GetCompiledRegexNode.executeVarying(arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(RegexObject arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            int oldState = state;
            int oldExclude = exclude;
            int oldCacheCount = state == 0 ? 0 : countCaches();
            try {
                if ((exclude) == 0 /* is-not-excluded executeFixed(RegexObject, RegexObject, Object) */) {
                    int count1_ = 0;
                    ExecuteFixedData s1_ = this.executeFixed_cache;
                    if ((state & 0b1) != 0 /* is-active executeFixed(RegexObject, RegexObject, Object) */) {
                        while (s1_ != null) {
                            if ((arg0Value == s1_.cachedReceiver_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg0Value == s1_.cachedReceiver_);
                        if (count1_ < (4)) {
                            s1_ = new ExecuteFixedData(executeFixed_cache);
                            s1_.cachedReceiver_ = (arg0Value);
                            s1_.cachedCompiledRegex_ = (arg0Value.getCompiledRegexObject());
                            this.executeFixed_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active executeFixed(RegexObject, RegexObject, Object) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return GetCompiledRegexNode.executeFixed(arg0Value, s1_.cachedReceiver_, s1_.cachedCompiledRegex_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded executeFixed(RegexObject, RegexObject, Object) */;
                this.executeFixed_cache = null;
                state = state & 0xfffffffe /* remove-active executeFixed(RegexObject, RegexObject, Object) */;
                this.state_ = state = state | 0b10 /* add-active executeVarying(RegexObject) */;
                lock.unlock();
                hasLock = false;
                return GetCompiledRegexNode.executeVarying(arg0Value);
            } finally {
                if (oldState != 0 || oldExclude != 0) {
                    checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
                }
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        private void checkForPolymorphicSpecialize(int oldState, int oldExclude, int oldCacheCount) {
            int newState = this.state_;
            int newExclude = this.exclude_;
            if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < countCaches()) {
                this.reportPolymorphicSpecialize();
            }
        }

        private int countCaches() {
            int cacheCount = 0;
            ExecuteFixedData s1_ = this.executeFixed_cache;
            while (s1_ != null) {
                cacheCount++;
                s1_= s1_.next_;
            }
            return cacheCount;
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                ExecuteFixedData s1_ = this.executeFixed_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static GetCompiledRegexNode create() {
            return new GetCompiledRegexNodeGen();
        }

        public static GetCompiledRegexNode getUncached() {
            return GetCompiledRegexNodeGen.UNCACHED;
        }

        @GeneratedBy(GetCompiledRegexNode.class)
        private static final class ExecuteFixedData {

            @CompilationFinal ExecuteFixedData next_;
            @CompilationFinal RegexObject cachedReceiver_;
            @CompilationFinal Object cachedCompiledRegex_;

            ExecuteFixedData(ExecuteFixedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(GetCompiledRegexNode.class)
        private static final class Uncached extends GetCompiledRegexNode {

            @TruffleBoundary
            @Override
            Object execute(RegexObject arg0Value) {
                return GetCompiledRegexNode.executeVarying(arg0Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ExecCompiledRegexNode.class)
    static final class ExecCompiledRegexNodeGen extends ExecCompiledRegexNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_;
        @CompilationFinal private volatile int exclude_;
        @Child private ExecuteTRegexFixedData executeTRegexFixed_cache;
        @Child private IndirectCallNode executeTRegexVarying_indirectCallNode_;
        @Child private ExecuteForeign0Data executeForeign0_cache;

        private ExecCompiledRegexNodeGen() {
        }

        @ExplodeLoop
        @Override
        Object execute(Object arg0Value, Object arg1Value, int arg2Value) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            int state = state_;
            if (state != 0 /* is-active executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) || executeTRegexVarying(CompiledRegexObject, Object, int, IndirectCallNode) || executeForeign(TruffleObject, Object, int, InteropLibrary) || executeForeign(TruffleObject, Object, int, InteropLibrary) */) {
                if ((state & 0b11) != 0 /* is-active executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) || executeTRegexVarying(CompiledRegexObject, Object, int, IndirectCallNode) */ && arg0Value instanceof CompiledRegexObject) {
                    CompiledRegexObject arg0Value_ = (CompiledRegexObject) arg0Value;
                    if ((state & 0b1) != 0 /* is-active executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) */) {
                        ExecuteTRegexFixedData s1_ = this.executeTRegexFixed_cache;
                        while (s1_ != null) {
                            if ((arg0Value_ == s1_.cachedReceiver_)) {
                                return ExecCompiledRegexNode.executeTRegexFixed(arg0Value_, arg1Value, arg2Value, s1_.cachedReceiver_, s1_.directCallNode_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active executeTRegexVarying(CompiledRegexObject, Object, int, IndirectCallNode) */) {
                        return ExecCompiledRegexNode.executeTRegexVarying(arg0Value_, arg1Value, arg2Value, this.executeTRegexVarying_indirectCallNode_);
                    }
                }
                if ((state & 0b1100) != 0 /* is-active executeForeign(TruffleObject, Object, int, InteropLibrary) || executeForeign(TruffleObject, Object, int, InteropLibrary) */ && arg0Value instanceof TruffleObject) {
                    TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                    if ((state & 0b100) != 0 /* is-active executeForeign(TruffleObject, Object, int, InteropLibrary) */) {
                        ExecuteForeign0Data s3_ = this.executeForeign0_cache;
                        while (s3_ != null) {
                            if ((s3_.receivers_.accepts(arg0Value_)) && (s3_.receivers_.isMemberInvocable(arg0Value_, RegexObject.PROP_EXEC))) {
                                return ExecCompiledRegexNode.executeForeign(arg0Value_, arg1Value, arg2Value, s3_.receivers_);
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state & 0b1000) != 0 /* is-active executeForeign(TruffleObject, Object, int, InteropLibrary) */) {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            {
                                InteropLibrary executeForeign1_receivers__ = (INTEROP_LIBRARY_.getUncached(arg0Value_));
                                if ((executeForeign1_receivers__.isMemberInvocable(arg0Value_, RegexObject.PROP_EXEC))) {
                                    return ExecCompiledRegexNode.executeForeign(arg0Value_, arg1Value, arg2Value, executeForeign1_receivers__);
                                }
                            }
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(Object arg0Value, Object arg1Value, int arg2Value) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            int oldState = state;
            int oldExclude = exclude;
            int oldCacheCount = state == 0 ? 0 : countCaches();
            try {
                if (arg0Value instanceof CompiledRegexObject) {
                    CompiledRegexObject arg0Value_ = (CompiledRegexObject) arg0Value;
                    if (((exclude & 0b1)) == 0 /* is-not-excluded executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) */) {
                        int count1_ = 0;
                        ExecuteTRegexFixedData s1_ = this.executeTRegexFixed_cache;
                        if ((state & 0b1) != 0 /* is-active executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) */) {
                            while (s1_ != null) {
                                if ((arg0Value_ == s1_.cachedReceiver_)) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (arg0Value_ == s1_.cachedReceiver_);
                            if (count1_ < (4)) {
                                s1_ = super.insert(new ExecuteTRegexFixedData(executeTRegexFixed_cache));
                                s1_.cachedReceiver_ = (arg0Value_);
                                s1_.directCallNode_ = s1_.insertAccessor((DirectCallNode.create(s1_.cachedReceiver_.getCallTarget())));
                                this.executeTRegexFixed_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return ExecCompiledRegexNode.executeTRegexFixed(arg0Value_, arg1Value, arg2Value, s1_.cachedReceiver_, s1_.directCallNode_);
                        }
                    }
                    this.executeTRegexVarying_indirectCallNode_ = super.insert((IndirectCallNode.create()));
                    this.exclude_ = exclude = exclude | 0b1 /* add-excluded executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) */;
                    this.executeTRegexFixed_cache = null;
                    state = state & 0xfffffffe /* remove-active executeTRegexFixed(CompiledRegexObject, Object, int, CompiledRegexObject, DirectCallNode) */;
                    this.state_ = state = state | 0b10 /* add-active executeTRegexVarying(CompiledRegexObject, Object, int, IndirectCallNode) */;
                    lock.unlock();
                    hasLock = false;
                    return ExecCompiledRegexNode.executeTRegexVarying(arg0Value_, arg1Value, arg2Value, this.executeTRegexVarying_indirectCallNode_);
                }
                if (arg0Value instanceof TruffleObject) {
                    TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                    if (((exclude & 0b10)) == 0 /* is-not-excluded executeForeign(TruffleObject, Object, int, InteropLibrary) */) {
                        int count3_ = 0;
                        ExecuteForeign0Data s3_ = this.executeForeign0_cache;
                        if ((state & 0b100) != 0 /* is-active executeForeign(TruffleObject, Object, int, InteropLibrary) */) {
                            while (s3_ != null) {
                                if ((s3_.receivers_.accepts(arg0Value_)) && (s3_.receivers_.isMemberInvocable(arg0Value_, RegexObject.PROP_EXEC))) {
                                    break;
                                }
                                s3_ = s3_.next_;
                                count3_++;
                            }
                        }
                        if (s3_ == null) {
                            {
                                InteropLibrary receivers__ = super.insert((INTEROP_LIBRARY_.create(arg0Value_)));
                                // assert (s3_.receivers_.accepts(arg0Value_));
                                if ((receivers__.isMemberInvocable(arg0Value_, RegexObject.PROP_EXEC)) && count3_ < (4)) {
                                    s3_ = super.insert(new ExecuteForeign0Data(executeForeign0_cache));
                                    s3_.receivers_ = s3_.insertAccessor(receivers__);
                                    this.executeForeign0_cache = s3_;
                                    this.state_ = state = state | 0b100 /* add-active executeForeign(TruffleObject, Object, int, InteropLibrary) */;
                                }
                            }
                        }
                        if (s3_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return ExecCompiledRegexNode.executeForeign(arg0Value_, arg1Value, arg2Value, s3_.receivers_);
                        }
                    }
                    {
                        InteropLibrary executeForeign1_receivers__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                {
                                    executeForeign1_receivers__ = (INTEROP_LIBRARY_.getUncached(arg0Value_));
                                    if ((executeForeign1_receivers__.isMemberInvocable(arg0Value_, RegexObject.PROP_EXEC))) {
                                        this.exclude_ = exclude = exclude | 0b10 /* add-excluded executeForeign(TruffleObject, Object, int, InteropLibrary) */;
                                        this.executeForeign0_cache = null;
                                        state = state & 0xfffffffb /* remove-active executeForeign(TruffleObject, Object, int, InteropLibrary) */;
                                        this.state_ = state = state | 0b1000 /* add-active executeForeign(TruffleObject, Object, int, InteropLibrary) */;
                                        lock.unlock();
                                        hasLock = false;
                                        return ExecCompiledRegexNode.executeForeign(arg0Value_, arg1Value, arg2Value, executeForeign1_receivers__);
                                    }
                                }
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            } finally {
                if (oldState != 0 || oldExclude != 0) {
                    checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
                }
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        private void checkForPolymorphicSpecialize(int oldState, int oldExclude, int oldCacheCount) {
            int newState = this.state_;
            int newExclude = this.exclude_;
            if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < countCaches()) {
                this.reportPolymorphicSpecialize();
            }
        }

        private int countCaches() {
            int cacheCount = 0;
            ExecuteTRegexFixedData s1_ = this.executeTRegexFixed_cache;
            while (s1_ != null) {
                cacheCount++;
                s1_= s1_.next_;
            }
            ExecuteForeign0Data s3_ = this.executeForeign0_cache;
            while (s3_ != null) {
                cacheCount++;
                s3_= s3_.next_;
            }
            return cacheCount;
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                ExecuteTRegexFixedData s1_ = this.executeTRegexFixed_cache;
                ExecuteForeign0Data s3_ = this.executeForeign0_cache;
                if ((s1_ == null || s1_.next_ == null) && (s3_ == null || s3_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ExecCompiledRegexNode create() {
            return new ExecCompiledRegexNodeGen();
        }

        public static ExecCompiledRegexNode getUncached() {
            return ExecCompiledRegexNodeGen.UNCACHED;
        }

        @GeneratedBy(ExecCompiledRegexNode.class)
        private static final class ExecuteTRegexFixedData extends Node {

            @Child ExecuteTRegexFixedData next_;
            @CompilationFinal CompiledRegexObject cachedReceiver_;
            @Child DirectCallNode directCallNode_;

            ExecuteTRegexFixedData(ExecuteTRegexFixedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ExecCompiledRegexNode.class)
        private static final class ExecuteForeign0Data extends Node {

            @Child ExecuteForeign0Data next_;
            @Child InteropLibrary receivers_;

            ExecuteForeign0Data(ExecuteForeign0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ExecCompiledRegexNode.class)
        private static final class Uncached extends ExecCompiledRegexNode {

            @TruffleBoundary
            @Override
            Object execute(Object arg0Value, Object arg1Value, int arg2Value) throws UnsupportedMessageException, ArityException, UnsupportedTypeException {
                if (arg0Value instanceof CompiledRegexObject) {
                    CompiledRegexObject arg0Value_ = (CompiledRegexObject) arg0Value;
                    return ExecCompiledRegexNode.executeTRegexVarying(arg0Value_, arg1Value, arg2Value, (IndirectCallNode.getUncached()));
                }
                if (arg0Value instanceof TruffleObject) {
                    TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                    if (((INTEROP_LIBRARY_.getUncached(arg0Value_)).isMemberInvocable(arg0Value_, RegexObject.PROP_EXEC))) {
                        return ExecCompiledRegexNode.executeForeign(arg0Value_, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg0Value_)));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
