// CheckStyle: start generated
package com.oracle.truffle.regex.runtime.nodes;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.regex.runtime.nodes.DispatchNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(DispatchNode.class)
public final class DispatchNodeGen extends DispatchNode {

    private static final Uncached UNCACHED = new Uncached();

    @CompilationFinal private volatile int state_;
    @CompilationFinal private volatile int exclude_;
    @Child private ExecuteDirectData executeDirect_cache;
    @Child private IndirectCallNode executeIndirect_callNode_;

    private DispatchNodeGen() {
    }

    @ExplodeLoop
    @Override
    public Object execute(CallTarget arg0Value, Object[] arg1Value) {
        int state = state_;
        if (state != 0 /* is-active executeDirect(CallTarget, Object[], CallTarget, DirectCallNode) || executeIndirect(CallTarget, Object[], IndirectCallNode) */) {
            if ((state & 0b1) != 0 /* is-active executeDirect(CallTarget, Object[], CallTarget, DirectCallNode) */) {
                ExecuteDirectData s1_ = this.executeDirect_cache;
                while (s1_ != null) {
                    if ((arg0Value == s1_.cachedTarget_)) {
                        return DispatchNode.executeDirect(arg0Value, arg1Value, s1_.cachedTarget_, s1_.callNode_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 0b10) != 0 /* is-active executeIndirect(CallTarget, Object[], IndirectCallNode) */) {
                return DispatchNode.executeIndirect(arg0Value, arg1Value, this.executeIndirect_callNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    private Object executeAndSpecialize(CallTarget arg0Value, Object[] arg1Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if ((exclude) == 0 /* is-not-excluded executeDirect(CallTarget, Object[], CallTarget, DirectCallNode) */) {
                int count1_ = 0;
                ExecuteDirectData s1_ = this.executeDirect_cache;
                if ((state & 0b1) != 0 /* is-active executeDirect(CallTarget, Object[], CallTarget, DirectCallNode) */) {
                    while (s1_ != null) {
                        if ((arg0Value == s1_.cachedTarget_)) {
                            break;
                        }
                        s1_ = s1_.next_;
                        count1_++;
                    }
                }
                if (s1_ == null) {
                    // assert (arg0Value == s1_.cachedTarget_);
                    if (count1_ < (3)) {
                        s1_ = super.insert(new ExecuteDirectData(executeDirect_cache));
                        s1_.cachedTarget_ = (arg0Value);
                        s1_.callNode_ = s1_.insertAccessor((DirectCallNode.create(s1_.cachedTarget_)));
                        this.executeDirect_cache = s1_;
                        this.state_ = state = state | 0b1 /* add-active executeDirect(CallTarget, Object[], CallTarget, DirectCallNode) */;
                    }
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return DispatchNode.executeDirect(arg0Value, arg1Value, s1_.cachedTarget_, s1_.callNode_);
                }
            }
            this.executeIndirect_callNode_ = super.insert((IndirectCallNode.create()));
            this.exclude_ = exclude = exclude | 0b1 /* add-excluded executeDirect(CallTarget, Object[], CallTarget, DirectCallNode) */;
            this.executeDirect_cache = null;
            state = state & 0xfffffffe /* remove-active executeDirect(CallTarget, Object[], CallTarget, DirectCallNode) */;
            this.state_ = state = state | 0b10 /* add-active executeIndirect(CallTarget, Object[], IndirectCallNode) */;
            lock.unlock();
            hasLock = false;
            return DispatchNode.executeIndirect(arg0Value, arg1Value, this.executeIndirect_callNode_);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            ExecuteDirectData s1_ = this.executeDirect_cache;
            if ((s1_ == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static DispatchNode create() {
        return new DispatchNodeGen();
    }

    public static DispatchNode getUncached() {
        return DispatchNodeGen.UNCACHED;
    }

    @GeneratedBy(DispatchNode.class)
    private static final class ExecuteDirectData extends Node {

        @Child ExecuteDirectData next_;
        @CompilationFinal CallTarget cachedTarget_;
        @Child DirectCallNode callNode_;

        ExecuteDirectData(ExecuteDirectData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(DispatchNode.class)
    private static final class Uncached extends DispatchNode {

        @TruffleBoundary
        @Override
        public Object execute(CallTarget arg0Value, Object[] arg1Value) {
            return DispatchNode.executeIndirect(arg0Value, arg1Value, (IndirectCallNode.getUncached()));
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
