// CheckStyle: start generated
package com.oracle.truffle.regex.runtime.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.regex.runtime.nodes.StringEqualsNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(StringEqualsNode.class)
public final class StringEqualsNodeGen extends StringEqualsNode {

    private static final Uncached UNCACHED = new Uncached();

    @CompilationFinal private volatile int state_;
    @CompilationFinal private volatile int exclude_;
    @CompilationFinal private CacheIdentityData cacheIdentity_cache;

    private StringEqualsNodeGen() {
    }

    @ExplodeLoop
    @Override
    public boolean execute(String arg0Value, String arg1Value) {
        int state = state_;
        if (state != 0 /* is-active cacheIdentity(String, String, String) || doEquals(String, String) */) {
            if ((state & 0b1) != 0 /* is-active cacheIdentity(String, String, String) */) {
                CacheIdentityData s1_ = this.cacheIdentity_cache;
                while (s1_ != null) {
                    if ((arg0Value == s1_.cachedA_) && (s1_.cachedA_.equals(arg1Value))) {
                        return StringEqualsNode.cacheIdentity(arg0Value, arg1Value, s1_.cachedA_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 0b10) != 0 /* is-active doEquals(String, String) */) {
                return StringEqualsNode.doEquals(arg0Value, arg1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    private boolean executeAndSpecialize(String arg0Value, String arg1Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if ((exclude) == 0 /* is-not-excluded cacheIdentity(String, String, String) */) {
                int count1_ = 0;
                CacheIdentityData s1_ = this.cacheIdentity_cache;
                if ((state & 0b1) != 0 /* is-active cacheIdentity(String, String, String) */) {
                    while (s1_ != null) {
                        if ((arg0Value == s1_.cachedA_) && (s1_.cachedA_.equals(arg1Value))) {
                            break;
                        }
                        s1_ = s1_.next_;
                        count1_++;
                    }
                }
                if (s1_ == null) {
                    {
                        String cachedA__ = (arg0Value);
                        // assert (arg0Value == s1_.cachedA_);
                        if ((cachedA__.equals(arg1Value)) && count1_ < (4)) {
                            s1_ = new CacheIdentityData(cacheIdentity_cache);
                            s1_.cachedA_ = cachedA__;
                            this.cacheIdentity_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active cacheIdentity(String, String, String) */;
                        }
                    }
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return StringEqualsNode.cacheIdentity(arg0Value, arg1Value, s1_.cachedA_);
                }
            }
            this.exclude_ = exclude = exclude | 0b1 /* add-excluded cacheIdentity(String, String, String) */;
            this.cacheIdentity_cache = null;
            state = state & 0xfffffffe /* remove-active cacheIdentity(String, String, String) */;
            this.state_ = state = state | 0b10 /* add-active doEquals(String, String) */;
            lock.unlock();
            hasLock = false;
            return StringEqualsNode.doEquals(arg0Value, arg1Value);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            CacheIdentityData s1_ = this.cacheIdentity_cache;
            if ((s1_ == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static StringEqualsNode create() {
        return new StringEqualsNodeGen();
    }

    public static StringEqualsNode getUncached() {
        return StringEqualsNodeGen.UNCACHED;
    }

    @GeneratedBy(StringEqualsNode.class)
    private static final class CacheIdentityData {

        @CompilationFinal CacheIdentityData next_;
        @CompilationFinal String cachedA_;

        CacheIdentityData(CacheIdentityData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(StringEqualsNode.class)
    private static final class Uncached extends StringEqualsNode {

        @TruffleBoundary
        @Override
        public boolean execute(String arg0Value, String arg1Value) {
            return StringEqualsNode.doEquals(arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
