// CheckStyle: start generated
package com.oracle.truffle.regex.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.regex.util.TruffleReadOnlyMap;
import com.oracle.truffle.regex.util.TruffleReadOnlyMap.IsReadableCacheNode;
import com.oracle.truffle.regex.util.TruffleReadOnlyMap.ReadCacheNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(TruffleReadOnlyMap.class)
public final class TruffleReadOnlyMapFactory {

    @GeneratedBy(IsReadableCacheNode.class)
    static final class IsReadableCacheNodeGen extends IsReadableCacheNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_;
        @CompilationFinal private volatile int exclude_;
        @CompilationFinal private CacheIdentityData cacheIdentity_cache;
        @CompilationFinal private CacheEqualsData cacheEquals_cache;

        private IsReadableCacheNodeGen() {
        }

        @ExplodeLoop
        @Override
        boolean execute(TruffleReadOnlyMap arg0Value, String arg1Value) {
            int state = state_;
            if (state != 0 /* is-active cacheIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean) || cacheEquals(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean) || isReadable(TruffleReadOnlyMap, String) */) {
                if ((state & 0b1) != 0 /* is-active cacheIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean) */) {
                    CacheIdentityData s1_ = this.cacheIdentity_cache;
                    while (s1_ != null) {
                        if ((arg0Value == s1_.cachedReceiver_) && (arg1Value == s1_.cachedSymbol_)) {
                            assert (s1_.result_);
                            return IsReadableCacheNode.cacheIdentity(arg0Value, arg1Value, s1_.cachedReceiver_, s1_.cachedSymbol_, s1_.result_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active cacheEquals(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean) */) {
                    CacheEqualsData s2_ = this.cacheEquals_cache;
                    while (s2_ != null) {
                        if ((arg0Value == s2_.cachedReceiver_) && (arg1Value.equals(s2_.cachedSymbol_))) {
                            assert (s2_.result_);
                            return IsReadableCacheNode.cacheEquals(arg0Value, arg1Value, s2_.cachedReceiver_, s2_.cachedSymbol_, s2_.result_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active isReadable(TruffleReadOnlyMap, String) */) {
                    return IsReadableCacheNode.isReadable(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(TruffleReadOnlyMap arg0Value, String arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if (((exclude & 0b1)) == 0 /* is-not-excluded cacheIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean) */) {
                    int count1_ = 0;
                    CacheIdentityData s1_ = this.cacheIdentity_cache;
                    if ((state & 0b1) != 0 /* is-active cacheIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean) */) {
                        while (s1_ != null) {
                            if ((arg0Value == s1_.cachedReceiver_) && (arg1Value == s1_.cachedSymbol_)) {
                                assert (s1_.result_);
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        {
                            TruffleReadOnlyMap cachedReceiver__ = (arg0Value);
                            String cachedSymbol__ = (arg1Value);
                            boolean result__ = (IsReadableCacheNode.isReadable(cachedReceiver__, cachedSymbol__));
                            // assert (arg0Value == s1_.cachedReceiver_);
                            // assert (arg1Value == s1_.cachedSymbol_);
                            if ((result__) && count1_ < (6)) {
                                s1_ = new CacheIdentityData(cacheIdentity_cache);
                                s1_.cachedReceiver_ = cachedReceiver__;
                                s1_.cachedSymbol_ = cachedSymbol__;
                                s1_.result_ = result__;
                                this.cacheIdentity_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active cacheIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean) */;
                            }
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return IsReadableCacheNode.cacheIdentity(arg0Value, arg1Value, s1_.cachedReceiver_, s1_.cachedSymbol_, s1_.result_);
                    }
                }
                if (((exclude & 0b10)) == 0 /* is-not-excluded cacheEquals(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean) */) {
                    int count2_ = 0;
                    CacheEqualsData s2_ = this.cacheEquals_cache;
                    if ((state & 0b10) != 0 /* is-active cacheEquals(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean) */) {
                        while (s2_ != null) {
                            if ((arg0Value == s2_.cachedReceiver_) && (arg1Value.equals(s2_.cachedSymbol_))) {
                                assert (s2_.result_);
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        {
                            TruffleReadOnlyMap cachedReceiver__1 = (arg0Value);
                            String cachedSymbol__1 = (arg1Value);
                            boolean result__1 = (IsReadableCacheNode.isReadable(cachedReceiver__1, cachedSymbol__1));
                            // assert (arg0Value == s2_.cachedReceiver_);
                            // assert (arg1Value.equals(s2_.cachedSymbol_));
                            if ((result__1) && count2_ < (6)) {
                                s2_ = new CacheEqualsData(cacheEquals_cache);
                                s2_.cachedReceiver_ = cachedReceiver__1;
                                s2_.cachedSymbol_ = cachedSymbol__1;
                                s2_.result_ = result__1;
                                this.cacheEquals_cache = s2_;
                                this.exclude_ = exclude = exclude | 0b1 /* add-excluded cacheIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean) */;
                                this.cacheIdentity_cache = null;
                                state = state & 0xfffffffe /* remove-active cacheIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean) */;
                                this.state_ = state = state | 0b10 /* add-active cacheEquals(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean) */;
                            }
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return IsReadableCacheNode.cacheEquals(arg0Value, arg1Value, s2_.cachedReceiver_, s2_.cachedSymbol_, s2_.result_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b11 /* add-excluded cacheIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean), cacheEquals(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean) */;
                this.cacheIdentity_cache = null;
                this.cacheEquals_cache = null;
                state = state & 0xfffffffc /* remove-active cacheIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean), cacheEquals(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, boolean) */;
                this.state_ = state = state | 0b100 /* add-active isReadable(TruffleReadOnlyMap, String) */;
                lock.unlock();
                hasLock = false;
                return IsReadableCacheNode.isReadable(arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CacheIdentityData s1_ = this.cacheIdentity_cache;
                CacheEqualsData s2_ = this.cacheEquals_cache;
                if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static IsReadableCacheNode create() {
            return new IsReadableCacheNodeGen();
        }

        public static IsReadableCacheNode getUncached() {
            return IsReadableCacheNodeGen.UNCACHED;
        }

        @GeneratedBy(IsReadableCacheNode.class)
        private static final class CacheIdentityData {

            @CompilationFinal CacheIdentityData next_;
            @CompilationFinal TruffleReadOnlyMap cachedReceiver_;
            @CompilationFinal String cachedSymbol_;
            @CompilationFinal boolean result_;

            CacheIdentityData(CacheIdentityData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(IsReadableCacheNode.class)
        private static final class CacheEqualsData {

            @CompilationFinal CacheEqualsData next_;
            @CompilationFinal TruffleReadOnlyMap cachedReceiver_;
            @CompilationFinal String cachedSymbol_;
            @CompilationFinal boolean result_;

            CacheEqualsData(CacheEqualsData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(IsReadableCacheNode.class)
        private static final class Uncached extends IsReadableCacheNode {

            @TruffleBoundary
            @Override
            boolean execute(TruffleReadOnlyMap arg0Value, String arg1Value) {
                return IsReadableCacheNode.isReadable(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ReadCacheNode.class)
    static final class ReadCacheNodeGen extends ReadCacheNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_;
        @CompilationFinal private volatile int exclude_;
        @CompilationFinal private ReadIdentityData readIdentity_cache;
        @CompilationFinal private ReadEqualsData readEquals_cache;

        private ReadCacheNodeGen() {
        }

        @ExplodeLoop
        @Override
        Object execute(TruffleReadOnlyMap arg0Value, String arg1Value) throws UnknownIdentifierException {
            int state = state_;
            if (state != 0 /* is-active readIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object) || readEquals(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object) || read(TruffleReadOnlyMap, String) */) {
                if ((state & 0b1) != 0 /* is-active readIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object) */) {
                    ReadIdentityData s1_ = this.readIdentity_cache;
                    while (s1_ != null) {
                        if ((arg0Value == s1_.cachedReceiver_) && (arg1Value == s1_.cachedSymbol_)) {
                            assert (s1_.result_ != null);
                            return ReadCacheNode.readIdentity(arg0Value, arg1Value, s1_.cachedReceiver_, s1_.cachedSymbol_, s1_.result_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active readEquals(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object) */) {
                    ReadEqualsData s2_ = this.readEquals_cache;
                    while (s2_ != null) {
                        if ((arg0Value == s2_.cachedReceiver_) && (arg1Value.equals(s2_.cachedSymbol_))) {
                            assert (s2_.result_ != null);
                            return ReadCacheNode.readEquals(arg0Value, arg1Value, s2_.cachedReceiver_, s2_.cachedSymbol_, s2_.result_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active read(TruffleReadOnlyMap, String) */) {
                    return ReadCacheNode.read(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(TruffleReadOnlyMap arg0Value, String arg1Value) throws UnknownIdentifierException {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if (((exclude & 0b1)) == 0 /* is-not-excluded readIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object) */) {
                    int count1_ = 0;
                    ReadIdentityData s1_ = this.readIdentity_cache;
                    if ((state & 0b1) != 0 /* is-active readIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object) */) {
                        while (s1_ != null) {
                            if ((arg0Value == s1_.cachedReceiver_) && (arg1Value == s1_.cachedSymbol_)) {
                                assert (s1_.result_ != null);
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        {
                            TruffleReadOnlyMap cachedReceiver__ = (arg0Value);
                            String cachedSymbol__ = (arg1Value);
                            Object result__ = (ReadCacheNode.readDirect(cachedReceiver__, cachedSymbol__));
                            // assert (arg0Value == s1_.cachedReceiver_);
                            // assert (arg1Value == s1_.cachedSymbol_);
                            if ((result__ != null) && count1_ < (6)) {
                                s1_ = new ReadIdentityData(readIdentity_cache);
                                s1_.cachedReceiver_ = cachedReceiver__;
                                s1_.cachedSymbol_ = cachedSymbol__;
                                s1_.result_ = result__;
                                this.readIdentity_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active readIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object) */;
                            }
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return ReadCacheNode.readIdentity(arg0Value, arg1Value, s1_.cachedReceiver_, s1_.cachedSymbol_, s1_.result_);
                    }
                }
                if (((exclude & 0b10)) == 0 /* is-not-excluded readEquals(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object) */) {
                    int count2_ = 0;
                    ReadEqualsData s2_ = this.readEquals_cache;
                    if ((state & 0b10) != 0 /* is-active readEquals(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object) */) {
                        while (s2_ != null) {
                            if ((arg0Value == s2_.cachedReceiver_) && (arg1Value.equals(s2_.cachedSymbol_))) {
                                assert (s2_.result_ != null);
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        {
                            TruffleReadOnlyMap cachedReceiver__1 = (arg0Value);
                            String cachedSymbol__1 = (arg1Value);
                            Object result__1 = (ReadCacheNode.readDirect(cachedReceiver__1, cachedSymbol__1));
                            // assert (arg0Value == s2_.cachedReceiver_);
                            // assert (arg1Value.equals(s2_.cachedSymbol_));
                            if ((result__1 != null) && count2_ < (6)) {
                                s2_ = new ReadEqualsData(readEquals_cache);
                                s2_.cachedReceiver_ = cachedReceiver__1;
                                s2_.cachedSymbol_ = cachedSymbol__1;
                                s2_.result_ = result__1;
                                this.readEquals_cache = s2_;
                                this.exclude_ = exclude = exclude | 0b1 /* add-excluded readIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object) */;
                                this.readIdentity_cache = null;
                                state = state & 0xfffffffe /* remove-active readIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object) */;
                                this.state_ = state = state | 0b10 /* add-active readEquals(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object) */;
                            }
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return ReadCacheNode.readEquals(arg0Value, arg1Value, s2_.cachedReceiver_, s2_.cachedSymbol_, s2_.result_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b11 /* add-excluded readIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object), readEquals(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object) */;
                this.readIdentity_cache = null;
                this.readEquals_cache = null;
                state = state & 0xfffffffc /* remove-active readIdentity(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object), readEquals(TruffleReadOnlyMap, String, TruffleReadOnlyMap, String, Object) */;
                this.state_ = state = state | 0b100 /* add-active read(TruffleReadOnlyMap, String) */;
                lock.unlock();
                hasLock = false;
                return ReadCacheNode.read(arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                ReadIdentityData s1_ = this.readIdentity_cache;
                ReadEqualsData s2_ = this.readEquals_cache;
                if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ReadCacheNode create() {
            return new ReadCacheNodeGen();
        }

        public static ReadCacheNode getUncached() {
            return ReadCacheNodeGen.UNCACHED;
        }

        @GeneratedBy(ReadCacheNode.class)
        private static final class ReadIdentityData {

            @CompilationFinal ReadIdentityData next_;
            @CompilationFinal TruffleReadOnlyMap cachedReceiver_;
            @CompilationFinal String cachedSymbol_;
            @CompilationFinal Object result_;

            ReadIdentityData(ReadIdentityData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ReadCacheNode.class)
        private static final class ReadEqualsData {

            @CompilationFinal ReadEqualsData next_;
            @CompilationFinal TruffleReadOnlyMap cachedReceiver_;
            @CompilationFinal String cachedSymbol_;
            @CompilationFinal Object result_;

            ReadEqualsData(ReadEqualsData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ReadCacheNode.class)
        private static final class Uncached extends ReadCacheNode {

            @TruffleBoundary
            @Override
            Object execute(TruffleReadOnlyMap arg0Value, String arg1Value) throws UnknownIdentifierException {
                return ReadCacheNode.read(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
