// CheckStyle: start generated
package com.oracle.truffle.regex.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.util.TruffleReadOnlyMap;
import com.oracle.truffle.regex.util.TruffleReadOnlyMap.IsReadableCacheNode;
import com.oracle.truffle.regex.util.TruffleReadOnlyMap.ReadCacheNode;
import com.oracle.truffle.regex.util.TruffleReadOnlyMapFactory.IsReadableCacheNodeGen;
import com.oracle.truffle.regex.util.TruffleReadOnlyMapFactory.ReadCacheNodeGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(TruffleReadOnlyMap.class)
final class TruffleReadOnlyMapGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(TruffleReadOnlyMap.class, new InteropLibraryExports());
    }

    private TruffleReadOnlyMapGen() {
    }

    @GeneratedBy(TruffleReadOnlyMap.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, TruffleReadOnlyMap.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof TruffleReadOnlyMap;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof TruffleReadOnlyMap;
            return new Cached(receiver);
        }

        @GeneratedBy(TruffleReadOnlyMap.class)
        private static final class Cached extends InteropLibrary {

            private final Class<? extends TruffleReadOnlyMap> receiverClass_;
            @CompilationFinal private volatile int state_;
            @CompilationFinal private ValueProfile receiverProfile;
            @Child private IsReadableCacheNode isMemberReadableNode__cache_;
            @Child private ReadCacheNode readMemberNode__readCache_;

            Cached(Object originalReceiver) {
                TruffleReadOnlyMap receiver = ((TruffleReadOnlyMap) originalReceiver) ;
                this.receiverClass_ = receiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).getLanguage();
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).toDisplayString(allowSideEffects);
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (CompilerDirectives.castExact(receiver, receiverClass_)).getMembers(includeInternal);
            }

            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                TruffleReadOnlyMap arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b1) != 0 /* is-active isMemberReadable(TruffleReadOnlyMap, String, IsReadableCacheNode, ValueProfile) */) {
                    return arg0Value.isMemberReadable(arg1Value, this.isMemberReadableNode__cache_, this.receiverProfile);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableNode_AndSpecialize(TruffleReadOnlyMap arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    this.isMemberReadableNode__cache_ = super.insert((IsReadableCacheNodeGen.create()));
                    if (this.receiverProfile == null) {
                        this.receiverProfile = (ValueProfile.createIdentityProfile());
                    }
                    this.state_ = state = state | 0b1 /* add-active isMemberReadable(TruffleReadOnlyMap, String, IsReadableCacheNode, ValueProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.isMemberReadable(arg1Value, this.isMemberReadableNode__cache_, this.receiverProfile);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b1) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                TruffleReadOnlyMap arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b10) != 0 /* is-active readMember(TruffleReadOnlyMap, String, ReadCacheNode, ValueProfile) */) {
                    return arg0Value.readMember(arg1Value, this.readMemberNode__readCache_, this.receiverProfile);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(TruffleReadOnlyMap arg0Value, String arg1Value) throws UnknownIdentifierException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    this.readMemberNode__readCache_ = super.insert((ReadCacheNodeGen.create()));
                    if (this.receiverProfile == null) {
                        this.receiverProfile = (ValueProfile.createIdentityProfile());
                    }
                    this.state_ = state = state | 0b10 /* add-active readMember(TruffleReadOnlyMap, String, ReadCacheNode, ValueProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.readMember(arg1Value, this.readMemberNode__readCache_, this.receiverProfile);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

        }
        @GeneratedBy(TruffleReadOnlyMap.class)
        private static final class Uncached extends InteropLibrary {

            private final Class<? extends TruffleReadOnlyMap> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((TruffleReadOnlyMap) receiver).getClass();
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractRegexObject) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractRegexObject) receiver) .getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractRegexObject) receiver) .toDisplayString(allowSideEffects);
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((TruffleReadOnlyMap) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((TruffleReadOnlyMap) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleReadOnlyMap arg0Value = ((TruffleReadOnlyMap) arg0Value_);
                return arg0Value.isMemberReadable(arg1Value, (IsReadableCacheNodeGen.getUncached()), (ValueProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                TruffleReadOnlyMap arg0Value = ((TruffleReadOnlyMap) arg0Value_);
                return arg0Value.readMember(arg1Value, (ReadCacheNodeGen.getUncached()), (ValueProfile.getUncached()));
            }

        }
    }
}
