/*
 * Copyright (c) 2021, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The Universal Permissive License (UPL), Version 1.0
 *
 * Subject to the condition set forth below, permission is hereby granted to any
 * person obtaining a copy of this software, associated documentation and/or
 * data (collectively the "Software"), free of charge and under any and all
 * copyright rights in the Software, and any and all patent rights owned or
 * freely licensable by each licensor hereunder covering either (i) the
 * unmodified Software as contributed to or provided by such licensor, or (ii)
 * the Larger Works (as defined below), to deal in both
 *
 * (a) the Software, and
 *
 * (b) any piece of software and/or hardware listed in the lrgrwrks.txt file if
 * one is included with the Software each a "Larger Work" to which the Software
 * is contributed by such licensors),
 *
 * without restriction, including without limitation the rights to copy, create
 * derivative works of, display, perform, and distribute the Software and make,
 * use, sell, offer for sale, import, export, have made, and have sold the
 * Software and the Larger Work(s), and to sublicense the foregoing rights on
 * either these or other terms.
 *
 * This license is subject to the following condition:
 *
 * The above copyright notice and either this complete permission notice or at a
 * minimum a reference to the UPL must be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import java.util.SortedMap;
import java.util.TreeMap;

public class RubyCaseFoldingData {

    public static final SortedMap<Integer, int[]> CASE_FOLD;

    static {
        CASE_FOLD = new TreeMap<>();

        CASE_FOLD.put(0x0041, new int[]{0x0061});
        CASE_FOLD.put(0x0042, new int[]{0x0062});
        CASE_FOLD.put(0x0043, new int[]{0x0063});
        CASE_FOLD.put(0x0044, new int[]{0x0064});
        CASE_FOLD.put(0x0045, new int[]{0x0065});
        CASE_FOLD.put(0x0046, new int[]{0x0066});
        CASE_FOLD.put(0x0047, new int[]{0x0067});
        CASE_FOLD.put(0x0048, new int[]{0x0068});
        CASE_FOLD.put(0x0049, new int[]{0x0069});
        CASE_FOLD.put(0x004A, new int[]{0x006A});
        CASE_FOLD.put(0x004B, new int[]{0x006B});
        CASE_FOLD.put(0x004C, new int[]{0x006C});
        CASE_FOLD.put(0x004D, new int[]{0x006D});
        CASE_FOLD.put(0x004E, new int[]{0x006E});
        CASE_FOLD.put(0x004F, new int[]{0x006F});
        CASE_FOLD.put(0x0050, new int[]{0x0070});
        CASE_FOLD.put(0x0051, new int[]{0x0071});
        CASE_FOLD.put(0x0052, new int[]{0x0072});
        CASE_FOLD.put(0x0053, new int[]{0x0073});
        CASE_FOLD.put(0x0054, new int[]{0x0074});
        CASE_FOLD.put(0x0055, new int[]{0x0075});
        CASE_FOLD.put(0x0056, new int[]{0x0076});
        CASE_FOLD.put(0x0057, new int[]{0x0077});
        CASE_FOLD.put(0x0058, new int[]{0x0078});
        CASE_FOLD.put(0x0059, new int[]{0x0079});
        CASE_FOLD.put(0x005A, new int[]{0x007A});
        CASE_FOLD.put(0x00B5, new int[]{0x03BC});
        CASE_FOLD.put(0x00C0, new int[]{0x00E0});
        CASE_FOLD.put(0x00C1, new int[]{0x00E1});
        CASE_FOLD.put(0x00C2, new int[]{0x00E2});
        CASE_FOLD.put(0x00C3, new int[]{0x00E3});
        CASE_FOLD.put(0x00C4, new int[]{0x00E4});
        CASE_FOLD.put(0x00C5, new int[]{0x00E5});
        CASE_FOLD.put(0x00C6, new int[]{0x00E6});
        CASE_FOLD.put(0x00C7, new int[]{0x00E7});
        CASE_FOLD.put(0x00C8, new int[]{0x00E8});
        CASE_FOLD.put(0x00C9, new int[]{0x00E9});
        CASE_FOLD.put(0x00CA, new int[]{0x00EA});
        CASE_FOLD.put(0x00CB, new int[]{0x00EB});
        CASE_FOLD.put(0x00CC, new int[]{0x00EC});
        CASE_FOLD.put(0x00CD, new int[]{0x00ED});
        CASE_FOLD.put(0x00CE, new int[]{0x00EE});
        CASE_FOLD.put(0x00CF, new int[]{0x00EF});
        CASE_FOLD.put(0x00D0, new int[]{0x00F0});
        CASE_FOLD.put(0x00D1, new int[]{0x00F1});
        CASE_FOLD.put(0x00D2, new int[]{0x00F2});
        CASE_FOLD.put(0x00D3, new int[]{0x00F3});
        CASE_FOLD.put(0x00D4, new int[]{0x00F4});
        CASE_FOLD.put(0x00D5, new int[]{0x00F5});
        CASE_FOLD.put(0x00D6, new int[]{0x00F6});
        CASE_FOLD.put(0x00D8, new int[]{0x00F8});
        CASE_FOLD.put(0x00D9, new int[]{0x00F9});
        CASE_FOLD.put(0x00DA, new int[]{0x00FA});
        CASE_FOLD.put(0x00DB, new int[]{0x00FB});
        CASE_FOLD.put(0x00DC, new int[]{0x00FC});
        CASE_FOLD.put(0x00DD, new int[]{0x00FD});
        CASE_FOLD.put(0x00DE, new int[]{0x00FE});
        CASE_FOLD.put(0x00DF, new int[]{0x0073, 0x0073});
        CASE_FOLD.put(0x0100, new int[]{0x0101});
        CASE_FOLD.put(0x0102, new int[]{0x0103});
        CASE_FOLD.put(0x0104, new int[]{0x0105});
        CASE_FOLD.put(0x0106, new int[]{0x0107});
        CASE_FOLD.put(0x0108, new int[]{0x0109});
        CASE_FOLD.put(0x010A, new int[]{0x010B});
        CASE_FOLD.put(0x010C, new int[]{0x010D});
        CASE_FOLD.put(0x010E, new int[]{0x010F});
        CASE_FOLD.put(0x0110, new int[]{0x0111});
        CASE_FOLD.put(0x0112, new int[]{0x0113});
        CASE_FOLD.put(0x0114, new int[]{0x0115});
        CASE_FOLD.put(0x0116, new int[]{0x0117});
        CASE_FOLD.put(0x0118, new int[]{0x0119});
        CASE_FOLD.put(0x011A, new int[]{0x011B});
        CASE_FOLD.put(0x011C, new int[]{0x011D});
        CASE_FOLD.put(0x011E, new int[]{0x011F});
        CASE_FOLD.put(0x0120, new int[]{0x0121});
        CASE_FOLD.put(0x0122, new int[]{0x0123});
        CASE_FOLD.put(0x0124, new int[]{0x0125});
        CASE_FOLD.put(0x0126, new int[]{0x0127});
        CASE_FOLD.put(0x0128, new int[]{0x0129});
        CASE_FOLD.put(0x012A, new int[]{0x012B});
        CASE_FOLD.put(0x012C, new int[]{0x012D});
        CASE_FOLD.put(0x012E, new int[]{0x012F});
        CASE_FOLD.put(0x0130, new int[]{0x0069, 0x0307});
        CASE_FOLD.put(0x0132, new int[]{0x0133});
        CASE_FOLD.put(0x0134, new int[]{0x0135});
        CASE_FOLD.put(0x0136, new int[]{0x0137});
        CASE_FOLD.put(0x0139, new int[]{0x013A});
        CASE_FOLD.put(0x013B, new int[]{0x013C});
        CASE_FOLD.put(0x013D, new int[]{0x013E});
        CASE_FOLD.put(0x013F, new int[]{0x0140});
        CASE_FOLD.put(0x0141, new int[]{0x0142});
        CASE_FOLD.put(0x0143, new int[]{0x0144});
        CASE_FOLD.put(0x0145, new int[]{0x0146});
        CASE_FOLD.put(0x0147, new int[]{0x0148});
        CASE_FOLD.put(0x0149, new int[]{0x02BC, 0x006E});
        CASE_FOLD.put(0x014A, new int[]{0x014B});
        CASE_FOLD.put(0x014C, new int[]{0x014D});
        CASE_FOLD.put(0x014E, new int[]{0x014F});
        CASE_FOLD.put(0x0150, new int[]{0x0151});
        CASE_FOLD.put(0x0152, new int[]{0x0153});
        CASE_FOLD.put(0x0154, new int[]{0x0155});
        CASE_FOLD.put(0x0156, new int[]{0x0157});
        CASE_FOLD.put(0x0158, new int[]{0x0159});
        CASE_FOLD.put(0x015A, new int[]{0x015B});
        CASE_FOLD.put(0x015C, new int[]{0x015D});
        CASE_FOLD.put(0x015E, new int[]{0x015F});
        CASE_FOLD.put(0x0160, new int[]{0x0161});
        CASE_FOLD.put(0x0162, new int[]{0x0163});
        CASE_FOLD.put(0x0164, new int[]{0x0165});
        CASE_FOLD.put(0x0166, new int[]{0x0167});
        CASE_FOLD.put(0x0168, new int[]{0x0169});
        CASE_FOLD.put(0x016A, new int[]{0x016B});
        CASE_FOLD.put(0x016C, new int[]{0x016D});
        CASE_FOLD.put(0x016E, new int[]{0x016F});
        CASE_FOLD.put(0x0170, new int[]{0x0171});
        CASE_FOLD.put(0x0172, new int[]{0x0173});
        CASE_FOLD.put(0x0174, new int[]{0x0175});
        CASE_FOLD.put(0x0176, new int[]{0x0177});
        CASE_FOLD.put(0x0178, new int[]{0x00FF});
        CASE_FOLD.put(0x0179, new int[]{0x017A});
        CASE_FOLD.put(0x017B, new int[]{0x017C});
        CASE_FOLD.put(0x017D, new int[]{0x017E});
        CASE_FOLD.put(0x017F, new int[]{0x0073});
        CASE_FOLD.put(0x0181, new int[]{0x0253});
        CASE_FOLD.put(0x0182, new int[]{0x0183});
        CASE_FOLD.put(0x0184, new int[]{0x0185});
        CASE_FOLD.put(0x0186, new int[]{0x0254});
        CASE_FOLD.put(0x0187, new int[]{0x0188});
        CASE_FOLD.put(0x0189, new int[]{0x0256});
        CASE_FOLD.put(0x018A, new int[]{0x0257});
        CASE_FOLD.put(0x018B, new int[]{0x018C});
        CASE_FOLD.put(0x018E, new int[]{0x01DD});
        CASE_FOLD.put(0x018F, new int[]{0x0259});
        CASE_FOLD.put(0x0190, new int[]{0x025B});
        CASE_FOLD.put(0x0191, new int[]{0x0192});
        CASE_FOLD.put(0x0193, new int[]{0x0260});
        CASE_FOLD.put(0x0194, new int[]{0x0263});
        CASE_FOLD.put(0x0196, new int[]{0x0269});
        CASE_FOLD.put(0x0197, new int[]{0x0268});
        CASE_FOLD.put(0x0198, new int[]{0x0199});
        CASE_FOLD.put(0x019C, new int[]{0x026F});
        CASE_FOLD.put(0x019D, new int[]{0x0272});
        CASE_FOLD.put(0x019F, new int[]{0x0275});
        CASE_FOLD.put(0x01A0, new int[]{0x01A1});
        CASE_FOLD.put(0x01A2, new int[]{0x01A3});
        CASE_FOLD.put(0x01A4, new int[]{0x01A5});
        CASE_FOLD.put(0x01A6, new int[]{0x0280});
        CASE_FOLD.put(0x01A7, new int[]{0x01A8});
        CASE_FOLD.put(0x01A9, new int[]{0x0283});
        CASE_FOLD.put(0x01AC, new int[]{0x01AD});
        CASE_FOLD.put(0x01AE, new int[]{0x0288});
        CASE_FOLD.put(0x01AF, new int[]{0x01B0});
        CASE_FOLD.put(0x01B1, new int[]{0x028A});
        CASE_FOLD.put(0x01B2, new int[]{0x028B});
        CASE_FOLD.put(0x01B3, new int[]{0x01B4});
        CASE_FOLD.put(0x01B5, new int[]{0x01B6});
        CASE_FOLD.put(0x01B7, new int[]{0x0292});
        CASE_FOLD.put(0x01B8, new int[]{0x01B9});
        CASE_FOLD.put(0x01BC, new int[]{0x01BD});
        CASE_FOLD.put(0x01C4, new int[]{0x01C6});
        CASE_FOLD.put(0x01C5, new int[]{0x01C6});
        CASE_FOLD.put(0x01C7, new int[]{0x01C9});
        CASE_FOLD.put(0x01C8, new int[]{0x01C9});
        CASE_FOLD.put(0x01CA, new int[]{0x01CC});
        CASE_FOLD.put(0x01CB, new int[]{0x01CC});
        CASE_FOLD.put(0x01CD, new int[]{0x01CE});
        CASE_FOLD.put(0x01CF, new int[]{0x01D0});
        CASE_FOLD.put(0x01D1, new int[]{0x01D2});
        CASE_FOLD.put(0x01D3, new int[]{0x01D4});
        CASE_FOLD.put(0x01D5, new int[]{0x01D6});
        CASE_FOLD.put(0x01D7, new int[]{0x01D8});
        CASE_FOLD.put(0x01D9, new int[]{0x01DA});
        CASE_FOLD.put(0x01DB, new int[]{0x01DC});
        CASE_FOLD.put(0x01DE, new int[]{0x01DF});
        CASE_FOLD.put(0x01E0, new int[]{0x01E1});
        CASE_FOLD.put(0x01E2, new int[]{0x01E3});
        CASE_FOLD.put(0x01E4, new int[]{0x01E5});
        CASE_FOLD.put(0x01E6, new int[]{0x01E7});
        CASE_FOLD.put(0x01E8, new int[]{0x01E9});
        CASE_FOLD.put(0x01EA, new int[]{0x01EB});
        CASE_FOLD.put(0x01EC, new int[]{0x01ED});
        CASE_FOLD.put(0x01EE, new int[]{0x01EF});
        CASE_FOLD.put(0x01F0, new int[]{0x006A, 0x030C});
        CASE_FOLD.put(0x01F1, new int[]{0x01F3});
        CASE_FOLD.put(0x01F2, new int[]{0x01F3});
        CASE_FOLD.put(0x01F4, new int[]{0x01F5});
        CASE_FOLD.put(0x01F6, new int[]{0x0195});
        CASE_FOLD.put(0x01F7, new int[]{0x01BF});
        CASE_FOLD.put(0x01F8, new int[]{0x01F9});
        CASE_FOLD.put(0x01FA, new int[]{0x01FB});
        CASE_FOLD.put(0x01FC, new int[]{0x01FD});
        CASE_FOLD.put(0x01FE, new int[]{0x01FF});
        CASE_FOLD.put(0x0200, new int[]{0x0201});
        CASE_FOLD.put(0x0202, new int[]{0x0203});
        CASE_FOLD.put(0x0204, new int[]{0x0205});
        CASE_FOLD.put(0x0206, new int[]{0x0207});
        CASE_FOLD.put(0x0208, new int[]{0x0209});
        CASE_FOLD.put(0x020A, new int[]{0x020B});
        CASE_FOLD.put(0x020C, new int[]{0x020D});
        CASE_FOLD.put(0x020E, new int[]{0x020F});
        CASE_FOLD.put(0x0210, new int[]{0x0211});
        CASE_FOLD.put(0x0212, new int[]{0x0213});
        CASE_FOLD.put(0x0214, new int[]{0x0215});
        CASE_FOLD.put(0x0216, new int[]{0x0217});
        CASE_FOLD.put(0x0218, new int[]{0x0219});
        CASE_FOLD.put(0x021A, new int[]{0x021B});
        CASE_FOLD.put(0x021C, new int[]{0x021D});
        CASE_FOLD.put(0x021E, new int[]{0x021F});
        CASE_FOLD.put(0x0220, new int[]{0x019E});
        CASE_FOLD.put(0x0222, new int[]{0x0223});
        CASE_FOLD.put(0x0224, new int[]{0x0225});
        CASE_FOLD.put(0x0226, new int[]{0x0227});
        CASE_FOLD.put(0x0228, new int[]{0x0229});
        CASE_FOLD.put(0x022A, new int[]{0x022B});
        CASE_FOLD.put(0x022C, new int[]{0x022D});
        CASE_FOLD.put(0x022E, new int[]{0x022F});
        CASE_FOLD.put(0x0230, new int[]{0x0231});
        CASE_FOLD.put(0x0232, new int[]{0x0233});
        CASE_FOLD.put(0x023A, new int[]{0x2C65});
        CASE_FOLD.put(0x023B, new int[]{0x023C});
        CASE_FOLD.put(0x023D, new int[]{0x019A});
        CASE_FOLD.put(0x023E, new int[]{0x2C66});
        CASE_FOLD.put(0x0241, new int[]{0x0242});
        CASE_FOLD.put(0x0243, new int[]{0x0180});
        CASE_FOLD.put(0x0244, new int[]{0x0289});
        CASE_FOLD.put(0x0245, new int[]{0x028C});
        CASE_FOLD.put(0x0246, new int[]{0x0247});
        CASE_FOLD.put(0x0248, new int[]{0x0249});
        CASE_FOLD.put(0x024A, new int[]{0x024B});
        CASE_FOLD.put(0x024C, new int[]{0x024D});
        CASE_FOLD.put(0x024E, new int[]{0x024F});
        CASE_FOLD.put(0x0345, new int[]{0x03B9});
        CASE_FOLD.put(0x0370, new int[]{0x0371});
        CASE_FOLD.put(0x0372, new int[]{0x0373});
        CASE_FOLD.put(0x0376, new int[]{0x0377});
        CASE_FOLD.put(0x037F, new int[]{0x03F3});
        CASE_FOLD.put(0x0386, new int[]{0x03AC});
        CASE_FOLD.put(0x0388, new int[]{0x03AD});
        CASE_FOLD.put(0x0389, new int[]{0x03AE});
        CASE_FOLD.put(0x038A, new int[]{0x03AF});
        CASE_FOLD.put(0x038C, new int[]{0x03CC});
        CASE_FOLD.put(0x038E, new int[]{0x03CD});
        CASE_FOLD.put(0x038F, new int[]{0x03CE});
        CASE_FOLD.put(0x0390, new int[]{0x03B9, 0x0308, 0x0301});
        CASE_FOLD.put(0x0391, new int[]{0x03B1});
        CASE_FOLD.put(0x0392, new int[]{0x03B2});
        CASE_FOLD.put(0x0393, new int[]{0x03B3});
        CASE_FOLD.put(0x0394, new int[]{0x03B4});
        CASE_FOLD.put(0x0395, new int[]{0x03B5});
        CASE_FOLD.put(0x0396, new int[]{0x03B6});
        CASE_FOLD.put(0x0397, new int[]{0x03B7});
        CASE_FOLD.put(0x0398, new int[]{0x03B8});
        CASE_FOLD.put(0x0399, new int[]{0x03B9});
        CASE_FOLD.put(0x039A, new int[]{0x03BA});
        CASE_FOLD.put(0x039B, new int[]{0x03BB});
        CASE_FOLD.put(0x039C, new int[]{0x03BC});
        CASE_FOLD.put(0x039D, new int[]{0x03BD});
        CASE_FOLD.put(0x039E, new int[]{0x03BE});
        CASE_FOLD.put(0x039F, new int[]{0x03BF});
        CASE_FOLD.put(0x03A0, new int[]{0x03C0});
        CASE_FOLD.put(0x03A1, new int[]{0x03C1});
        CASE_FOLD.put(0x03A3, new int[]{0x03C3});
        CASE_FOLD.put(0x03A4, new int[]{0x03C4});
        CASE_FOLD.put(0x03A5, new int[]{0x03C5});
        CASE_FOLD.put(0x03A6, new int[]{0x03C6});
        CASE_FOLD.put(0x03A7, new int[]{0x03C7});
        CASE_FOLD.put(0x03A8, new int[]{0x03C8});
        CASE_FOLD.put(0x03A9, new int[]{0x03C9});
        CASE_FOLD.put(0x03AA, new int[]{0x03CA});
        CASE_FOLD.put(0x03AB, new int[]{0x03CB});
        CASE_FOLD.put(0x03B0, new int[]{0x03C5, 0x0308, 0x0301});
        CASE_FOLD.put(0x03C2, new int[]{0x03C3});
        CASE_FOLD.put(0x03CF, new int[]{0x03D7});
        CASE_FOLD.put(0x03D0, new int[]{0x03B2});
        CASE_FOLD.put(0x03D1, new int[]{0x03B8});
        CASE_FOLD.put(0x03D5, new int[]{0x03C6});
        CASE_FOLD.put(0x03D6, new int[]{0x03C0});
        CASE_FOLD.put(0x03D8, new int[]{0x03D9});
        CASE_FOLD.put(0x03DA, new int[]{0x03DB});
        CASE_FOLD.put(0x03DC, new int[]{0x03DD});
        CASE_FOLD.put(0x03DE, new int[]{0x03DF});
        CASE_FOLD.put(0x03E0, new int[]{0x03E1});
        CASE_FOLD.put(0x03E2, new int[]{0x03E3});
        CASE_FOLD.put(0x03E4, new int[]{0x03E5});
        CASE_FOLD.put(0x03E6, new int[]{0x03E7});
        CASE_FOLD.put(0x03E8, new int[]{0x03E9});
        CASE_FOLD.put(0x03EA, new int[]{0x03EB});
        CASE_FOLD.put(0x03EC, new int[]{0x03ED});
        CASE_FOLD.put(0x03EE, new int[]{0x03EF});
        CASE_FOLD.put(0x03F0, new int[]{0x03BA});
        CASE_FOLD.put(0x03F1, new int[]{0x03C1});
        CASE_FOLD.put(0x03F4, new int[]{0x03B8});
        CASE_FOLD.put(0x03F5, new int[]{0x03B5});
        CASE_FOLD.put(0x03F7, new int[]{0x03F8});
        CASE_FOLD.put(0x03F9, new int[]{0x03F2});
        CASE_FOLD.put(0x03FA, new int[]{0x03FB});
        CASE_FOLD.put(0x03FD, new int[]{0x037B});
        CASE_FOLD.put(0x03FE, new int[]{0x037C});
        CASE_FOLD.put(0x03FF, new int[]{0x037D});
        CASE_FOLD.put(0x0400, new int[]{0x0450});
        CASE_FOLD.put(0x0401, new int[]{0x0451});
        CASE_FOLD.put(0x0402, new int[]{0x0452});
        CASE_FOLD.put(0x0403, new int[]{0x0453});
        CASE_FOLD.put(0x0404, new int[]{0x0454});
        CASE_FOLD.put(0x0405, new int[]{0x0455});
        CASE_FOLD.put(0x0406, new int[]{0x0456});
        CASE_FOLD.put(0x0407, new int[]{0x0457});
        CASE_FOLD.put(0x0408, new int[]{0x0458});
        CASE_FOLD.put(0x0409, new int[]{0x0459});
        CASE_FOLD.put(0x040A, new int[]{0x045A});
        CASE_FOLD.put(0x040B, new int[]{0x045B});
        CASE_FOLD.put(0x040C, new int[]{0x045C});
        CASE_FOLD.put(0x040D, new int[]{0x045D});
        CASE_FOLD.put(0x040E, new int[]{0x045E});
        CASE_FOLD.put(0x040F, new int[]{0x045F});
        CASE_FOLD.put(0x0410, new int[]{0x0430});
        CASE_FOLD.put(0x0411, new int[]{0x0431});
        CASE_FOLD.put(0x0412, new int[]{0x0432});
        CASE_FOLD.put(0x0413, new int[]{0x0433});
        CASE_FOLD.put(0x0414, new int[]{0x0434});
        CASE_FOLD.put(0x0415, new int[]{0x0435});
        CASE_FOLD.put(0x0416, new int[]{0x0436});
        CASE_FOLD.put(0x0417, new int[]{0x0437});
        CASE_FOLD.put(0x0418, new int[]{0x0438});
        CASE_FOLD.put(0x0419, new int[]{0x0439});
        CASE_FOLD.put(0x041A, new int[]{0x043A});
        CASE_FOLD.put(0x041B, new int[]{0x043B});
        CASE_FOLD.put(0x041C, new int[]{0x043C});
        CASE_FOLD.put(0x041D, new int[]{0x043D});
        CASE_FOLD.put(0x041E, new int[]{0x043E});
        CASE_FOLD.put(0x041F, new int[]{0x043F});
        CASE_FOLD.put(0x0420, new int[]{0x0440});
        CASE_FOLD.put(0x0421, new int[]{0x0441});
        CASE_FOLD.put(0x0422, new int[]{0x0442});
        CASE_FOLD.put(0x0423, new int[]{0x0443});
        CASE_FOLD.put(0x0424, new int[]{0x0444});
        CASE_FOLD.put(0x0425, new int[]{0x0445});
        CASE_FOLD.put(0x0426, new int[]{0x0446});
        CASE_FOLD.put(0x0427, new int[]{0x0447});
        CASE_FOLD.put(0x0428, new int[]{0x0448});
        CASE_FOLD.put(0x0429, new int[]{0x0449});
        CASE_FOLD.put(0x042A, new int[]{0x044A});
        CASE_FOLD.put(0x042B, new int[]{0x044B});
        CASE_FOLD.put(0x042C, new int[]{0x044C});
        CASE_FOLD.put(0x042D, new int[]{0x044D});
        CASE_FOLD.put(0x042E, new int[]{0x044E});
        CASE_FOLD.put(0x042F, new int[]{0x044F});
        CASE_FOLD.put(0x0460, new int[]{0x0461});
        CASE_FOLD.put(0x0462, new int[]{0x0463});
        CASE_FOLD.put(0x0464, new int[]{0x0465});
        CASE_FOLD.put(0x0466, new int[]{0x0467});
        CASE_FOLD.put(0x0468, new int[]{0x0469});
        CASE_FOLD.put(0x046A, new int[]{0x046B});
        CASE_FOLD.put(0x046C, new int[]{0x046D});
        CASE_FOLD.put(0x046E, new int[]{0x046F});
        CASE_FOLD.put(0x0470, new int[]{0x0471});
        CASE_FOLD.put(0x0472, new int[]{0x0473});
        CASE_FOLD.put(0x0474, new int[]{0x0475});
        CASE_FOLD.put(0x0476, new int[]{0x0477});
        CASE_FOLD.put(0x0478, new int[]{0x0479});
        CASE_FOLD.put(0x047A, new int[]{0x047B});
        CASE_FOLD.put(0x047C, new int[]{0x047D});
        CASE_FOLD.put(0x047E, new int[]{0x047F});
        CASE_FOLD.put(0x0480, new int[]{0x0481});
        CASE_FOLD.put(0x048A, new int[]{0x048B});
        CASE_FOLD.put(0x048C, new int[]{0x048D});
        CASE_FOLD.put(0x048E, new int[]{0x048F});
        CASE_FOLD.put(0x0490, new int[]{0x0491});
        CASE_FOLD.put(0x0492, new int[]{0x0493});
        CASE_FOLD.put(0x0494, new int[]{0x0495});
        CASE_FOLD.put(0x0496, new int[]{0x0497});
        CASE_FOLD.put(0x0498, new int[]{0x0499});
        CASE_FOLD.put(0x049A, new int[]{0x049B});
        CASE_FOLD.put(0x049C, new int[]{0x049D});
        CASE_FOLD.put(0x049E, new int[]{0x049F});
        CASE_FOLD.put(0x04A0, new int[]{0x04A1});
        CASE_FOLD.put(0x04A2, new int[]{0x04A3});
        CASE_FOLD.put(0x04A4, new int[]{0x04A5});
        CASE_FOLD.put(0x04A6, new int[]{0x04A7});
        CASE_FOLD.put(0x04A8, new int[]{0x04A9});
        CASE_FOLD.put(0x04AA, new int[]{0x04AB});
        CASE_FOLD.put(0x04AC, new int[]{0x04AD});
        CASE_FOLD.put(0x04AE, new int[]{0x04AF});
        CASE_FOLD.put(0x04B0, new int[]{0x04B1});
        CASE_FOLD.put(0x04B2, new int[]{0x04B3});
        CASE_FOLD.put(0x04B4, new int[]{0x04B5});
        CASE_FOLD.put(0x04B6, new int[]{0x04B7});
        CASE_FOLD.put(0x04B8, new int[]{0x04B9});
        CASE_FOLD.put(0x04BA, new int[]{0x04BB});
        CASE_FOLD.put(0x04BC, new int[]{0x04BD});
        CASE_FOLD.put(0x04BE, new int[]{0x04BF});
        CASE_FOLD.put(0x04C0, new int[]{0x04CF});
        CASE_FOLD.put(0x04C1, new int[]{0x04C2});
        CASE_FOLD.put(0x04C3, new int[]{0x04C4});
        CASE_FOLD.put(0x04C5, new int[]{0x04C6});
        CASE_FOLD.put(0x04C7, new int[]{0x04C8});
        CASE_FOLD.put(0x04C9, new int[]{0x04CA});
        CASE_FOLD.put(0x04CB, new int[]{0x04CC});
        CASE_FOLD.put(0x04CD, new int[]{0x04CE});
        CASE_FOLD.put(0x04D0, new int[]{0x04D1});
        CASE_FOLD.put(0x04D2, new int[]{0x04D3});
        CASE_FOLD.put(0x04D4, new int[]{0x04D5});
        CASE_FOLD.put(0x04D6, new int[]{0x04D7});
        CASE_FOLD.put(0x04D8, new int[]{0x04D9});
        CASE_FOLD.put(0x04DA, new int[]{0x04DB});
        CASE_FOLD.put(0x04DC, new int[]{0x04DD});
        CASE_FOLD.put(0x04DE, new int[]{0x04DF});
        CASE_FOLD.put(0x04E0, new int[]{0x04E1});
        CASE_FOLD.put(0x04E2, new int[]{0x04E3});
        CASE_FOLD.put(0x04E4, new int[]{0x04E5});
        CASE_FOLD.put(0x04E6, new int[]{0x04E7});
        CASE_FOLD.put(0x04E8, new int[]{0x04E9});
        CASE_FOLD.put(0x04EA, new int[]{0x04EB});
        CASE_FOLD.put(0x04EC, new int[]{0x04ED});
        CASE_FOLD.put(0x04EE, new int[]{0x04EF});
        CASE_FOLD.put(0x04F0, new int[]{0x04F1});
        CASE_FOLD.put(0x04F2, new int[]{0x04F3});
        CASE_FOLD.put(0x04F4, new int[]{0x04F5});
        CASE_FOLD.put(0x04F6, new int[]{0x04F7});
        CASE_FOLD.put(0x04F8, new int[]{0x04F9});
        CASE_FOLD.put(0x04FA, new int[]{0x04FB});
        CASE_FOLD.put(0x04FC, new int[]{0x04FD});
        CASE_FOLD.put(0x04FE, new int[]{0x04FF});
        CASE_FOLD.put(0x0500, new int[]{0x0501});
        CASE_FOLD.put(0x0502, new int[]{0x0503});
        CASE_FOLD.put(0x0504, new int[]{0x0505});
        CASE_FOLD.put(0x0506, new int[]{0x0507});
        CASE_FOLD.put(0x0508, new int[]{0x0509});
        CASE_FOLD.put(0x050A, new int[]{0x050B});
        CASE_FOLD.put(0x050C, new int[]{0x050D});
        CASE_FOLD.put(0x050E, new int[]{0x050F});
        CASE_FOLD.put(0x0510, new int[]{0x0511});
        CASE_FOLD.put(0x0512, new int[]{0x0513});
        CASE_FOLD.put(0x0514, new int[]{0x0515});
        CASE_FOLD.put(0x0516, new int[]{0x0517});
        CASE_FOLD.put(0x0518, new int[]{0x0519});
        CASE_FOLD.put(0x051A, new int[]{0x051B});
        CASE_FOLD.put(0x051C, new int[]{0x051D});
        CASE_FOLD.put(0x051E, new int[]{0x051F});
        CASE_FOLD.put(0x0520, new int[]{0x0521});
        CASE_FOLD.put(0x0522, new int[]{0x0523});
        CASE_FOLD.put(0x0524, new int[]{0x0525});
        CASE_FOLD.put(0x0526, new int[]{0x0527});
        CASE_FOLD.put(0x0528, new int[]{0x0529});
        CASE_FOLD.put(0x052A, new int[]{0x052B});
        CASE_FOLD.put(0x052C, new int[]{0x052D});
        CASE_FOLD.put(0x052E, new int[]{0x052F});
        CASE_FOLD.put(0x0531, new int[]{0x0561});
        CASE_FOLD.put(0x0532, new int[]{0x0562});
        CASE_FOLD.put(0x0533, new int[]{0x0563});
        CASE_FOLD.put(0x0534, new int[]{0x0564});
        CASE_FOLD.put(0x0535, new int[]{0x0565});
        CASE_FOLD.put(0x0536, new int[]{0x0566});
        CASE_FOLD.put(0x0537, new int[]{0x0567});
        CASE_FOLD.put(0x0538, new int[]{0x0568});
        CASE_FOLD.put(0x0539, new int[]{0x0569});
        CASE_FOLD.put(0x053A, new int[]{0x056A});
        CASE_FOLD.put(0x053B, new int[]{0x056B});
        CASE_FOLD.put(0x053C, new int[]{0x056C});
        CASE_FOLD.put(0x053D, new int[]{0x056D});
        CASE_FOLD.put(0x053E, new int[]{0x056E});
        CASE_FOLD.put(0x053F, new int[]{0x056F});
        CASE_FOLD.put(0x0540, new int[]{0x0570});
        CASE_FOLD.put(0x0541, new int[]{0x0571});
        CASE_FOLD.put(0x0542, new int[]{0x0572});
        CASE_FOLD.put(0x0543, new int[]{0x0573});
        CASE_FOLD.put(0x0544, new int[]{0x0574});
        CASE_FOLD.put(0x0545, new int[]{0x0575});
        CASE_FOLD.put(0x0546, new int[]{0x0576});
        CASE_FOLD.put(0x0547, new int[]{0x0577});
        CASE_FOLD.put(0x0548, new int[]{0x0578});
        CASE_FOLD.put(0x0549, new int[]{0x0579});
        CASE_FOLD.put(0x054A, new int[]{0x057A});
        CASE_FOLD.put(0x054B, new int[]{0x057B});
        CASE_FOLD.put(0x054C, new int[]{0x057C});
        CASE_FOLD.put(0x054D, new int[]{0x057D});
        CASE_FOLD.put(0x054E, new int[]{0x057E});
        CASE_FOLD.put(0x054F, new int[]{0x057F});
        CASE_FOLD.put(0x0550, new int[]{0x0580});
        CASE_FOLD.put(0x0551, new int[]{0x0581});
        CASE_FOLD.put(0x0552, new int[]{0x0582});
        CASE_FOLD.put(0x0553, new int[]{0x0583});
        CASE_FOLD.put(0x0554, new int[]{0x0584});
        CASE_FOLD.put(0x0555, new int[]{0x0585});
        CASE_FOLD.put(0x0556, new int[]{0x0586});
        CASE_FOLD.put(0x0587, new int[]{0x0565, 0x0582});
        CASE_FOLD.put(0x10A0, new int[]{0x2D00});
        CASE_FOLD.put(0x10A1, new int[]{0x2D01});
        CASE_FOLD.put(0x10A2, new int[]{0x2D02});
        CASE_FOLD.put(0x10A3, new int[]{0x2D03});
        CASE_FOLD.put(0x10A4, new int[]{0x2D04});
        CASE_FOLD.put(0x10A5, new int[]{0x2D05});
        CASE_FOLD.put(0x10A6, new int[]{0x2D06});
        CASE_FOLD.put(0x10A7, new int[]{0x2D07});
        CASE_FOLD.put(0x10A8, new int[]{0x2D08});
        CASE_FOLD.put(0x10A9, new int[]{0x2D09});
        CASE_FOLD.put(0x10AA, new int[]{0x2D0A});
        CASE_FOLD.put(0x10AB, new int[]{0x2D0B});
        CASE_FOLD.put(0x10AC, new int[]{0x2D0C});
        CASE_FOLD.put(0x10AD, new int[]{0x2D0D});
        CASE_FOLD.put(0x10AE, new int[]{0x2D0E});
        CASE_FOLD.put(0x10AF, new int[]{0x2D0F});
        CASE_FOLD.put(0x10B0, new int[]{0x2D10});
        CASE_FOLD.put(0x10B1, new int[]{0x2D11});
        CASE_FOLD.put(0x10B2, new int[]{0x2D12});
        CASE_FOLD.put(0x10B3, new int[]{0x2D13});
        CASE_FOLD.put(0x10B4, new int[]{0x2D14});
        CASE_FOLD.put(0x10B5, new int[]{0x2D15});
        CASE_FOLD.put(0x10B6, new int[]{0x2D16});
        CASE_FOLD.put(0x10B7, new int[]{0x2D17});
        CASE_FOLD.put(0x10B8, new int[]{0x2D18});
        CASE_FOLD.put(0x10B9, new int[]{0x2D19});
        CASE_FOLD.put(0x10BA, new int[]{0x2D1A});
        CASE_FOLD.put(0x10BB, new int[]{0x2D1B});
        CASE_FOLD.put(0x10BC, new int[]{0x2D1C});
        CASE_FOLD.put(0x10BD, new int[]{0x2D1D});
        CASE_FOLD.put(0x10BE, new int[]{0x2D1E});
        CASE_FOLD.put(0x10BF, new int[]{0x2D1F});
        CASE_FOLD.put(0x10C0, new int[]{0x2D20});
        CASE_FOLD.put(0x10C1, new int[]{0x2D21});
        CASE_FOLD.put(0x10C2, new int[]{0x2D22});
        CASE_FOLD.put(0x10C3, new int[]{0x2D23});
        CASE_FOLD.put(0x10C4, new int[]{0x2D24});
        CASE_FOLD.put(0x10C5, new int[]{0x2D25});
        CASE_FOLD.put(0x10C7, new int[]{0x2D27});
        CASE_FOLD.put(0x10CD, new int[]{0x2D2D});
        CASE_FOLD.put(0x13F8, new int[]{0x13F0});
        CASE_FOLD.put(0x13F9, new int[]{0x13F1});
        CASE_FOLD.put(0x13FA, new int[]{0x13F2});
        CASE_FOLD.put(0x13FB, new int[]{0x13F3});
        CASE_FOLD.put(0x13FC, new int[]{0x13F4});
        CASE_FOLD.put(0x13FD, new int[]{0x13F5});
        CASE_FOLD.put(0x1C80, new int[]{0x0432});
        CASE_FOLD.put(0x1C81, new int[]{0x0434});
        CASE_FOLD.put(0x1C82, new int[]{0x043E});
        CASE_FOLD.put(0x1C83, new int[]{0x0441});
        CASE_FOLD.put(0x1C84, new int[]{0x0442});
        CASE_FOLD.put(0x1C85, new int[]{0x0442});
        CASE_FOLD.put(0x1C86, new int[]{0x044A});
        CASE_FOLD.put(0x1C87, new int[]{0x0463});
        CASE_FOLD.put(0x1C88, new int[]{0xA64B});
        CASE_FOLD.put(0x1C90, new int[]{0x10D0});
        CASE_FOLD.put(0x1C91, new int[]{0x10D1});
        CASE_FOLD.put(0x1C92, new int[]{0x10D2});
        CASE_FOLD.put(0x1C93, new int[]{0x10D3});
        CASE_FOLD.put(0x1C94, new int[]{0x10D4});
        CASE_FOLD.put(0x1C95, new int[]{0x10D5});
        CASE_FOLD.put(0x1C96, new int[]{0x10D6});
        CASE_FOLD.put(0x1C97, new int[]{0x10D7});
        CASE_FOLD.put(0x1C98, new int[]{0x10D8});
        CASE_FOLD.put(0x1C99, new int[]{0x10D9});
        CASE_FOLD.put(0x1C9A, new int[]{0x10DA});
        CASE_FOLD.put(0x1C9B, new int[]{0x10DB});
        CASE_FOLD.put(0x1C9C, new int[]{0x10DC});
        CASE_FOLD.put(0x1C9D, new int[]{0x10DD});
        CASE_FOLD.put(0x1C9E, new int[]{0x10DE});
        CASE_FOLD.put(0x1C9F, new int[]{0x10DF});
        CASE_FOLD.put(0x1CA0, new int[]{0x10E0});
        CASE_FOLD.put(0x1CA1, new int[]{0x10E1});
        CASE_FOLD.put(0x1CA2, new int[]{0x10E2});
        CASE_FOLD.put(0x1CA3, new int[]{0x10E3});
        CASE_FOLD.put(0x1CA4, new int[]{0x10E4});
        CASE_FOLD.put(0x1CA5, new int[]{0x10E5});
        CASE_FOLD.put(0x1CA6, new int[]{0x10E6});
        CASE_FOLD.put(0x1CA7, new int[]{0x10E7});
        CASE_FOLD.put(0x1CA8, new int[]{0x10E8});
        CASE_FOLD.put(0x1CA9, new int[]{0x10E9});
        CASE_FOLD.put(0x1CAA, new int[]{0x10EA});
        CASE_FOLD.put(0x1CAB, new int[]{0x10EB});
        CASE_FOLD.put(0x1CAC, new int[]{0x10EC});
        CASE_FOLD.put(0x1CAD, new int[]{0x10ED});
        CASE_FOLD.put(0x1CAE, new int[]{0x10EE});
        CASE_FOLD.put(0x1CAF, new int[]{0x10EF});
        CASE_FOLD.put(0x1CB0, new int[]{0x10F0});
        CASE_FOLD.put(0x1CB1, new int[]{0x10F1});
        CASE_FOLD.put(0x1CB2, new int[]{0x10F2});
        CASE_FOLD.put(0x1CB3, new int[]{0x10F3});
        CASE_FOLD.put(0x1CB4, new int[]{0x10F4});
        CASE_FOLD.put(0x1CB5, new int[]{0x10F5});
        CASE_FOLD.put(0x1CB6, new int[]{0x10F6});
        CASE_FOLD.put(0x1CB7, new int[]{0x10F7});
        CASE_FOLD.put(0x1CB8, new int[]{0x10F8});
        CASE_FOLD.put(0x1CB9, new int[]{0x10F9});
        CASE_FOLD.put(0x1CBA, new int[]{0x10FA});
        CASE_FOLD.put(0x1CBD, new int[]{0x10FD});
        CASE_FOLD.put(0x1CBE, new int[]{0x10FE});
        CASE_FOLD.put(0x1CBF, new int[]{0x10FF});
        CASE_FOLD.put(0x1E00, new int[]{0x1E01});
        CASE_FOLD.put(0x1E02, new int[]{0x1E03});
        CASE_FOLD.put(0x1E04, new int[]{0x1E05});
        CASE_FOLD.put(0x1E06, new int[]{0x1E07});
        CASE_FOLD.put(0x1E08, new int[]{0x1E09});
        CASE_FOLD.put(0x1E0A, new int[]{0x1E0B});
        CASE_FOLD.put(0x1E0C, new int[]{0x1E0D});
        CASE_FOLD.put(0x1E0E, new int[]{0x1E0F});
        CASE_FOLD.put(0x1E10, new int[]{0x1E11});
        CASE_FOLD.put(0x1E12, new int[]{0x1E13});
        CASE_FOLD.put(0x1E14, new int[]{0x1E15});
        CASE_FOLD.put(0x1E16, new int[]{0x1E17});
        CASE_FOLD.put(0x1E18, new int[]{0x1E19});
        CASE_FOLD.put(0x1E1A, new int[]{0x1E1B});
        CASE_FOLD.put(0x1E1C, new int[]{0x1E1D});
        CASE_FOLD.put(0x1E1E, new int[]{0x1E1F});
        CASE_FOLD.put(0x1E20, new int[]{0x1E21});
        CASE_FOLD.put(0x1E22, new int[]{0x1E23});
        CASE_FOLD.put(0x1E24, new int[]{0x1E25});
        CASE_FOLD.put(0x1E26, new int[]{0x1E27});
        CASE_FOLD.put(0x1E28, new int[]{0x1E29});
        CASE_FOLD.put(0x1E2A, new int[]{0x1E2B});
        CASE_FOLD.put(0x1E2C, new int[]{0x1E2D});
        CASE_FOLD.put(0x1E2E, new int[]{0x1E2F});
        CASE_FOLD.put(0x1E30, new int[]{0x1E31});
        CASE_FOLD.put(0x1E32, new int[]{0x1E33});
        CASE_FOLD.put(0x1E34, new int[]{0x1E35});
        CASE_FOLD.put(0x1E36, new int[]{0x1E37});
        CASE_FOLD.put(0x1E38, new int[]{0x1E39});
        CASE_FOLD.put(0x1E3A, new int[]{0x1E3B});
        CASE_FOLD.put(0x1E3C, new int[]{0x1E3D});
        CASE_FOLD.put(0x1E3E, new int[]{0x1E3F});
        CASE_FOLD.put(0x1E40, new int[]{0x1E41});
        CASE_FOLD.put(0x1E42, new int[]{0x1E43});
        CASE_FOLD.put(0x1E44, new int[]{0x1E45});
        CASE_FOLD.put(0x1E46, new int[]{0x1E47});
        CASE_FOLD.put(0x1E48, new int[]{0x1E49});
        CASE_FOLD.put(0x1E4A, new int[]{0x1E4B});
        CASE_FOLD.put(0x1E4C, new int[]{0x1E4D});
        CASE_FOLD.put(0x1E4E, new int[]{0x1E4F});
        CASE_FOLD.put(0x1E50, new int[]{0x1E51});
        CASE_FOLD.put(0x1E52, new int[]{0x1E53});
        CASE_FOLD.put(0x1E54, new int[]{0x1E55});
        CASE_FOLD.put(0x1E56, new int[]{0x1E57});
        CASE_FOLD.put(0x1E58, new int[]{0x1E59});
        CASE_FOLD.put(0x1E5A, new int[]{0x1E5B});
        CASE_FOLD.put(0x1E5C, new int[]{0x1E5D});
        CASE_FOLD.put(0x1E5E, new int[]{0x1E5F});
        CASE_FOLD.put(0x1E60, new int[]{0x1E61});
        CASE_FOLD.put(0x1E62, new int[]{0x1E63});
        CASE_FOLD.put(0x1E64, new int[]{0x1E65});
        CASE_FOLD.put(0x1E66, new int[]{0x1E67});
        CASE_FOLD.put(0x1E68, new int[]{0x1E69});
        CASE_FOLD.put(0x1E6A, new int[]{0x1E6B});
        CASE_FOLD.put(0x1E6C, new int[]{0x1E6D});
        CASE_FOLD.put(0x1E6E, new int[]{0x1E6F});
        CASE_FOLD.put(0x1E70, new int[]{0x1E71});
        CASE_FOLD.put(0x1E72, new int[]{0x1E73});
        CASE_FOLD.put(0x1E74, new int[]{0x1E75});
        CASE_FOLD.put(0x1E76, new int[]{0x1E77});
        CASE_FOLD.put(0x1E78, new int[]{0x1E79});
        CASE_FOLD.put(0x1E7A, new int[]{0x1E7B});
        CASE_FOLD.put(0x1E7C, new int[]{0x1E7D});
        CASE_FOLD.put(0x1E7E, new int[]{0x1E7F});
        CASE_FOLD.put(0x1E80, new int[]{0x1E81});
        CASE_FOLD.put(0x1E82, new int[]{0x1E83});
        CASE_FOLD.put(0x1E84, new int[]{0x1E85});
        CASE_FOLD.put(0x1E86, new int[]{0x1E87});
        CASE_FOLD.put(0x1E88, new int[]{0x1E89});
        CASE_FOLD.put(0x1E8A, new int[]{0x1E8B});
        CASE_FOLD.put(0x1E8C, new int[]{0x1E8D});
        CASE_FOLD.put(0x1E8E, new int[]{0x1E8F});
        CASE_FOLD.put(0x1E90, new int[]{0x1E91});
        CASE_FOLD.put(0x1E92, new int[]{0x1E93});
        CASE_FOLD.put(0x1E94, new int[]{0x1E95});
        CASE_FOLD.put(0x1E96, new int[]{0x0068, 0x0331});
        CASE_FOLD.put(0x1E97, new int[]{0x0074, 0x0308});
        CASE_FOLD.put(0x1E98, new int[]{0x0077, 0x030A});
        CASE_FOLD.put(0x1E99, new int[]{0x0079, 0x030A});
        CASE_FOLD.put(0x1E9A, new int[]{0x0061, 0x02BE});
        CASE_FOLD.put(0x1E9B, new int[]{0x1E61});
        CASE_FOLD.put(0x1E9E, new int[]{0x0073, 0x0073});
        CASE_FOLD.put(0x1EA0, new int[]{0x1EA1});
        CASE_FOLD.put(0x1EA2, new int[]{0x1EA3});
        CASE_FOLD.put(0x1EA4, new int[]{0x1EA5});
        CASE_FOLD.put(0x1EA6, new int[]{0x1EA7});
        CASE_FOLD.put(0x1EA8, new int[]{0x1EA9});
        CASE_FOLD.put(0x1EAA, new int[]{0x1EAB});
        CASE_FOLD.put(0x1EAC, new int[]{0x1EAD});
        CASE_FOLD.put(0x1EAE, new int[]{0x1EAF});
        CASE_FOLD.put(0x1EB0, new int[]{0x1EB1});
        CASE_FOLD.put(0x1EB2, new int[]{0x1EB3});
        CASE_FOLD.put(0x1EB4, new int[]{0x1EB5});
        CASE_FOLD.put(0x1EB6, new int[]{0x1EB7});
        CASE_FOLD.put(0x1EB8, new int[]{0x1EB9});
        CASE_FOLD.put(0x1EBA, new int[]{0x1EBB});
        CASE_FOLD.put(0x1EBC, new int[]{0x1EBD});
        CASE_FOLD.put(0x1EBE, new int[]{0x1EBF});
        CASE_FOLD.put(0x1EC0, new int[]{0x1EC1});
        CASE_FOLD.put(0x1EC2, new int[]{0x1EC3});
        CASE_FOLD.put(0x1EC4, new int[]{0x1EC5});
        CASE_FOLD.put(0x1EC6, new int[]{0x1EC7});
        CASE_FOLD.put(0x1EC8, new int[]{0x1EC9});
        CASE_FOLD.put(0x1ECA, new int[]{0x1ECB});
        CASE_FOLD.put(0x1ECC, new int[]{0x1ECD});
        CASE_FOLD.put(0x1ECE, new int[]{0x1ECF});
        CASE_FOLD.put(0x1ED0, new int[]{0x1ED1});
        CASE_FOLD.put(0x1ED2, new int[]{0x1ED3});
        CASE_FOLD.put(0x1ED4, new int[]{0x1ED5});
        CASE_FOLD.put(0x1ED6, new int[]{0x1ED7});
        CASE_FOLD.put(0x1ED8, new int[]{0x1ED9});
        CASE_FOLD.put(0x1EDA, new int[]{0x1EDB});
        CASE_FOLD.put(0x1EDC, new int[]{0x1EDD});
        CASE_FOLD.put(0x1EDE, new int[]{0x1EDF});
        CASE_FOLD.put(0x1EE0, new int[]{0x1EE1});
        CASE_FOLD.put(0x1EE2, new int[]{0x1EE3});
        CASE_FOLD.put(0x1EE4, new int[]{0x1EE5});
        CASE_FOLD.put(0x1EE6, new int[]{0x1EE7});
        CASE_FOLD.put(0x1EE8, new int[]{0x1EE9});
        CASE_FOLD.put(0x1EEA, new int[]{0x1EEB});
        CASE_FOLD.put(0x1EEC, new int[]{0x1EED});
        CASE_FOLD.put(0x1EEE, new int[]{0x1EEF});
        CASE_FOLD.put(0x1EF0, new int[]{0x1EF1});
        CASE_FOLD.put(0x1EF2, new int[]{0x1EF3});
        CASE_FOLD.put(0x1EF4, new int[]{0x1EF5});
        CASE_FOLD.put(0x1EF6, new int[]{0x1EF7});
        CASE_FOLD.put(0x1EF8, new int[]{0x1EF9});
        CASE_FOLD.put(0x1EFA, new int[]{0x1EFB});
        CASE_FOLD.put(0x1EFC, new int[]{0x1EFD});
        CASE_FOLD.put(0x1EFE, new int[]{0x1EFF});
        CASE_FOLD.put(0x1F08, new int[]{0x1F00});
        CASE_FOLD.put(0x1F09, new int[]{0x1F01});
        CASE_FOLD.put(0x1F0A, new int[]{0x1F02});
        CASE_FOLD.put(0x1F0B, new int[]{0x1F03});
        CASE_FOLD.put(0x1F0C, new int[]{0x1F04});
        CASE_FOLD.put(0x1F0D, new int[]{0x1F05});
        CASE_FOLD.put(0x1F0E, new int[]{0x1F06});
        CASE_FOLD.put(0x1F0F, new int[]{0x1F07});
        CASE_FOLD.put(0x1F18, new int[]{0x1F10});
        CASE_FOLD.put(0x1F19, new int[]{0x1F11});
        CASE_FOLD.put(0x1F1A, new int[]{0x1F12});
        CASE_FOLD.put(0x1F1B, new int[]{0x1F13});
        CASE_FOLD.put(0x1F1C, new int[]{0x1F14});
        CASE_FOLD.put(0x1F1D, new int[]{0x1F15});
        CASE_FOLD.put(0x1F28, new int[]{0x1F20});
        CASE_FOLD.put(0x1F29, new int[]{0x1F21});
        CASE_FOLD.put(0x1F2A, new int[]{0x1F22});
        CASE_FOLD.put(0x1F2B, new int[]{0x1F23});
        CASE_FOLD.put(0x1F2C, new int[]{0x1F24});
        CASE_FOLD.put(0x1F2D, new int[]{0x1F25});
        CASE_FOLD.put(0x1F2E, new int[]{0x1F26});
        CASE_FOLD.put(0x1F2F, new int[]{0x1F27});
        CASE_FOLD.put(0x1F38, new int[]{0x1F30});
        CASE_FOLD.put(0x1F39, new int[]{0x1F31});
        CASE_FOLD.put(0x1F3A, new int[]{0x1F32});
        CASE_FOLD.put(0x1F3B, new int[]{0x1F33});
        CASE_FOLD.put(0x1F3C, new int[]{0x1F34});
        CASE_FOLD.put(0x1F3D, new int[]{0x1F35});
        CASE_FOLD.put(0x1F3E, new int[]{0x1F36});
        CASE_FOLD.put(0x1F3F, new int[]{0x1F37});
        CASE_FOLD.put(0x1F48, new int[]{0x1F40});
        CASE_FOLD.put(0x1F49, new int[]{0x1F41});
        CASE_FOLD.put(0x1F4A, new int[]{0x1F42});
        CASE_FOLD.put(0x1F4B, new int[]{0x1F43});
        CASE_FOLD.put(0x1F4C, new int[]{0x1F44});
        CASE_FOLD.put(0x1F4D, new int[]{0x1F45});
        CASE_FOLD.put(0x1F50, new int[]{0x03C5, 0x0313});
        CASE_FOLD.put(0x1F52, new int[]{0x03C5, 0x0313, 0x0300});
        CASE_FOLD.put(0x1F54, new int[]{0x03C5, 0x0313, 0x0301});
        CASE_FOLD.put(0x1F56, new int[]{0x03C5, 0x0313, 0x0342});
        CASE_FOLD.put(0x1F59, new int[]{0x1F51});
        CASE_FOLD.put(0x1F5B, new int[]{0x1F53});
        CASE_FOLD.put(0x1F5D, new int[]{0x1F55});
        CASE_FOLD.put(0x1F5F, new int[]{0x1F57});
        CASE_FOLD.put(0x1F68, new int[]{0x1F60});
        CASE_FOLD.put(0x1F69, new int[]{0x1F61});
        CASE_FOLD.put(0x1F6A, new int[]{0x1F62});
        CASE_FOLD.put(0x1F6B, new int[]{0x1F63});
        CASE_FOLD.put(0x1F6C, new int[]{0x1F64});
        CASE_FOLD.put(0x1F6D, new int[]{0x1F65});
        CASE_FOLD.put(0x1F6E, new int[]{0x1F66});
        CASE_FOLD.put(0x1F6F, new int[]{0x1F67});
        CASE_FOLD.put(0x1F80, new int[]{0x1F00, 0x03B9});
        CASE_FOLD.put(0x1F81, new int[]{0x1F01, 0x03B9});
        CASE_FOLD.put(0x1F82, new int[]{0x1F02, 0x03B9});
        CASE_FOLD.put(0x1F83, new int[]{0x1F03, 0x03B9});
        CASE_FOLD.put(0x1F84, new int[]{0x1F04, 0x03B9});
        CASE_FOLD.put(0x1F85, new int[]{0x1F05, 0x03B9});
        CASE_FOLD.put(0x1F86, new int[]{0x1F06, 0x03B9});
        CASE_FOLD.put(0x1F87, new int[]{0x1F07, 0x03B9});
        CASE_FOLD.put(0x1F88, new int[]{0x1F00, 0x03B9});
        CASE_FOLD.put(0x1F89, new int[]{0x1F01, 0x03B9});
        CASE_FOLD.put(0x1F8A, new int[]{0x1F02, 0x03B9});
        CASE_FOLD.put(0x1F8B, new int[]{0x1F03, 0x03B9});
        CASE_FOLD.put(0x1F8C, new int[]{0x1F04, 0x03B9});
        CASE_FOLD.put(0x1F8D, new int[]{0x1F05, 0x03B9});
        CASE_FOLD.put(0x1F8E, new int[]{0x1F06, 0x03B9});
        CASE_FOLD.put(0x1F8F, new int[]{0x1F07, 0x03B9});
        CASE_FOLD.put(0x1F90, new int[]{0x1F20, 0x03B9});
        CASE_FOLD.put(0x1F91, new int[]{0x1F21, 0x03B9});
        CASE_FOLD.put(0x1F92, new int[]{0x1F22, 0x03B9});
        CASE_FOLD.put(0x1F93, new int[]{0x1F23, 0x03B9});
        CASE_FOLD.put(0x1F94, new int[]{0x1F24, 0x03B9});
        CASE_FOLD.put(0x1F95, new int[]{0x1F25, 0x03B9});
        CASE_FOLD.put(0x1F96, new int[]{0x1F26, 0x03B9});
        CASE_FOLD.put(0x1F97, new int[]{0x1F27, 0x03B9});
        CASE_FOLD.put(0x1F98, new int[]{0x1F20, 0x03B9});
        CASE_FOLD.put(0x1F99, new int[]{0x1F21, 0x03B9});
        CASE_FOLD.put(0x1F9A, new int[]{0x1F22, 0x03B9});
        CASE_FOLD.put(0x1F9B, new int[]{0x1F23, 0x03B9});
        CASE_FOLD.put(0x1F9C, new int[]{0x1F24, 0x03B9});
        CASE_FOLD.put(0x1F9D, new int[]{0x1F25, 0x03B9});
        CASE_FOLD.put(0x1F9E, new int[]{0x1F26, 0x03B9});
        CASE_FOLD.put(0x1F9F, new int[]{0x1F27, 0x03B9});
        CASE_FOLD.put(0x1FA0, new int[]{0x1F60, 0x03B9});
        CASE_FOLD.put(0x1FA1, new int[]{0x1F61, 0x03B9});
        CASE_FOLD.put(0x1FA2, new int[]{0x1F62, 0x03B9});
        CASE_FOLD.put(0x1FA3, new int[]{0x1F63, 0x03B9});
        CASE_FOLD.put(0x1FA4, new int[]{0x1F64, 0x03B9});
        CASE_FOLD.put(0x1FA5, new int[]{0x1F65, 0x03B9});
        CASE_FOLD.put(0x1FA6, new int[]{0x1F66, 0x03B9});
        CASE_FOLD.put(0x1FA7, new int[]{0x1F67, 0x03B9});
        CASE_FOLD.put(0x1FA8, new int[]{0x1F60, 0x03B9});
        CASE_FOLD.put(0x1FA9, new int[]{0x1F61, 0x03B9});
        CASE_FOLD.put(0x1FAA, new int[]{0x1F62, 0x03B9});
        CASE_FOLD.put(0x1FAB, new int[]{0x1F63, 0x03B9});
        CASE_FOLD.put(0x1FAC, new int[]{0x1F64, 0x03B9});
        CASE_FOLD.put(0x1FAD, new int[]{0x1F65, 0x03B9});
        CASE_FOLD.put(0x1FAE, new int[]{0x1F66, 0x03B9});
        CASE_FOLD.put(0x1FAF, new int[]{0x1F67, 0x03B9});
        CASE_FOLD.put(0x1FB2, new int[]{0x1F70, 0x03B9});
        CASE_FOLD.put(0x1FB3, new int[]{0x03B1, 0x03B9});
        CASE_FOLD.put(0x1FB4, new int[]{0x03AC, 0x03B9});
        CASE_FOLD.put(0x1FB6, new int[]{0x03B1, 0x0342});
        CASE_FOLD.put(0x1FB7, new int[]{0x03B1, 0x0342, 0x03B9});
        CASE_FOLD.put(0x1FB8, new int[]{0x1FB0});
        CASE_FOLD.put(0x1FB9, new int[]{0x1FB1});
        CASE_FOLD.put(0x1FBA, new int[]{0x1F70});
        CASE_FOLD.put(0x1FBB, new int[]{0x1F71});
        CASE_FOLD.put(0x1FBC, new int[]{0x03B1, 0x03B9});
        CASE_FOLD.put(0x1FBE, new int[]{0x03B9});
        CASE_FOLD.put(0x1FC2, new int[]{0x1F74, 0x03B9});
        CASE_FOLD.put(0x1FC3, new int[]{0x03B7, 0x03B9});
        CASE_FOLD.put(0x1FC4, new int[]{0x03AE, 0x03B9});
        CASE_FOLD.put(0x1FC6, new int[]{0x03B7, 0x0342});
        CASE_FOLD.put(0x1FC7, new int[]{0x03B7, 0x0342, 0x03B9});
        CASE_FOLD.put(0x1FC8, new int[]{0x1F72});
        CASE_FOLD.put(0x1FC9, new int[]{0x1F73});
        CASE_FOLD.put(0x1FCA, new int[]{0x1F74});
        CASE_FOLD.put(0x1FCB, new int[]{0x1F75});
        CASE_FOLD.put(0x1FCC, new int[]{0x03B7, 0x03B9});
        CASE_FOLD.put(0x1FD2, new int[]{0x03B9, 0x0308, 0x0300});
        CASE_FOLD.put(0x1FD3, new int[]{0x03B9, 0x0308, 0x0301});
        CASE_FOLD.put(0x1FD6, new int[]{0x03B9, 0x0342});
        CASE_FOLD.put(0x1FD7, new int[]{0x03B9, 0x0308, 0x0342});
        CASE_FOLD.put(0x1FD8, new int[]{0x1FD0});
        CASE_FOLD.put(0x1FD9, new int[]{0x1FD1});
        CASE_FOLD.put(0x1FDA, new int[]{0x1F76});
        CASE_FOLD.put(0x1FDB, new int[]{0x1F77});
        CASE_FOLD.put(0x1FE2, new int[]{0x03C5, 0x0308, 0x0300});
        CASE_FOLD.put(0x1FE3, new int[]{0x03C5, 0x0308, 0x0301});
        CASE_FOLD.put(0x1FE4, new int[]{0x03C1, 0x0313});
        CASE_FOLD.put(0x1FE6, new int[]{0x03C5, 0x0342});
        CASE_FOLD.put(0x1FE7, new int[]{0x03C5, 0x0308, 0x0342});
        CASE_FOLD.put(0x1FE8, new int[]{0x1FE0});
        CASE_FOLD.put(0x1FE9, new int[]{0x1FE1});
        CASE_FOLD.put(0x1FEA, new int[]{0x1F7A});
        CASE_FOLD.put(0x1FEB, new int[]{0x1F7B});
        CASE_FOLD.put(0x1FEC, new int[]{0x1FE5});
        CASE_FOLD.put(0x1FF2, new int[]{0x1F7C, 0x03B9});
        CASE_FOLD.put(0x1FF3, new int[]{0x03C9, 0x03B9});
        CASE_FOLD.put(0x1FF4, new int[]{0x03CE, 0x03B9});
        CASE_FOLD.put(0x1FF6, new int[]{0x03C9, 0x0342});
        CASE_FOLD.put(0x1FF7, new int[]{0x03C9, 0x0342, 0x03B9});
        CASE_FOLD.put(0x1FF8, new int[]{0x1F78});
        CASE_FOLD.put(0x1FF9, new int[]{0x1F79});
        CASE_FOLD.put(0x1FFA, new int[]{0x1F7C});
        CASE_FOLD.put(0x1FFB, new int[]{0x1F7D});
        CASE_FOLD.put(0x1FFC, new int[]{0x03C9, 0x03B9});
        CASE_FOLD.put(0x2126, new int[]{0x03C9});
        CASE_FOLD.put(0x212A, new int[]{0x006B});
        CASE_FOLD.put(0x212B, new int[]{0x00E5});
        CASE_FOLD.put(0x2132, new int[]{0x214E});
        CASE_FOLD.put(0x2160, new int[]{0x2170});
        CASE_FOLD.put(0x2161, new int[]{0x2171});
        CASE_FOLD.put(0x2162, new int[]{0x2172});
        CASE_FOLD.put(0x2163, new int[]{0x2173});
        CASE_FOLD.put(0x2164, new int[]{0x2174});
        CASE_FOLD.put(0x2165, new int[]{0x2175});
        CASE_FOLD.put(0x2166, new int[]{0x2176});
        CASE_FOLD.put(0x2167, new int[]{0x2177});
        CASE_FOLD.put(0x2168, new int[]{0x2178});
        CASE_FOLD.put(0x2169, new int[]{0x2179});
        CASE_FOLD.put(0x216A, new int[]{0x217A});
        CASE_FOLD.put(0x216B, new int[]{0x217B});
        CASE_FOLD.put(0x216C, new int[]{0x217C});
        CASE_FOLD.put(0x216D, new int[]{0x217D});
        CASE_FOLD.put(0x216E, new int[]{0x217E});
        CASE_FOLD.put(0x216F, new int[]{0x217F});
        CASE_FOLD.put(0x2183, new int[]{0x2184});
        CASE_FOLD.put(0x24B6, new int[]{0x24D0});
        CASE_FOLD.put(0x24B7, new int[]{0x24D1});
        CASE_FOLD.put(0x24B8, new int[]{0x24D2});
        CASE_FOLD.put(0x24B9, new int[]{0x24D3});
        CASE_FOLD.put(0x24BA, new int[]{0x24D4});
        CASE_FOLD.put(0x24BB, new int[]{0x24D5});
        CASE_FOLD.put(0x24BC, new int[]{0x24D6});
        CASE_FOLD.put(0x24BD, new int[]{0x24D7});
        CASE_FOLD.put(0x24BE, new int[]{0x24D8});
        CASE_FOLD.put(0x24BF, new int[]{0x24D9});
        CASE_FOLD.put(0x24C0, new int[]{0x24DA});
        CASE_FOLD.put(0x24C1, new int[]{0x24DB});
        CASE_FOLD.put(0x24C2, new int[]{0x24DC});
        CASE_FOLD.put(0x24C3, new int[]{0x24DD});
        CASE_FOLD.put(0x24C4, new int[]{0x24DE});
        CASE_FOLD.put(0x24C5, new int[]{0x24DF});
        CASE_FOLD.put(0x24C6, new int[]{0x24E0});
        CASE_FOLD.put(0x24C7, new int[]{0x24E1});
        CASE_FOLD.put(0x24C8, new int[]{0x24E2});
        CASE_FOLD.put(0x24C9, new int[]{0x24E3});
        CASE_FOLD.put(0x24CA, new int[]{0x24E4});
        CASE_FOLD.put(0x24CB, new int[]{0x24E5});
        CASE_FOLD.put(0x24CC, new int[]{0x24E6});
        CASE_FOLD.put(0x24CD, new int[]{0x24E7});
        CASE_FOLD.put(0x24CE, new int[]{0x24E8});
        CASE_FOLD.put(0x24CF, new int[]{0x24E9});
        CASE_FOLD.put(0x2C00, new int[]{0x2C30});
        CASE_FOLD.put(0x2C01, new int[]{0x2C31});
        CASE_FOLD.put(0x2C02, new int[]{0x2C32});
        CASE_FOLD.put(0x2C03, new int[]{0x2C33});
        CASE_FOLD.put(0x2C04, new int[]{0x2C34});
        CASE_FOLD.put(0x2C05, new int[]{0x2C35});
        CASE_FOLD.put(0x2C06, new int[]{0x2C36});
        CASE_FOLD.put(0x2C07, new int[]{0x2C37});
        CASE_FOLD.put(0x2C08, new int[]{0x2C38});
        CASE_FOLD.put(0x2C09, new int[]{0x2C39});
        CASE_FOLD.put(0x2C0A, new int[]{0x2C3A});
        CASE_FOLD.put(0x2C0B, new int[]{0x2C3B});
        CASE_FOLD.put(0x2C0C, new int[]{0x2C3C});
        CASE_FOLD.put(0x2C0D, new int[]{0x2C3D});
        CASE_FOLD.put(0x2C0E, new int[]{0x2C3E});
        CASE_FOLD.put(0x2C0F, new int[]{0x2C3F});
        CASE_FOLD.put(0x2C10, new int[]{0x2C40});
        CASE_FOLD.put(0x2C11, new int[]{0x2C41});
        CASE_FOLD.put(0x2C12, new int[]{0x2C42});
        CASE_FOLD.put(0x2C13, new int[]{0x2C43});
        CASE_FOLD.put(0x2C14, new int[]{0x2C44});
        CASE_FOLD.put(0x2C15, new int[]{0x2C45});
        CASE_FOLD.put(0x2C16, new int[]{0x2C46});
        CASE_FOLD.put(0x2C17, new int[]{0x2C47});
        CASE_FOLD.put(0x2C18, new int[]{0x2C48});
        CASE_FOLD.put(0x2C19, new int[]{0x2C49});
        CASE_FOLD.put(0x2C1A, new int[]{0x2C4A});
        CASE_FOLD.put(0x2C1B, new int[]{0x2C4B});
        CASE_FOLD.put(0x2C1C, new int[]{0x2C4C});
        CASE_FOLD.put(0x2C1D, new int[]{0x2C4D});
        CASE_FOLD.put(0x2C1E, new int[]{0x2C4E});
        CASE_FOLD.put(0x2C1F, new int[]{0x2C4F});
        CASE_FOLD.put(0x2C20, new int[]{0x2C50});
        CASE_FOLD.put(0x2C21, new int[]{0x2C51});
        CASE_FOLD.put(0x2C22, new int[]{0x2C52});
        CASE_FOLD.put(0x2C23, new int[]{0x2C53});
        CASE_FOLD.put(0x2C24, new int[]{0x2C54});
        CASE_FOLD.put(0x2C25, new int[]{0x2C55});
        CASE_FOLD.put(0x2C26, new int[]{0x2C56});
        CASE_FOLD.put(0x2C27, new int[]{0x2C57});
        CASE_FOLD.put(0x2C28, new int[]{0x2C58});
        CASE_FOLD.put(0x2C29, new int[]{0x2C59});
        CASE_FOLD.put(0x2C2A, new int[]{0x2C5A});
        CASE_FOLD.put(0x2C2B, new int[]{0x2C5B});
        CASE_FOLD.put(0x2C2C, new int[]{0x2C5C});
        CASE_FOLD.put(0x2C2D, new int[]{0x2C5D});
        CASE_FOLD.put(0x2C2E, new int[]{0x2C5E});
        CASE_FOLD.put(0x2C60, new int[]{0x2C61});
        CASE_FOLD.put(0x2C62, new int[]{0x026B});
        CASE_FOLD.put(0x2C63, new int[]{0x1D7D});
        CASE_FOLD.put(0x2C64, new int[]{0x027D});
        CASE_FOLD.put(0x2C67, new int[]{0x2C68});
        CASE_FOLD.put(0x2C69, new int[]{0x2C6A});
        CASE_FOLD.put(0x2C6B, new int[]{0x2C6C});
        CASE_FOLD.put(0x2C6D, new int[]{0x0251});
        CASE_FOLD.put(0x2C6E, new int[]{0x0271});
        CASE_FOLD.put(0x2C6F, new int[]{0x0250});
        CASE_FOLD.put(0x2C70, new int[]{0x0252});
        CASE_FOLD.put(0x2C72, new int[]{0x2C73});
        CASE_FOLD.put(0x2C75, new int[]{0x2C76});
        CASE_FOLD.put(0x2C7E, new int[]{0x023F});
        CASE_FOLD.put(0x2C7F, new int[]{0x0240});
        CASE_FOLD.put(0x2C80, new int[]{0x2C81});
        CASE_FOLD.put(0x2C82, new int[]{0x2C83});
        CASE_FOLD.put(0x2C84, new int[]{0x2C85});
        CASE_FOLD.put(0x2C86, new int[]{0x2C87});
        CASE_FOLD.put(0x2C88, new int[]{0x2C89});
        CASE_FOLD.put(0x2C8A, new int[]{0x2C8B});
        CASE_FOLD.put(0x2C8C, new int[]{0x2C8D});
        CASE_FOLD.put(0x2C8E, new int[]{0x2C8F});
        CASE_FOLD.put(0x2C90, new int[]{0x2C91});
        CASE_FOLD.put(0x2C92, new int[]{0x2C93});
        CASE_FOLD.put(0x2C94, new int[]{0x2C95});
        CASE_FOLD.put(0x2C96, new int[]{0x2C97});
        CASE_FOLD.put(0x2C98, new int[]{0x2C99});
        CASE_FOLD.put(0x2C9A, new int[]{0x2C9B});
        CASE_FOLD.put(0x2C9C, new int[]{0x2C9D});
        CASE_FOLD.put(0x2C9E, new int[]{0x2C9F});
        CASE_FOLD.put(0x2CA0, new int[]{0x2CA1});
        CASE_FOLD.put(0x2CA2, new int[]{0x2CA3});
        CASE_FOLD.put(0x2CA4, new int[]{0x2CA5});
        CASE_FOLD.put(0x2CA6, new int[]{0x2CA7});
        CASE_FOLD.put(0x2CA8, new int[]{0x2CA9});
        CASE_FOLD.put(0x2CAA, new int[]{0x2CAB});
        CASE_FOLD.put(0x2CAC, new int[]{0x2CAD});
        CASE_FOLD.put(0x2CAE, new int[]{0x2CAF});
        CASE_FOLD.put(0x2CB0, new int[]{0x2CB1});
        CASE_FOLD.put(0x2CB2, new int[]{0x2CB3});
        CASE_FOLD.put(0x2CB4, new int[]{0x2CB5});
        CASE_FOLD.put(0x2CB6, new int[]{0x2CB7});
        CASE_FOLD.put(0x2CB8, new int[]{0x2CB9});
        CASE_FOLD.put(0x2CBA, new int[]{0x2CBB});
        CASE_FOLD.put(0x2CBC, new int[]{0x2CBD});
        CASE_FOLD.put(0x2CBE, new int[]{0x2CBF});
        CASE_FOLD.put(0x2CC0, new int[]{0x2CC1});
        CASE_FOLD.put(0x2CC2, new int[]{0x2CC3});
        CASE_FOLD.put(0x2CC4, new int[]{0x2CC5});
        CASE_FOLD.put(0x2CC6, new int[]{0x2CC7});
        CASE_FOLD.put(0x2CC8, new int[]{0x2CC9});
        CASE_FOLD.put(0x2CCA, new int[]{0x2CCB});
        CASE_FOLD.put(0x2CCC, new int[]{0x2CCD});
        CASE_FOLD.put(0x2CCE, new int[]{0x2CCF});
        CASE_FOLD.put(0x2CD0, new int[]{0x2CD1});
        CASE_FOLD.put(0x2CD2, new int[]{0x2CD3});
        CASE_FOLD.put(0x2CD4, new int[]{0x2CD5});
        CASE_FOLD.put(0x2CD6, new int[]{0x2CD7});
        CASE_FOLD.put(0x2CD8, new int[]{0x2CD9});
        CASE_FOLD.put(0x2CDA, new int[]{0x2CDB});
        CASE_FOLD.put(0x2CDC, new int[]{0x2CDD});
        CASE_FOLD.put(0x2CDE, new int[]{0x2CDF});
        CASE_FOLD.put(0x2CE0, new int[]{0x2CE1});
        CASE_FOLD.put(0x2CE2, new int[]{0x2CE3});
        CASE_FOLD.put(0x2CEB, new int[]{0x2CEC});
        CASE_FOLD.put(0x2CED, new int[]{0x2CEE});
        CASE_FOLD.put(0x2CF2, new int[]{0x2CF3});
        CASE_FOLD.put(0xA640, new int[]{0xA641});
        CASE_FOLD.put(0xA642, new int[]{0xA643});
        CASE_FOLD.put(0xA644, new int[]{0xA645});
        CASE_FOLD.put(0xA646, new int[]{0xA647});
        CASE_FOLD.put(0xA648, new int[]{0xA649});
        CASE_FOLD.put(0xA64A, new int[]{0xA64B});
        CASE_FOLD.put(0xA64C, new int[]{0xA64D});
        CASE_FOLD.put(0xA64E, new int[]{0xA64F});
        CASE_FOLD.put(0xA650, new int[]{0xA651});
        CASE_FOLD.put(0xA652, new int[]{0xA653});
        CASE_FOLD.put(0xA654, new int[]{0xA655});
        CASE_FOLD.put(0xA656, new int[]{0xA657});
        CASE_FOLD.put(0xA658, new int[]{0xA659});
        CASE_FOLD.put(0xA65A, new int[]{0xA65B});
        CASE_FOLD.put(0xA65C, new int[]{0xA65D});
        CASE_FOLD.put(0xA65E, new int[]{0xA65F});
        CASE_FOLD.put(0xA660, new int[]{0xA661});
        CASE_FOLD.put(0xA662, new int[]{0xA663});
        CASE_FOLD.put(0xA664, new int[]{0xA665});
        CASE_FOLD.put(0xA666, new int[]{0xA667});
        CASE_FOLD.put(0xA668, new int[]{0xA669});
        CASE_FOLD.put(0xA66A, new int[]{0xA66B});
        CASE_FOLD.put(0xA66C, new int[]{0xA66D});
        CASE_FOLD.put(0xA680, new int[]{0xA681});
        CASE_FOLD.put(0xA682, new int[]{0xA683});
        CASE_FOLD.put(0xA684, new int[]{0xA685});
        CASE_FOLD.put(0xA686, new int[]{0xA687});
        CASE_FOLD.put(0xA688, new int[]{0xA689});
        CASE_FOLD.put(0xA68A, new int[]{0xA68B});
        CASE_FOLD.put(0xA68C, new int[]{0xA68D});
        CASE_FOLD.put(0xA68E, new int[]{0xA68F});
        CASE_FOLD.put(0xA690, new int[]{0xA691});
        CASE_FOLD.put(0xA692, new int[]{0xA693});
        CASE_FOLD.put(0xA694, new int[]{0xA695});
        CASE_FOLD.put(0xA696, new int[]{0xA697});
        CASE_FOLD.put(0xA698, new int[]{0xA699});
        CASE_FOLD.put(0xA69A, new int[]{0xA69B});
        CASE_FOLD.put(0xA722, new int[]{0xA723});
        CASE_FOLD.put(0xA724, new int[]{0xA725});
        CASE_FOLD.put(0xA726, new int[]{0xA727});
        CASE_FOLD.put(0xA728, new int[]{0xA729});
        CASE_FOLD.put(0xA72A, new int[]{0xA72B});
        CASE_FOLD.put(0xA72C, new int[]{0xA72D});
        CASE_FOLD.put(0xA72E, new int[]{0xA72F});
        CASE_FOLD.put(0xA732, new int[]{0xA733});
        CASE_FOLD.put(0xA734, new int[]{0xA735});
        CASE_FOLD.put(0xA736, new int[]{0xA737});
        CASE_FOLD.put(0xA738, new int[]{0xA739});
        CASE_FOLD.put(0xA73A, new int[]{0xA73B});
        CASE_FOLD.put(0xA73C, new int[]{0xA73D});
        CASE_FOLD.put(0xA73E, new int[]{0xA73F});
        CASE_FOLD.put(0xA740, new int[]{0xA741});
        CASE_FOLD.put(0xA742, new int[]{0xA743});
        CASE_FOLD.put(0xA744, new int[]{0xA745});
        CASE_FOLD.put(0xA746, new int[]{0xA747});
        CASE_FOLD.put(0xA748, new int[]{0xA749});
        CASE_FOLD.put(0xA74A, new int[]{0xA74B});
        CASE_FOLD.put(0xA74C, new int[]{0xA74D});
        CASE_FOLD.put(0xA74E, new int[]{0xA74F});
        CASE_FOLD.put(0xA750, new int[]{0xA751});
        CASE_FOLD.put(0xA752, new int[]{0xA753});
        CASE_FOLD.put(0xA754, new int[]{0xA755});
        CASE_FOLD.put(0xA756, new int[]{0xA757});
        CASE_FOLD.put(0xA758, new int[]{0xA759});
        CASE_FOLD.put(0xA75A, new int[]{0xA75B});
        CASE_FOLD.put(0xA75C, new int[]{0xA75D});
        CASE_FOLD.put(0xA75E, new int[]{0xA75F});
        CASE_FOLD.put(0xA760, new int[]{0xA761});
        CASE_FOLD.put(0xA762, new int[]{0xA763});
        CASE_FOLD.put(0xA764, new int[]{0xA765});
        CASE_FOLD.put(0xA766, new int[]{0xA767});
        CASE_FOLD.put(0xA768, new int[]{0xA769});
        CASE_FOLD.put(0xA76A, new int[]{0xA76B});
        CASE_FOLD.put(0xA76C, new int[]{0xA76D});
        CASE_FOLD.put(0xA76E, new int[]{0xA76F});
        CASE_FOLD.put(0xA779, new int[]{0xA77A});
        CASE_FOLD.put(0xA77B, new int[]{0xA77C});
        CASE_FOLD.put(0xA77D, new int[]{0x1D79});
        CASE_FOLD.put(0xA77E, new int[]{0xA77F});
        CASE_FOLD.put(0xA780, new int[]{0xA781});
        CASE_FOLD.put(0xA782, new int[]{0xA783});
        CASE_FOLD.put(0xA784, new int[]{0xA785});
        CASE_FOLD.put(0xA786, new int[]{0xA787});
        CASE_FOLD.put(0xA78B, new int[]{0xA78C});
        CASE_FOLD.put(0xA78D, new int[]{0x0265});
        CASE_FOLD.put(0xA790, new int[]{0xA791});
        CASE_FOLD.put(0xA792, new int[]{0xA793});
        CASE_FOLD.put(0xA796, new int[]{0xA797});
        CASE_FOLD.put(0xA798, new int[]{0xA799});
        CASE_FOLD.put(0xA79A, new int[]{0xA79B});
        CASE_FOLD.put(0xA79C, new int[]{0xA79D});
        CASE_FOLD.put(0xA79E, new int[]{0xA79F});
        CASE_FOLD.put(0xA7A0, new int[]{0xA7A1});
        CASE_FOLD.put(0xA7A2, new int[]{0xA7A3});
        CASE_FOLD.put(0xA7A4, new int[]{0xA7A5});
        CASE_FOLD.put(0xA7A6, new int[]{0xA7A7});
        CASE_FOLD.put(0xA7A8, new int[]{0xA7A9});
        CASE_FOLD.put(0xA7AA, new int[]{0x0266});
        CASE_FOLD.put(0xA7AB, new int[]{0x025C});
        CASE_FOLD.put(0xA7AC, new int[]{0x0261});
        CASE_FOLD.put(0xA7AD, new int[]{0x026C});
        CASE_FOLD.put(0xA7AE, new int[]{0x026A});
        CASE_FOLD.put(0xA7B0, new int[]{0x029E});
        CASE_FOLD.put(0xA7B1, new int[]{0x0287});
        CASE_FOLD.put(0xA7B2, new int[]{0x029D});
        CASE_FOLD.put(0xA7B3, new int[]{0xAB53});
        CASE_FOLD.put(0xA7B4, new int[]{0xA7B5});
        CASE_FOLD.put(0xA7B6, new int[]{0xA7B7});
        CASE_FOLD.put(0xA7B8, new int[]{0xA7B9});
        CASE_FOLD.put(0xA7BA, new int[]{0xA7BB});
        CASE_FOLD.put(0xA7BC, new int[]{0xA7BD});
        CASE_FOLD.put(0xA7BE, new int[]{0xA7BF});
        CASE_FOLD.put(0xA7C2, new int[]{0xA7C3});
        CASE_FOLD.put(0xA7C4, new int[]{0xA794});
        CASE_FOLD.put(0xA7C5, new int[]{0x0282});
        CASE_FOLD.put(0xA7C6, new int[]{0x1D8E});
        CASE_FOLD.put(0xA7C7, new int[]{0xA7C8});
        CASE_FOLD.put(0xA7C9, new int[]{0xA7CA});
        CASE_FOLD.put(0xA7F5, new int[]{0xA7F6});
        CASE_FOLD.put(0xAB70, new int[]{0x13A0});
        CASE_FOLD.put(0xAB71, new int[]{0x13A1});
        CASE_FOLD.put(0xAB72, new int[]{0x13A2});
        CASE_FOLD.put(0xAB73, new int[]{0x13A3});
        CASE_FOLD.put(0xAB74, new int[]{0x13A4});
        CASE_FOLD.put(0xAB75, new int[]{0x13A5});
        CASE_FOLD.put(0xAB76, new int[]{0x13A6});
        CASE_FOLD.put(0xAB77, new int[]{0x13A7});
        CASE_FOLD.put(0xAB78, new int[]{0x13A8});
        CASE_FOLD.put(0xAB79, new int[]{0x13A9});
        CASE_FOLD.put(0xAB7A, new int[]{0x13AA});
        CASE_FOLD.put(0xAB7B, new int[]{0x13AB});
        CASE_FOLD.put(0xAB7C, new int[]{0x13AC});
        CASE_FOLD.put(0xAB7D, new int[]{0x13AD});
        CASE_FOLD.put(0xAB7E, new int[]{0x13AE});
        CASE_FOLD.put(0xAB7F, new int[]{0x13AF});
        CASE_FOLD.put(0xAB80, new int[]{0x13B0});
        CASE_FOLD.put(0xAB81, new int[]{0x13B1});
        CASE_FOLD.put(0xAB82, new int[]{0x13B2});
        CASE_FOLD.put(0xAB83, new int[]{0x13B3});
        CASE_FOLD.put(0xAB84, new int[]{0x13B4});
        CASE_FOLD.put(0xAB85, new int[]{0x13B5});
        CASE_FOLD.put(0xAB86, new int[]{0x13B6});
        CASE_FOLD.put(0xAB87, new int[]{0x13B7});
        CASE_FOLD.put(0xAB88, new int[]{0x13B8});
        CASE_FOLD.put(0xAB89, new int[]{0x13B9});
        CASE_FOLD.put(0xAB8A, new int[]{0x13BA});
        CASE_FOLD.put(0xAB8B, new int[]{0x13BB});
        CASE_FOLD.put(0xAB8C, new int[]{0x13BC});
        CASE_FOLD.put(0xAB8D, new int[]{0x13BD});
        CASE_FOLD.put(0xAB8E, new int[]{0x13BE});
        CASE_FOLD.put(0xAB8F, new int[]{0x13BF});
        CASE_FOLD.put(0xAB90, new int[]{0x13C0});
        CASE_FOLD.put(0xAB91, new int[]{0x13C1});
        CASE_FOLD.put(0xAB92, new int[]{0x13C2});
        CASE_FOLD.put(0xAB93, new int[]{0x13C3});
        CASE_FOLD.put(0xAB94, new int[]{0x13C4});
        CASE_FOLD.put(0xAB95, new int[]{0x13C5});
        CASE_FOLD.put(0xAB96, new int[]{0x13C6});
        CASE_FOLD.put(0xAB97, new int[]{0x13C7});
        CASE_FOLD.put(0xAB98, new int[]{0x13C8});
        CASE_FOLD.put(0xAB99, new int[]{0x13C9});
        CASE_FOLD.put(0xAB9A, new int[]{0x13CA});
        CASE_FOLD.put(0xAB9B, new int[]{0x13CB});
        CASE_FOLD.put(0xAB9C, new int[]{0x13CC});
        CASE_FOLD.put(0xAB9D, new int[]{0x13CD});
        CASE_FOLD.put(0xAB9E, new int[]{0x13CE});
        CASE_FOLD.put(0xAB9F, new int[]{0x13CF});
        CASE_FOLD.put(0xABA0, new int[]{0x13D0});
        CASE_FOLD.put(0xABA1, new int[]{0x13D1});
        CASE_FOLD.put(0xABA2, new int[]{0x13D2});
        CASE_FOLD.put(0xABA3, new int[]{0x13D3});
        CASE_FOLD.put(0xABA4, new int[]{0x13D4});
        CASE_FOLD.put(0xABA5, new int[]{0x13D5});
        CASE_FOLD.put(0xABA6, new int[]{0x13D6});
        CASE_FOLD.put(0xABA7, new int[]{0x13D7});
        CASE_FOLD.put(0xABA8, new int[]{0x13D8});
        CASE_FOLD.put(0xABA9, new int[]{0x13D9});
        CASE_FOLD.put(0xABAA, new int[]{0x13DA});
        CASE_FOLD.put(0xABAB, new int[]{0x13DB});
        CASE_FOLD.put(0xABAC, new int[]{0x13DC});
        CASE_FOLD.put(0xABAD, new int[]{0x13DD});
        CASE_FOLD.put(0xABAE, new int[]{0x13DE});
        CASE_FOLD.put(0xABAF, new int[]{0x13DF});
        CASE_FOLD.put(0xABB0, new int[]{0x13E0});
        CASE_FOLD.put(0xABB1, new int[]{0x13E1});
        CASE_FOLD.put(0xABB2, new int[]{0x13E2});
        CASE_FOLD.put(0xABB3, new int[]{0x13E3});
        CASE_FOLD.put(0xABB4, new int[]{0x13E4});
        CASE_FOLD.put(0xABB5, new int[]{0x13E5});
        CASE_FOLD.put(0xABB6, new int[]{0x13E6});
        CASE_FOLD.put(0xABB7, new int[]{0x13E7});
        CASE_FOLD.put(0xABB8, new int[]{0x13E8});
        CASE_FOLD.put(0xABB9, new int[]{0x13E9});
        CASE_FOLD.put(0xABBA, new int[]{0x13EA});
        CASE_FOLD.put(0xABBB, new int[]{0x13EB});
        CASE_FOLD.put(0xABBC, new int[]{0x13EC});
        CASE_FOLD.put(0xABBD, new int[]{0x13ED});
        CASE_FOLD.put(0xABBE, new int[]{0x13EE});
        CASE_FOLD.put(0xABBF, new int[]{0x13EF});
        CASE_FOLD.put(0xFB00, new int[]{0x0066, 0x0066});
        CASE_FOLD.put(0xFB01, new int[]{0x0066, 0x0069});
        CASE_FOLD.put(0xFB02, new int[]{0x0066, 0x006C});
        CASE_FOLD.put(0xFB03, new int[]{0x0066, 0x0066, 0x0069});
        CASE_FOLD.put(0xFB04, new int[]{0x0066, 0x0066, 0x006C});
        CASE_FOLD.put(0xFB05, new int[]{0x0073, 0x0074});
        CASE_FOLD.put(0xFB06, new int[]{0x0073, 0x0074});
        CASE_FOLD.put(0xFB13, new int[]{0x0574, 0x0576});
        CASE_FOLD.put(0xFB14, new int[]{0x0574, 0x0565});
        CASE_FOLD.put(0xFB15, new int[]{0x0574, 0x056B});
        CASE_FOLD.put(0xFB16, new int[]{0x057E, 0x0576});
        CASE_FOLD.put(0xFB17, new int[]{0x0574, 0x056D});
        CASE_FOLD.put(0xFF21, new int[]{0xFF41});
        CASE_FOLD.put(0xFF22, new int[]{0xFF42});
        CASE_FOLD.put(0xFF23, new int[]{0xFF43});
        CASE_FOLD.put(0xFF24, new int[]{0xFF44});
        CASE_FOLD.put(0xFF25, new int[]{0xFF45});
        CASE_FOLD.put(0xFF26, new int[]{0xFF46});
        CASE_FOLD.put(0xFF27, new int[]{0xFF47});
        CASE_FOLD.put(0xFF28, new int[]{0xFF48});
        CASE_FOLD.put(0xFF29, new int[]{0xFF49});
        CASE_FOLD.put(0xFF2A, new int[]{0xFF4A});
        CASE_FOLD.put(0xFF2B, new int[]{0xFF4B});
        CASE_FOLD.put(0xFF2C, new int[]{0xFF4C});
        CASE_FOLD.put(0xFF2D, new int[]{0xFF4D});
        CASE_FOLD.put(0xFF2E, new int[]{0xFF4E});
        CASE_FOLD.put(0xFF2F, new int[]{0xFF4F});
        CASE_FOLD.put(0xFF30, new int[]{0xFF50});
        CASE_FOLD.put(0xFF31, new int[]{0xFF51});
        CASE_FOLD.put(0xFF32, new int[]{0xFF52});
        CASE_FOLD.put(0xFF33, new int[]{0xFF53});
        CASE_FOLD.put(0xFF34, new int[]{0xFF54});
        CASE_FOLD.put(0xFF35, new int[]{0xFF55});
        CASE_FOLD.put(0xFF36, new int[]{0xFF56});
        CASE_FOLD.put(0xFF37, new int[]{0xFF57});
        CASE_FOLD.put(0xFF38, new int[]{0xFF58});
        CASE_FOLD.put(0xFF39, new int[]{0xFF59});
        CASE_FOLD.put(0xFF3A, new int[]{0xFF5A});
        CASE_FOLD.put(0x10400, new int[]{0x10428});
        CASE_FOLD.put(0x10401, new int[]{0x10429});
        CASE_FOLD.put(0x10402, new int[]{0x1042A});
        CASE_FOLD.put(0x10403, new int[]{0x1042B});
        CASE_FOLD.put(0x10404, new int[]{0x1042C});
        CASE_FOLD.put(0x10405, new int[]{0x1042D});
        CASE_FOLD.put(0x10406, new int[]{0x1042E});
        CASE_FOLD.put(0x10407, new int[]{0x1042F});
        CASE_FOLD.put(0x10408, new int[]{0x10430});
        CASE_FOLD.put(0x10409, new int[]{0x10431});
        CASE_FOLD.put(0x1040A, new int[]{0x10432});
        CASE_FOLD.put(0x1040B, new int[]{0x10433});
        CASE_FOLD.put(0x1040C, new int[]{0x10434});
        CASE_FOLD.put(0x1040D, new int[]{0x10435});
        CASE_FOLD.put(0x1040E, new int[]{0x10436});
        CASE_FOLD.put(0x1040F, new int[]{0x10437});
        CASE_FOLD.put(0x10410, new int[]{0x10438});
        CASE_FOLD.put(0x10411, new int[]{0x10439});
        CASE_FOLD.put(0x10412, new int[]{0x1043A});
        CASE_FOLD.put(0x10413, new int[]{0x1043B});
        CASE_FOLD.put(0x10414, new int[]{0x1043C});
        CASE_FOLD.put(0x10415, new int[]{0x1043D});
        CASE_FOLD.put(0x10416, new int[]{0x1043E});
        CASE_FOLD.put(0x10417, new int[]{0x1043F});
        CASE_FOLD.put(0x10418, new int[]{0x10440});
        CASE_FOLD.put(0x10419, new int[]{0x10441});
        CASE_FOLD.put(0x1041A, new int[]{0x10442});
        CASE_FOLD.put(0x1041B, new int[]{0x10443});
        CASE_FOLD.put(0x1041C, new int[]{0x10444});
        CASE_FOLD.put(0x1041D, new int[]{0x10445});
        CASE_FOLD.put(0x1041E, new int[]{0x10446});
        CASE_FOLD.put(0x1041F, new int[]{0x10447});
        CASE_FOLD.put(0x10420, new int[]{0x10448});
        CASE_FOLD.put(0x10421, new int[]{0x10449});
        CASE_FOLD.put(0x10422, new int[]{0x1044A});
        CASE_FOLD.put(0x10423, new int[]{0x1044B});
        CASE_FOLD.put(0x10424, new int[]{0x1044C});
        CASE_FOLD.put(0x10425, new int[]{0x1044D});
        CASE_FOLD.put(0x10426, new int[]{0x1044E});
        CASE_FOLD.put(0x10427, new int[]{0x1044F});
        CASE_FOLD.put(0x104B0, new int[]{0x104D8});
        CASE_FOLD.put(0x104B1, new int[]{0x104D9});
        CASE_FOLD.put(0x104B2, new int[]{0x104DA});
        CASE_FOLD.put(0x104B3, new int[]{0x104DB});
        CASE_FOLD.put(0x104B4, new int[]{0x104DC});
        CASE_FOLD.put(0x104B5, new int[]{0x104DD});
        CASE_FOLD.put(0x104B6, new int[]{0x104DE});
        CASE_FOLD.put(0x104B7, new int[]{0x104DF});
        CASE_FOLD.put(0x104B8, new int[]{0x104E0});
        CASE_FOLD.put(0x104B9, new int[]{0x104E1});
        CASE_FOLD.put(0x104BA, new int[]{0x104E2});
        CASE_FOLD.put(0x104BB, new int[]{0x104E3});
        CASE_FOLD.put(0x104BC, new int[]{0x104E4});
        CASE_FOLD.put(0x104BD, new int[]{0x104E5});
        CASE_FOLD.put(0x104BE, new int[]{0x104E6});
        CASE_FOLD.put(0x104BF, new int[]{0x104E7});
        CASE_FOLD.put(0x104C0, new int[]{0x104E8});
        CASE_FOLD.put(0x104C1, new int[]{0x104E9});
        CASE_FOLD.put(0x104C2, new int[]{0x104EA});
        CASE_FOLD.put(0x104C3, new int[]{0x104EB});
        CASE_FOLD.put(0x104C4, new int[]{0x104EC});
        CASE_FOLD.put(0x104C5, new int[]{0x104ED});
        CASE_FOLD.put(0x104C6, new int[]{0x104EE});
        CASE_FOLD.put(0x104C7, new int[]{0x104EF});
        CASE_FOLD.put(0x104C8, new int[]{0x104F0});
        CASE_FOLD.put(0x104C9, new int[]{0x104F1});
        CASE_FOLD.put(0x104CA, new int[]{0x104F2});
        CASE_FOLD.put(0x104CB, new int[]{0x104F3});
        CASE_FOLD.put(0x104CC, new int[]{0x104F4});
        CASE_FOLD.put(0x104CD, new int[]{0x104F5});
        CASE_FOLD.put(0x104CE, new int[]{0x104F6});
        CASE_FOLD.put(0x104CF, new int[]{0x104F7});
        CASE_FOLD.put(0x104D0, new int[]{0x104F8});
        CASE_FOLD.put(0x104D1, new int[]{0x104F9});
        CASE_FOLD.put(0x104D2, new int[]{0x104FA});
        CASE_FOLD.put(0x104D3, new int[]{0x104FB});
        CASE_FOLD.put(0x10C80, new int[]{0x10CC0});
        CASE_FOLD.put(0x10C81, new int[]{0x10CC1});
        CASE_FOLD.put(0x10C82, new int[]{0x10CC2});
        CASE_FOLD.put(0x10C83, new int[]{0x10CC3});
        CASE_FOLD.put(0x10C84, new int[]{0x10CC4});
        CASE_FOLD.put(0x10C85, new int[]{0x10CC5});
        CASE_FOLD.put(0x10C86, new int[]{0x10CC6});
        CASE_FOLD.put(0x10C87, new int[]{0x10CC7});
        CASE_FOLD.put(0x10C88, new int[]{0x10CC8});
        CASE_FOLD.put(0x10C89, new int[]{0x10CC9});
        CASE_FOLD.put(0x10C8A, new int[]{0x10CCA});
        CASE_FOLD.put(0x10C8B, new int[]{0x10CCB});
        CASE_FOLD.put(0x10C8C, new int[]{0x10CCC});
        CASE_FOLD.put(0x10C8D, new int[]{0x10CCD});
        CASE_FOLD.put(0x10C8E, new int[]{0x10CCE});
        CASE_FOLD.put(0x10C8F, new int[]{0x10CCF});
        CASE_FOLD.put(0x10C90, new int[]{0x10CD0});
        CASE_FOLD.put(0x10C91, new int[]{0x10CD1});
        CASE_FOLD.put(0x10C92, new int[]{0x10CD2});
        CASE_FOLD.put(0x10C93, new int[]{0x10CD3});
        CASE_FOLD.put(0x10C94, new int[]{0x10CD4});
        CASE_FOLD.put(0x10C95, new int[]{0x10CD5});
        CASE_FOLD.put(0x10C96, new int[]{0x10CD6});
        CASE_FOLD.put(0x10C97, new int[]{0x10CD7});
        CASE_FOLD.put(0x10C98, new int[]{0x10CD8});
        CASE_FOLD.put(0x10C99, new int[]{0x10CD9});
        CASE_FOLD.put(0x10C9A, new int[]{0x10CDA});
        CASE_FOLD.put(0x10C9B, new int[]{0x10CDB});
        CASE_FOLD.put(0x10C9C, new int[]{0x10CDC});
        CASE_FOLD.put(0x10C9D, new int[]{0x10CDD});
        CASE_FOLD.put(0x10C9E, new int[]{0x10CDE});
        CASE_FOLD.put(0x10C9F, new int[]{0x10CDF});
        CASE_FOLD.put(0x10CA0, new int[]{0x10CE0});
        CASE_FOLD.put(0x10CA1, new int[]{0x10CE1});
        CASE_FOLD.put(0x10CA2, new int[]{0x10CE2});
        CASE_FOLD.put(0x10CA3, new int[]{0x10CE3});
        CASE_FOLD.put(0x10CA4, new int[]{0x10CE4});
        CASE_FOLD.put(0x10CA5, new int[]{0x10CE5});
        CASE_FOLD.put(0x10CA6, new int[]{0x10CE6});
        CASE_FOLD.put(0x10CA7, new int[]{0x10CE7});
        CASE_FOLD.put(0x10CA8, new int[]{0x10CE8});
        CASE_FOLD.put(0x10CA9, new int[]{0x10CE9});
        CASE_FOLD.put(0x10CAA, new int[]{0x10CEA});
        CASE_FOLD.put(0x10CAB, new int[]{0x10CEB});
        CASE_FOLD.put(0x10CAC, new int[]{0x10CEC});
        CASE_FOLD.put(0x10CAD, new int[]{0x10CED});
        CASE_FOLD.put(0x10CAE, new int[]{0x10CEE});
        CASE_FOLD.put(0x10CAF, new int[]{0x10CEF});
        CASE_FOLD.put(0x10CB0, new int[]{0x10CF0});
        CASE_FOLD.put(0x10CB1, new int[]{0x10CF1});
        CASE_FOLD.put(0x10CB2, new int[]{0x10CF2});
        CASE_FOLD.put(0x118A0, new int[]{0x118C0});
        CASE_FOLD.put(0x118A1, new int[]{0x118C1});
        CASE_FOLD.put(0x118A2, new int[]{0x118C2});
        CASE_FOLD.put(0x118A3, new int[]{0x118C3});
        CASE_FOLD.put(0x118A4, new int[]{0x118C4});
        CASE_FOLD.put(0x118A5, new int[]{0x118C5});
        CASE_FOLD.put(0x118A6, new int[]{0x118C6});
        CASE_FOLD.put(0x118A7, new int[]{0x118C7});
        CASE_FOLD.put(0x118A8, new int[]{0x118C8});
        CASE_FOLD.put(0x118A9, new int[]{0x118C9});
        CASE_FOLD.put(0x118AA, new int[]{0x118CA});
        CASE_FOLD.put(0x118AB, new int[]{0x118CB});
        CASE_FOLD.put(0x118AC, new int[]{0x118CC});
        CASE_FOLD.put(0x118AD, new int[]{0x118CD});
        CASE_FOLD.put(0x118AE, new int[]{0x118CE});
        CASE_FOLD.put(0x118AF, new int[]{0x118CF});
        CASE_FOLD.put(0x118B0, new int[]{0x118D0});
        CASE_FOLD.put(0x118B1, new int[]{0x118D1});
        CASE_FOLD.put(0x118B2, new int[]{0x118D2});
        CASE_FOLD.put(0x118B3, new int[]{0x118D3});
        CASE_FOLD.put(0x118B4, new int[]{0x118D4});
        CASE_FOLD.put(0x118B5, new int[]{0x118D5});
        CASE_FOLD.put(0x118B6, new int[]{0x118D6});
        CASE_FOLD.put(0x118B7, new int[]{0x118D7});
        CASE_FOLD.put(0x118B8, new int[]{0x118D8});
        CASE_FOLD.put(0x118B9, new int[]{0x118D9});
        CASE_FOLD.put(0x118BA, new int[]{0x118DA});
        CASE_FOLD.put(0x118BB, new int[]{0x118DB});
        CASE_FOLD.put(0x118BC, new int[]{0x118DC});
        CASE_FOLD.put(0x118BD, new int[]{0x118DD});
        CASE_FOLD.put(0x118BE, new int[]{0x118DE});
        CASE_FOLD.put(0x118BF, new int[]{0x118DF});
        CASE_FOLD.put(0x16E40, new int[]{0x16E60});
        CASE_FOLD.put(0x16E41, new int[]{0x16E61});
        CASE_FOLD.put(0x16E42, new int[]{0x16E62});
        CASE_FOLD.put(0x16E43, new int[]{0x16E63});
        CASE_FOLD.put(0x16E44, new int[]{0x16E64});
        CASE_FOLD.put(0x16E45, new int[]{0x16E65});
        CASE_FOLD.put(0x16E46, new int[]{0x16E66});
        CASE_FOLD.put(0x16E47, new int[]{0x16E67});
        CASE_FOLD.put(0x16E48, new int[]{0x16E68});
        CASE_FOLD.put(0x16E49, new int[]{0x16E69});
        CASE_FOLD.put(0x16E4A, new int[]{0x16E6A});
        CASE_FOLD.put(0x16E4B, new int[]{0x16E6B});
        CASE_FOLD.put(0x16E4C, new int[]{0x16E6C});
        CASE_FOLD.put(0x16E4D, new int[]{0x16E6D});
        CASE_FOLD.put(0x16E4E, new int[]{0x16E6E});
        CASE_FOLD.put(0x16E4F, new int[]{0x16E6F});
        CASE_FOLD.put(0x16E50, new int[]{0x16E70});
        CASE_FOLD.put(0x16E51, new int[]{0x16E71});
        CASE_FOLD.put(0x16E52, new int[]{0x16E72});
        CASE_FOLD.put(0x16E53, new int[]{0x16E73});
        CASE_FOLD.put(0x16E54, new int[]{0x16E74});
        CASE_FOLD.put(0x16E55, new int[]{0x16E75});
        CASE_FOLD.put(0x16E56, new int[]{0x16E76});
        CASE_FOLD.put(0x16E57, new int[]{0x16E77});
        CASE_FOLD.put(0x16E58, new int[]{0x16E78});
        CASE_FOLD.put(0x16E59, new int[]{0x16E79});
        CASE_FOLD.put(0x16E5A, new int[]{0x16E7A});
        CASE_FOLD.put(0x16E5B, new int[]{0x16E7B});
        CASE_FOLD.put(0x16E5C, new int[]{0x16E7C});
        CASE_FOLD.put(0x16E5D, new int[]{0x16E7D});
        CASE_FOLD.put(0x16E5E, new int[]{0x16E7E});
        CASE_FOLD.put(0x16E5F, new int[]{0x16E7F});
        CASE_FOLD.put(0x1E900, new int[]{0x1E922});
        CASE_FOLD.put(0x1E901, new int[]{0x1E923});
        CASE_FOLD.put(0x1E902, new int[]{0x1E924});
        CASE_FOLD.put(0x1E903, new int[]{0x1E925});
        CASE_FOLD.put(0x1E904, new int[]{0x1E926});
        CASE_FOLD.put(0x1E905, new int[]{0x1E927});
        CASE_FOLD.put(0x1E906, new int[]{0x1E928});
        CASE_FOLD.put(0x1E907, new int[]{0x1E929});
        CASE_FOLD.put(0x1E908, new int[]{0x1E92A});
        CASE_FOLD.put(0x1E909, new int[]{0x1E92B});
        CASE_FOLD.put(0x1E90A, new int[]{0x1E92C});
        CASE_FOLD.put(0x1E90B, new int[]{0x1E92D});
        CASE_FOLD.put(0x1E90C, new int[]{0x1E92E});
        CASE_FOLD.put(0x1E90D, new int[]{0x1E92F});
        CASE_FOLD.put(0x1E90E, new int[]{0x1E930});
        CASE_FOLD.put(0x1E90F, new int[]{0x1E931});
        CASE_FOLD.put(0x1E910, new int[]{0x1E932});
        CASE_FOLD.put(0x1E911, new int[]{0x1E933});
        CASE_FOLD.put(0x1E912, new int[]{0x1E934});
        CASE_FOLD.put(0x1E913, new int[]{0x1E935});
        CASE_FOLD.put(0x1E914, new int[]{0x1E936});
        CASE_FOLD.put(0x1E915, new int[]{0x1E937});
        CASE_FOLD.put(0x1E916, new int[]{0x1E938});
        CASE_FOLD.put(0x1E917, new int[]{0x1E939});
        CASE_FOLD.put(0x1E918, new int[]{0x1E93A});
        CASE_FOLD.put(0x1E919, new int[]{0x1E93B});
        CASE_FOLD.put(0x1E91A, new int[]{0x1E93C});
        CASE_FOLD.put(0x1E91B, new int[]{0x1E93D});
        CASE_FOLD.put(0x1E91C, new int[]{0x1E93E});
        CASE_FOLD.put(0x1E91D, new int[]{0x1E93F});
        CASE_FOLD.put(0x1E91E, new int[]{0x1E940});
        CASE_FOLD.put(0x1E91F, new int[]{0x1E941});
        CASE_FOLD.put(0x1E920, new int[]{0x1E942});
        CASE_FOLD.put(0x1E921, new int[]{0x1E943});
    }
}
