/*
 * Copyright (c) 2022, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The Universal Permissive License (UPL), Version 1.0
 *
 * Subject to the condition set forth below, permission is hereby granted to any
 * person obtaining a copy of this software, associated documentation and/or
 * data (collectively the "Software"), free of charge and under any and all
 * copyright rights in the Software, and any and all patent rights owned or
 * freely licensable by each licensor hereunder covering either (i) the
 * unmodified Software as contributed to or provided by such licensor, or (ii)
 * the Larger Works (as defined below), to deal in both
 *
 * (a) the Software, and
 *
 * (b) any piece of software and/or hardware listed in the lrgrwrks.txt file if
 * one is included with the Software each a "Larger Work" to which the Software
 * is contributed by such licensors),
 *
 * without restriction, including without limitation the rights to copy, create
 * derivative works of, display, perform, and distribute the Software and make,
 * use, sell, offer for sale, import, export, have made, and have sold the
 * Software and the Larger Work(s), and to sublicense the foregoing rights on
 * either these or other terms.
 *
 * This license is subject to the following condition:
 *
 * The above copyright notice and either this complete permission notice or at a
 * minimum a reference to the UPL must be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
/* Copyright (c) 2022 Unicode, Inc.
 * Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
 * For terms of use, see http://www.unicode.org/terms_of_use.html
 */

package com.oracle.truffle.regex.chardata;

import org.graalvm.collections.EconomicMap;

public class UnicodeCharacterAliases {

    public static final EconomicMap<String, Integer> CHARACTER_ALIASES = EconomicMap.create(470);

    static {
        CHARACTER_ALIASES.put("ACK", 0x0006);
        CHARACTER_ALIASES.put("ACKNOWLEDGE", 0x0006);
        CHARACTER_ALIASES.put("ALERT", 0x0007);
        CHARACTER_ALIASES.put("ALM", 0x061C);
        CHARACTER_ALIASES.put("APC", 0x009F);
        CHARACTER_ALIASES.put("APPLICATION PROGRAM COMMAND", 0x009F);
        CHARACTER_ALIASES.put("BACKSPACE", 0x0008);
        CHARACTER_ALIASES.put("BEL", 0x0007);
        CHARACTER_ALIASES.put("BOM", 0xFEFF);
        CHARACTER_ALIASES.put("BPH", 0x0082);
        CHARACTER_ALIASES.put("BREAK PERMITTED HERE", 0x0082);
        CHARACTER_ALIASES.put("BS", 0x0008);
        CHARACTER_ALIASES.put("BYTE ORDER MARK", 0xFEFF);
        CHARACTER_ALIASES.put("BYZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS", 0x1D0C5);
        CHARACTER_ALIASES.put("CAN", 0x0018);
        CHARACTER_ALIASES.put("CANCEL", 0x0018);
        CHARACTER_ALIASES.put("CANCEL CHARACTER", 0x0094);
        CHARACTER_ALIASES.put("CARRIAGE RETURN", 0x000D);
        CHARACTER_ALIASES.put("CCH", 0x0094);
        CHARACTER_ALIASES.put("CGJ", 0x034F);
        CHARACTER_ALIASES.put("CHARACTER TABULATION", 0x0009);
        CHARACTER_ALIASES.put("CHARACTER TABULATION SET", 0x0088);
        CHARACTER_ALIASES.put("CHARACTER TABULATION WITH JUSTIFICATION", 0x0089);
        CHARACTER_ALIASES.put("CONTROL SEQUENCE INTRODUCER", 0x009B);
        CHARACTER_ALIASES.put("CR", 0x000D);
        CHARACTER_ALIASES.put("CSI", 0x009B);
        CHARACTER_ALIASES.put("CUNEIFORM SIGN NU11 OVER NU11 BUR OVER BUR", 0x122D5);
        CHARACTER_ALIASES.put("CUNEIFORM SIGN NU11 TENU", 0x122D4);
        CHARACTER_ALIASES.put("DATA LINK ESCAPE", 0x0010);
        CHARACTER_ALIASES.put("DC1", 0x0011);
        CHARACTER_ALIASES.put("DC2", 0x0012);
        CHARACTER_ALIASES.put("DC3", 0x0013);
        CHARACTER_ALIASES.put("DC4", 0x0014);
        CHARACTER_ALIASES.put("DCS", 0x0090);
        CHARACTER_ALIASES.put("DEL", 0x007F);
        CHARACTER_ALIASES.put("DELETE", 0x007F);
        CHARACTER_ALIASES.put("DEVICE CONTROL FOUR", 0x0014);
        CHARACTER_ALIASES.put("DEVICE CONTROL ONE", 0x0011);
        CHARACTER_ALIASES.put("DEVICE CONTROL STRING", 0x0090);
        CHARACTER_ALIASES.put("DEVICE CONTROL THREE", 0x0013);
        CHARACTER_ALIASES.put("DEVICE CONTROL TWO", 0x0012);
        CHARACTER_ALIASES.put("DLE", 0x0010);
        CHARACTER_ALIASES.put("END OF GUARDED AREA", 0x0097);
        CHARACTER_ALIASES.put("END OF LINE", 0x000A);
        CHARACTER_ALIASES.put("END OF MEDIUM", 0x0019);
        CHARACTER_ALIASES.put("END OF PROTECTED AREA", 0x0097);
        CHARACTER_ALIASES.put("END OF SELECTED AREA", 0x0087);
        CHARACTER_ALIASES.put("END OF TEXT", 0x0003);
        CHARACTER_ALIASES.put("END OF TRANSMISSION", 0x0004);
        CHARACTER_ALIASES.put("END OF TRANSMISSION BLOCK", 0x0017);
        CHARACTER_ALIASES.put("ENQ", 0x0005);
        CHARACTER_ALIASES.put("ENQUIRY", 0x0005);
        CHARACTER_ALIASES.put("EOL", 0x000A);
        CHARACTER_ALIASES.put("EOM", 0x0019);
        CHARACTER_ALIASES.put("EOT", 0x0004);
        CHARACTER_ALIASES.put("EPA", 0x0097);
        CHARACTER_ALIASES.put("ESA", 0x0087);
        CHARACTER_ALIASES.put("ESC", 0x001B);
        CHARACTER_ALIASES.put("ESCAPE", 0x001B);
        CHARACTER_ALIASES.put("ETB", 0x0017);
        CHARACTER_ALIASES.put("ETX", 0x0003);
        CHARACTER_ALIASES.put("FF", 0x000C);
        CHARACTER_ALIASES.put("FILE SEPARATOR", 0x001C);
        CHARACTER_ALIASES.put("FORM FEED", 0x000C);
        CHARACTER_ALIASES.put("FS", 0x001C);
        CHARACTER_ALIASES.put("FSI", 0x2068);
        CHARACTER_ALIASES.put("FVS1", 0x180B);
        CHARACTER_ALIASES.put("FVS2", 0x180C);
        CHARACTER_ALIASES.put("FVS3", 0x180D);
        CHARACTER_ALIASES.put("FVS4", 0x180F);
        CHARACTER_ALIASES.put("GROUP SEPARATOR", 0x001D);
        CHARACTER_ALIASES.put("GS", 0x001D);
        CHARACTER_ALIASES.put("HANGUL JONGSEONG SSANGYESIEUNG", 0x11EE);
        CHARACTER_ALIASES.put("HANGUL JONGSEONG YESIEUNG-KHIEUKH", 0x11EF);
        CHARACTER_ALIASES.put("HANGUL JONGSEONG YESIEUNG-KIYEOK", 0x11EC);
        CHARACTER_ALIASES.put("HANGUL JONGSEONG YESIEUNG-SSANGKIYEOK", 0x11ED);
        CHARACTER_ALIASES.put("HENTAIGANA LETTER E-1", 0x1B001);
        CHARACTER_ALIASES.put("HIGH OCTET PRESET", 0x0081);
        CHARACTER_ALIASES.put("HOP", 0x0081);
        CHARACTER_ALIASES.put("HORIZONTAL TABULATION", 0x0009);
        CHARACTER_ALIASES.put("HORIZONTAL TABULATION SET", 0x0088);
        CHARACTER_ALIASES.put("HORIZONTAL TABULATION WITH JUSTIFICATION", 0x0089);
        CHARACTER_ALIASES.put("HT", 0x0009);
        CHARACTER_ALIASES.put("HTJ", 0x0089);
        CHARACTER_ALIASES.put("HTS", 0x0088);
        CHARACTER_ALIASES.put("IND", 0x0084);
        CHARACTER_ALIASES.put("INDEX", 0x0084);
        CHARACTER_ALIASES.put("INFORMATION SEPARATOR FOUR", 0x001C);
        CHARACTER_ALIASES.put("INFORMATION SEPARATOR ONE", 0x001F);
        CHARACTER_ALIASES.put("INFORMATION SEPARATOR THREE", 0x001D);
        CHARACTER_ALIASES.put("INFORMATION SEPARATOR TWO", 0x001E);
        CHARACTER_ALIASES.put("KANNADA LETTER LLLA", 0x0CDE);
        CHARACTER_ALIASES.put("LAO LETTER FO FAY", 0x0E9F);
        CHARACTER_ALIASES.put("LAO LETTER FO FON", 0x0E9D);
        CHARACTER_ALIASES.put("LAO LETTER LO", 0x0EA5);
        CHARACTER_ALIASES.put("LAO LETTER RO", 0x0EA3);
        CHARACTER_ALIASES.put("LATIN CAPITAL LETTER GHA", 0x01A2);
        CHARACTER_ALIASES.put("LATIN SMALL LETTER GHA", 0x01A3);
        CHARACTER_ALIASES.put("LEFTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE VERTICAL STROKE", 0x2B7A);
        CHARACTER_ALIASES.put("LF", 0x000A);
        CHARACTER_ALIASES.put("LINE FEED", 0x000A);
        CHARACTER_ALIASES.put("LINE TABULATION", 0x000B);
        CHARACTER_ALIASES.put("LINE TABULATION SET", 0x008A);
        CHARACTER_ALIASES.put("LOCKING-SHIFT ONE", 0x000E);
        CHARACTER_ALIASES.put("LOCKING-SHIFT ZERO", 0x000F);
        CHARACTER_ALIASES.put("LRE", 0x202A);
        CHARACTER_ALIASES.put("LRI", 0x2066);
        CHARACTER_ALIASES.put("LRM", 0x200E);
        CHARACTER_ALIASES.put("LRO", 0x202D);
        CHARACTER_ALIASES.put("MEDEFAIDRIN CAPITAL LETTER H", 0x16E56);
        CHARACTER_ALIASES.put("MEDEFAIDRIN CAPITAL LETTER NG", 0x16E57);
        CHARACTER_ALIASES.put("MEDEFAIDRIN SMALL LETTER H", 0x16E76);
        CHARACTER_ALIASES.put("MEDEFAIDRIN SMALL LETTER NG", 0x16E77);
        CHARACTER_ALIASES.put("MESSAGE WAITING", 0x0095);
        CHARACTER_ALIASES.put("MICR DASH SYMBOL", 0x2449);
        CHARACTER_ALIASES.put("MICR ON US SYMBOL", 0x2448);
        CHARACTER_ALIASES.put("MMSP", 0x205F);
        CHARACTER_ALIASES.put("MVS", 0x180E);
        CHARACTER_ALIASES.put("MW", 0x0095);
        CHARACTER_ALIASES.put("MYANMAR LETTER KHAMTI LLA", 0xAA6E);
        CHARACTER_ALIASES.put("NAK", 0x0015);
        CHARACTER_ALIASES.put("NBH", 0x0083);
        CHARACTER_ALIASES.put("NBSP", 0x00A0);
        CHARACTER_ALIASES.put("NEGATIVE ACKNOWLEDGE", 0x0015);
        CHARACTER_ALIASES.put("NEL", 0x0085);
        CHARACTER_ALIASES.put("NEW LINE", 0x000A);
        CHARACTER_ALIASES.put("NEXT LINE", 0x0085);
        CHARACTER_ALIASES.put("NL", 0x000A);
        CHARACTER_ALIASES.put("NNBSP", 0x202F);
        CHARACTER_ALIASES.put("NO BREAK HERE", 0x0083);
        CHARACTER_ALIASES.put("NUL", 0x0000);
        CHARACTER_ALIASES.put("NULL", 0x0000);
        CHARACTER_ALIASES.put("OPERATING SYSTEM COMMAND", 0x009D);
        CHARACTER_ALIASES.put("OSC", 0x009D);
        CHARACTER_ALIASES.put("PAD", 0x0080);
        CHARACTER_ALIASES.put("PADDING CHARACTER", 0x0080);
        CHARACTER_ALIASES.put("PARTIAL LINE BACKWARD", 0x008C);
        CHARACTER_ALIASES.put("PARTIAL LINE DOWN", 0x008B);
        CHARACTER_ALIASES.put("PARTIAL LINE FORWARD", 0x008B);
        CHARACTER_ALIASES.put("PARTIAL LINE UP", 0x008C);
        CHARACTER_ALIASES.put("PDF", 0x202C);
        CHARACTER_ALIASES.put("PDI", 0x2069);
        CHARACTER_ALIASES.put("PLD", 0x008B);
        CHARACTER_ALIASES.put("PLU", 0x008C);
        CHARACTER_ALIASES.put("PM", 0x009E);
        CHARACTER_ALIASES.put("PRESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRACKET", 0xFE18);
        CHARACTER_ALIASES.put("PRIVACY MESSAGE", 0x009E);
        CHARACTER_ALIASES.put("PRIVATE USE ONE", 0x0091);
        CHARACTER_ALIASES.put("PRIVATE USE TWO", 0x0092);
        CHARACTER_ALIASES.put("PRIVATE USE-1", 0x0091);
        CHARACTER_ALIASES.put("PRIVATE USE-2", 0x0092);
        CHARACTER_ALIASES.put("PU1", 0x0091);
        CHARACTER_ALIASES.put("PU2", 0x0092);
        CHARACTER_ALIASES.put("RECORD SEPARATOR", 0x001E);
        CHARACTER_ALIASES.put("REVERSE INDEX", 0x008D);
        CHARACTER_ALIASES.put("REVERSE LINE FEED", 0x008D);
        CHARACTER_ALIASES.put("RI", 0x008D);
        CHARACTER_ALIASES.put("RIGHTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE VERTICAL STROKE", 0x2B7C);
        CHARACTER_ALIASES.put("RLE", 0x202B);
        CHARACTER_ALIASES.put("RLI", 0x2067);
        CHARACTER_ALIASES.put("RLM", 0x200F);
        CHARACTER_ALIASES.put("RLO", 0x202E);
        CHARACTER_ALIASES.put("RS", 0x001E);
        CHARACTER_ALIASES.put("SCI", 0x009A);
        CHARACTER_ALIASES.put("SET TRANSMIT STATE", 0x0093);
        CHARACTER_ALIASES.put("SGC", 0x0099);
        CHARACTER_ALIASES.put("SHIFT IN", 0x000F);
        CHARACTER_ALIASES.put("SHIFT OUT", 0x000E);
        CHARACTER_ALIASES.put("SHY", 0x00AD);
        CHARACTER_ALIASES.put("SI", 0x000F);
        CHARACTER_ALIASES.put("SINGLE CHARACTER INTRODUCER", 0x009A);
        CHARACTER_ALIASES.put("SINGLE GRAPHIC CHARACTER INTRODUCER", 0x0099);
        CHARACTER_ALIASES.put("SINGLE SHIFT THREE", 0x008F);
        CHARACTER_ALIASES.put("SINGLE SHIFT TWO", 0x008E);
        CHARACTER_ALIASES.put("SINGLE-SHIFT-2", 0x008E);
        CHARACTER_ALIASES.put("SINGLE-SHIFT-3", 0x008F);
        CHARACTER_ALIASES.put("SO", 0x000E);
        CHARACTER_ALIASES.put("SOH", 0x0001);
        CHARACTER_ALIASES.put("SOS", 0x0098);
        CHARACTER_ALIASES.put("SP", 0x0020);
        CHARACTER_ALIASES.put("SPA", 0x0096);
        CHARACTER_ALIASES.put("SS2", 0x008E);
        CHARACTER_ALIASES.put("SS3", 0x008F);
        CHARACTER_ALIASES.put("SSA", 0x0086);
        CHARACTER_ALIASES.put("ST", 0x009C);
        CHARACTER_ALIASES.put("START OF GUARDED AREA", 0x0096);
        CHARACTER_ALIASES.put("START OF HEADING", 0x0001);
        CHARACTER_ALIASES.put("START OF PROTECTED AREA", 0x0096);
        CHARACTER_ALIASES.put("START OF SELECTED AREA", 0x0086);
        CHARACTER_ALIASES.put("START OF STRING", 0x0098);
        CHARACTER_ALIASES.put("START OF TEXT", 0x0002);
        CHARACTER_ALIASES.put("STRING TERMINATOR", 0x009C);
        CHARACTER_ALIASES.put("STS", 0x0093);
        CHARACTER_ALIASES.put("STX", 0x0002);
        CHARACTER_ALIASES.put("SUB", 0x001A);
        CHARACTER_ALIASES.put("SUBSTITUTE", 0x001A);
        CHARACTER_ALIASES.put("SYN", 0x0016);
        CHARACTER_ALIASES.put("SYNCHRONOUS IDLE", 0x0016);
        CHARACTER_ALIASES.put("SYRIAC SUBLINEAR COLON SKEWED LEFT", 0x0709);
        CHARACTER_ALIASES.put("TAB", 0x0009);
        CHARACTER_ALIASES.put("TIBETAN MARK BKA- SHOG GI MGO RGYAN", 0x0FD0);
        CHARACTER_ALIASES.put("UNIT SEPARATOR", 0x001F);
        CHARACTER_ALIASES.put("US", 0x001F);
        CHARACTER_ALIASES.put("VERTICAL TABULATION", 0x000B);
        CHARACTER_ALIASES.put("VERTICAL TABULATION SET", 0x008A);
        CHARACTER_ALIASES.put("VS1", 0xFE00);
        CHARACTER_ALIASES.put("VS10", 0xFE09);
        CHARACTER_ALIASES.put("VS100", 0xE0153);
        CHARACTER_ALIASES.put("VS101", 0xE0154);
        CHARACTER_ALIASES.put("VS102", 0xE0155);
        CHARACTER_ALIASES.put("VS103", 0xE0156);
        CHARACTER_ALIASES.put("VS104", 0xE0157);
        CHARACTER_ALIASES.put("VS105", 0xE0158);
        CHARACTER_ALIASES.put("VS106", 0xE0159);
        CHARACTER_ALIASES.put("VS107", 0xE015A);
        CHARACTER_ALIASES.put("VS108", 0xE015B);
        CHARACTER_ALIASES.put("VS109", 0xE015C);
        CHARACTER_ALIASES.put("VS11", 0xFE0A);
        CHARACTER_ALIASES.put("VS110", 0xE015D);
        CHARACTER_ALIASES.put("VS111", 0xE015E);
        CHARACTER_ALIASES.put("VS112", 0xE015F);
        CHARACTER_ALIASES.put("VS113", 0xE0160);
        CHARACTER_ALIASES.put("VS114", 0xE0161);
        CHARACTER_ALIASES.put("VS115", 0xE0162);
        CHARACTER_ALIASES.put("VS116", 0xE0163);
        CHARACTER_ALIASES.put("VS117", 0xE0164);
        CHARACTER_ALIASES.put("VS118", 0xE0165);
        CHARACTER_ALIASES.put("VS119", 0xE0166);
        CHARACTER_ALIASES.put("VS12", 0xFE0B);
        CHARACTER_ALIASES.put("VS120", 0xE0167);
        CHARACTER_ALIASES.put("VS121", 0xE0168);
        CHARACTER_ALIASES.put("VS122", 0xE0169);
        CHARACTER_ALIASES.put("VS123", 0xE016A);
        CHARACTER_ALIASES.put("VS124", 0xE016B);
        CHARACTER_ALIASES.put("VS125", 0xE016C);
        CHARACTER_ALIASES.put("VS126", 0xE016D);
        CHARACTER_ALIASES.put("VS127", 0xE016E);
        CHARACTER_ALIASES.put("VS128", 0xE016F);
        CHARACTER_ALIASES.put("VS129", 0xE0170);
        CHARACTER_ALIASES.put("VS13", 0xFE0C);
        CHARACTER_ALIASES.put("VS130", 0xE0171);
        CHARACTER_ALIASES.put("VS131", 0xE0172);
        CHARACTER_ALIASES.put("VS132", 0xE0173);
        CHARACTER_ALIASES.put("VS133", 0xE0174);
        CHARACTER_ALIASES.put("VS134", 0xE0175);
        CHARACTER_ALIASES.put("VS135", 0xE0176);
        CHARACTER_ALIASES.put("VS136", 0xE0177);
        CHARACTER_ALIASES.put("VS137", 0xE0178);
        CHARACTER_ALIASES.put("VS138", 0xE0179);
        CHARACTER_ALIASES.put("VS139", 0xE017A);
        CHARACTER_ALIASES.put("VS14", 0xFE0D);
        CHARACTER_ALIASES.put("VS140", 0xE017B);
        CHARACTER_ALIASES.put("VS141", 0xE017C);
        CHARACTER_ALIASES.put("VS142", 0xE017D);
        CHARACTER_ALIASES.put("VS143", 0xE017E);
        CHARACTER_ALIASES.put("VS144", 0xE017F);
        CHARACTER_ALIASES.put("VS145", 0xE0180);
        CHARACTER_ALIASES.put("VS146", 0xE0181);
        CHARACTER_ALIASES.put("VS147", 0xE0182);
        CHARACTER_ALIASES.put("VS148", 0xE0183);
        CHARACTER_ALIASES.put("VS149", 0xE0184);
        CHARACTER_ALIASES.put("VS15", 0xFE0E);
        CHARACTER_ALIASES.put("VS150", 0xE0185);
        CHARACTER_ALIASES.put("VS151", 0xE0186);
        CHARACTER_ALIASES.put("VS152", 0xE0187);
        CHARACTER_ALIASES.put("VS153", 0xE0188);
        CHARACTER_ALIASES.put("VS154", 0xE0189);
        CHARACTER_ALIASES.put("VS155", 0xE018A);
        CHARACTER_ALIASES.put("VS156", 0xE018B);
        CHARACTER_ALIASES.put("VS157", 0xE018C);
        CHARACTER_ALIASES.put("VS158", 0xE018D);
        CHARACTER_ALIASES.put("VS159", 0xE018E);
        CHARACTER_ALIASES.put("VS16", 0xFE0F);
        CHARACTER_ALIASES.put("VS160", 0xE018F);
        CHARACTER_ALIASES.put("VS161", 0xE0190);
        CHARACTER_ALIASES.put("VS162", 0xE0191);
        CHARACTER_ALIASES.put("VS163", 0xE0192);
        CHARACTER_ALIASES.put("VS164", 0xE0193);
        CHARACTER_ALIASES.put("VS165", 0xE0194);
        CHARACTER_ALIASES.put("VS166", 0xE0195);
        CHARACTER_ALIASES.put("VS167", 0xE0196);
        CHARACTER_ALIASES.put("VS168", 0xE0197);
        CHARACTER_ALIASES.put("VS169", 0xE0198);
        CHARACTER_ALIASES.put("VS17", 0xE0100);
        CHARACTER_ALIASES.put("VS170", 0xE0199);
        CHARACTER_ALIASES.put("VS171", 0xE019A);
        CHARACTER_ALIASES.put("VS172", 0xE019B);
        CHARACTER_ALIASES.put("VS173", 0xE019C);
        CHARACTER_ALIASES.put("VS174", 0xE019D);
        CHARACTER_ALIASES.put("VS175", 0xE019E);
        CHARACTER_ALIASES.put("VS176", 0xE019F);
        CHARACTER_ALIASES.put("VS177", 0xE01A0);
        CHARACTER_ALIASES.put("VS178", 0xE01A1);
        CHARACTER_ALIASES.put("VS179", 0xE01A2);
        CHARACTER_ALIASES.put("VS18", 0xE0101);
        CHARACTER_ALIASES.put("VS180", 0xE01A3);
        CHARACTER_ALIASES.put("VS181", 0xE01A4);
        CHARACTER_ALIASES.put("VS182", 0xE01A5);
        CHARACTER_ALIASES.put("VS183", 0xE01A6);
        CHARACTER_ALIASES.put("VS184", 0xE01A7);
        CHARACTER_ALIASES.put("VS185", 0xE01A8);
        CHARACTER_ALIASES.put("VS186", 0xE01A9);
        CHARACTER_ALIASES.put("VS187", 0xE01AA);
        CHARACTER_ALIASES.put("VS188", 0xE01AB);
        CHARACTER_ALIASES.put("VS189", 0xE01AC);
        CHARACTER_ALIASES.put("VS19", 0xE0102);
        CHARACTER_ALIASES.put("VS190", 0xE01AD);
        CHARACTER_ALIASES.put("VS191", 0xE01AE);
        CHARACTER_ALIASES.put("VS192", 0xE01AF);
        CHARACTER_ALIASES.put("VS193", 0xE01B0);
        CHARACTER_ALIASES.put("VS194", 0xE01B1);
        CHARACTER_ALIASES.put("VS195", 0xE01B2);
        CHARACTER_ALIASES.put("VS196", 0xE01B3);
        CHARACTER_ALIASES.put("VS197", 0xE01B4);
        CHARACTER_ALIASES.put("VS198", 0xE01B5);
        CHARACTER_ALIASES.put("VS199", 0xE01B6);
        CHARACTER_ALIASES.put("VS2", 0xFE01);
        CHARACTER_ALIASES.put("VS20", 0xE0103);
        CHARACTER_ALIASES.put("VS200", 0xE01B7);
        CHARACTER_ALIASES.put("VS201", 0xE01B8);
        CHARACTER_ALIASES.put("VS202", 0xE01B9);
        CHARACTER_ALIASES.put("VS203", 0xE01BA);
        CHARACTER_ALIASES.put("VS204", 0xE01BB);
        CHARACTER_ALIASES.put("VS205", 0xE01BC);
        CHARACTER_ALIASES.put("VS206", 0xE01BD);
        CHARACTER_ALIASES.put("VS207", 0xE01BE);
        CHARACTER_ALIASES.put("VS208", 0xE01BF);
        CHARACTER_ALIASES.put("VS209", 0xE01C0);
        CHARACTER_ALIASES.put("VS21", 0xE0104);
        CHARACTER_ALIASES.put("VS210", 0xE01C1);
        CHARACTER_ALIASES.put("VS211", 0xE01C2);
        CHARACTER_ALIASES.put("VS212", 0xE01C3);
        CHARACTER_ALIASES.put("VS213", 0xE01C4);
        CHARACTER_ALIASES.put("VS214", 0xE01C5);
        CHARACTER_ALIASES.put("VS215", 0xE01C6);
        CHARACTER_ALIASES.put("VS216", 0xE01C7);
        CHARACTER_ALIASES.put("VS217", 0xE01C8);
        CHARACTER_ALIASES.put("VS218", 0xE01C9);
        CHARACTER_ALIASES.put("VS219", 0xE01CA);
        CHARACTER_ALIASES.put("VS22", 0xE0105);
        CHARACTER_ALIASES.put("VS220", 0xE01CB);
        CHARACTER_ALIASES.put("VS221", 0xE01CC);
        CHARACTER_ALIASES.put("VS222", 0xE01CD);
        CHARACTER_ALIASES.put("VS223", 0xE01CE);
        CHARACTER_ALIASES.put("VS224", 0xE01CF);
        CHARACTER_ALIASES.put("VS225", 0xE01D0);
        CHARACTER_ALIASES.put("VS226", 0xE01D1);
        CHARACTER_ALIASES.put("VS227", 0xE01D2);
        CHARACTER_ALIASES.put("VS228", 0xE01D3);
        CHARACTER_ALIASES.put("VS229", 0xE01D4);
        CHARACTER_ALIASES.put("VS23", 0xE0106);
        CHARACTER_ALIASES.put("VS230", 0xE01D5);
        CHARACTER_ALIASES.put("VS231", 0xE01D6);
        CHARACTER_ALIASES.put("VS232", 0xE01D7);
        CHARACTER_ALIASES.put("VS233", 0xE01D8);
        CHARACTER_ALIASES.put("VS234", 0xE01D9);
        CHARACTER_ALIASES.put("VS235", 0xE01DA);
        CHARACTER_ALIASES.put("VS236", 0xE01DB);
        CHARACTER_ALIASES.put("VS237", 0xE01DC);
        CHARACTER_ALIASES.put("VS238", 0xE01DD);
        CHARACTER_ALIASES.put("VS239", 0xE01DE);
        CHARACTER_ALIASES.put("VS24", 0xE0107);
        CHARACTER_ALIASES.put("VS240", 0xE01DF);
        CHARACTER_ALIASES.put("VS241", 0xE01E0);
        CHARACTER_ALIASES.put("VS242", 0xE01E1);
        CHARACTER_ALIASES.put("VS243", 0xE01E2);
        CHARACTER_ALIASES.put("VS244", 0xE01E3);
        CHARACTER_ALIASES.put("VS245", 0xE01E4);
        CHARACTER_ALIASES.put("VS246", 0xE01E5);
        CHARACTER_ALIASES.put("VS247", 0xE01E6);
        CHARACTER_ALIASES.put("VS248", 0xE01E7);
        CHARACTER_ALIASES.put("VS249", 0xE01E8);
        CHARACTER_ALIASES.put("VS25", 0xE0108);
        CHARACTER_ALIASES.put("VS250", 0xE01E9);
        CHARACTER_ALIASES.put("VS251", 0xE01EA);
        CHARACTER_ALIASES.put("VS252", 0xE01EB);
        CHARACTER_ALIASES.put("VS253", 0xE01EC);
        CHARACTER_ALIASES.put("VS254", 0xE01ED);
        CHARACTER_ALIASES.put("VS255", 0xE01EE);
        CHARACTER_ALIASES.put("VS256", 0xE01EF);
        CHARACTER_ALIASES.put("VS26", 0xE0109);
        CHARACTER_ALIASES.put("VS27", 0xE010A);
        CHARACTER_ALIASES.put("VS28", 0xE010B);
        CHARACTER_ALIASES.put("VS29", 0xE010C);
        CHARACTER_ALIASES.put("VS3", 0xFE02);
        CHARACTER_ALIASES.put("VS30", 0xE010D);
        CHARACTER_ALIASES.put("VS31", 0xE010E);
        CHARACTER_ALIASES.put("VS32", 0xE010F);
        CHARACTER_ALIASES.put("VS33", 0xE0110);
        CHARACTER_ALIASES.put("VS34", 0xE0111);
        CHARACTER_ALIASES.put("VS35", 0xE0112);
        CHARACTER_ALIASES.put("VS36", 0xE0113);
        CHARACTER_ALIASES.put("VS37", 0xE0114);
        CHARACTER_ALIASES.put("VS38", 0xE0115);
        CHARACTER_ALIASES.put("VS39", 0xE0116);
        CHARACTER_ALIASES.put("VS4", 0xFE03);
        CHARACTER_ALIASES.put("VS40", 0xE0117);
        CHARACTER_ALIASES.put("VS41", 0xE0118);
        CHARACTER_ALIASES.put("VS42", 0xE0119);
        CHARACTER_ALIASES.put("VS43", 0xE011A);
        CHARACTER_ALIASES.put("VS44", 0xE011B);
        CHARACTER_ALIASES.put("VS45", 0xE011C);
        CHARACTER_ALIASES.put("VS46", 0xE011D);
        CHARACTER_ALIASES.put("VS47", 0xE011E);
        CHARACTER_ALIASES.put("VS48", 0xE011F);
        CHARACTER_ALIASES.put("VS49", 0xE0120);
        CHARACTER_ALIASES.put("VS5", 0xFE04);
        CHARACTER_ALIASES.put("VS50", 0xE0121);
        CHARACTER_ALIASES.put("VS51", 0xE0122);
        CHARACTER_ALIASES.put("VS52", 0xE0123);
        CHARACTER_ALIASES.put("VS53", 0xE0124);
        CHARACTER_ALIASES.put("VS54", 0xE0125);
        CHARACTER_ALIASES.put("VS55", 0xE0126);
        CHARACTER_ALIASES.put("VS56", 0xE0127);
        CHARACTER_ALIASES.put("VS57", 0xE0128);
        CHARACTER_ALIASES.put("VS58", 0xE0129);
        CHARACTER_ALIASES.put("VS59", 0xE012A);
        CHARACTER_ALIASES.put("VS6", 0xFE05);
        CHARACTER_ALIASES.put("VS60", 0xE012B);
        CHARACTER_ALIASES.put("VS61", 0xE012C);
        CHARACTER_ALIASES.put("VS62", 0xE012D);
        CHARACTER_ALIASES.put("VS63", 0xE012E);
        CHARACTER_ALIASES.put("VS64", 0xE012F);
        CHARACTER_ALIASES.put("VS65", 0xE0130);
        CHARACTER_ALIASES.put("VS66", 0xE0131);
        CHARACTER_ALIASES.put("VS67", 0xE0132);
        CHARACTER_ALIASES.put("VS68", 0xE0133);
        CHARACTER_ALIASES.put("VS69", 0xE0134);
        CHARACTER_ALIASES.put("VS7", 0xFE06);
        CHARACTER_ALIASES.put("VS70", 0xE0135);
        CHARACTER_ALIASES.put("VS71", 0xE0136);
        CHARACTER_ALIASES.put("VS72", 0xE0137);
        CHARACTER_ALIASES.put("VS73", 0xE0138);
        CHARACTER_ALIASES.put("VS74", 0xE0139);
        CHARACTER_ALIASES.put("VS75", 0xE013A);
        CHARACTER_ALIASES.put("VS76", 0xE013B);
        CHARACTER_ALIASES.put("VS77", 0xE013C);
        CHARACTER_ALIASES.put("VS78", 0xE013D);
        CHARACTER_ALIASES.put("VS79", 0xE013E);
        CHARACTER_ALIASES.put("VS8", 0xFE07);
        CHARACTER_ALIASES.put("VS80", 0xE013F);
        CHARACTER_ALIASES.put("VS81", 0xE0140);
        CHARACTER_ALIASES.put("VS82", 0xE0141);
        CHARACTER_ALIASES.put("VS83", 0xE0142);
        CHARACTER_ALIASES.put("VS84", 0xE0143);
        CHARACTER_ALIASES.put("VS85", 0xE0144);
        CHARACTER_ALIASES.put("VS86", 0xE0145);
        CHARACTER_ALIASES.put("VS87", 0xE0146);
        CHARACTER_ALIASES.put("VS88", 0xE0147);
        CHARACTER_ALIASES.put("VS89", 0xE0148);
        CHARACTER_ALIASES.put("VS9", 0xFE08);
        CHARACTER_ALIASES.put("VS90", 0xE0149);
        CHARACTER_ALIASES.put("VS91", 0xE014A);
        CHARACTER_ALIASES.put("VS92", 0xE014B);
        CHARACTER_ALIASES.put("VS93", 0xE014C);
        CHARACTER_ALIASES.put("VS94", 0xE014D);
        CHARACTER_ALIASES.put("VS95", 0xE014E);
        CHARACTER_ALIASES.put("VS96", 0xE014F);
        CHARACTER_ALIASES.put("VS97", 0xE0150);
        CHARACTER_ALIASES.put("VS98", 0xE0151);
        CHARACTER_ALIASES.put("VS99", 0xE0152);
        CHARACTER_ALIASES.put("VT", 0x000B);
        CHARACTER_ALIASES.put("VTS", 0x008A);
        CHARACTER_ALIASES.put("WEIERSTRASS ELLIPTIC FUNCTION", 0x2118);
        CHARACTER_ALIASES.put("WJ", 0x2060);
        CHARACTER_ALIASES.put("YI SYLLABLE ITERATION MARK", 0xA015);
        CHARACTER_ALIASES.put("ZWJ", 0x200D);
        CHARACTER_ALIASES.put("ZWNBSP", 0xFEFF);
        CHARACTER_ALIASES.put("ZWNJ", 0x200C);
        CHARACTER_ALIASES.put("ZWSP", 0x200B);
    }
}
