/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractSavePersistentMethod;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.sitemesh.GrailsContentBufferingResponse;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.orm.hibernate4.support.OpenSessionInViewInterceptor;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.WebRequest;

public class GrailsOpenSessionInViewInterceptor
extends OpenSessionInViewInterceptor {
    protected static final String IS_FLOW_REQUEST_ATTRIBUTE = "org.codehaus.groovy.grails.webflow.flow_request";
    protected int flushMode = 1;

    public void preHandle(WebRequest request) throws DataAccessException {
        boolean isFlowRequest;
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        boolean bl = isFlowRequest = webRequest != null && webRequest.isFlowRequest();
        if (isFlowRequest) {
            webRequest.setAttribute(IS_FLOW_REQUEST_ATTRIBUTE, (Object)"true", 0);
        } else {
            super.preHandle(request);
            SessionFactory sessionFactory = this.getSessionFactory();
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
            if (sessionHolder != null) {
                Session session = sessionHolder.getSession();
                GrailsHibernateUtil.enableDynamicFilterEnablerIfPresent(sessionFactory, session);
            }
        }
    }

    protected Session openSession() throws DataAccessResourceFailureException {
        Session session = super.openSession();
        this.applyFlushMode(session);
        return session;
    }

    protected void applyFlushMode(Session session) {
        FlushMode hibernateFlushMode = FlushMode.AUTO;
        switch (this.getFlushMode()) {
            case 1: 
            case 2: {
                hibernateFlushMode = FlushMode.AUTO;
                break;
            }
            case 0: {
                hibernateFlushMode = FlushMode.MANUAL;
                break;
            }
            case 3: {
                hibernateFlushMode = FlushMode.COMMIT;
                break;
            }
            case 4: {
                hibernateFlushMode = FlushMode.ALWAYS;
            }
        }
        session.setFlushMode(hibernateFlushMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postHandle(WebRequest request, ModelMap model) throws DataAccessException {
        boolean isFlowRequest;
        boolean bl = isFlowRequest = request.getAttribute(IS_FLOW_REQUEST_ATTRIBUTE, 0) != null;
        if (isFlowRequest) {
            return;
        }
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory());
        Session session = sessionHolder != null ? sessionHolder.getSession() : null;
        try {
            super.postHandle(request, model);
            if (session != null && this.getFlushMode() != 0 && !FlushMode.isManualFlushMode((FlushMode)session.getFlushMode())) {
                this.logger.debug((Object)"Eagerly flushing Hibernate session");
                session.flush();
            }
        }
        finally {
            if (session != null) {
                session.setFlushMode(FlushMode.MANUAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(WebRequest request, Exception ex) throws DataAccessException {
        try {
            boolean isWebRequest;
            boolean bl = isWebRequest = request.getAttribute(IS_FLOW_REQUEST_ATTRIBUTE, 0) != null;
            if (isWebRequest) {
                return;
            }
            request = (WebRequest)RequestContextHolder.currentRequestAttributes();
            if (!(request instanceof GrailsWebRequest)) {
                super.afterCompletion(request, ex);
                return;
            }
            GrailsWebRequest webRequest = (GrailsWebRequest)request;
            HttpServletResponse response = webRequest.getCurrentResponse();
            GrailsContentBufferingResponse contentBufferingResponse = this.getContentBufferingResponse(response);
            if (contentBufferingResponse == null) {
                super.afterCompletion(request, ex);
                return;
            }
            if (!contentBufferingResponse.isActive()) {
                super.afterCompletion(request, ex);
                return;
            }
            try {
                Session session;
                SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory());
                if (sessionHolder != null && (session = sessionHolder.getSession()) != null) {
                    session.disconnect();
                }
            }
            catch (IllegalStateException e) {
                super.afterCompletion(request, ex);
            }
        }
        finally {
            AbstractSavePersistentMethod.clearDisabledValidations();
        }
    }

    protected GrailsContentBufferingResponse getContentBufferingResponse(HttpServletResponse response) {
        while (response instanceof HttpServletResponseWrapper) {
            if (response instanceof GrailsContentBufferingResponse) {
                return (GrailsContentBufferingResponse)response;
            }
            response = (HttpServletResponse)((HttpServletResponseWrapper)response).getResponse();
        }
        return null;
    }

    public void setFlushMode(int flushMode) {
        this.flushMode = flushMode;
    }

    public int getFlushMode() {
        return this.flushMode;
    }
}

