/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate;

import groovy.lang.GroovySystem;
import groovy.util.ConfigObject;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.groovy.grails.commons.AnnotationDomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.DomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.AbstractEventTriggeringInterceptor;
import org.codehaus.groovy.grails.orm.hibernate.HibernateDatastore;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.codehaus.groovy.grails.orm.hibernate.support.ClosureEventListener;
import org.codehaus.groovy.grails.orm.hibernate.support.SoftKey;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.ValidationEvent;
import org.hibernate.HibernateException;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.SaveOrUpdateEvent;
import org.springframework.context.ApplicationEvent;

public class EventTriggeringInterceptor
extends AbstractEventTriggeringInterceptor {
    protected transient ConcurrentMap<SoftKey<Class<?>>, ClosureEventListener> eventListeners = new ConcurrentHashMap();
    protected final GrailsDomainBinder domainBinder = new GrailsDomainBinder();

    public EventTriggeringInterceptor(HibernateDatastore datastore, ConfigObject co) {
        super((Datastore)datastore);
        Object failOnErrorConfig = co.flatten().get("grails.gorm.failOnError");
        if (failOnErrorConfig instanceof List) {
            this.failOnError = true;
            this.failOnErrorPackages = (List)failOnErrorConfig;
        } else {
            this.failOnError = DefaultTypeTransformation.castToBoolean(failOnErrorConfig);
        }
    }

    protected void onPersistenceEvent(AbstractPersistenceEvent event) {
        switch (event.getEventType()) {
            case PreInsert: {
                if (!this.onPreInsert((PreInsertEvent)event.getNativeEvent())) break;
                event.cancel();
                break;
            }
            case PostInsert: {
                this.onPostInsert((PostInsertEvent)event.getNativeEvent());
                break;
            }
            case PreUpdate: {
                if (!this.onPreUpdate((PreUpdateEvent)event.getNativeEvent())) break;
                event.cancel();
                break;
            }
            case PostUpdate: {
                this.onPostUpdate((PostUpdateEvent)event.getNativeEvent());
                break;
            }
            case PreDelete: {
                if (!this.onPreDelete((PreDeleteEvent)event.getNativeEvent())) break;
                event.cancel();
                break;
            }
            case PostDelete: {
                this.onPostDelete((PostDeleteEvent)event.getNativeEvent());
                break;
            }
            case PreLoad: {
                this.onPreLoad((PreLoadEvent)event.getNativeEvent());
                break;
            }
            case PostLoad: {
                this.onPostLoad((PostLoadEvent)event.getNativeEvent());
                break;
            }
            case SaveOrUpdate: {
                this.onSaveOrUpdate((SaveOrUpdateEvent)event.getNativeEvent());
                break;
            }
            case Validation: {
                this.onValidate((ValidationEvent)event);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected EventType: " + event.getEventType());
            }
        }
    }

    public void onSaveOrUpdate(SaveOrUpdateEvent event) throws HibernateException {
        ClosureEventListener eventListener = this.findEventListener(event.getObject());
        if (eventListener != null) {
            eventListener.onSaveOrUpdate(event);
        }
    }

    public void onPreLoad(PreLoadEvent event) {
        Object entity = event.getEntity();
        GrailsHibernateUtil.ensureCorrectGroovyMetaClass(entity, entity.getClass());
        ClosureEventListener eventListener = this.findEventListener(entity);
        if (eventListener != null) {
            eventListener.onPreLoad(event);
        }
    }

    public void onPostLoad(PostLoadEvent event) {
        ClosureEventListener eventListener = this.findEventListener(event.getEntity());
        if (eventListener != null) {
            eventListener.onPostLoad(event);
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        ClosureEventListener eventListener = this.findEventListener(event.getEntity());
        if (eventListener != null) {
            eventListener.onPostInsert(event);
        }
    }

    public boolean onPreInsert(PreInsertEvent event) {
        boolean evict = false;
        ClosureEventListener eventListener = this.findEventListener(event.getEntity());
        if (eventListener != null) {
            evict = eventListener.onPreInsert(event);
        }
        return evict;
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        boolean evict = false;
        ClosureEventListener eventListener = this.findEventListener(event.getEntity());
        if (eventListener != null) {
            evict = eventListener.onPreUpdate(event);
        }
        return evict;
    }

    public void onPostUpdate(PostUpdateEvent event) {
        ClosureEventListener eventListener = this.findEventListener(event.getEntity());
        if (eventListener != null) {
            eventListener.onPostUpdate(event);
        }
    }

    public boolean onPreDelete(PreDeleteEvent event) {
        boolean evict = false;
        ClosureEventListener eventListener = this.findEventListener(event.getEntity());
        if (eventListener != null) {
            evict = eventListener.onPreDelete(event);
        }
        return evict;
    }

    public void onPostDelete(PostDeleteEvent event) {
        ClosureEventListener eventListener = this.findEventListener(event.getEntity());
        if (eventListener != null) {
            eventListener.onPostDelete(event);
        }
    }

    public void onValidate(ValidationEvent event) {
        ClosureEventListener eventListener = this.findEventListener(event.getEntityObject());
        if (eventListener != null) {
            eventListener.onValidate(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClosureEventListener findEventListener(Object entity) {
        if (entity == null) {
            return null;
        }
        Class<?> clazz = entity.getClass();
        SoftKey key = new SoftKey(clazz);
        ClosureEventListener eventListener = (ClosureEventListener)this.eventListeners.get(key);
        if (eventListener != null) {
            return eventListener;
        }
        Boolean shouldTrigger = (Boolean)this.cachedShouldTrigger.get(key);
        if (shouldTrigger == null || shouldTrigger.booleanValue()) {
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                eventListener = (ClosureEventListener)this.eventListeners.get(key);
                if (eventListener == null) {
                    ClosureEventListener previous;
                    shouldTrigger = GroovySystem.getMetaClassRegistry().getMetaClass(entity.getClass()) != null && (DomainClassArtefactHandler.isDomainClass(clazz) || AnnotationDomainClassArtefactHandler.isJPADomainClass(clazz)) && this.isDefinedByCurrentDataStore(entity, this.domainBinder);
                    if (shouldTrigger.booleanValue() && (previous = this.eventListeners.putIfAbsent(key, eventListener = new ClosureEventListener(clazz, this.failOnError, this.failOnErrorPackages))) != null) {
                        eventListener = previous;
                    }
                    this.cachedShouldTrigger.put(key, shouldTrigger);
                }
            }
        }
        return eventListener;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return AbstractPersistenceEvent.class.isAssignableFrom(eventType);
    }

    protected List<String> getDatasourceNames(GrailsDomainClass dc) {
        return GrailsHibernateUtil.getDatasourceNames(dc);
    }
}

