/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import groovy.util.ConfigObject;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.orm.hibernate.exceptions.CouldNotDetermineHibernateDialectException;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.internal.StrategySelectorImpl;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.internal.DialectFactoryImpl;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfoSource;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HibernateDialectDetectorFactoryBean
implements FactoryBean<String>,
InitializingBean,
GrailsApplicationAware {
    private DataSource dataSource;
    private Properties vendorNameDialectMappings;
    private String hibernateDialectClassName;
    private Dialect hibernateDialect;
    private GrailsApplication grailsApplication;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setVendorNameDialectMappings(Properties mappings) {
        this.vendorNameDialectMappings = mappings;
    }

    public String getObject() {
        return this.hibernateDialectClassName;
    }

    public Class<String> getObjectType() {
        return String.class;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws MetaDataAccessException {
        Assert.notNull((Object)this.dataSource, (String)"Data source is not set!");
        Assert.notNull((Object)this.vendorNameDialectMappings, (String)"Vendor name/dialect mappings are not set!");
        Connection connection = null;
        String dbName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, (String)"getDatabaseProductName");
        try {
            connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
            try {
                ConfigObject config = this.grailsApplication == null ? null : this.grailsApplication.getConfig();
                Properties properties = config == null ? new Properties() : config.toProperties();
                DialectFactory dialectFactory = this.createDialectFactory();
                final Connection finalConnection = connection;
                DialectResolutionInfoSource infoSource = new DialectResolutionInfoSource(){

                    public DialectResolutionInfo getDialectResolutionInfo() {
                        try {
                            return new DatabaseMetaDataDialectResolutionInfoAdapter(finalConnection.getMetaData());
                        }
                        catch (SQLException e) {
                            throw new CouldNotDetermineHibernateDialectException("Could not determine Hibernate dialect", (Throwable)e);
                        }
                    }
                };
                this.hibernateDialect = dialectFactory.buildDialect((Map)properties, infoSource);
                this.hibernateDialectClassName = this.hibernateDialect.getClass().getName();
            }
            catch (HibernateException e) {
                this.hibernateDialectClassName = this.vendorNameDialectMappings.getProperty(dbName);
            }
            if (!StringUtils.hasText((String)this.hibernateDialectClassName)) {
                throw new CouldNotDetermineHibernateDialectException("Could not determine Hibernate dialect for database name [" + dbName + "]!");
            }
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
        }
    }

    protected DialectFactory createDialectFactory() {
        DialectFactoryImpl factory = new DialectFactoryImpl();
        factory.injectServices(new ServiceRegistryImplementor(){

            public <R extends Service> R getService(Class<R> serviceRole) {
                if (serviceRole == DialectResolver.class) {
                    return (R)new StandardDialectResolver();
                }
                if (serviceRole == StrategySelector.class) {
                    return (R)new StrategySelectorImpl((ClassLoaderService)new ClassLoaderServiceImpl(Thread.currentThread().getContextClassLoader()));
                }
                return null;
            }

            public <R extends Service> ServiceBinding<R> locateServiceBinding(Class<R> serviceRole) {
                return null;
            }

            public void destroy() {
            }

            public void registerChild(ServiceRegistryImplementor child) {
            }

            public void deRegisterChild(ServiceRegistryImplementor child) {
            }

            public ServiceRegistry getParentServiceRegistry() {
                return null;
            }
        });
        return factory;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }
}

