/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate;

import grails.gorm.MultiTenant;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import org.grails.datastore.gorm.events.AutoTimestampEventListener;
import org.grails.datastore.gorm.events.ConfigurableApplicationContextEventPublisher;
import org.grails.datastore.gorm.events.ConfigurableApplicationEventPublisher;
import org.grails.datastore.gorm.events.DefaultApplicationEventPublisher;
import org.grails.datastore.gorm.jdbc.connections.DataSourceSettings;
import org.grails.datastore.gorm.utils.ClasspathEntityScanner;
import org.grails.datastore.gorm.validation.constraints.MappingContextAwareConstraintFactory;
import org.grails.datastore.gorm.validation.constraints.builtin.UniqueConstraint;
import org.grails.datastore.gorm.validation.constraints.factory.ConstraintFactory;
import org.grails.datastore.gorm.validation.constraints.registry.ConstraintRegistry;
import org.grails.datastore.mapping.core.ConnectionNotFoundException;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.DatastoreUtils;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSourceFactory;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.core.connections.ConnectionSources;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesInitializer;
import org.grails.datastore.mapping.core.connections.DefaultConnectionSource;
import org.grails.datastore.mapping.core.connections.SingletonConnectionSources;
import org.grails.datastore.mapping.core.exceptions.ConfigurationException;
import org.grails.datastore.mapping.model.DatastoreConfigurationException;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.multitenancy.AllTenantsResolver;
import org.grails.datastore.mapping.multitenancy.MultiTenancySettings;
import org.grails.datastore.mapping.validation.ValidatorRegistry;
import org.grails.orm.hibernate.AbstractHibernateDatastore;
import org.grails.orm.hibernate.EventTriggeringInterceptor;
import org.grails.orm.hibernate.GrailsHibernateTemplate;
import org.grails.orm.hibernate.GrailsHibernateTransactionManager;
import org.grails.orm.hibernate.HibernateGormEnhancer;
import org.grails.orm.hibernate.HibernateSession;
import org.grails.orm.hibernate.IHibernateTemplate;
import org.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.grails.orm.hibernate.cfg.HibernateMappingContext;
import org.grails.orm.hibernate.connections.HibernateConnectionSource;
import org.grails.orm.hibernate.connections.HibernateConnectionSourceFactory;
import org.grails.orm.hibernate.connections.HibernateConnectionSourceSettings;
import org.grails.orm.hibernate.multitenancy.MultiTenantEventListener;
import org.grails.orm.hibernate.support.ClosureEventTriggeringInterceptor;
import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.transaction.PlatformTransactionManager;

public class HibernateDatastore
extends AbstractHibernateDatastore {
    protected final GrailsHibernateTransactionManager transactionManager;
    protected ConfigurableApplicationEventPublisher eventPublisher;
    protected final HibernateGormEnhancer gormEnhancer;
    protected final Map<String, HibernateDatastore> datastoresByConnectionSource = new LinkedHashMap<String, HibernateDatastore>();

    public HibernateDatastore(ConnectionSources<SessionFactory, HibernateConnectionSourceSettings> connectionSources, HibernateMappingContext mappingContext, ConfigurableApplicationEventPublisher eventPublisher) {
        super(connectionSources, mappingContext);
        GrailsHibernateTransactionManager hibernateTransactionManager = new GrailsHibernateTransactionManager();
        HibernateConnectionSource defaultConnectionSource = (HibernateConnectionSource)connectionSources.getDefaultConnectionSource();
        hibernateTransactionManager.setDataSource(defaultConnectionSource.getDataSource());
        hibernateTransactionManager.setSessionFactory((SessionFactory)defaultConnectionSource.getSource());
        this.transactionManager = hibernateTransactionManager;
        this.eventPublisher = eventPublisher;
        this.eventTriggeringInterceptor = new EventTriggeringInterceptor((AbstractHibernateDatastore)this);
        this.autoTimestampEventListener = new AutoTimestampEventListener((Datastore)this);
        HibernateConnectionSourceSettings.HibernateSettings hibernateSettings = ((HibernateConnectionSourceSettings)defaultConnectionSource.getSettings()).getHibernate();
        ClosureEventTriggeringInterceptor interceptor = (ClosureEventTriggeringInterceptor)hibernateSettings.getEventTriggeringInterceptor();
        interceptor.setDatastore((AbstractHibernateDatastore)this);
        interceptor.setEventPublisher(eventPublisher);
        this.registerEventListeners(this.eventPublisher);
        this.configureValidatorRegistry((HibernateConnectionSourceSettings)defaultConnectionSource.getSettings(), mappingContext);
        this.mappingContext.addMappingContextListener(new MappingContext.Listener(){

            public void persistentEntityAdded(PersistentEntity entity) {
                HibernateDatastore.this.gormEnhancer.registerEntity(entity);
            }
        });
        this.initializeConverters(this.mappingContext);
        if (!(connectionSources instanceof SingletonConnectionSources)) {
            Iterable allConnectionSources = connectionSources.getAllConnectionSources();
            for (ConnectionSource connectionSource : allConnectionSources) {
                SingletonConnectionSources singletonConnectionSources = new SingletonConnectionSources(connectionSource, connectionSources.getBaseConfiguration());
                HibernateDatastore childDatastore = "DEFAULT".equals(connectionSource.getName()) ? this : new HibernateDatastore((ConnectionSources)singletonConnectionSources, mappingContext, eventPublisher){

                    @Override
                    protected HibernateGormEnhancer initialize() {
                        return null;
                    }
                };
                this.datastoresByConnectionSource.put(connectionSource.getName(), childDatastore);
            }
            if (this.multiTenantMode == MultiTenancySettings.MultiTenancyMode.SCHEMA) {
                if (this.tenantResolver instanceof AllTenantsResolver) {
                    AllTenantsResolver allTenantsResolver = (AllTenantsResolver)this.tenantResolver;
                    Iterable tenantIds = allTenantsResolver.resolveTenantIds();
                    for (Serializable tenantId : tenantIds) {
                        this.addTenantForSchemaInternal(tenantId.toString());
                    }
                } else {
                    Collection allSchemas = this.schemaHandler.resolveSchemaNames(defaultConnectionSource.getDataSource());
                    for (String schema : allSchemas) {
                        this.addTenantForSchemaInternal(schema);
                    }
                }
            }
        }
        this.gormEnhancer = this.initialize();
    }

    public HibernateDatastore(PropertyResolver configuration, HibernateConnectionSourceFactory connectionSourceFactory, ConfigurableApplicationEventPublisher eventPublisher) {
        this((ConnectionSources<SessionFactory, HibernateConnectionSourceSettings>)ConnectionSourcesInitializer.create((ConnectionSourceFactory)connectionSourceFactory, (PropertyResolver)DatastoreUtils.preparePropertyResolver((PropertyResolver)configuration, (String[])new String[]{"grails", "hibernate", "dataSource"})), connectionSourceFactory.getMappingContext(), eventPublisher);
    }

    public HibernateDatastore(PropertyResolver configuration, HibernateConnectionSourceFactory connectionSourceFactory) {
        this((ConnectionSources<SessionFactory, HibernateConnectionSourceSettings>)ConnectionSourcesInitializer.create((ConnectionSourceFactory)connectionSourceFactory, (PropertyResolver)DatastoreUtils.preparePropertyResolver((PropertyResolver)configuration, (String[])new String[]{"grails", "hibernate", "dataSource"})), connectionSourceFactory.getMappingContext(), (ConfigurableApplicationEventPublisher)new DefaultApplicationEventPublisher());
    }

    public HibernateDatastore(PropertyResolver configuration, ConfigurableApplicationEventPublisher eventPublisher, Class ... classes) {
        this(configuration, new HibernateConnectionSourceFactory(classes), eventPublisher);
    }

    public HibernateDatastore(PropertyResolver configuration, Class ... classes) {
        this(configuration, new HibernateConnectionSourceFactory(classes));
    }

    public HibernateDatastore(Class ... classes) {
        this(DatastoreUtils.createPropertyResolver(Collections.singletonMap("dataSource.dbCreate", "create-drop")), new HibernateConnectionSourceFactory(classes));
    }

    public HibernateDatastore(Package ... packagesToScan) {
        this(new ClasspathEntityScanner().scan(packagesToScan));
    }

    public HibernateDatastore(PropertyResolver configuration, Package ... packagesToScan) {
        this(configuration, new ClasspathEntityScanner().scan(packagesToScan));
    }

    public HibernateDatastore(Map<String, Object> configuration, Package ... packagesToScan) {
        this(DatastoreUtils.createPropertyResolver(configuration), packagesToScan);
    }

    public HibernateDatastore(Map<String, Object> configuration, Class ... classes) {
        this(DatastoreUtils.createPropertyResolver(configuration), classes);
    }

    public HibernateDatastore(PropertyResolver configuration, ConfigurableApplicationEventPublisher eventPublisher, Package ... packagesToScan) {
        this(configuration, eventPublisher, new ClasspathEntityScanner().scan(packagesToScan));
    }

    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.eventPublisher;
    }

    public GrailsHibernateTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public HibernateDatastore getDatastoreForConnection(String connectionName) {
        if (connectionName.equals("dataSource") || connectionName.equals("DEFAULT")) {
            return this;
        }
        HibernateDatastore hibernateDatastore = this.datastoresByConnectionSource.get(connectionName);
        if (hibernateDatastore == null) {
            throw new ConfigurationException("DataSource not found for name [" + connectionName + "] in configuration. Please check your multiple data sources configuration and try again.");
        }
        return hibernateDatastore;
    }

    protected void registerEventListeners(ConfigurableApplicationEventPublisher eventPublisher) {
        eventPublisher.addApplicationListener((ApplicationListener)this.autoTimestampEventListener);
        if (this.multiTenantMode == MultiTenancySettings.MultiTenancyMode.DISCRIMINATOR) {
            eventPublisher.addApplicationListener((ApplicationListener)new MultiTenantEventListener());
        }
        eventPublisher.addApplicationListener((ApplicationListener)this.eventTriggeringInterceptor);
    }

    protected HibernateGormEnhancer initialize() {
        final HibernateConnectionSource defaultConnectionSource = (HibernateConnectionSource)this.getConnectionSources().getDefaultConnectionSource();
        if (this.multiTenantMode == MultiTenancySettings.MultiTenancyMode.SCHEMA) {
            return new HibernateGormEnhancer((Datastore)this, (PlatformTransactionManager)this.transactionManager, this.getConnectionSources().getDefaultConnectionSource().getSettings()){

                public List<String> allQualifiers(Datastore datastore, PersistentEntity entity) {
                    List allQualifiers;
                    block5: {
                        allQualifiers = super.allQualifiers(datastore, entity);
                        if (!MultiTenant.class.isAssignableFrom(entity.getJavaClass())) break block5;
                        if (HibernateDatastore.this.tenantResolver instanceof AllTenantsResolver) {
                            Iterable tenantIds = ((AllTenantsResolver)HibernateDatastore.this.tenantResolver).resolveTenantIds();
                            for (Serializable id : tenantIds) {
                                allQualifiers.add(id.toString());
                            }
                        } else {
                            Collection schemaNames = HibernateDatastore.this.schemaHandler.resolveSchemaNames(defaultConnectionSource.getDataSource());
                            for (String schemaName : schemaNames) {
                                if (schemaName.equals("INFORMATION_SCHEMA") || schemaName.equals("PUBLIC")) continue;
                                for (String connectionName : HibernateDatastore.this.datastoresByConnectionSource.keySet()) {
                                    if (!schemaName.equalsIgnoreCase(connectionName)) continue;
                                    allQualifiers.add(connectionName);
                                }
                            }
                        }
                    }
                    return allQualifiers;
                }
            };
        }
        return new HibernateGormEnhancer((Datastore)this, (PlatformTransactionManager)this.transactionManager, this.getConnectionSources().getDefaultConnectionSource().getSettings());
    }

    protected void configureValidatorRegistry(HibernateConnectionSourceSettings settings, HibernateMappingContext mappingContext) {
        StaticMessageSource messageSource = new StaticMessageSource();
        ValidatorRegistry defaultValidatorRegistry = this.createValidatorRegistry((MessageSource)messageSource);
        this.configureValidatorRegistry(settings, mappingContext, defaultValidatorRegistry, (MessageSource)messageSource);
    }

    protected void configureValidatorRegistry(HibernateConnectionSourceSettings settings, HibernateMappingContext mappingContext, ValidatorRegistry validatorRegistry, MessageSource messageSource) {
        if (validatorRegistry instanceof ConstraintRegistry) {
            ((ConstraintRegistry)validatorRegistry).addConstraintFactory((ConstraintFactory)new MappingContextAwareConstraintFactory(UniqueConstraint.class, messageSource, (MappingContext)mappingContext));
        }
        mappingContext.setValidatorRegistry(validatorRegistry);
    }

    protected Session createSession(PropertyResolver connectionDetails) {
        return new HibernateSession(this, this.sessionFactory);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            super.setApplicationContext(applicationContext);
            for (HibernateDatastore hibernateDatastore : this.datastoresByConnectionSource.values()) {
                if (hibernateDatastore == this) continue;
                hibernateDatastore.setApplicationContext(applicationContext);
            }
            this.eventPublisher = new ConfigurableApplicationContextEventPublisher((ConfigurableApplicationContext)applicationContext);
            HibernateConnectionSourceSettings settings = (HibernateConnectionSourceSettings)this.getConnectionSources().getDefaultConnectionSource().getSettings();
            HibernateConnectionSourceSettings.HibernateSettings hibernateSettings = settings.getHibernate();
            ClosureEventTriggeringInterceptor interceptor = (ClosureEventTriggeringInterceptor)hibernateSettings.getEventTriggeringInterceptor();
            interceptor.setDatastore((AbstractHibernateDatastore)this);
            interceptor.setEventPublisher(this.eventPublisher);
            MappingContext mappingContext = this.getMappingContext();
            ValidatorRegistry validatorRegistry = this.createValidatorRegistry((MessageSource)applicationContext);
            this.configureValidatorRegistry(settings, (HibernateMappingContext)mappingContext, validatorRegistry, (MessageSource)applicationContext);
            mappingContext.setValidatorRegistry(validatorRegistry);
            this.registerEventListeners(this.eventPublisher);
        }
    }

    @Autowired(required=false)
    public void setMessageSource(MessageSource messageSource) {
        HibernateMappingContext mappingContext = (HibernateMappingContext)this.getMappingContext();
        ValidatorRegistry validatorRegistry = this.createValidatorRegistry(messageSource);
        HibernateConnectionSourceSettings settings = (HibernateConnectionSourceSettings)this.getConnectionSources().getDefaultConnectionSource().getSettings();
        this.configureValidatorRegistry(settings, mappingContext, validatorRegistry, messageSource);
    }

    public IHibernateTemplate getHibernateTemplate(int flushMode) {
        return new GrailsHibernateTemplate(this.getSessionFactory(), this, flushMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withFlushMode(AbstractHibernateDatastore.FlushMode flushMode, Callable<Boolean> callable) {
        org.hibernate.Session session = this.sessionFactory.getCurrentSession();
        FlushMode previousMode = null;
        Boolean reset = true;
        try {
            if (session != null) {
                previousMode = session.getFlushMode();
                session.setFlushMode(FlushMode.valueOf((String)flushMode.name()));
            }
            try {
                reset = callable.call();
            }
            catch (Exception e) {
                reset = false;
            }
        }
        finally {
            if (session != null && previousMode != null && reset.booleanValue()) {
                session.setFlushMode(previousMode);
            }
        }
    }

    public org.hibernate.Session openSession() {
        return this.sessionFactory.openSession();
    }

    public Session getCurrentSession() throws ConnectionNotFoundException {
        return new HibernateSession(this, this.sessionFactory, this.getDefaultFlushMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        try {
            super.destroy();
        }
        finally {
            GrailsDomainBinder.clearMappingCache();
            this.gormEnhancer.close();
        }
    }

    public void addTenantForSchema(String schemaName) {
        this.addTenantForSchemaInternal(schemaName);
        for (PersistentEntity persistentEntity : this.mappingContext.getPersistentEntities()) {
            this.gormEnhancer.registerEntity(persistentEntity);
        }
    }

    private void addTenantForSchemaInternal(String schemaName) {
        HibernateConnectionSourceSettings tenantSettings;
        if (this.multiTenantMode != MultiTenancySettings.MultiTenancyMode.SCHEMA) {
            throw new ConfigurationException("The method [addTenantForSchema] can only be called with multi-tenancy mode SCHEMA. Current mode is: " + this.multiTenantMode);
        }
        HibernateConnectionSourceFactory factory = (HibernateConnectionSourceFactory)this.connectionSources.getFactory();
        HibernateConnectionSource defaultConnectionSource = (HibernateConnectionSource)this.connectionSources.getDefaultConnectionSource();
        try {
            tenantSettings = ((HibernateConnectionSourceSettings)this.connectionSources.getDefaultConnectionSource().getSettings()).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ConfigurationException("Couldn't clone default Hibernate settings! " + e.getMessage(), (Throwable)e);
        }
        tenantSettings.getHibernate().put((Object)"default_schema", (Object)schemaName);
        String dbCreate = tenantSettings.getDataSource().getDbCreate();
        if (dbCreate != null && Arrays.asList("update", "create", "create-drop").contains(dbCreate)) {
            Connection connection = null;
            try {
                connection = defaultConnectionSource.getDataSource().getConnection();
                try {
                    this.schemaHandler.useSchema(connection, schemaName);
                }
                catch (Exception e) {
                    this.schemaHandler.createSchema(connection, schemaName);
                }
            }
            catch (SQLException e) {
                throw new DatastoreConfigurationException(String.format("Failed to create schema for name [%s]", schemaName));
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        DefaultConnectionSource dataSourceConnectionSource = new DefaultConnectionSource(schemaName, (Object)defaultConnectionSource.getDataSource(), (ConnectionSourceSettings)tenantSettings.getDataSource());
        ConnectionSource<SessionFactory, HibernateConnectionSourceSettings> connectionSource = factory.create(schemaName, (ConnectionSource<DataSource, DataSourceSettings>)dataSourceConnectionSource, tenantSettings);
        SingletonConnectionSources singletonConnectionSources = new SingletonConnectionSources(connectionSource, this.connectionSources.getBaseConfiguration());
        HibernateDatastore childDatastore = new HibernateDatastore((ConnectionSources)singletonConnectionSources, (HibernateMappingContext)this.mappingContext, this.eventPublisher){

            @Override
            protected HibernateGormEnhancer initialize() {
                return null;
            }
        };
        this.datastoresByConnectionSource.put(connectionSource.getName(), childDatastore);
    }
}

