/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingPropertyException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.grails.orm.hibernate.GrailsSessionContext;
import org.grails.orm.hibernate.SessionFactoryHolder;
import org.hibernate.Cache;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.TypeHelper;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.cfg.Settings;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.query.spi.QueryPlanCache;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.internal.NamedQueryRepository;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.InfrastructureProxy;
import org.springframework.util.ReflectionUtils;

public class SessionFactoryProxy
extends GroovyObjectSupport
implements SessionFactoryImplementor,
ApplicationContextAware,
InitializingBean,
InfrastructureProxy {
    private static final long serialVersionUID = 1L;
    private String targetBean;
    private ApplicationContext applicationContext;
    private Class currentSessionContextClass = GrailsSessionContext.class;
    private SessionFactory currentSessionFactory;

    public void setTargetBean(String targetBean) {
        this.targetBean = targetBean;
    }

    public Object getProperty(String property) {
        try {
            return super.getProperty(property);
        }
        catch (MissingPropertyException e) {
            return InvokerHelper.getProperty((Object)this.getCurrentSessionFactory(), (String)property);
        }
    }

    public void setCurrentSessionContextClass(Class currentSessionContextClass) {
        this.currentSessionContextClass = currentSessionContextClass;
    }

    public SessionFactory getCurrentSessionFactory() {
        SessionFactory sf = ((SessionFactoryHolder)this.applicationContext.getBean(this.targetBean, SessionFactoryHolder.class)).getSessionFactory();
        if (!sf.equals(this.currentSessionFactory)) {
            this.currentSessionFactory = sf;
            this.updateCurrentSessionContext(sf);
        }
        return this.currentSessionFactory;
    }

    public SessionFactoryImplementor getCurrentSessionFactoryImplementor() {
        return (SessionFactoryImplementor)this.getCurrentSessionFactory();
    }

    public Session openSession() throws HibernateException {
        return this.getCurrentSessionFactory().openSession();
    }

    public Session getCurrentSession() throws HibernateException {
        return this.getCurrentSessionFactory().getCurrentSession();
    }

    public StatelessSession openStatelessSession() {
        return this.getCurrentSessionFactory().openStatelessSession();
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return this.getCurrentSessionFactory().openStatelessSession(connection);
    }

    public ClassMetadata getClassMetadata(Class entityClass) {
        return this.getCurrentSessionFactory().getClassMetadata(entityClass);
    }

    public ClassMetadata getClassMetadata(String entityName) {
        return this.getCurrentSessionFactory().getClassMetadata(entityName);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) {
        return this.getCurrentSessionFactory().getCollectionMetadata(roleName);
    }

    public Map<String, ClassMetadata> getAllClassMetadata() {
        return this.getCurrentSessionFactory().getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() {
        return this.getCurrentSessionFactory().getAllCollectionMetadata();
    }

    public Statistics getStatistics() {
        return this.getCurrentSessionFactory().getStatistics();
    }

    public void close() throws HibernateException {
        this.getCurrentSessionFactory().close();
    }

    public boolean isClosed() {
        return this.getCurrentSessionFactory().isClosed();
    }

    public Cache getCache() {
        return this.getCurrentSessionFactory().getCache();
    }

    @Deprecated
    public void evict(Class persistentClass) throws HibernateException {
        this.getCurrentSessionFactory().evict(persistentClass);
    }

    @Deprecated
    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.getCurrentSessionFactory().evict(persistentClass, id);
    }

    @Deprecated
    public void evictEntity(String entityName) throws HibernateException {
        this.getCurrentSessionFactory().evictEntity(entityName);
    }

    @Deprecated
    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        this.getCurrentSessionFactory().evictEntity(entityName, id);
    }

    @Deprecated
    public void evictCollection(String roleName) throws HibernateException {
        this.getCurrentSessionFactory().evictCollection(roleName);
    }

    @Deprecated
    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.getCurrentSessionFactory().evictCollection(roleName, id);
    }

    @Deprecated
    public void evictQueries(String cacheRegion) throws HibernateException {
        this.getCurrentSessionFactory().evictQueries(cacheRegion);
    }

    @Deprecated
    public void evictQueries() throws HibernateException {
        this.getCurrentSessionFactory().evictQueries();
    }

    public Set getDefinedFilterNames() {
        return this.getCurrentSessionFactory().getDefinedFilterNames();
    }

    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return this.getCurrentSessionFactory().getFilterDefinition(filterName);
    }

    public boolean containsFetchProfileDefinition(String name) {
        return this.getCurrentSessionFactory().containsFetchProfileDefinition(name);
    }

    public TypeHelper getTypeHelper() {
        return this.getCurrentSessionFactory().getTypeHelper();
    }

    public Reference getReference() throws NamingException {
        return this.getCurrentSessionFactory().getReference();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public TypeResolver getTypeResolver() {
        return this.getCurrentSessionFactoryImplementor().getTypeResolver();
    }

    public Properties getProperties() {
        return this.getCurrentSessionFactoryImplementor().getProperties();
    }

    public EntityPersister getEntityPersister(String entityName) throws MappingException {
        return this.getCurrentSessionFactoryImplementor().getEntityPersister(entityName);
    }

    public CollectionPersister getCollectionPersister(String role) throws MappingException {
        return this.getCurrentSessionFactoryImplementor().getCollectionPersister(role);
    }

    public Dialect getDialect() {
        return this.getCurrentSessionFactoryImplementor().getDialect();
    }

    public Interceptor getInterceptor() {
        return this.getCurrentSessionFactoryImplementor().getInterceptor();
    }

    public QueryPlanCache getQueryPlanCache() {
        return this.getCurrentSessionFactoryImplementor().getQueryPlanCache();
    }

    public Type[] getReturnTypes(String queryString) throws HibernateException {
        return this.getCurrentSessionFactoryImplementor().getReturnTypes(queryString);
    }

    public String[] getReturnAliases(String queryString) throws HibernateException {
        return this.getCurrentSessionFactoryImplementor().getReturnAliases(queryString);
    }

    public ConnectionProvider getConnectionProvider() {
        return this.getCurrentSessionFactoryImplementor().getConnectionProvider();
    }

    public String[] getImplementors(String className) throws MappingException {
        return this.getCurrentSessionFactoryImplementor().getImplementors(className);
    }

    public String getImportedClassName(String name) {
        return this.getCurrentSessionFactoryImplementor().getImportedClassName(name);
    }

    public QueryCache getQueryCache() {
        return this.getCurrentSessionFactoryImplementor().getQueryCache();
    }

    public QueryCache getQueryCache(String regionName) throws HibernateException {
        return this.getCurrentSessionFactoryImplementor().getQueryCache(regionName);
    }

    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.getCurrentSessionFactoryImplementor().getUpdateTimestampsCache();
    }

    public StatisticsImplementor getStatisticsImplementor() {
        return this.getCurrentSessionFactoryImplementor().getStatisticsImplementor();
    }

    public NamedQueryDefinition getNamedQuery(String queryName) {
        return this.getCurrentSessionFactoryImplementor().getNamedQuery(queryName);
    }

    public void registerNamedQueryDefinition(String name, NamedQueryDefinition definition) {
        this.getCurrentSessionFactoryImplementor().registerNamedQueryDefinition(name, definition);
    }

    public NamedSQLQueryDefinition getNamedSQLQuery(String queryName) {
        return this.getCurrentSessionFactoryImplementor().getNamedSQLQuery(queryName);
    }

    public void registerNamedSQLQueryDefinition(String name, NamedSQLQueryDefinition definition) {
        this.getCurrentSessionFactoryImplementor().registerNamedSQLQueryDefinition(name, definition);
    }

    public ResultSetMappingDefinition getResultSetMapping(String name) {
        return this.getCurrentSessionFactoryImplementor().getResultSetMapping(name);
    }

    public IdentifierGenerator getIdentifierGenerator(String rootEntityName) {
        return this.getCurrentSessionFactoryImplementor().getIdentifierGenerator(rootEntityName);
    }

    public Region getSecondLevelCacheRegion(String regionName) {
        return this.getCurrentSessionFactoryImplementor().getSecondLevelCacheRegion(regionName);
    }

    public Map getAllSecondLevelCacheRegions() {
        return this.getCurrentSessionFactoryImplementor().getAllSecondLevelCacheRegions();
    }

    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.getCurrentSessionFactoryImplementor().getSQLExceptionConverter();
    }

    public Settings getSettings() {
        return this.getCurrentSessionFactoryImplementor().getSettings();
    }

    public Session openTemporarySession() throws HibernateException {
        return this.getCurrentSessionFactoryImplementor().openTemporarySession();
    }

    public Set<String> getCollectionRolesByEntityParticipant(String entityName) {
        return this.getCurrentSessionFactoryImplementor().getCollectionRolesByEntityParticipant(entityName);
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.getCurrentSessionFactoryImplementor().getEntityNotFoundDelegate();
    }

    public SQLFunctionRegistry getSqlFunctionRegistry() {
        return this.getCurrentSessionFactoryImplementor().getSqlFunctionRegistry();
    }

    public FetchProfile getFetchProfile(String name) {
        return this.getCurrentSessionFactoryImplementor().getFetchProfile(name);
    }

    @Deprecated
    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.getCurrentSessionFactoryImplementor().getIdentifierGeneratorFactory();
    }

    public Type getIdentifierType(String className) throws MappingException {
        return this.getCurrentSessionFactoryImplementor().getIdentifierType(className);
    }

    public String getIdentifierPropertyName(String className) throws MappingException {
        return this.getCurrentSessionFactoryImplementor().getIdentifierPropertyName(className);
    }

    public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
        return this.getCurrentSessionFactoryImplementor().getReferencedPropertyType(className, propertyName);
    }

    public void afterPropertiesSet() {
        this.getCurrentSessionFactoryImplementor();
    }

    private void updateCurrentSessionContext(SessionFactory sessionFactory) {
        CurrentSessionContext ssc = this.createCurrentSessionContext();
        if (ssc instanceof GrailsSessionContext) {
            ((GrailsSessionContext)ssc).initJta();
        }
        try {
            Class<?> sessionFactoryClass = sessionFactory.getClass();
            Field currentSessionContextField = sessionFactoryClass.getDeclaredField("currentSessionContext");
            if (currentSessionContextField != null) {
                ReflectionUtils.makeAccessible((Field)currentSessionContextField);
                currentSessionContextField.set(sessionFactory, ssc);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    protected CurrentSessionContext createCurrentSessionContext() {
        Class<GrailsSessionContext> sessionContextClass = this.currentSessionContextClass;
        if (sessionContextClass == null) {
            sessionContextClass = GrailsSessionContext.class;
        }
        try {
            Constructor constructor = sessionContextClass.getConstructor(SessionFactoryImplementor.class);
            return (CurrentSessionContext)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{this});
        }
        catch (NoSuchMethodException e) {
            return new GrailsSessionContext(this);
        }
    }

    public Object getWrappedObject() {
        return this.getCurrentSessionFactory();
    }

    public SessionFactory.SessionFactoryOptions getSessionFactoryOptions() {
        return this.getCurrentSessionFactoryImplementor().getSessionFactoryOptions();
    }

    public StatelessSessionBuilder withStatelessOptions() {
        return this.getCurrentSessionFactoryImplementor().withStatelessOptions();
    }

    public SessionBuilderImplementor withOptions() {
        return this.getCurrentSessionFactoryImplementor().withOptions();
    }

    public Map<String, EntityPersister> getEntityPersisters() {
        return this.getCurrentSessionFactoryImplementor().getEntityPersisters();
    }

    public Map<String, CollectionPersister> getCollectionPersisters() {
        return this.getCurrentSessionFactoryImplementor().getCollectionPersisters();
    }

    public JdbcServices getJdbcServices() {
        return this.getCurrentSessionFactoryImplementor().getJdbcServices();
    }

    public Region getNaturalIdCacheRegion(String regionName) {
        return this.getCurrentSessionFactoryImplementor().getNaturalIdCacheRegion(regionName);
    }

    public SqlExceptionHelper getSQLExceptionHelper() {
        return this.getCurrentSessionFactoryImplementor().getSQLExceptionHelper();
    }

    public ServiceRegistryImplementor getServiceRegistry() {
        return this.getCurrentSessionFactoryImplementor().getServiceRegistry();
    }

    public void addObserver(SessionFactoryObserver observer) {
        this.getCurrentSessionFactoryImplementor().addObserver(observer);
    }

    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return this.getCurrentSessionFactoryImplementor().getCustomEntityDirtinessStrategy();
    }

    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.getCurrentSessionFactoryImplementor().getCurrentTenantIdentifierResolver();
    }

    public NamedQueryRepository getNamedQueryRepository() {
        return this.getCurrentSessionFactoryImplementor().getNamedQueryRepository();
    }

    public Iterable<EntityNameResolver> iterateEntityNameResolvers() {
        return this.getCurrentSessionFactoryImplementor().iterateEntityNameResolvers();
    }
}

