/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.cfg;

import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.grails.orm.hibernate.AbstractHibernateDatastore;
import org.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.grails.orm.hibernate.cfg.HibernatePersistentEntity;
import org.grails.orm.hibernate.cfg.Mapping;
import org.grails.orm.hibernate.datasource.MultipleDataSourceSupport;
import org.grails.orm.hibernate.proxy.GroovyAwareJavassistProxyFactory;
import org.grails.orm.hibernate.proxy.HibernateProxyHandler;
import org.grails.orm.hibernate.support.HibernateRuntimeUtils;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;
import org.springframework.core.convert.ConversionService;

public class GrailsHibernateUtil
extends HibernateRuntimeUtils {
    protected static final Log LOG = LogFactory.getLog(GrailsHibernateUtil.class);
    public static final String ARGUMENT_FETCH_SIZE = "fetchSize";
    public static final String ARGUMENT_TIMEOUT = "timeout";
    public static final String ARGUMENT_READ_ONLY = "readOnly";
    public static final String ARGUMENT_FLUSH_MODE = "flushMode";
    public static final String ARGUMENT_MAX = "max";
    public static final String ARGUMENT_OFFSET = "offset";
    public static final String ARGUMENT_ORDER = "order";
    public static final String ARGUMENT_SORT = "sort";
    public static final String ORDER_DESC = "desc";
    public static final String ORDER_ASC = "asc";
    public static final String ARGUMENT_FETCH = "fetch";
    public static final String ARGUMENT_IGNORE_CASE = "ignoreCase";
    public static final String ARGUMENT_CACHE = "cache";
    public static final String ARGUMENT_LOCK = "lock";
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static HibernateProxyHandler proxyHandler = new HibernateProxyHandler();
    private static GrailsDomainBinder binder;

    public static void populateArgumentsForCriteria(AbstractHibernateDatastore datastore, Class<?> targetClass, Criteria c, Map argMap, ConversionService conversionService) {
        GrailsHibernateUtil.populateArgumentsForCriteria(datastore, targetClass, c, argMap, conversionService, true);
    }

    public static void populateArgumentsForCriteria(AbstractHibernateDatastore datastore, Class<?> targetClass, Criteria c, Map argMap, ConversionService conversionService, boolean useDefaultMapping) {
        block21: {
            block20: {
                int offset;
                Integer maxParam = null;
                Integer offsetParam = null;
                if (argMap.containsKey(ARGUMENT_MAX)) {
                    maxParam = (Integer)conversionService.convert(argMap.get(ARGUMENT_MAX), Integer.class);
                }
                if (argMap.containsKey(ARGUMENT_OFFSET)) {
                    offsetParam = (Integer)conversionService.convert(argMap.get(ARGUMENT_OFFSET), Integer.class);
                }
                if (argMap.containsKey(ARGUMENT_FETCH_SIZE)) {
                    c.setFetchSize(((Integer)conversionService.convert(argMap.get(ARGUMENT_FETCH_SIZE), Integer.class)).intValue());
                }
                if (argMap.containsKey(ARGUMENT_TIMEOUT)) {
                    c.setTimeout(((Integer)conversionService.convert(argMap.get(ARGUMENT_TIMEOUT), Integer.class)).intValue());
                }
                if (argMap.containsKey(ARGUMENT_FLUSH_MODE)) {
                    c.setFlushMode(GrailsHibernateUtil.convertFlushMode(argMap.get(ARGUMENT_FLUSH_MODE)));
                }
                if (argMap.containsKey(ARGUMENT_READ_ONLY)) {
                    c.setReadOnly(ClassUtils.getBooleanFromMap((String)ARGUMENT_READ_ONLY, (Map)argMap));
                }
                String orderParam = (String)argMap.get(ARGUMENT_ORDER);
                Object fetchObj = argMap.get(ARGUMENT_FETCH);
                if (fetchObj instanceof Map) {
                    Map fetch = (Map)fetchObj;
                    for (Object o : fetch.keySet()) {
                        String associationName = (String)o;
                        c.setFetchMode(associationName, GrailsHibernateUtil.getFetchMode(fetch.get(associationName)));
                    }
                }
                int max = maxParam == null ? -1 : maxParam;
                int n = offset = offsetParam == null ? -1 : offsetParam;
                if (max > -1) {
                    c.setMaxResults(max);
                }
                if (offset > -1) {
                    c.setFirstResult(offset);
                }
                if (ClassUtils.getBooleanFromMap((String)ARGUMENT_LOCK, (Map)argMap)) {
                    c.setLockMode(LockMode.PESSIMISTIC_WRITE);
                    c.setCacheable(false);
                } else if (argMap.containsKey(ARGUMENT_CACHE)) {
                    c.setCacheable(ClassUtils.getBooleanFromMap((String)ARGUMENT_CACHE, (Map)argMap));
                } else {
                    GrailsHibernateUtil.cacheCriteriaByMapping(targetClass, c);
                }
                Object sortObj = argMap.get(ARGUMENT_SORT);
                if (sortObj == null) break block20;
                boolean ignoreCase = true;
                Object caseArg = argMap.get(ARGUMENT_IGNORE_CASE);
                if (caseArg instanceof Boolean) {
                    ignoreCase = (Boolean)caseArg;
                }
                if (sortObj instanceof Map) {
                    Map sortMap = (Map)sortObj;
                    for (Object sort : sortMap.keySet()) {
                        String order = ORDER_DESC.equalsIgnoreCase((String)sortMap.get(sort)) ? ORDER_DESC : ORDER_ASC;
                        GrailsHibernateUtil.addOrderPossiblyNested(datastore, c, targetClass, (String)sort, order, ignoreCase);
                    }
                } else {
                    String sort = (String)sortObj;
                    String order = ORDER_DESC.equalsIgnoreCase(orderParam) ? ORDER_DESC : ORDER_ASC;
                    GrailsHibernateUtil.addOrderPossiblyNested(datastore, c, targetClass, sort, order, ignoreCase);
                }
                break block21;
            }
            if (!useDefaultMapping) break block21;
            GrailsHibernateUtil.getDomainBinder();
            Mapping m = GrailsDomainBinder.getMapping(targetClass);
            if (m != null) {
                Map sortMap = m.getSort().getNamesAndDirections();
                for (Object sort : sortMap.keySet()) {
                    String order = ORDER_DESC.equalsIgnoreCase((String)sortMap.get(sort)) ? ORDER_DESC : ORDER_ASC;
                    GrailsHibernateUtil.addOrderPossiblyNested(datastore, c, targetClass, (String)sort, order, true);
                }
            }
        }
    }

    public static GrailsDomainBinder getDomainBinder() {
        if (binder == null) {
            binder = new GrailsDomainBinder();
        }
        return binder;
    }

    public static void setBinder(GrailsDomainBinder binder) {
        GrailsHibernateUtil.binder = binder;
    }

    @Deprecated
    public static void populateArgumentsForCriteria(Class<?> targetClass, Criteria c, Map argMap, ConversionService conversionService) {
        GrailsHibernateUtil.populateArgumentsForCriteria(null, targetClass, c, argMap, conversionService);
    }

    public static void populateArgumentsForCriteria(Criteria c, Map argMap, ConversionService conversionService) {
        GrailsHibernateUtil.populateArgumentsForCriteria(null, null, c, argMap, conversionService);
    }

    private static FlushMode convertFlushMode(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof FlushMode) {
            return (FlushMode)object;
        }
        return FlushMode.valueOf((String)String.valueOf(object));
    }

    private static void addOrderPossiblyNested(AbstractHibernateDatastore datastore, Criteria c, Class<?> targetClass, String sort, String order, boolean ignoreCase) {
        int firstDotPos = sort.indexOf(".");
        if (firstDotPos == -1) {
            GrailsHibernateUtil.addOrder(c, sort, order, ignoreCase);
        } else {
            String sortHead = sort.substring(0, firstDotPos);
            String sortTail = sort.substring(firstDotPos + 1);
            PersistentProperty property = GrailsHibernateUtil.getGrailsDomainClassProperty(datastore, targetClass, sortHead);
            if (property instanceof Embedded) {
                GrailsHibernateUtil.addOrder(c, sort, order, ignoreCase);
            } else if (property instanceof Association) {
                Criteria subCriteria = c.createCriteria(sortHead);
                Class propertyTargetClass = ((Association)property).getAssociatedEntity().getJavaClass();
                GrailsHibernateUtil.cacheCriteriaByMapping(datastore, propertyTargetClass, subCriteria);
                GrailsHibernateUtil.addOrderPossiblyNested(datastore, subCriteria, propertyTargetClass, sortTail, order, ignoreCase);
            }
        }
    }

    private static void addOrder(Criteria c, String sort, String order, boolean ignoreCase) {
        if (ORDER_DESC.equals(order)) {
            c.addOrder(ignoreCase ? Order.desc((String)sort).ignoreCase() : Order.desc((String)sort));
        } else {
            c.addOrder(ignoreCase ? Order.asc((String)sort).ignoreCase() : Order.asc((String)sort));
        }
    }

    private static PersistentProperty getGrailsDomainClassProperty(AbstractHibernateDatastore datastore, Class<?> targetClass, String propertyName) {
        PersistentEntity grailsClass;
        PersistentEntity persistentEntity = grailsClass = datastore != null ? datastore.getMappingContext().getPersistentEntity(targetClass.getName()) : null;
        if (grailsClass == null) {
            throw new IllegalArgumentException("Unexpected: class is not a domain class:" + targetClass.getName());
        }
        return grailsClass.getPropertyByName(propertyName);
    }

    public static void cacheCriteriaByMapping(Class<?> targetClass, Criteria criteria) {
        GrailsHibernateUtil.getDomainBinder();
        Mapping m = GrailsDomainBinder.getMapping(targetClass);
        if (m != null && m.getCache() != null && m.getCache().getEnabled()) {
            criteria.setCacheable(true);
        }
    }

    public static void cacheCriteriaByMapping(AbstractHibernateDatastore datastore, Class<?> targetClass, Criteria criteria) {
        GrailsHibernateUtil.cacheCriteriaByMapping(targetClass, criteria);
    }

    public static FetchMode getFetchMode(Object object) {
        String name;
        String string = name = object != null ? object.toString() : "default";
        if (name.equalsIgnoreCase(FetchMode.JOIN.toString()) || name.equalsIgnoreCase("eager")) {
            return FetchMode.JOIN;
        }
        if (name.equalsIgnoreCase(FetchMode.SELECT.toString()) || name.equalsIgnoreCase("lazy")) {
            return FetchMode.SELECT;
        }
        return FetchMode.DEFAULT;
    }

    public static void setObjectToReadyOnly(Object target, SessionFactory sessionFactory) {
        Session session = sessionFactory.getCurrentSession();
        if (GrailsHibernateUtil.canModifyReadWriteState(session, target)) {
            if (target instanceof HibernateProxy) {
                target = ((HibernateProxy)target).getHibernateLazyInitializer().getImplementation();
            }
            session.setReadOnly(target, true);
            session.setFlushMode(FlushMode.MANUAL);
        }
    }

    private static boolean canModifyReadWriteState(Session session, Object target) {
        return session.contains(target) && Hibernate.isInitialized((Object)target);
    }

    public static void setObjectToReadWrite(Object target, SessionFactory sessionFactory) {
        Session session = sessionFactory.getCurrentSession();
        if (!GrailsHibernateUtil.canModifyReadWriteState(session, target)) {
            return;
        }
        SessionImplementor sessionImpl = (SessionImplementor)session;
        EntityEntry ee = sessionImpl.getPersistenceContext().getEntry(target);
        if (ee == null || ee.getStatus() != Status.READ_ONLY) {
            return;
        }
        Object actualTarget = target;
        if (target instanceof HibernateProxy) {
            actualTarget = ((HibernateProxy)target).getHibernateLazyInitializer().getImplementation();
        }
        session.setReadOnly(actualTarget, false);
        session.setFlushMode(FlushMode.AUTO);
        GrailsHibernateUtil.incrementVersion(target);
    }

    public static void incrementVersion(Object target) {
        Object version;
        MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
        if (metaClass.hasProperty(target, "version") != null && (version = metaClass.getProperty(target, "version")) instanceof Long) {
            Long newVersion = (Long)version + 1L;
            metaClass.setProperty(target, "version", (Object)newVersion);
        }
    }

    public static void ensureCorrectGroovyMetaClass(Object target, Class<?> persistentClass) {
        GroovyObject go;
        if (target instanceof GroovyObject && !(go = (GroovyObject)target).getMetaClass().getTheClass().equals(persistentClass)) {
            go.setMetaClass(GroovySystem.getMetaClassRegistry().getMetaClass(persistentClass));
        }
    }

    public static Object unwrapProxy(HibernateProxy proxy) {
        return proxyHandler.unwrapProxy(proxy);
    }

    public static HibernateProxy getAssociationProxy(Object obj, String associationName) {
        return proxyHandler.getAssociationProxy(obj, associationName);
    }

    public static boolean isInitialized(Object obj, String associationName) {
        return proxyHandler.isInitialized(obj, associationName);
    }

    public static GroovyAwareJavassistProxyFactory buildProxyFactory(PersistentClass persistentClass) {
        GroovyAwareJavassistProxyFactory proxyFactory = new GroovyAwareJavassistProxyFactory();
        HashSet<Class<HibernateProxy>> proxyInterfaces = new HashSet<Class<HibernateProxy>>();
        proxyInterfaces.add(HibernateProxy.class);
        Class javaClass = persistentClass.getMappedClass();
        Property identifierProperty = persistentClass.getIdentifierProperty();
        Method idGetterMethod = identifierProperty != null ? identifierProperty.getGetter(javaClass).getMethod() : null;
        Method idSetterMethod = identifierProperty != null ? identifierProperty.getSetter(javaClass).getMethod() : null;
        Type identifierType = persistentClass.hasEmbeddedIdentifier() ? persistentClass.getIdentifier().getType() : null;
        try {
            proxyFactory.postInstantiate(persistentClass.getEntityName(), javaClass, proxyInterfaces, idGetterMethod, idSetterMethod, identifierType instanceof CompositeType ? (CompositeType)identifierType : null);
        }
        catch (HibernateException e) {
            LOG.warn((Object)("Cannot instantiate proxy factory: " + e.getMessage()));
            return null;
        }
        return proxyFactory;
    }

    public static Object unwrapIfProxy(Object instance) {
        return proxyHandler.unwrapIfProxy(instance);
    }

    @Deprecated
    public static String getDefaultDataSource(PersistentEntity domainClass) {
        return MultipleDataSourceSupport.getDefaultDataSource((PersistentEntity)domainClass);
    }

    @Deprecated
    public static List<String> getDatasourceNames(PersistentEntity domainClass) {
        return MultipleDataSourceSupport.getDatasourceNames((PersistentEntity)domainClass);
    }

    @Deprecated
    public static boolean usesDatasource(PersistentEntity domainClass, String dataSourceName) {
        return MultipleDataSourceSupport.usesDatasource((PersistentEntity)domainClass, (String)dataSourceName);
    }

    public static boolean isMappedWithHibernate(PersistentEntity domainClass) {
        return domainClass instanceof HibernatePersistentEntity;
    }

    public static String qualify(String prefix, String name) {
        return StringHelper.qualify((String)prefix, (String)name);
    }

    public static boolean isNotEmpty(String string) {
        return StringHelper.isNotEmpty((String)string);
    }

    public static String unqualify(String qualifiedName) {
        return StringHelper.unqualify((String)qualifiedName);
    }
}

