/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.cfg;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.datastore.gorm.jdbc.connections.DataSourceSettings;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSourcesSupport;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.orm.hibernate.EventListenerIntegrator;
import org.grails.orm.hibernate.GrailsSessionContext;
import org.grails.orm.hibernate.HibernateEventListeners;
import org.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.grails.orm.hibernate.cfg.GrailsIdentifierGeneratorFactory;
import org.grails.orm.hibernate.cfg.HibernateMappingContext;
import org.grails.orm.hibernate.cfg.Mapping;
import org.grails.orm.hibernate.proxy.GroovyAwarePojoEntityTuplizer;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class HibernateMappingContextConfiguration
extends Configuration
implements ApplicationContextAware {
    private static final long serialVersionUID = -7115087342689305517L;
    protected static final Log LOG = LogFactory.getLog(HibernateMappingContextConfiguration.class);
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private static final TypeFilter[] ENTITY_TYPE_FILTERS = new TypeFilter[]{new AnnotationTypeFilter(Entity.class, false), new AnnotationTypeFilter(Embeddable.class, false), new AnnotationTypeFilter(MappedSuperclass.class, false)};
    protected boolean configLocked;
    protected String sessionFactoryBeanName = "sessionFactory";
    protected String dataSourceName = Mapping.DEFAULT_DATA_SOURCE;
    protected GrailsDomainBinder binder = new GrailsDomainBinder();
    protected HibernateMappingContext hibernateMappingContext;
    private boolean subclassForeignKeysCreated = false;
    private HibernateEventListeners hibernateEventListeners;
    private Map<String, Object> eventListeners;
    private ServiceRegistry serviceRegistry;
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public void setHibernateMappingContext(HibernateMappingContext hibernateMappingContext) {
        this.hibernateMappingContext = hibernateMappingContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)applicationContext);
        String dsName = Mapping.DEFAULT_DATA_SOURCE.equals(this.dataSourceName) ? "dataSource" : "dataSource_" + this.dataSourceName;
        Properties properties = this.getProperties();
        if (applicationContext.containsBean(dsName)) {
            properties.put("hibernate.connection.datasource", applicationContext.getBean(dsName));
        }
        properties.put("hibernate.current_session_context_class", GrailsSessionContext.class.getName());
        properties.put("hibernate.classLoaders", applicationContext.getClassLoader());
    }

    public void setDataSourceConnectionSource(ConnectionSource<DataSource, DataSourceSettings> connectionSource) {
        this.dataSourceName = connectionSource.getName();
        DataSource source = (DataSource)connectionSource.getSource();
        this.getProperties().put("hibernate.connection.datasource", source);
        this.getProperties().put("hibernate.current_session_context_class", GrailsSessionContext.class.getName());
        this.getProperties().put("hibernate.classLoaders", connectionSource.getClass().getClassLoader());
    }

    public void addAnnotatedClasses(Class<?> ... annotatedClasses) {
        for (Class<?> annotatedClass : annotatedClasses) {
            this.addAnnotatedClass(annotatedClass);
        }
    }

    public void addPackages(String ... annotatedPackages) {
        for (String annotatedPackage : annotatedPackages) {
            this.addPackage(annotatedPackage);
        }
    }

    public void scanPackages(String ... packagesToScan) throws HibernateException {
        try {
            for (String pkg : packagesToScan) {
                String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + RESOURCE_PATTERN;
                Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                for (Resource resource : resources) {
                    if (!resource.isReadable()) continue;
                    MetadataReader reader = readerFactory.getMetadataReader(resource);
                    String className = reader.getClassMetadata().getClassName();
                    if (!this.matchesFilter(reader, (MetadataReaderFactory)readerFactory)) continue;
                    this.addAnnotatedClasses(this.resourcePatternResolver.getClassLoader().loadClass(className));
                }
            }
        }
        catch (IOException ex) {
            throw new MappingException("Failed to scan classpath for unlisted classes", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new MappingException("Failed to load annotated classes from classpath", (Throwable)ex);
        }
    }

    protected boolean matchesFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        for (TypeFilter filter : ENTITY_TYPE_FILTERS) {
            if (!filter.match(reader, readerFactory)) continue;
            return true;
        }
        return false;
    }

    public void setSessionFactoryBeanName(String name) {
        this.sessionFactoryBeanName = name;
    }

    public void setDataSourceName(String name) {
        this.dataSourceName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionFactory buildSessionFactory() throws HibernateException {
        boolean overrideClassLoader;
        HashMap empty = new HashMap();
        this.addFilterDefinition(new FilterDefinition("dynamicFilterEnabler", "1=1", empty));
        SessionFactory sessionFactory = null;
        ClassLoader appClassLoader = (ClassLoader)this.getProperties().get("hibernate.classLoader.application");
        Thread currentThread = Thread.currentThread();
        ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
        boolean bl = overrideClassLoader = appClassLoader != null && !appClassLoader.equals(threadContextClassLoader);
        if (overrideClassLoader) {
            currentThread.setContextClassLoader(appClassLoader);
        }
        try {
            ConfigurationHelper.resolvePlaceHolders((Map)this.getProperties());
            EventListenerIntegrator eventListenerIntegrator = new EventListenerIntegrator(this.hibernateEventListeners, this.eventListeners);
            BootstrapServiceRegistry bootstrapServiceRegistry = new BootstrapServiceRegistryBuilder().with((Integrator)eventListenerIntegrator).build();
            this.setSessionFactoryObserver(new SessionFactoryObserver(){
                private static final long serialVersionUID = 1L;

                public void sessionFactoryCreated(SessionFactory factory) {
                }

                public void sessionFactoryClosed(SessionFactory factory) {
                    ((ServiceRegistryImplementor)HibernateMappingContextConfiguration.this.serviceRegistry).destroy();
                }
            });
            StandardServiceRegistryBuilder standardServiceRegistryBuilder = new StandardServiceRegistryBuilder(bootstrapServiceRegistry).applySettings((Map)this.getProperties());
            sessionFactory = super.buildSessionFactory((ServiceRegistry)standardServiceRegistryBuilder.build());
            this.serviceRegistry = ((SessionFactoryImplementor)sessionFactory).getServiceRegistry();
        }
        finally {
            if (overrideClassLoader) {
                currentThread.setContextClassLoader(threadContextClassLoader);
            }
        }
        return sessionFactory;
    }

    public Settings buildSettings(ServiceRegistry serviceRegistry) {
        this.configureNamingStrategy();
        Settings settings = super.buildSettings(serviceRegistry);
        settings.getEntityTuplizerFactory().registerDefaultTuplizerClass(EntityMode.POJO, GroovyAwarePojoEntityTuplizer.class);
        return settings;
    }

    public Settings buildSettings(Properties props, ServiceRegistry serviceRegistry) throws HibernateException {
        this.configureNamingStrategy();
        Settings settings = super.buildSettings(props, serviceRegistry);
        settings.getEntityTuplizerFactory().registerDefaultTuplizerClass(EntityMode.POJO, GroovyAwarePojoEntityTuplizer.class);
        return settings;
    }

    public void setEventListeners(Map<String, Object> listeners) {
        this.eventListeners = listeners;
    }

    public void setHibernateEventListeners(HibernateEventListeners listeners) {
        this.hibernateEventListeners = listeners;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected void secondPassCompile() throws MappingException {
        if (!this.configLocked) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsAnnotationConfiguration] [" + this.hibernateMappingContext.getPersistentEntities().size() + "] Grails domain classes to bind to persistence runtime"));
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (PersistentEntity entity : this.hibernateMappingContext.getPersistentEntities()) {
                this.binder.evaluateMapping(entity);
            }
            for (PersistentEntity domainClass : this.hibernateMappingContext.getPersistentEntities()) {
                Mapping m;
                String fullClassName = domainClass.getName();
                String hibernateConfig = fullClassName.replace('.', '/') + ".hbm.xml";
                if (loader.getResource(hibernateConfig) != null) continue;
                Mappings mappings = super.createMappings();
                if (!ConnectionSourcesSupport.usesConnectionSource((PersistentEntity)domainClass, (String)this.dataSourceName)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsAnnotationConfiguration] Binding persistent class [" + fullClassName + "]"));
                }
                mappings.setAutoImport((m = GrailsDomainBinder.getMapping((PersistentEntity)domainClass)) == null || m.getAutoImport());
                this.binder.bindClass(domainClass, mappings, this.sessionFactoryBeanName);
            }
        }
        this.createSubclassForeignKeys();
        super.secondPassCompile();
        this.configLocked = true;
    }

    private void createSubclassForeignKeys() {
        if (this.subclassForeignKeysCreated) {
            return;
        }
        for (PersistentClass persistentClass : this.classes.values()) {
            RootClass rootClass;
            if (!(persistentClass instanceof RootClass) || !(rootClass = (RootClass)persistentClass).hasSubclasses()) continue;
            Iterator subclasses = rootClass.getSubclassIterator();
            while (subclasses.hasNext()) {
                Object subclass = subclasses.next();
                if (!(subclass instanceof JoinedSubclass)) continue;
                JoinedSubclass joinedSubclass = (JoinedSubclass)subclass;
                joinedSubclass.createForeignKey();
            }
        }
        this.subclassForeignKeysCreated = true;
    }

    protected void configureNamingStrategy() {
        NamingStrategy strategy = this.getNamingStrategy();
        if (strategy == null) {
            strategy = ImprovedNamingStrategy.INSTANCE;
        }
        this.setNamingStrategy(strategy);
    }

    protected void reset() {
        super.reset();
        try {
            GrailsIdentifierGeneratorFactory.applyNewInstance(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

