/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import java.util.TimerTask;
import org.granite.gravity.Gravity;
import org.granite.logging.Logger;

public class ChannelTimerTask
extends TimerTask {
    private static final Logger log = Logger.getLogger(ChannelTimerTask.class);
    private final Gravity gravity;
    private final String channelId;

    public ChannelTimerTask(Gravity gravity, String channelId) {
        this.gravity = gravity;
        this.channelId = channelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.debug("Removing channel: %s...", this.channelId);
        try {
            this.gravity.initThread();
            this.gravity.removeChannel(this.channelId);
        }
        finally {
            this.gravity.releaseThread();
        }
        log.debug("Channel: %s removed.", this.channelId);
    }

    public String toString() {
        return this.getClass().getName() + " {channelId=" + this.channelId + "}";
    }
}

