/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.adapters;

import javax.jms.Destination;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQTopic;
import org.granite.gravity.adapters.JMSServiceAdapter;
import org.granite.messaging.service.ServiceException;
import org.granite.util.XMap;

public class ActiveMQServiceAdapter
extends JMSServiceAdapter {
    public void configure(XMap adapterProperties, XMap destinationProperties) throws ServiceException {
        try {
            this.destinationName = destinationProperties.get("jms/destination-name");
            if (Boolean.TRUE.toString().equals(destinationProperties.get("jms/transacted-sessions"))) {
                this.transactedSessions = true;
            }
            if ("AUTO_ACKNOWLEDGE".equals(destinationProperties.get("jms/acknowledge-mode"))) {
                this.acknowledgeMode = 1;
            } else if ("CLIENT_ACKNOWLEDGE".equals(destinationProperties.get("jms/acknowledge-mode"))) {
                this.acknowledgeMode = 2;
            } else if ("DUPS_OK_ACKNOWLEDGE".equals(destinationProperties.get("jms/acknowledge-mode"))) {
                this.acknowledgeMode = 3;
            }
            if ("javax.jms.TextMessage".equals(destinationProperties.get("jms/message-type"))) {
                this.textMessages = true;
            }
            StringBuilder sb = null;
            if (destinationProperties.get("server/broker-url") != null) {
                sb = new StringBuilder(destinationProperties.get("server/broker-url"));
            } else {
                sb = new StringBuilder("vm://");
                sb.append(this.getId());
                if (Boolean.FALSE.toString().equals(destinationProperties.get("server/create-broker"))) {
                    sb.append("?create=false");
                    String startupWait = destinationProperties.get("server/wait-for-start");
                    if (startupWait != null) {
                        sb.append("&waitForStart=" + startupWait);
                    }
                } else {
                    sb.append("?create=true");
                }
                if (Boolean.TRUE.toString().equals(destinationProperties.get("server/durable"))) {
                    sb.append("&broker.persistent=true");
                    if (destinationProperties.containsKey("server/file-store-root")) {
                        sb.append("&broker.dataDirectory=").append(destinationProperties.get("server/file-store-root"));
                    }
                } else {
                    sb.append("&broker.persistent=false");
                }
            }
            this.jmsConnectionFactory = new ActiveMQConnectionFactory(sb.toString());
        }
        catch (Exception e) {
            throw new ServiceException("Error when configuring JMS Adapter", e);
        }
    }

    protected Destination getProducerDestination(String topic) {
        return new ActiveMQTopic(topic != null ? this.destinationName + "." + topic.replaceAll("\\*\\*", ">") : this.destinationName);
    }

    protected Destination getConsumerDestination(String topic) {
        return new ActiveMQTopic(topic != null ? this.destinationName + "." + topic.replaceAll("\\*\\*", ">") : this.destinationName);
    }
}

