/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityManager;
import org.granite.gravity.tomcat.AbstractCometProcessor;
import org.granite.gravity.tomcat.ByteArrayCometIO;
import org.granite.gravity.tomcat.CometIO;
import org.granite.gravity.tomcat.EventUtil;
import org.granite.gravity.tomcat.TomcatChannel;
import org.granite.logging.Logger;

public class GravityTomcatServlet
extends AbstractCometProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(GravityTomcatServlet.class);

    public CometIO createCometIO() {
        return new ByteArrayCometIO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleRequest(CometEvent event, InputStream content) throws IOException, ServletException {
        Gravity gravity = GravityManager.getGravity(this.getServletContext());
        HttpServletRequest request = event.getHttpServletRequest();
        HttpServletResponse response = event.getHttpServletResponse();
        try {
            this.initializeRequest(gravity, request, response);
            Message[] amf3Requests = this.deserialize(gravity, request, content);
            log.debug(">> [AMF3 REQUESTS] %s", new Object[]{amf3Requests});
            Message[] amf3Responses = null;
            boolean accessed = false;
            for (int i = 0; i < amf3Requests.length; ++i) {
                Message amf3Request = amf3Requests[i];
                Message amf3Response = gravity.handleMessage(amf3Request);
                String channelId = (String)amf3Request.getClientId();
                if (!accessed) {
                    accessed = gravity.access(channelId);
                }
                if (amf3Response == null) {
                    if (amf3Requests.length > 1) {
                        throw new IllegalArgumentException("Only one connect request is allowed on tunnel.");
                    }
                    TomcatChannel channel = (TomcatChannel)gravity.getChannel(channelId);
                    if (channel == null) {
                        throw new NullPointerException("No channel on tunnel connect");
                    }
                    if (channel.runReceived(new AsyncHttpContext(request, response, amf3Request))) {
                        boolean bl = true;
                        return bl;
                    }
                    GravityTomcatServlet.setConnectMessage(request, amf3Request);
                    channel.setCometEvent(event);
                    boolean bl = false;
                    return bl;
                }
                if (amf3Responses == null) {
                    amf3Responses = new Message[amf3Requests.length];
                }
                amf3Responses[i] = amf3Response;
            }
            log.debug("<< [AMF3 RESPONSES] %s", new Object[]{amf3Responses});
            this.serialize(gravity, response, amf3Responses);
        }
        catch (IOException e) {
            log.error(e, "Gravity message error", new Object[0]);
            throw e;
        }
        catch (Exception e) {
            log.error(e, "Gravity message error", new Object[0]);
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                if (content != null) {
                    content.close();
                }
            }
            finally {
                this.cleanupRequest(request);
            }
        }
        return true;
    }

    public boolean handleEnd(CometEvent event) throws IOException, ServletException {
        return true;
    }

    public boolean handleError(CometEvent event) throws IOException {
        if (EventUtil.isErrorButNotTimeout(event)) {
            log.warn("Got an error event: %s", EventUtil.toString(event));
        }
        try {
            String channelId;
            Gravity gravity;
            TomcatChannel channel;
            HttpServletRequest request = event.getHttpServletRequest();
            CommandMessage connect = GravityTomcatServlet.getConnectMessage(request);
            if (connect != null && (channel = (TomcatChannel)(gravity = GravityManager.getGravity(this.getServletContext())).getChannel(channelId = (String)connect.getClientId())) != null) {
                channel.setCometEvent(null);
            }
        }
        catch (Exception e) {
            log.error(e, "Error while processing event: %s", EventUtil.toString(event));
        }
        return true;
    }
}

