/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io;

import flex.messaging.io.ASObject;
import flex.messaging.io.ASRecordSet;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.AMF0Body;
import org.granite.messaging.amf.AMF0Header;
import org.granite.messaging.amf.AMF0Message;
import org.granite.messaging.amf.AMF3Object;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMF0Serializer {
    private static final Logger log = Logger.getLogger(AMF0Serializer.class);
    private static final int MILLS_PER_HOUR = 60000;
    private static final String NULL_MESSAGE = "null";
    private final DataOutputStream dataOutputStream;
    private final OutputStream rawOutputStream;
    private final Map<Object, Integer> storedObjects = new IdentityHashMap<Object, Integer>();
    private int storedObjectCount = 0;

    public AMF0Serializer(OutputStream outputStream) {
        this.rawOutputStream = outputStream;
        this.dataOutputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
    }

    public void serializeMessage(AMF0Message message) throws IOException {
        this.clearStoredObjects();
        this.dataOutputStream.writeShort(message.getVersion());
        this.dataOutputStream.writeShort(message.getHeaderCount());
        for (AMF0Header header : message.getHeaders()) {
            this.writeHeader(header);
        }
        this.dataOutputStream.writeShort(message.getBodyCount());
        Iterator<AMF0Body> bodies = message.getBodies();
        while (bodies.hasNext()) {
            AMF0Body body = bodies.next();
            this.writeBody(body);
        }
    }

    protected void writeHeader(AMF0Header header) throws IOException {
        this.dataOutputStream.writeUTF(header.getKey());
        this.dataOutputStream.writeBoolean(header.isRequired());
        this.dataOutputStream.writeInt(-1);
        this.writeData(header.getValue());
    }

    protected void writeBody(AMF0Body body) throws IOException {
        if (body.getTarget() == null) {
            this.dataOutputStream.writeUTF(NULL_MESSAGE);
        } else {
            this.dataOutputStream.writeUTF(body.getTarget());
        }
        if (body.getResponse() == null) {
            this.dataOutputStream.writeUTF(NULL_MESSAGE);
        } else {
            this.dataOutputStream.writeUTF(body.getResponse());
        }
        this.dataOutputStream.writeInt(-1);
        this.writeData(body.getValue());
    }

    protected void writeData(Object value) throws IOException {
        if (value == null) {
            this.dataOutputStream.writeByte(5);
        } else if (value instanceof AMF3Object) {
            this.writeAMF3Data((AMF3Object)value);
        } else if (this.isPrimitiveArray(value)) {
            this.writePrimitiveArray(value);
        } else if (value instanceof Number) {
            this.dataOutputStream.writeByte(0);
            this.dataOutputStream.writeDouble(((Number)value).doubleValue());
        } else if (value instanceof String) {
            this.writeString((String)value);
        } else if (value instanceof Character) {
            this.dataOutputStream.writeByte(2);
            this.dataOutputStream.writeUTF(value.toString());
        } else if (value instanceof Boolean) {
            this.dataOutputStream.writeByte(1);
            this.dataOutputStream.writeBoolean((Boolean)value);
        } else if (value instanceof Date) {
            this.dataOutputStream.writeByte(11);
            this.dataOutputStream.writeDouble(((Date)value).getTime());
            int offset = TimeZone.getDefault().getRawOffset();
            this.dataOutputStream.writeShort(offset / 60000);
        } else {
            if (this.storedObjects.containsKey(value)) {
                this.writeStoredObject(value);
                return;
            }
            this.storeObject(value);
            if (value instanceof Object[]) {
                this.writeArray((Object[])value);
            } else if (value instanceof Iterator) {
                this.write((Iterator)value);
            } else if (value instanceof Collection) {
                this.write((Collection)value);
            } else if (value instanceof Map) {
                this.writeMap((Map)value);
            } else if (value instanceof ResultSet) {
                ASRecordSet asRecordSet = new ASRecordSet();
                asRecordSet.populate((ResultSet)value);
                this.writeData(asRecordSet);
            } else if (value instanceof Document) {
                this.write((Document)value);
            } else {
                this.writeObject(value);
            }
        }
    }

    protected void writeObject(Object object) throws IOException {
        if (object == null) {
            log.debug("Writing object, object param == null", new Object[0]);
            throw new NullPointerException("object cannot be null");
        }
        log.debug("Writing object, class = %s", object.getClass());
        this.dataOutputStream.writeByte(3);
        try {
            PropertyDescriptor[] properties = null;
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
                properties = beanInfo.getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                // empty catch block
            }
            if (properties == null) {
                properties = new PropertyDescriptor[]{};
            }
            for (int i = 0; i < properties.length; ++i) {
                if (properties[i].getName().equals("class")) continue;
                String propertyName = properties[i].getName();
                Method readMethod = properties[i].getReadMethod();
                Object propertyValue = null;
                if (readMethod == null) {
                    log.error("unable to find readMethod for : %s writing null!", propertyName);
                } else {
                    log.debug("invoking readMethod: %s", readMethod);
                    propertyValue = readMethod.invoke(object, new Object[0]);
                }
                log.debug("%s=%s", propertyName, propertyValue);
                this.dataOutputStream.writeUTF(propertyName);
                this.writeData(propertyValue);
            }
            this.dataOutputStream.writeShort(0);
            this.dataOutputStream.writeByte(9);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Write error", e);
            throw new IOException(e.getMessage());
        }
    }

    protected void writeArray(Object[] array) throws IOException {
        this.dataOutputStream.writeByte(10);
        this.dataOutputStream.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeData(array[i]);
        }
    }

    protected void writePrimitiveArray(Object array) throws IOException {
        this.writeArray(this.convertPrimitiveArrayToObjectArray(array));
    }

    protected Object[] convertPrimitiveArrayToObjectArray(Object array) {
        Class<?> componentType = array.getClass().getComponentType();
        Object[] result = null;
        if (componentType == null) {
            throw new NullPointerException("componentType is null");
        }
        if (componentType == Character.TYPE) {
            char[] carray = (char[])array;
            result = new Object[carray.length];
            for (int i = 0; i < carray.length; ++i) {
                result[i] = new Character(carray[i]);
            }
        } else if (componentType == Byte.TYPE) {
            byte[] barray = (byte[])array;
            result = new Object[barray.length];
            for (int i = 0; i < barray.length; ++i) {
                result[i] = new Byte(barray[i]);
            }
        } else if (componentType == Short.TYPE) {
            short[] sarray = (short[])array;
            result = new Object[sarray.length];
            for (int i = 0; i < sarray.length; ++i) {
                result[i] = new Short(sarray[i]);
            }
        } else if (componentType == Integer.TYPE) {
            int[] iarray = (int[])array;
            result = new Object[iarray.length];
            for (int i = 0; i < iarray.length; ++i) {
                result[i] = iarray[i];
            }
        } else if (componentType == Long.TYPE) {
            long[] larray = (long[])array;
            result = new Object[larray.length];
            for (int i = 0; i < larray.length; ++i) {
                result[i] = new Long(larray[i]);
            }
        } else if (componentType == Double.TYPE) {
            double[] darray = (double[])array;
            result = new Object[darray.length];
            for (int i = 0; i < darray.length; ++i) {
                result[i] = new Double(darray[i]);
            }
        } else if (componentType == Float.TYPE) {
            float[] farray = (float[])array;
            result = new Object[farray.length];
            for (int i = 0; i < farray.length; ++i) {
                result[i] = new Float(farray[i]);
            }
        } else if (componentType == Boolean.TYPE) {
            boolean[] barray = (boolean[])array;
            result = new Object[barray.length];
            for (int i = 0; i < barray.length; ++i) {
                result[i] = new Boolean(barray[i]);
            }
        } else {
            throw new IllegalArgumentException("unexpected component type: " + componentType.getClass().getName());
        }
        return result;
    }

    protected void write(Iterator<?> iterator) throws IOException {
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        this.write(list);
    }

    protected void write(Collection<?> collection) throws IOException {
        this.dataOutputStream.writeByte(10);
        this.dataOutputStream.writeInt(collection.size());
        for (Object object : collection) {
            this.writeData(object);
        }
    }

    protected void writeMap(Map<?, ?> map) throws IOException {
        if (map instanceof ASObject && ((ASObject)map).getType() != null) {
            log.debug("Writing Custom Class: %s", ((ASObject)map).getType());
            this.dataOutputStream.writeByte(16);
            this.dataOutputStream.writeUTF(((ASObject)map).getType());
        } else {
            log.debug("Writing Map", new Object[0]);
            this.dataOutputStream.writeByte(8);
            this.dataOutputStream.writeInt(0);
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            log.debug("%s: %s", entry.getKey(), entry.getValue());
            this.dataOutputStream.writeUTF(entry.getKey().toString());
            this.writeData(entry.getValue());
        }
        this.dataOutputStream.writeShort(0);
        this.dataOutputStream.writeByte(9);
    }

    protected void write(Document document) throws IOException {
        this.dataOutputStream.writeByte(15);
        Element docElement = document.getDocumentElement();
        String xmlData = AMF0Serializer.convertDOMToString(docElement);
        log.debug("Writing xmlData: \n%s", xmlData);
        ByteArrayOutputStream baOutputStream = new ByteArrayOutputStream();
        baOutputStream.write(xmlData.getBytes("UTF-8"));
        this.dataOutputStream.writeInt(baOutputStream.size());
        baOutputStream.writeTo(this.dataOutputStream);
    }

    protected int writeString(String str) throws IOException {
        byte[] bytearr;
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen <= 65535) {
            this.dataOutputStream.writeByte(2);
            bytearr = new byte[utflen + 2];
        } else {
            this.dataOutputStream.writeByte(12);
            bytearr = new byte[utflen + 4];
            bytearr[count++] = (byte)(utflen >>> 24 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 16 & 0xFF);
        }
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        this.dataOutputStream.write(bytearr);
        return utflen + 2;
    }

    private void writeStoredObject(Object obj) throws IOException {
        log.debug("Writing object reference for %s", obj);
        this.dataOutputStream.write(7);
        this.dataOutputStream.writeShort(this.storedObjects.get(obj));
    }

    private void storeObject(Object obj) {
        this.storedObjects.put(obj, this.storedObjectCount++);
    }

    private void clearStoredObjects() {
        this.storedObjects.clear();
        this.storedObjectCount = 0;
    }

    protected boolean isPrimitiveArray(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().isArray() && obj.getClass().getComponentType().isPrimitive();
    }

    private void writeAMF3Data(AMF3Object data) throws IOException {
        this.dataOutputStream.writeByte(17);
        ObjectOutput amf3 = GraniteContext.getCurrentInstance().getGraniteConfig().newAMF3Serializer(this.rawOutputStream);
        amf3.writeObject(data.getValue());
    }

    public static String convertDOMToString(Node node) {
        StringBuffer sb = new StringBuffer();
        if (node.getNodeType() == 3) {
            sb.append(node.getNodeValue());
        } else {
            String currentTag = node.getNodeName();
            sb.append('<');
            sb.append(currentTag);
            AMF0Serializer.appendAttributes(node, sb);
            sb.append('>');
            if (node.getNodeValue() != null) {
                sb.append(node.getNodeValue());
            }
            AMF0Serializer.appendChildren(node, sb);
            AMF0Serializer.appendEndTag(sb, currentTag);
        }
        return sb.toString();
    }

    private static void appendAttributes(Node node, StringBuffer sb) {
        if (node instanceof Element) {
            NamedNodeMap nodeMap = node.getAttributes();
            for (int i = 0; i < nodeMap.getLength(); ++i) {
                sb.append(' ');
                sb.append(nodeMap.item(i).getNodeName());
                sb.append('=');
                sb.append('\"');
                sb.append(nodeMap.item(i).getNodeValue());
                sb.append('\"');
            }
        }
    }

    private static void appendChildren(Node node, StringBuffer sb) {
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                sb.append(AMF0Serializer.convertDOMToString(children.item(i)));
            }
        }
    }

    private static void appendEndTag(StringBuffer sb, String currentTag) {
        sb.append('<');
        sb.append('/');
        sb.append(currentTag);
        sb.append('>');
    }
}

